/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.system.classes;
import java.io.*;
/** Interface <code>StringsListener</code>. Every object which wants to handle Chainging the
  * collection inherited from Strings have to implement this interface.
  * IF you do not want to serialize listeners which implements this interface you have to subclass
  * StringList class and override writeObject() and readObject() methods
  *
  * @author	George Petkov <a href=mailto:pgeorge@mail.techno-link.com> pgeorge@mail.techno-link.com </a>,  <a href=mailto:gpetkov@usa.net> gpetkov@usa.net</a>
  * @version 0.7, 12/12/97
  */
public interface StringsListener extends Serializable {
  /** This function is called just befor some changes are beeing performed */
  public void BeforeChange(Strings Sender);
  /** This function is called after all the changes have been performed */
  public void AfterChange (Strings Sender);
}

