/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.system.classes;

import java.io.*;
import java.net.URL;
import java.awt.*;
import java.awt.image.*;
import org.freebuilder.system.ideengine.*;
import org.freebuilder.system.debug.Debug;

/** <code>ResMan</code> is responsible for loading resources. For now it loads only Immages,
  * but in the future will be extended to load other resources too.
  *
  * @author	George Petkov <a href=mailto:pgeorge@mail.techno-link.com> pgeorge@mail.techno-link.com </a>,  <a href=mailto:gpetkov@usa.net> gpetkov@usa.net</a>
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
  * @version 0.7, 12/12/97
*/

public class ResMan extends Component {

  public ResMan () throws IdeException {
    Globals.DefaultImage = loadImage(Globals.IconsDir + Globals.FreeBuilderIconName);
    if (Globals.DefaultImage == null)
      throw new IdeException();
  }

  public Image loadImage (String Name) {
    Image  Result   = null;
    URL    ImageUrl = null;
    String ImagePath;
    try {
      try {
        ImagePath = Name.replace(Globals.FileSeparatorChar, Globals.ZipFileSeparatorChar);
        ImageUrl  = ClassLoader.getSystemResource(ImagePath);
        Result    = getToolkit().getImage(ImageUrl);
      }
      catch(Exception e) {
        if (Debug.isDebug)
          Debug.Assert(e, this,"Error loading image " + Name);
        else {
          System.out.println("Error loading image " + Name);
          System.out.println(e.getMessage());
        }
      }
    }
    finally {
      if (Result != null) return Result;
      return Globals.DefaultImage;
    }
  }
}
