/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.gui.xysaveframe;

import java.awt.*;
import java.awt.event.*;
import org.freebuilder.system.debug.*;
import org.freebuilder.system.classes.options.*;
import org.freebuilder.system.classes.options.manager.*;
import org.freebuilder.system.classes.events.engine.*;

import org.freebuilder.system.ideengine.Globals;

/** The <code>XySaveFrame</code> frame has the abilities to save its size and location to the project configuration or
  * to the default configuration. You can descent from that class to add these features to the new frame.
  * IF this is a first time you create this class, and it have not steel saved options and you have not set a
  * size and location, CreateDefaultSizeLocation() method will be called. You have to override this method, to
  * assign a new Size and Location. You can call Method CenterFrame() to center the frame to the screen.
  *
  * @author	George Petkov <a href=mailto:pgeorge@mail.techno-link.com> pgeorge@mail.techno-link.com </a>,  <a href=mailto:gpetkov@usa.net> gpetkov@usa.net</a>
  * @version 0.7, 02-12-97 */

public class XySaveFrame extends WindowLFrame implements ComponentListener {
  protected String          OptionsName  = "";

  public XySaveFrame(String AOptionsName) {
    addComponentListener(this);

    OptionsName  = AOptionsName;
    if (AOptionsName.length() == 0) {
      if (Debug.isDebug) {
        Debug.Assert(null, this,"XySaveFrame : Options name is empty string");
      }
    }
    InitConfig();
  }

  void SaveFrameOptions(ComponentEvent e) {
    if (! Globals.EventsEngine.IsEnabled()) return; // If comment this line (if not loaded the default options will not take efect
    Globals.Options.setOptions(GetOptions());
  }

  protected void AssignOptionsToFrame(XyFrameOptions AOptions) {
    setSize    (AOptions.frameSize);
    setLocation(AOptions.frameLocation);
  }

  public void componentResized(ComponentEvent e) {
    SaveFrameOptions(e);
  }

  public void componentMoved(ComponentEvent e) {
    SaveFrameOptions(e);
  }

  /** if by mistake the frame is shown before load the Options can use this
    * code to assign new bounds and position before that */
  void BeforeShow() {
    XyFrameOptions ThisFrameOptions = null;
    XyFrameOptions ConfigOptions    = null;

    if (Globals.Options == null) return;
    ThisFrameOptions = GetOptions();
    ConfigOptions    = (XyFrameOptions)(Globals.Options.getOptions(ThisFrameOptions.getName()));

    if (ThisFrameOptions.IsDifferent(ConfigOptions)) {
      AssignOptionsToFrame(ConfigOptions);
    }
  }

  public void componentShown(ComponentEvent e) { /* BeforeShow(); */ }
  public void componentHidden(ComponentEvent e) {}

  public XyFrameOptions GetOptions() {
    return new XyFrameOptions(this,OptionsName);
  }

  /** This method registers the Options in OptionsMngr and adds some event listeners to the EventsEngine
    * It is recomended to call this method at the end of the constructor of the subclass. */
  protected void InitConfig() {
    OptionsEventAdapter OptionsAdapter   = null;

    try {
      OptionsAdapter = new OptionsEventAdapter(OptionsName, OptionsEvent.msgOptionsRefresh,
                                               IdeEventListenerI.CALL_MASK, this, "OnRefresh");
      Globals.EventsEngine.AddEventListener(OptionsAdapter);
    }
    catch (NoSuchMethodException e) {
      Debug.Assert(e, this,"NoSuchMethodException");
    }
    catch (SecurityException     e) {
      Debug.Assert(e, this,"SecurityException");
    };
  }

  /** This method sets size to (300,200) and center the frame to the center of the screen
    * If you want other default sizes & positions you have to override this method. */
  public void CenterFrame() {
    Dimension frameSize  = getSize();
    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize(); // Let's center it.

    if (frameSize.height > screenSize.height) frameSize.height = screenSize.height;
    if (frameSize.width  > screenSize.width)  frameSize.width  = screenSize.width;
    setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
  }

  /** Every Frame inherited from this one have to override this method, to set it's StartUp Size & location */
  public void CreateDefaultSizeLocation() {
    setSize(500,150);
    setLocation(0,0);
  }

  /** You does not have to call this method. It is called to set the saved options to the frame On StartUp */
  public void OnRefresh(IdeSuperEvent AEvent) {
    XyFrameOptions FOptions = null;
    OptionsEvent   Event    = (OptionsEvent)AEvent;

    if ((! Globals.Options.IsLoaded()) && (! Globals.Options.isOpenedProject())) {
      CreateDefaultSizeLocation();
      FOptions = GetOptions();
      Globals.Options.setOptions(FOptions);
    }
    else FOptions = (XyFrameOptions)Event.getOptions();
    
    AssignOptionsToFrame(FOptions);
  }
}

