/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.gui.ideoptions;

import org.freebuilder.system.classes.options.*;
import org.freebuilder.system.classes.events.engine.*;
import org.freebuilder.system.classes.events.*;
import org.freebuilder.system.debug.Debug;
import org.freebuilder.system.ideengine.*;

import org.freebuilder.gui.ideoptions.abstr.*;
import java.util.*;

/**
  This class is a simple extender of ItemMan.
  Implements the functions for moving, adding and removeing
  the pages.
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
    @version 0.7, 07-01-98
*/
public class PaletteOptions extends ItemMan implements OptionsSuperI {
  public static final int MAX_PAGE_SIZE = 50;
  public static final String PaletteManOptionsName = "Palette Options";
  String ImagePath = Globals.IconsDir + "Beans"+ Globals.FileSeparator;



  public OptionsSuperI Clone () {
    int i;
    PaletteOptions TheClone = new PaletteOptions();
    for (i = 0; i < getPageCount(); i++)
      TheClone.addPage (getPage(i).clone(TheClone));
    return TheClone;
  }

  /** This method creates a new object of the same class, but with default options.
    * It must be overriden by every new Options Object */

  public void setDefaults() {
    removeAllPages();
    MakeDemoConfiguration();
  }

  /** Compares the datas for the options included in both objects and returns the result.
    * It must be overriden by every new Options Object */
  public boolean IsDifferent(OptionsSuperI TheOtherOne) {
    int PageCounter;
    int i;
    PaletteOptions OtherPM = null;

    try {
      OtherPM = (PaletteOptions) TheOtherOne;
    } catch (ClassCastException e)
      { return false;}

    if (OtherPM.getPageCount() != (PageCounter = getPageCount()))
      return true;

    for (i = 0; i < PageCounter; i++)
      if (!getPage(i).equals (OtherPM.getPage(i)))
        return true;

    return false;
  }

  public void removeAllPages () {
    super.removeAll();
  }

  /** Returns the number of stored pages. */
  public int getPageCount () {
    return super.getItemsCount();
  }

  /** Adds a new page to the Objects data. */
  public void addPage (PalettePage NewPage) {
    super.addItem (NewPage);
  }

  /**
    Returns the page at the specified position.
    If the <code>PageNo</code> is an invalid position,
    returns null.
  */
  public PalettePage getPage (int PageNo) {
    return (PalettePage) super.getItem (PageNo);
  }

  /**
    Returns the page with the specified name.
    If no page with that name exists, returns null.
  */
  public PalettePage getPage (String PageName) {
    return (PalettePage) super.getItem (PageName);
  }

  /**
    Removes the page at the specified position.
    If the <code>PageNo</code> is an invalid position,
    does nothing.
  */
  public void removePage (int PageNo) {
    super.removeItem (PageNo);
  }

  /**
    Removes the page with the specified name.
    If no such page exists, does nothing.
  */
  public void removePage (String PageName) {
    super.removeItem (PageName);
  }

  /**
    Removes the specified page, if it exists in the
    Object's data.
  */
  public void removePage (PalettePage APage) {
    super.removeItem (APage);
  }

  /**
    Moves the page from the <code>SourcePos</code> to <code>DestPos</code>.
    If either of the arguments is an invalid posistion, does nothing.
  */
  public void movePage (int SourcePos, int DestPos) {
    super.moveItem (SourcePos, DestPos);
  }

  public Vector getPages () {
    return getItems();
  }

  public String getName () {
    return PaletteManOptionsName;
  }

  public OptionsEvent PrepareEvent (int EventNumber) {
    return new OptionsEvent(EventNumber, new EventObject(this), this);
  }

  PalettePage CreatePage(String PageName) {
    PalettePage FPalettePage = new PalettePage (this);
    FPalettePage.setName (PageName);
    return FPalettePage;
  }

  void AddBeanToPage(PalettePage APalettePage, String BeanName, String BeanImageName) {
    ABean Bean;
    try {
      Bean = new ABean(APalettePage, BeanName, ImagePath + BeanImageName, true);
      APalettePage.addBean(Bean);
    }
    catch (ClassNotFoundException e) {
      if (Debug.isDebug) {
        Debug.Assert(e, this,"Can not find Bean with name " + BeanName);
      }
    };
  }

  public void MakeDemoConfiguration() {
    PalettePage FPalettePage;

    FPalettePage = CreatePage("AWT Controls");
    AddBeanToPage(FPalettePage, "java.awt.Button",        "Button.gif");
    AddBeanToPage(FPalettePage, "java.awt.Checkbox",      "Checkbox.gif");
    AddBeanToPage(FPalettePage, "java.awt.CheckboxGroup", "CheckboxGroup.gif");
    AddBeanToPage(FPalettePage, "java.awt.Choice",        "Choice.gif");
    AddBeanToPage(FPalettePage, "java.awt.Label",         "Label.gif");
    AddBeanToPage(FPalettePage, "java.awt.List",          "List.gif");
    AddBeanToPage(FPalettePage, "java.awt.MenuBar",       "MenuBar.gif");
    AddBeanToPage(FPalettePage, "java.awt.PopupMenu",     "PopupMenu.gif");
    AddBeanToPage(FPalettePage, "java.awt.Panel",         "Panel.gif");
    AddBeanToPage(FPalettePage, "java.awt.Scrollbar",     "ScrollBar.gif");
    AddBeanToPage(FPalettePage, "java.awt.ScrollPane",    "ScrollPane.gif");
    AddBeanToPage(FPalettePage, "java.awt.TextArea",      "TextArea.gif");
    AddBeanToPage(FPalettePage, "java.awt.TextField",     "TextField.gif");
    addPage (FPalettePage);

    FPalettePage = CreatePage("Containers");
    AddBeanToPage(FPalettePage, "java.awt.ScrollPane",    "ScrollPane.gif");
    AddBeanToPage(FPalettePage, "java.awt.Panel",         "Panel.gif");
    AddBeanToPage(FPalettePage, "java.awt.Window",        "Window.gif");
    AddBeanToPage(FPalettePage, "java.awt.Frame",         "Frame.gif");
    AddBeanToPage(FPalettePage, "java.awt.Dialog",        "Dialog.gif");
    addPage (FPalettePage);

    FPalettePage = CreatePage("Others");
    addPage (FPalettePage);
  }

}
