/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.gui.idemenu;

import java.util.EventObject;
import org.freebuilder.system.classes.events.engine.*;
import org.freebuilder.system.classes.events.*;

/** Class <code>MainMenuEvent</code>. is the Event kind whick MenuItems will send.
  *
  * @author	George Petkov <a href=mailto:pgeorge@mail.techno-link.com> pgeorge@mail.techno-link.com </a>,  <a href=mailto:gpetkov@usa.net> gpetkov@usa.net</a>
  * @version 0.7, 07-01-98 */

public class MainMenuEvent extends SystemEvent {
  public static final int mmsgNotUsed        = 0;
  public static final int mmsgFirstMnuMsg    = mmsgNotUsed + 1;

  public static final int msubcDoIt          = mmsgFirstMnuMsg;
  public static final int msubcRefresh       = msubcDoIt          + 1; // Makes MenuItem to Refresh it's status
  public static final int msubcWhoAreYou     = msubcRefresh       + 1; // Return Corresponding MenuItem reference
  public static final int msubcRefreshForAll = msubcWhoAreYou     + 1; // Refresh for all MenuItems
  public static final int msubcTryToSendDoIt = msubcRefreshForAll + 1; // IF corresponding MenuItem is enabled Sends msubcDoIt

  public IdeMenuItem SenderMenuItem;
  public int         MenuSubCommand = msubcTryToSendDoIt;


  MainMenuEvent(Object Sender) {
    super(0,Sender);
  }

  public MainMenuEvent(int AEventID, Object Sender) {
    this(AEventID, Sender, null);
  }

  public MainMenuEvent(int AEventID, int SubCommand, Object Sender) {
    this(AEventID, Sender, null);
    MenuSubCommand = SubCommand;
  }

  public MainMenuEvent(int AEventID, Object Sender, IdeMenuItem MenuSender) {
    super(AEventID, new EventObject(Sender));
    SenderMenuItem = MenuSender;
  }

  public MainMenuEvent(int AEventID, int SubCommand, Object Sender, IdeMenuItem MenuSender) {
    this(AEventID, Sender, MenuSender);
    MenuSubCommand = SubCommand;
  }
}
