/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.gui.ide;
import com.sun.java.swing.*;
import com.sun.java.swing.plaf.basic.*;
import com.sun.java.swing.event.*;

import org.freebuilder.gui.ideoptions.abstr.*;
import org.freebuilder.gui.ideoptions.*;
import org.freebuilder.system.ideengine.*;
import org.freebuilder.gui.config.*;

import org.freebuilder.system.classes.*;

import java.awt.event.*;
import java.awt.*;

import java.beans.*;
import org.freebuilder.gui.beans.*;


//==============================================================================
// Begin of ArrowIconCanvas
//==============================================================================
/**
  This calss represents the Arrows for scrolling the Palette.
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
    @version 0.7, 07-01-98
*/
class ArrowIconCanvas extends SpeedButton {
  private boolean ArrowEnabled = true;

  public ArrowIconCanvas (Image ArrowImage, int No) {
    super (ArrowImage, No, 2);
    canBePressed(false);
    setAlwaysOn (true);
    IconHeight = 32 + 4;
    IconWidth = 11 + 4;
    setSize (IconWidth, IconHeight);
  }

  public Dimension getPreferredSize () {
    IconHeight = 32 + 4;
    IconWidth = 11 + 4;
    return new Dimension (IconWidth, IconHeight);
  }
}

//==============================================================================
// End of ArrowIconCanvas
//==============================================================================

//==============================================================================
// Begin of InnerPalettePanel
//==============================================================================

/**
  This class represents the panel, where the beans are located.
   @author	Peter Radkov <wreck@nat.bg>
   @version 0.7, 07-01-98
*/
class InnerPalettePanel extends JPanel implements IconCanvasListener {
  private static final int BeanSize = 36;

  private int Selected = -1;
  private PalettePanel Parent;

  public int Left;
  public int Right;

  public InnerPalettePanel (PalettePage P, PalettePanel Parent) {
    int BeansCount = P.getBeansCount();
    int i;
    this.Parent = Parent;

    setLayout (new XYLayout());
    for (i = 0; i < BeansCount; i++) {

      SpeedButton I = new SpeedButton (P.getBean(i).getIcon(), i, 1);
      I.setHint (P.getBean(i).getName());
      add (I, i);
      I.setLocation (i * BeanSize, 0);
      I.setSize (BeanSize, BeanSize);
      I.addIconCanvasListener (this);
    }
  }

  private void focusBean () {
    Rectangle IB = getBounds();
    IB.width = getPreferredSize().width;

    int BeanLeft  = IB.x + Selected    *BeanSize;
    int BeanRight = IB.x + (Selected+1)*BeanSize;

    if (BeanLeft < Left) {
      setLocation (IB.x + (Left - BeanLeft),   IB.y);
      Parent.updateArrows ();
      return;
    }

    if (BeanRight > Right) {
      setLocation (IB.x - (BeanRight - Right), IB.y);
      Parent.updateArrows ();
      return;
    }
  }

  public void select (int No) {
    if (Selected >= 0)
      ((IconCanvas) getComponent (Selected)).deselect();
    Selected = No;
    if (Selected >= 0) {
      ((IconCanvas) getComponent (Selected)).select();
      Parent.deselectMainArrow();
      focusBean();
    }
  }

  public Dimension getPreferredSize () {
    return new Dimension (getComponentCount()*BeanSize, BeanSize);
  }

  public int getSelectedIndex () {
    return Selected;
  }
}

//==============================================================================
// End of InnerPalettePanel
//==============================================================================

//==============================================================================
// Begin of PalettePanel
//==============================================================================

/**
  This class represents the panel, where the beans panel and
  the scrolling Arrows are loacted. It is responsible for the
  scroll of the beans panel;
   @author	Peter Radkov <wreck@nat.bg>
   @version 0.7, 07-01-98
*/

class PalettePanel extends JPanel implements IconCanvasListener, ChangeListener {

  private static final int LeftArrowIndex   = -1001;
  private static final int RightArrowIndex  = -1002;
  public  static final int MainArrowIndex   = -1003;
  private static final int ArrowSize = 36;
  private static final int BeanSize = 36;

  private int SelectedInner;
  private InnerPalettePanel[] Inner;
  private int InnerLeft;
  private int InnerRight;
  private ArrowIconCanvas LeftArrow;
  private ArrowIconCanvas RightArrow;
  private IconCanvas Arrow;
  private JPanel LeftPanel  = new JPanel();
  private JPanel RightPanel = new JPanel ();

  public PalettePanel (PaletteOptions PO) {
    int i;
    String FS        = System.getProperty ("file.separator");
    String ArrowsDir = Globals.IconsDir + "Arrows" + Globals.FileSeparator;

    setLayout (new BorderLayout());

    LeftArrow = new ArrowIconCanvas (Globals.ResourceMngr.loadImage (ArrowsDir + "LeftArrow.gif"),
                                     LeftArrowIndex);
    RightArrow = new ArrowIconCanvas (Globals.ResourceMngr.loadImage (ArrowsDir + "RightArrow.gif"),
                                     RightArrowIndex);
    Arrow = new IconCanvas (Globals.ResourceMngr.loadImage (ArrowsDir + "PalArrow.gif"),
                             MainArrowIndex);
    Arrow.setSize (ArrowSize, ArrowSize);

    LeftArrow .setHint ("Scroll Left");
    RightArrow.setHint ("Scroll Right");
    Arrow     .setHint ("Selection Tool");

    LeftArrow .addIconCanvasListener (this);
    RightArrow.addIconCanvasListener (this);
    Arrow     .addIconCanvasListener (this);

    RightPanel.setLayout (new BorderLayout());
    RightPanel.add (RightArrow);
    add (RightPanel, BorderLayout.EAST);

    LeftPanel.setLayout (new BorderLayout(3, 3));
    LeftPanel.add (Arrow, BorderLayout.WEST);
    LeftPanel.add (LeftArrow, BorderLayout.EAST);
    add (LeftPanel, BorderLayout.WEST);

    Inner = new InnerPalettePanel [PO.getPageCount()];
    for (i = 0; i < PO.getPageCount(); i++)
      Inner[i] = new InnerPalettePanel (PO.getPage(i), this);
    if (PO.getPageCount() > 0) {
      SelectedInner = 0;
      add (Inner[0], BorderLayout.CENTER);
    } else
      SelectedInner = -1;
  }

  public boolean isOptimizedDrawingEnabled () {
    return false;
  }

  private void updateRightArrow () {
    Rectangle IB = Inner[SelectedInner].getBounds();
    IB.width = Inner[SelectedInner].getPreferredSize().width;

    if (IB.width == 0) {
      RightArrow.setEnabled (false);
      return;
    }

    if (IB.x + IB.width > InnerRight)
      RightArrow.setEnabled (true);
    else
      RightArrow.setEnabled (false);
  }

  private void updateLeftArrow () {
    Rectangle IB = Inner[SelectedInner].getBounds();
    IB.width = Inner[SelectedInner].getPreferredSize().width;

    if (IB.width == 0) {
      LeftArrow.setEnabled (false);
      return;
    }

    if (IB.x < InnerLeft)
      LeftArrow.setEnabled (true);
    else
      LeftArrow.setEnabled (false);
  }

  public int getSelectedIndex () {
    return Inner[SelectedInner].getSelectedIndex();
  }

  public void updateArrows () {
    updateLeftArrow();
    updateRightArrow();
    Inner[SelectedInner].invalidate();
    Inner[SelectedInner].validate();
  }

  public void selectFromPalette (int No) {
    Inner[SelectedInner].select (No);
  }

  public void deselectMainArrow () {
    Arrow.deselect();
  }

  public void select (int No) {
    Rectangle IB = Inner[SelectedInner].getBounds();
    IB.width = Inner[SelectedInner].getPreferredSize().width;
    int Offset;
    switch (No) {
      case LeftArrowIndex:
        Offset = (InnerLeft - IB.x) % BeanSize;
        if (Offset == 0)
          Offset = BeanSize;
        Inner[SelectedInner].setLocation (IB.x + Offset, IB.y);
        updateArrows ();
      break;
      case RightArrowIndex:
        Offset = (InnerRight - IB.x) % BeanSize;
        if (Offset != 0)
          Offset = BeanSize - Offset;
        else
          Offset = BeanSize;
        Inner[SelectedInner].setLocation (IB.x - Offset, IB.y);
        updateArrows ();
      break;
      case MainArrowIndex:
        Arrow.select ();
        Inner[SelectedInner].select (-1);
      break;
    }
  }

  public void doLayout () {
    Point PrevLoc;
    if (SelectedInner < 0) {
      super.doLayout();
      return;
    } else {
      PrevLoc = Inner[SelectedInner].getLocation();
      super.doLayout();
    }

    int InnerWidth;
    int PrefWidth;

    Rectangle NewDim = Inner[SelectedInner].getBounds();

    Inner[SelectedInner].Left  = InnerLeft  = NewDim.x;
    Inner[SelectedInner].Right = InnerRight = NewDim.x + NewDim.width;

    Inner[SelectedInner].setSize (Inner[SelectedInner].getPreferredSize());
    PrefWidth = Inner[SelectedInner].getSize().width;

    InnerWidth = NewDim.width;

    if (InnerWidth < PrefWidth)
      if (PrevLoc.x + PrefWidth < InnerRight)
        Inner[SelectedInner].setLocation (InnerRight - PrefWidth, NewDim.y);
      else
        Inner[SelectedInner].setLocation (PrevLoc.x, PrevLoc.y);

    updateRightArrow ();
    updateLeftArrow ();
  }

  public void stateChanged (ChangeEvent e) {
    JTabbedPane MTP = (JTabbedPane) e.getSource();
    int Comp = MTP.getSelectedIndex();
    select (MainArrowIndex);
    if (SelectedInner >= 0)
      remove(Inner[SelectedInner]);
    SelectedInner = Comp;
    add (Inner[SelectedInner], BorderLayout.CENTER);
  }
}

//==============================================================================
// End of PalettePanel
//==============================================================================

//==============================================================================
// Begin of Palette
//==============================================================================

/**
  This is the main class, which represents the panel, where
  all pages i.e. the MyTabbedPane is located. It is responsible
  for positioning inner panels when the container of this panel
  changes size.
   @author	Peter Radkov <wreck@nat.bg>
   @version 0.7, 07-01-98
*/

public class Palette extends BPanel implements ChangeListener{
  private static final int BeanSize = 36;
  protected PaletteOptions FPaletteMan;
  private JTabbedPane Tabs        = new JTabbedPane();
  private Dimension OldSize       = null;
  private PalettePanel ThePalette = null;
  private boolean LazyInitOK      = false;
  private JPanel[] PalettePanels   = null;

  public Palette (PaletteOptions APaletteMan) {
    this();
    setPalette(APaletteMan);
  }

  public Palette () {
    super();
    setLayout (new BorderLayout(3,3));
    add (Tabs, BorderLayout.CENTER);
    Tabs.addChangeListener (this);
  }

  private void init () {
    int i;
    setVisible (false);
    if (ThePalette != null)
      Tabs.removeChangeListener (ThePalette);

    int Count = Tabs.getTabCount();
    for (i = 0; i < Count; i++)
      Tabs.removeTabAt (0);

    ThePalette = new PalettePanel (FPaletteMan);
    PalettePanels = new JPanel [FPaletteMan.getPageCount()];
    for (i = 0; i < FPaletteMan.getPageCount(); i++) {
      PalettePanels[i] = new JPanel();
      PalettePanels[i].setLayout (new BorderLayout());
      Tabs.addTab (FPaletteMan.getPage(i).getName(), PalettePanels[i]);
    }
    Tabs.addChangeListener (ThePalette);
    LazyInitOK = true;
    invalidate();
    setVisible (true);
  }

  public void doLayout () {
    if (!LazyInitOK)
      init();
    super.doLayout();
  }

  public void setPalette (PaletteOptions APalette) {
    FPaletteMan = APalette;
    init();
    if (Globals.IdeMainFrame != null) {
      invalidate();
      Globals.IdeMainFrame.validate();
    }
  }

  public Dimension getMinimumSize() {
    Dimension PrefSize = getPreferredSize();
    return new Dimension (200, PrefSize.height);
  }

  public Dimension getPreferredSize () {
    int Correction = 9;
    if (getParent() == null)
      return super.getPreferredSize();

    if (!LazyInitOK)
      init();

    int i;
    int MinY = -1;
    int MaxY = -1;
    int DesiredHeight = BeanSize;
    Insets I = getInsets();

    int Height = getParent().getSize().height - getLocation().y - I.top - I.bottom;
    int Width  = getParent().getSize().width  - getLocation().x - I.left - I.right;

    Tabs.setSize (Width, Height);
    BasicTabbedPaneUI UI = (BasicTabbedPaneUI) Tabs.getLayout();

    for (i = 0; i < Tabs.getTabCount(); i++) {
      Rectangle CurTabD = UI.getTabBounds (Tabs, i);
      int CurrentMinY = CurTabD.y;
      int CurrentMaxY = CurrentMinY + CurTabD.height;
      if (i == 0) {
        MinY = CurrentMinY;
        MaxY = CurrentMaxY;
      } else {
        if (CurrentMinY < MinY)
          MinY =  CurrentMinY;
        if (CurrentMaxY > MaxY)
          MaxY = CurrentMaxY;
      }
    }

    return new Dimension(Tabs.getPreferredSize().width + I.left + I.right,
                         MaxY - MinY + DesiredHeight +
                         Correction + I.top + I.bottom);
  }

  public void stateChanged (ChangeEvent e) {
    int SelTab = Tabs.getSelectedIndex();
    if (SelTab < 0)
      return;
    PalettePanels[SelTab].removeAll();
    PalettePanels[SelTab].add (ThePalette, BorderLayout.CENTER);
    Tabs.doLayout();
  }
}
//==============================================================================
// End of Palette
//==============================================================================







