/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.gui.beans;

import java.awt.*;
import java.awt.event.*;
import org.freebuilder.system.ideengine.*;
import org.freebuilder.gui.beans.*;

import com.sun.java.swing.*;

/**
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
  * @version 0.7, 07-01-98
*/
public class FindDialog extends JDialog implements ActionListener {
  private static final String OK_CMD     = "OK";
  private static final String CANCEL_CMD = "Cancel";

  private BPanel MainPanel          = new BPanel ();
  private BPanel DirectionPanel     = new BPanel ("Direction");
  private BPanel ScopePanel         = new BPanel ("Scope");
  private BPanel OriginPanel        = new BPanel ("Origin");
  private JPanel AllChecksPanel     = new JPanel ();
  private JPanel ChecksAndTextPanel = new JPanel ();
  private BPanel TextPanel          = new BPanel ("Text to find:");

  protected JPanel TextsPanel         = new JPanel ();
  protected BPanel OptionsPanel       = new BPanel ("Options");
  protected BPanel ButtonsPanel       = new BPanel ();

  private JTextField TextToFind        = new JTextField();
  private ButtonGroup DirectionGroup   = new ButtonGroup();
  private ButtonGroup ScopeGroup       = new ButtonGroup();
  private ButtonGroup OriginGroup      = new ButtonGroup();

  private JCheckBox CaseSensitive  = new JCheckBox ("Case Sensitive");
  private JCheckBox WholeWordsOnly = new JCheckBox ("Whole Words Only");

  private JRadioButton Forward      = new JRadioButton ("Forward", true);
  private JRadioButton Backward     = new JRadioButton ("Backward", false);

  private JRadioButton Global       = new JRadioButton ("Global", true);
  private JRadioButton SelectedText = new JRadioButton ("Selected Text", false);

  private JRadioButton FromCursor   = new JRadioButton ("From Cursor", false);
  private JRadioButton EntireScope  = new JRadioButton ("Entire Scope", true);

  private Button OKButton     = new Button (OK_CMD);
  private Button CancelButton = new Button (CANCEL_CMD);
  private JPanel UpperChecksPanel = new JPanel();
  private JPanel LowerChecksPanel = new JPanel();

  protected boolean Confirmed;

  public FindDialog () {
    super (Globals.IdeMainFrame, "Find Text", true);
    DirectionGroup.add (Forward);
    DirectionGroup.add (Backward);

    ScopeGroup.add (Global);
    ScopeGroup.add (SelectedText);

    OriginGroup.add (FromCursor);
    OriginGroup.add (EntireScope);

    OptionsPanel      .setLayout (new GridLayout (2, 1, 1, 1));
    DirectionPanel    .setLayout (new GridLayout (2, 1, 1, 1));
    ScopePanel        .setLayout (new GridLayout (2, 1, 1, 1));
    OriginPanel       .setLayout (new GridLayout (2, 1, 1, 1));

    AllChecksPanel    .setLayout (new BorderLayout (2, 2));
    UpperChecksPanel  .setLayout (new GridLayout (1, 2));
    LowerChecksPanel  .setLayout (new GridLayout (1, 2));

    ButtonsPanel      .setLayout (new GridLayout (1, 2, 5, 5));
    ChecksAndTextPanel.setLayout (new BorderLayout (5, 5));
    MainPanel         .setLayout (new BorderLayout (5, 5));
    TextPanel         .setLayout (new BorderLayout ());
    TextsPanel        .setLayout (new GridLayout (1, 1, 1, 1));
    getContentPane()  .setLayout (new BorderLayout ());

    OptionsPanel  .setInner (BPanel.RAISED);
    OptionsPanel  .setOuter (BPanel.LOWERED);
    DirectionPanel.setInner (BPanel.RAISED);
    DirectionPanel.setOuter (BPanel.LOWERED);
    ScopePanel    .setInner (BPanel.RAISED);
    ScopePanel    .setOuter (BPanel.LOWERED);
    OriginPanel   .setInner (BPanel.RAISED);
    OriginPanel   .setOuter (BPanel.LOWERED);

    OptionsPanel      .add (CaseSensitive);
    OptionsPanel      .add (WholeWordsOnly);
    DirectionPanel    .add (Forward);
    DirectionPanel    .add (Backward);
    ScopePanel        .add (Global);
    ScopePanel        .add (SelectedText);
    OriginPanel       .add (FromCursor);
    OriginPanel       .add (EntireScope);
    ButtonsPanel      .add (OKButton);
    ButtonsPanel      .add (CancelButton);
    TextsPanel        .add (TextPanel);
    UpperChecksPanel  .add (OptionsPanel);
    UpperChecksPanel  .add (DirectionPanel);
    LowerChecksPanel  .add (ScopePanel);
    LowerChecksPanel  .add (OriginPanel);
    TextPanel         .add (TextToFind,         BorderLayout.NORTH);
    AllChecksPanel    .add (UpperChecksPanel,   BorderLayout.NORTH);
    AllChecksPanel    .add (LowerChecksPanel,   BorderLayout.SOUTH);
    ChecksAndTextPanel.add (TextsPanel,         BorderLayout.NORTH);
    ChecksAndTextPanel.add (AllChecksPanel,     BorderLayout.CENTER);
    MainPanel         .add (ChecksAndTextPanel, BorderLayout.NORTH);
    MainPanel         .add (ButtonsPanel,       BorderLayout.SOUTH);
    getContentPane()  .add (MainPanel,          BorderLayout.CENTER);

    MainPanel.setBorderWidth (3);
    MainPanel.setInner (BPanel.NONE);
    MainPanel.setOuter (BPanel.NONE);
    pack();
    Misc.hardCenter (this);
    OKButton    .addActionListener (this);
    CancelButton.addActionListener (this);
  }

  public void actionPerformed (ActionEvent e) {
    if (e.getSource().equals(OKButton))
      Confirmed = true;
    if ((getTextToFind().length() == 0) || (e.getSource().equals(CancelButton)))
      Confirmed = false;
    setVisible (false);
  }

  public boolean isConfirmed () {
    return Confirmed;
  }

  public String getTextToFind () {
    String Ret = TextToFind.getText();
    if (Ret == null)
      return "";
    return Ret;
  }

  public boolean isCaseSensitive () {
    return CaseSensitive.isSelected();
  }

  public boolean isFromCursor () {
    return FromCursor.isSelected();
  }

  public boolean isGlobal () {
    return Global.isSelected();
  }

  public boolean isWholeWordsOnly () {
    return WholeWordsOnly.isSelected();
  }

  public boolean isForward () {
    return Forward.isSelected();
  }
}


