/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.gui;

import java.awt.*;
import java.awt.event.*;
import org.freebuilder.system.ideengine.*;
import org.freebuilder.gui.beans.*;

/**
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
  * @version 0.7, 07-01-98
*/
class InfoPanel extends Panel {
  private Font BigFont;
  private Font SmallFont;
  private Image  LogoCup     = Globals.ResourceMngr.loadImage (Globals.IconsDir + "Logo.jpg");
  String [] Text = new String [] {"Version 0.7", "Releace 1998", "Designed and Developed by Vanand Ltd."};
  private static int TheWidth  = -1;
  private static int TheHeight = -1;

  public InfoPanel () {
    super();
    prepareImage (LogoCup, this);
    while ((TheWidth == -1) || (TheHeight == -1));
  }

  public void paint (Graphics g) {
    Insets Inss = getInsets();
    Dimension Size = getSize();
    int CurrentY;
      g.drawImage (LogoCup, Size.width - Inss.right - TheWidth - 10, Inss.top + 10, this);
    if (BigFont == null)
      BigFont = new Font (g.getFont().getName(), Font.BOLD, 36);
    if (SmallFont == null)
      SmallFont = new Font (g.getFont().getName(), Font.BOLD, 12);

    g.setFont (BigFont);
    CurrentY = g.getFontMetrics().getHeight() + Inss.top;
    int TextXLoc = Inss.left + 20;
    g.drawString ("Free Builder", TextXLoc, CurrentY);

    g.setFont (SmallFont);
    for (int i = 0; i < Text.length; i++) {
      CurrentY += g.getFontMetrics().getHeight();
      g.drawString (Text[i], TextXLoc, CurrentY);
    }
  }

  public Dimension getPreferredSize () {
    return new Dimension (TheWidth + 260, TheHeight + 10);
  }

  public boolean imageUpdate (Image I, int InfoFlags, int x, int y, int Width, int Height) {
    boolean Ret = super.imageUpdate(I, InfoFlags, x, y, Width, Height);
    if (((InfoFlags&PROPERTIES) != 0) || ((InfoFlags&ALLBITS) != 0)) {
      TheWidth  = LogoCup.getWidth  (this) ;
      TheHeight = LogoCup.getHeight (this);
    }
    return Ret;
  }
}

/**
  * @author	Peter Radkov <wreck@nat.bg>
  * @version 1.00, 26-01-97
*/
public class AboutDialog extends Dialog implements ActionListener, WindowListener {
  private Button OKButton     = new Button   ("        OK        ");
  private Panel ButtonsPanel  = new Panel    ();
  private InfoPanel MainPanel = new InfoPanel();

  public AboutDialog () {
    super (Globals.IdeMainFrame, "About Free Builder", true);
    ButtonsPanel.add (OKButton);
    setLayout(new BorderLayout());
    add (ButtonsPanel, BorderLayout.SOUTH);
    add (MainPanel, BorderLayout.NORTH);
    OKButton.addActionListener (this);
    setResizable (false);
    pack();
    Misc.hardCenter (this);
    addWindowListener (this);
  }

  private void closeAbout () {
    setVisible (false);
    dispose();
  }

  public void windowClosing (WindowEvent e) {
    closeAbout();
  }
  public void windowClosed (WindowEvent e) {}
  public void windowActivated (WindowEvent e) {}
  public void windowDeactivated (WindowEvent e) {}
  public void windowIconified (WindowEvent e) {}
  public void windowDeiconified (WindowEvent e) {}
  public void windowOpened (WindowEvent e) {}

  public void actionPerformed (ActionEvent e) {
    closeAbout();
  }
}
