/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */
package org.freebuilder.wizards;

import java.io.*;
import java.awt.*;
import java.util.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import com.sun.java.swing.text.*;
import com.sun.java.swing.table.*;
import com.sun.java.swing.event.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.basic.*;

import org.freebuilder.gui.*;
import org.freebuilder.gui.beans.*;
import org.freebuilder.gui.idemenu.*;
import org.freebuilder.gui.ideoptions.*;
import org.freebuilder.system.debug.*;
import org.freebuilder.system.packages.*;
import org.freebuilder.system.ideengine.*;
import org.freebuilder.system.projectman.*;
import org.freebuilder.system.classes.options.*;
import org.freebuilder.system.classes.events.engine.*;

/**
  *@author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
   @version 0.7, 07-01-98
*/
class NoBorder implements Border {
  public void paintBorder(Component c,
                          Graphics g,
                          int x,
                          int y,
                          int width,
                          int height) {}
  public boolean isBorderOpaque () {return true;}
  public Insets getBorderInsets (Component c) {return new Insets(0, 0, 0, 0);}
}

/**
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
    @version 0.7, 07-01-98
*/
class EditorText extends JTextField implements FocusListener{
  private MyCellEditor Boss;
  public EditorText (MyCellEditor Boss) {
    this.Boss = Boss;
    addFocusListener (this);
  }

  public void focusGained (FocusEvent e) {}
  public void focusLost   (FocusEvent e) {
    if ((getText() == null) || (getText().length() == 0))
      Boss.cancelCellEditing();
    else
      Boss.stopCellEditing();
  }
}

/**
  *@author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
   @version 0.7, 07-01-98
*/
class EditorCombo extends JComboBox implements FocusListener {
  private MyCellEditor Boss;
  public EditorCombo (MyCellEditor Boss, Object [] Param) {
    super(Param);
    this.Boss = Boss;
    addFocusListener (this);
  }
  public void focusGained (FocusEvent e) {}
  public void focusLost (FocusEvent e) {
    Boss.cancelCellEditing();
  }
}

/**
  *@author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
   @version 0.7, 07-01-98
*/
/** This class is the editor of the parameters table in the Applet Wizar. */
class MyCellEditor extends JPanel implements TableCellEditor, ActionListener {
  private Vector Listeners      = new Vector();
  private EditorText   Text;
  private EditorCombo  Editor;
  private static final String [] Params = new String [] {"String", "boolean", "int", "short", "long", "float", "double"};
  private boolean isText;

  public MyCellEditor () {
    Text = new EditorText(this);
    Text.addActionListener (this);
    Text.setBorder  (new NoBorder());
    setLayout (new BorderLayout());
  }

  public void removeCellEditorListener (CellEditorListener L) {
    Listeners.removeElement(L);
  }
  public void addCellEditorListener (CellEditorListener L) {
    Listeners.addElement(L);
  }

  public void cancelCellEditing () {
    int Size = Listeners.size();
    ChangeEvent TheEvent = new ChangeEvent(this);
    for (int i = 0; i < Size; i++)
      ((CellEditorListener)Listeners.elementAt(i)).editingCanceled(TheEvent);
  }

  public boolean stopCellEditing () {
    int Size = Listeners.size();
    ChangeEvent TheEvent = new ChangeEvent(this);
    for (int i = 0; i < Size; i++)
      ((CellEditorListener)Listeners.elementAt(i)).editingStopped(TheEvent);
    return true;
  }

  public boolean shouldSelectCell      (EventObject e) {
    MouseEvent TheEvent = (MouseEvent) (e);
    if (TheEvent.getClickCount() > 1)
      return true;
    return false;
  }

  public boolean isCellEditable        (EventObject e) {
    if (e == null)
      return false;
    MouseEvent TheEvent = (MouseEvent) (e);
    if (TheEvent.getClickCount() > 1)
      return true;
    return false;
  }

  public Object getCellEditorValue () {
    if (isText)
      return Text.getText();
    else
      return Editor.getSelectedItem();
  }

  public Component getTableCellEditorComponent(JTable table,
                                               Object value,
                                               boolean isSelected,
                                               int row,
                                               int column) {
    String TheValue = (String) value;
    removeAll();
    if (!table.getColumnModel().getColumn(column).getIdentifier().equals (AppletWizard.TypeColID)) {
      if ((TheValue != null) && (TheValue.length() > 0))
        Text.setText (TheValue);
      else
        Text.setText ("");
      isText = true;
      add (Text);
      return this;
    }

    if ((TheValue != null) && (TheValue.length() > 0))
      Editor.setSelectedItem(TheValue);
    else {
      if (Editor != null)
        Editor.removeActionListener (this);
      Editor = new EditorCombo (this, Params);
      Editor.addActionListener (this);
      Editor.setFont (new Font("TimeRoman", Font.PLAIN, 10));
    }
    isText = false;
    add (Editor);
    return this;
  }

  public void actionPerformed (ActionEvent e) {
    stopCellEditing ();
  }
}

/**
  *@author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
   @version 0.7, 07-01-98
*/
/** This class does the rendering of the column headers in the Applet Wizard
    parameters table.
*/
class MyHeaderRenderer implements TableCellRenderer, TableColumnModelListener {
  private Hashtable Columns = new Hashtable();

  public MyHeaderRenderer () {
    Columns.put (AppletWizard.NameColID.toString(),        new JButton ("Name"));
    Columns.put (AppletWizard.TypeColID.toString(),        new JButton ("Type"));
    Columns.put (AppletWizard.DescriptionColID.toString(), new JButton ("Description"));
    Columns.put (AppletWizard.VariableColID.toString(),    new JButton ("Variable"));
    Columns.put (AppletWizard.DefaultColID.toString(),     new JButton ("Default"));
  }
  public Component getTableCellRendererComponent(JTable table,
                                                 Object value,
                                                 boolean isSelected,
                                                 boolean hasFocus,
                                                 int row,
                                                 int column) {
    return (Component) Columns.get (value);
  }
  public void columnAdded   (TableColumnModelEvent e) {}
  public void columnRemoved (TableColumnModelEvent e) {}
  public synchronized void columnMoved   (TableColumnModelEvent e) {}
  public void columnMarginChanged    (ChangeEvent e) {}
  public void columnSelectionChanged (ListSelectionEvent e) {}
}

/**
  *@author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
   @version 0.7, 07-01-98
*/
/** The Applet Wizard*/
public class AppletWizard extends JDialog implements ActionListener, WindowListener {
  private static final String OK_CMD           = "OK";
  private static final String CANCEL_CMD       = "Cancel";
  private static final String ADD_PARAM_CMD    = "AddParam";
  private static final String REMOVE_PARAM_CMD = "RemoveParam";

  private Button OKButton           = new Button (OK_CMD);
  private Button CancelButton       = new Button (CANCEL_CMD);

  private BPanel ParamsPanel        = new BPanel  ("Applet Parameters");

  private JButton AddParamButton    = new JButton ("Add Parameter");
  private JButton RemoveParamButton = new JButton ("Remove Parameter");

  private BPanel ParamButtonsPanel  = new BPanel();

  private BPanel ButtonsPanel       = new BPanel();
  private ClassPathAndNamePanel DataPanel = new ClassPathAndNamePanel ("Applet");

  public static final Object NameColID        = new Object();
  public static final Object TypeColID        = new Object();
  public static final Object DescriptionColID = new Object();
  public static final Object VariableColID    = new Object();
  public static final Object DefaultColID     = new Object();

  Object []   CNames  = new Object []   {NameColID,
                                         TypeColID,
                                         DescriptionColID,
                                         VariableColID,
                                         DefaultColID};
  private JTable Params            = new JTable(new DefaultTableModel(CNames, 0));
  private boolean Confirmed        = false;

  public AppletWizard () {
    super (Globals.IdeMainFrame, "Applet Wizard", true);
    setDefaultCloseOperation (DO_NOTHING_ON_CLOSE);
    addWindowListener (this);

    ButtonsPanel.setLayout (new GridLayout (1, 2, 3, 3));
    ButtonsPanel.add (OKButton);
    ButtonsPanel.add (CancelButton);

    MyHeaderRenderer HRenderer = new MyHeaderRenderer();
    MyCellEditor     CEditor   = new MyCellEditor();

    for (int i = 0; i < CNames.length; i++) {
      TableColumn CurrentColumn = Params.getColumnModel().getColumn(i);
      CurrentColumn.setIdentifier (CNames[i]);
      CurrentColumn.setHeaderRenderer(HRenderer);
    }

    Params.setDefaultEditor ((new Object()).getClass(), CEditor);
    Params.getColumnModel().addColumnModelListener(HRenderer);
    Params.getTableHeader().setUpdateTableInRealTime (true);
    Params.getTableHeader().setReorderingAllowed(true);;
    Params.getTableHeader().setResizingAllowed(true);;
    ParamsPanel.setLayout (new BorderLayout());
    ParamsPanel.add (Params.createScrollPaneForTable(Params), BorderLayout.CENTER);

    ParamButtonsPanel.setLayout (new GridLayout (1, 2, 3, 3));
    ParamButtonsPanel.add (AddParamButton);
    ParamButtonsPanel.add (RemoveParamButton);
    ParamsPanel.add (ParamButtonsPanel, BorderLayout.SOUTH);

    AddParamButton.   setActionCommand (ADD_PARAM_CMD);
    RemoveParamButton.setActionCommand (REMOVE_PARAM_CMD);

    getContentPane().setLayout (new BorderLayout());
    getContentPane().add (ButtonsPanel, BorderLayout.SOUTH);
    getContentPane().add (DataPanel,    BorderLayout.NORTH);
    getContentPane().add (ParamsPanel,  BorderLayout.CENTER);
    pack();
    setSize (getSize().width, getToolkit().getScreenSize().height / 2);
    Misc.hardCenter (this);
    OKButton         .addActionListener (this);
    CancelButton     .addActionListener (this);
    AddParamButton   .addActionListener (this);
    RemoveParamButton.addActionListener (this);
  }
  /** Checks the validity of the name for program variables.
      This function calls Misc.isValidID().
  */
  private boolean checkVarNameValidity (int RowNo) {
    TableModel TheModel = Params.getModel();
    int ColNo;
    ColNo = Params.getColumnModel().getColumnIndex (VariableColID);
    if (TheModel.getValueAt (RowNo, ColNo) == null)
      return false;
    return Misc.isValidID(TheModel.getValueAt (RowNo, ColNo).toString());
  }

  /** Checks the validity of the name for HTML variables.
      This function calls Misc.isValidID().
  */
  private boolean checkHTMLVarNameValidity (int RowNo) {
    TableModel TheModel = Params.getModel();
    int ColNo;
    ColNo = Params.getColumnModel().getColumnIndex (NameColID);
    if (TheModel.getValueAt (RowNo, ColNo) == null)
      return false;
    return Misc.isValidID(TheModel.getValueAt (RowNo, ColNo).toString());
  }

  /** Checks the validity of the default variable value, according to its type. */
  private boolean checkVarDefValueValidity (int RowNo) {
    int TypeColNo = Params.getColumnModel().getColumnIndex (TypeColID);
    int ValColNo  = Params.getColumnModel().getColumnIndex (DefaultColID);

    String Type  = Params.getModel().getValueAt (RowNo, TypeColNo).toString();
    String Value = Params.getModel().getValueAt (RowNo, ValColNo).toString();
    if (Type.compareTo ("String") == 0)
      return true;

    if (Type.compareTo ("boolean") == 0) {
      String RealVal = Value.trim().toLowerCase();
      return (RealVal.compareTo("true")==0) || (RealVal.compareTo("false")==0);
    }

    if (Type.compareTo ("int") == 0) {
      try {
        Integer.valueOf (Value);
      } catch (NumberFormatException e) {return false;}
      return true;
    }

    if (Type.compareTo ("short") == 0) {
      try {
        Short.valueOf (Value);
      } catch (NumberFormatException e) {return false;}
      return true;
    }
    if (Type.compareTo ("float") == 0) {
      try {
        Float.valueOf (Value);
      } catch (NumberFormatException e) {return false;}
      return true;
    }
    if (Type.compareTo ("double") == 0) {
      try {
        Double.valueOf (Value);
      } catch (NumberFormatException e) {return false;}
      return true;
    }
    if (Type.compareTo ("long") == 0) {
      try {
        Long.valueOf (Value);
      } catch (NumberFormatException e) {return false;}
      return true;
    }
    return false;
  }


  /** Checks if the type is specified for a certain variable. */
  private boolean checkVarTypeValidity (int RowNo) {
    int ColNo = Params.getColumnModel().getColumnIndex (TypeColID);
    if (Params.getModel().getValueAt (RowNo, ColNo) == null)
      return false;
    if (Params.getModel().getValueAt (RowNo, ColNo).toString().length() == 0)
      return false;
    return true;
  }

  /** Checks the validity of the inout data. This function is called befor exiting
      the dialog. If it returns <code>false</code>, the dialog does NOT close and
      the iser is promped to correct the errors.
  */
  private boolean checkValidity () {
    int i;
    int Count = Params.getRowCount();

    if (!DataPanel.checkValidity())
      return false;

    for (i = 0; i < Count; i++) {
      if (!checkVarTypeValidity(i)) {
        Params.setRowSelectionInterval (i, i);
        Misc.messageBox (new String [] {"OK"}, new String [] {"Invalid Variable Type."}, 0);
        return false;
      }
      if (!checkVarNameValidity(i)) {
        Params.setRowSelectionInterval (i, i);
        Misc.messageBox (new String [] {"OK"}, new String [] {"Invalid Variable Name."}, 0);
        return false;
      }
      if (!checkHTMLVarNameValidity(i)) {
        Params.setRowSelectionInterval (i, i);
        Misc.messageBox (new String [] {"OK"}, new String [] {"Invalid Variable Name."}, 0);
        return false;
      }
      if (!checkVarDefValueValidity(i)) {
        Params.setRowSelectionInterval (i, i);
        Misc.messageBox (new String [] {"OK"}, new String [] {"Invalid Default Value."}, 0);
        return false;
      }
    }
    return true;
  }

  /** Returns a string that is the appropriate program representation of the passed
      string. For example if you pass "I'm a "Free Bulder" fan!" the return falue
      will be "I\'m a \"Free Builder\" fan!". This function is used in the automtic
      code generation. It checks for these chars:
      Quotation mark  - \"
      New Line        - \n
      Carrige return  - \r
      Apostrophe      - \'
      Back Slash      - \\
  */
  private String validateString (String ToVal) {
    java.lang.String Spec = "\"\n\t\r\'\\";
    String Ret = "";
    int i,j;
    for (i = 0; i < ToVal.length();i ++) {
      for (j = 0; j < Spec.length();j ++)
        if (Spec.charAt(j) == ToVal.charAt(i)) {
          Ret += "\\"+Spec.charAt(j);
          break;
        }
      if (j == Spec.length())
        Ret += ToVal.charAt(i);
    }
    return Ret;
  }

  private void genStrAssignment (PrintWriter Printer, int i, String Variable, String Value) {
    Printer.println ("    if (PassedParams["+i+"] == null)");
    Printer.println ("      " + Variable + " = \"" + validateString(Value) + "\";");
    Printer.println ("    else");
    Printer.println ("      " + Variable + " = PassedParams["+i+"];");
  }

  private void genBoolAssignment (PrintWriter Printer, int i, String Variable, String Value) {
    Printer.println ("    if (PassedParams["+i+"] == null)");
    Printer.println ("      " + Variable + " = " + Value.trim().toLowerCase() + ";");
    Printer.println ("    else {");
    Printer.println ("      String RealVal = PassedParams["+i+"].trim().toLowerCase();");
    Printer.println ("      if ((RealVal.compareTo(\"true\")==0) || (RealVal.compareTo(\"false\")==0))");
    Printer.println ("        " + Variable + " = (new Boolean(RealVal)).booleanValue();");
    Printer.println ("      else");
    Printer.println ("        " + Variable + " = "+ Value.trim().toLowerCase() + ";");
    Printer.println ("    }");
  }
  private void genNumAssignment (PrintWriter Printer, int i, String Variable, String Value, String ObjNum, String SimpleNum) {
    Printer.println ("    if (PassedParams["+i+"] == null)");
    Printer.println ("      " + Variable + " = " + Value + ";");
    Printer.println ("    else");
    Printer.println ("      try {");
    Printer.println ("        " + Variable + " = " + ObjNum + ".valueOf (PassedParams["+i+"])."+ SimpleNum +"Value();");
    Printer.println ("      } catch (NumberFormatException e) { " + Variable + " = " + Value + ";}");
  }

  private void genParamsAssignment (PrintWriter Printer) {
    int i;
    int Count = Params.getRowCount();
    int TypeColNo = Params.getColumnModel().getColumnIndex (TypeColID);
    int ValColNo  = Params.getColumnModel().getColumnIndex (DefaultColID);
    int VarColNo  = Params.getColumnModel().getColumnIndex (VariableColID);

    for (i = 0; i < Count; i++) {
      String Type     = Params.getModel().getValueAt (i, TypeColNo).toString();
      String Value    = Params.getModel().getValueAt (i, ValColNo).toString();
      String Variable = Params.getModel().getValueAt (i, VarColNo).toString();

      if (Type.compareTo ("String") == 0) {
        genStrAssignment (Printer, i, Variable, Value);
        continue;
      }
      if (Type.compareTo ("boolean") == 0) {
        genBoolAssignment (Printer, i, Variable, Value);
        continue;
      }
      if (Type.compareTo ("int") == 0) {
        genNumAssignment (Printer, i, Variable, Value, "Integer", Type);
        continue;
      }
      if (Type.compareTo ("short") == 0) {
        genNumAssignment (Printer, i, Variable, Value, "Short", Type);
        continue;
      }
      if (Type.compareTo ("float") == 0) {
        genNumAssignment (Printer, i, Variable, Value, "Float", Type);
        continue;
      }
      if (Type.compareTo ("double") == 0) {
        genNumAssignment (Printer, i, Variable, Value, "Double", Type);
        continue;
      }
      if (Type.compareTo ("long") == 0) {
        genNumAssignment (Printer, i, Variable, Value, "Long", Type);
        continue;
      }
    }
  }

  private void genInit (PrintWriter Printer) {
    Printer.println ("  public void init () {");
    if (Params.getRowCount() > 0) {
      Printer.println ("    String [][] Params = getParameterInfo();");
      Printer.println ("    if (Params == null)");
      Printer.println ("      return;");
      Printer.println ("    String []   PassedParams = new String [Params.length];");
      Printer.println ("    int Counter;");
      Printer.println ("    int ParamCount = Params.length;");
      Printer.println ("    for (Counter = 0; Counter < ParamCount; Counter++)");
      Printer.println ("      PassedParams[Counter] = getParameter (Params[Counter][0]);");
      genParamsAssignment(Printer);
    }
    Printer.println ("  }");
  }

  private void genGetParameterInfo (PrintWriter Printer) {
    int i;
    int Count = Params.getRowCount();
    TableColumnModel TheModel  = Params.getColumnModel();
    TableModel       DataModel = Params.getModel();
    int TypeColIndex        = TheModel.getColumnIndex(TypeColID);
    int NameColIndex        = TheModel.getColumnIndex(NameColID);
    int DescriptionColIndex = TheModel.getColumnIndex(DescriptionColID);

    Printer.println ("  public String[][] getParameterInfo () {");
    Printer.println ("    return new String[][] {");
    for (i = 0; i < Count; i++) {
      Printer.print ("      {\"" + DataModel.getValueAt(i, NameColIndex)+"\", \""+DataModel.getValueAt(i, TypeColIndex)+"\", \"" + validateString(DataModel.getValueAt(i, DescriptionColIndex).toString())+"\"}");
      if (i < Count -1)
        Printer.println (",");
      else
        Printer.println ();
    }
    Printer.println ("    };");
    Printer.println ("  }");
  }

  private void genVars (PrintWriter Printer) {
    int i;
    int Count = Params.getRowCount();
    TableColumnModel TheModel  = Params.getColumnModel();
    TableModel       DataModel = Params.getModel();
    int TypeColIndex = TheModel.getColumnIndex(TypeColID);
    int VarColIndex = TheModel.getColumnIndex(VariableColID);
    for (i = 0; i < Count; i++)
      Printer.println ("  private " + DataModel.getValueAt (i, TypeColIndex) + " " + DataModel.getValueAt (i, VarColIndex)+";");
  }

  /** Generates the applet code. */
  private void autoGen (PrintWriter Printer) {
    Printer.println ("/*FreeBuilder Applet Generator*/");
    Printer.println ();
    Printer.println ("package " + DataPanel.getPackage() + ";");
    Printer.println ();
    Printer.println ();
    Printer.println ("import java.awt.*;");
    Printer.println ("import java.applet.*;");
    Printer.println ();
    Printer.println ();
    Printer.println ("public class " + DataPanel.getClassName() + " extends Applet {");
    genVars             (Printer);
    genInit             (Printer);
    genGetParameterInfo (Printer);
    Printer.println ("}");
  }

  /** Saves the newly generated file and adds it to the project.*/
  public void createFile () {
    String FileName = DataPanel.getFileName();
    int i = 0;
    int Count = Globals.PItems.getCount();
    for (i = 0; i < Count; i++) {
      PacketItemI CurPItem = Globals.PItems.getPacketItem(i);
      if (CurPItem == null)
        continue;
      if (FileName.equalsIgnoreCase(CurPItem.getFullDosPath()))
        break;
    }
    if (i == Count)
      Globals.PManager .addFile (FileName);

    StringWriter AutoGen = new StringWriter ();
    PrintWriter Printer = new PrintWriter (AutoGen);
    autoGen (Printer);
    String Text = AutoGen.getBuffer().toString();
    Globals.TextFiles.openFile(FileName, new StringReader (Text), Text.length());
    while (!Globals.TextFiles.saveActiveFile()) {
      if (Misc.messageBox (new String [] {"Retry", "Ignore"}, new String [] {"Unable to save "+ FileName}, 1) != 0)
        break;
    }
  }

  public void actionPerformed (ActionEvent e) {
    if (e.getActionCommand().compareTo (OK_CMD) == 0) {
      if (checkValidity()) {
        Confirmed = true;
        setVisible (false);
      }
    }

    if (e.getActionCommand().compareTo (CANCEL_CMD) == 0) {
      Confirmed = false;
      setVisible (false);
    }  

    if (e.getActionCommand().compareTo (ADD_PARAM_CMD) == 0) {
      ((DefaultTableModel)Params.getModel()).addRow (new String [] {"", "", "", "", ""});
      Params.setRowSelectionInterval (Params.getRowCount()-1,Params.getRowCount()-1);
    }

    if (e.getActionCommand().compareTo (REMOVE_PARAM_CMD) == 0) {
      int SelectedRow = Params.getSelectedRow();
      if ((SelectedRow < 0) || (SelectedRow >= Params.getRowCount()))
        return;
      ((DefaultTableModel)Params.getModel()).removeRow (SelectedRow);
      if (SelectedRow < Params.getRowCount())
        Params.setRowSelectionInterval (SelectedRow, SelectedRow);
      else
        Params.setRowSelectionInterval (Params.getRowCount()-1,Params.getRowCount()-1);
    }
  }

  /** Returns <code>true</code> if the user exited the dialog pressing the "OK" button.*/
  public boolean isConfirmed () {
    return Confirmed;
  }

  //--------------- Window listener interface functions ---------------------
  public void windowClosed (WindowEvent e) {}
  public void windowIconified (WindowEvent e) {}
  public void windowDeiconified (WindowEvent e) {}
  public void windowActivated (WindowEvent e) {}
  public void windowDeactivated (WindowEvent e) {}
  public void windowOpened (WindowEvent e) {}
  public void windowClosing (WindowEvent e) {
    Confirmed = false;
    CancelButton.requestFocus();
    setVisible(false);
  }
}


