/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.system.projectman;

import java.util.EventObject;
import org.freebuilder.system.classes.options.manager.*;
import org.freebuilder.system.classes.events.engine.*;

/** Class <code>ProjectManEvent</code>. To inform other objects for changes in Project Manager.
  *
  * @author	George Petkov <a href=mailto:pgeorge@mail.techno-link.com> pgeorge@mail.techno-link.com </a>,  <a href=mailto:gpetkov@usa.net> gpetkov@usa.net</a>
  * @version 0.7, 02-12-97 */

public class ProjectManEvent extends NumberEvent {
  final static public int msgNotUsed          = 0;
  final static public int msgCloseProject  = msgNotUsed       + 1; /** add BrowseItem to the Collection */
  final static public int msgOpenProject   = msgCloseProject  + 1; /** add BrowseItem to the Collection */
  final static public int msgCreateProject = msgOpenProject   + 1; /** add BrowseItem to the Collection */
  final static public int msgSaveProject   = msgCreateProject + 1;
  final static public int msgSaveProjectAs = msgSaveProject   + 1;

  public ProjectConfig PrConf    = null;
  public boolean       CanDoThat = true;   /** Any object can set this to false (on the first dispatch pass) and prevent do this operation */
  public boolean       Done      = false;  /** the object that do the operation, if successful set it to true */
  public String        FName     = "";     /** When send msgSaveProjectAs, FName is the Project's new name */

  public ProjectManEvent(int AEventID, EventObject Event, ProjectConfig APrConf, String AFName) {
    super(AEventID, Event);
    PrConf = APrConf;
    FName  = AFName;
  }
}
