/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.system.classes.events.engine;
import java.awt.peer.*; // Sorry !!! in version 1.1 ActiveEvent was in packet java.awt.peer
import java.awt.*;      // Sorry !!! in version 1.2 ActiveEvent was in packet java.awt

/** The class <code>IdeEngineEvent</code> is the one which will transport all other events.
 *  It implements <code> ActiveEvent </code>, so the Queue dispatching thread calls every
 *  event's dispatch() method, wich calls engine's Dispatch() method.
 *
  * @author	George Petkov <a href=mailto:pgeorge@mail.techno-link.com> pgeorge@mail.techno-link.com </a>,  <a href=mailto:gpetkov@usa.net> gpetkov@usa.net</a>
 *  @version 0.7, 02-12-97 */

class IdeEngineEvent extends AWTEvent implements ActiveEvent {
  IdeEventsEngine EventsEngine; // Event's engine, which will accept the event.
  IdeSuperEvent   TheEvent;     // The event we want to deliver to the listeners.

  /** Creates a new <code>IdeEngineEvent</code>.
  * @param  AEventsEngine Event's engine, which will accept the event.
  * @param  ATheEvent     The event we want to deliver to the listeners. */

  // will be created only by IdeEventsEngine
  IdeEngineEvent(IdeEventsEngine AEventsEngine, IdeSuperEvent ATheEvent) {
    super(AEventsEngine,0);
    EventsEngine = AEventsEngine;
    TheEvent     = ATheEvent;
  }

  /** calls engine's Dispatch(TheEvent) method */
  public void dispatch() { // Inherited from ActiveEvent
    if (EventsEngine != null)
      EventsEngine.Dispatch(TheEvent, false); // false - deliver the event (not check for listeners)
  }
}
