/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.gui.idemenu;

import com.sun.java.swing.*;

import java.awt.*;
import org.freebuilder.system.classes.events.engine.IdeEventsEngine;

/** The <code>IdeMenuBar</code> class is Ide version of MenuBar. The new methods, and
  * overriden methods use IdemMenu class instead of Menu class.
  * UpdateMenu() method have to be called after the EventsEngine have been Enabled, to
  * discover the status of all MenuItems.
  *
  * @author	George Petkov <a href=mailto:pgeorge@mail.techno-link.com> pgeorge@mail.techno-link.com </a>,  <a href=mailto:gpetkov@usa.net> gpetkov@usa.net</a>
  * @version 0.7, 07-01-98 */

public class IdeMenuBar extends JMenuBar {

  public EnDisableI FindMenu(int CmndNumber) {
    int Cntr;
    EnDisableI CrntMenu;
    IdeMenu    SearchedMenu;

    for (Cntr = 0; Cntr < getMenuCount(); Cntr++) {
      SearchedMenu = (IdeMenu)getIdeMenu(Cntr);
      CrntMenu = SearchedMenu.FindMenu(CmndNumber);
      if (CrntMenu != null)
        return CrntMenu;
    }
    return null;
  }

  /** Sets Enable/Disable for all the menues, submenues and menuItems */
  public void UpdateMenu() {
    int Cntr;
    EnDisableI CrntMenu;

    for (Cntr = 0; Cntr < getMenuCount(); Cntr++) {
      CrntMenu = getIdeMenu(Cntr);
      CrntMenu.RefreshIsEnabled();
    }
  }

  public IdeMenu add(IdeMenu m) {
    return (IdeMenu) super.add (m);
  }

  public IdeMenu getIdeMenu(int i) {
    return (IdeMenu)getMenu(i);
  }

  /** Gets the help menu on the menu bar. */
  public IdeMenu getIdeHelpMenu() {
    return (IdeMenu)getHelpMenu();
  }

  public synchronized void remove(int index) {
    JMenu m = getMenu(index);
    remove(m);
  }

  public synchronized void remove(JMenu m) {
    if (m != null)
      ((IdeMenu)m).RemoveFromMenu();
    super.remove(m);
  }

}

