/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.gui.ide;

import java.awt.*;

import org.freebuilder.system.classes.*;
import org.freebuilder.gui.beans.*;
import org.freebuilder.gui.ideoptions.*;
import org.freebuilder.gui.idemenu.*;
import org.freebuilder.system.ideengine.Globals;

/**
  *  @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
   @version 0.7, 07-01-98
*/
class TDSpButtons {
  public int    CmndNumber; // Will be used in the future. By this number shall find the IdeMenuItem
  public String Hint;
  public String IconName;

  TDSpButtons(final int ACmndNumber, String AHint, String AIconName) {
    CmndNumber = ACmndNumber;
    Hint       = AHint;
    IconName   = AIconName;
  }
}

/** <code>SpeedPanel</code>  Makes Sped panel for menu commands and attach buttons to it.
  * chainging Palette Options and redraws the Palette.
  *
  * @author	George Petkov <pgeorge@mail.techno-link.com>,<gpetkov@hotmail.com>, <gpetkov@usa.net>
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
  * @version 0.7, 07-01-98
*/
public class SpeedPanel extends BPanel implements IconCanvasContainer {
  TDSpButtons SpBnsDefaults[] = {
    new TDSpButtons(IdeMainMenu.msgmiProjectOpenCreate,      "Open",       "Open.gif"),
    new TDSpButtons(IdeMainMenu.msgmiProjectSave,            "Save",       "Save.gif"),
    new TDSpButtons(IdeMainMenu.msgmiFileExit,               "Exit",       "Exit.gif"),
    new TDSpButtons(IdeMainMenu.msgmiSearchFind,             "Find",       "Find.gif"),
    new TDSpButtons(IdeMainMenu.msgmiSearchFindAgain,        "Find Again", "FindAgain.gif"),
    new TDSpButtons(IdeMainMenu.msgmiSearchReplace,          "Replace",    "Replace.gif"),
    new TDSpButtons(IdeMainMenu.msgmiRunRun,                 "Run",        "Run.gif"),
    new TDSpButtons(IdeMainMenu.msgmiRunDebug,               "Debug",      "Debug.gif"),
    new TDSpButtons(IdeMainMenu.msgmiBuildMake,              "Compile",    "Compile.gif"),
    new TDSpButtons(IdeMainMenu.msgmiBuildRebuild,           "Rebuild",    "Rebuild.gif")
  };

  private int sbCntr = 0; // Will be inc on every add for speed button.

  private int Selected     = -1;
  private int ButtonWidth  = 25;
  private int ButtonHeight = 25;
  private int Gap          = 3;
  private int TopGap       = 4;
  private int Rows         = 2;

  private String IconsDir      = Globals.spbIconsDir;
  private Insets sbInsets;

  public SpeedPanel () {
    super();
    setLayout     (new XYLayout());
    sbInsets = getInsets();
    setDefaults();
  }

  int  getSbXLoacation() {
    return (sbCntr / Rows) * (ButtonWidth + Gap) + TopGap + sbInsets.left;
  }

  int  getSbYLoacation() {
    return (sbCntr % Rows) * (ButtonHeight + Gap) + TopGap + sbInsets.top;
  }


  void AddMenuSpeedButton() {
    MenuSpeedButton SpButton;
    String          sbHint;
    String          sbIconName;
    IdeMenuItem     AMenuItem;
    int             CmndNumber;

    if (sbCntr >= SpBnsDefaults.length) return;
    // ----------------------------------------------------------------
    CmndNumber = SpBnsDefaults[sbCntr].CmndNumber;
    sbHint     = SpBnsDefaults[sbCntr].Hint;
    sbIconName = IconsDir + SpBnsDefaults[sbCntr].IconName;
    AMenuItem = (IdeMenuItem)Globals.MainMenu.FindMenu(CmndNumber);
    if (AMenuItem == null) return;

    SpButton   = new MenuSpeedButton(AMenuItem.getCmndNumber(), Globals.ResourceMngr.loadImage(sbIconName), sbCntr);

    SpButton.setLocation (getSbXLoacation(), getSbYLoacation());

    SpButton.setSize (ButtonWidth, ButtonHeight);
    SpButton.setHint (sbHint);
    SpButton.canBePressed (false);
    add(SpButton);
    AMenuItem.setSpeedButton(SpButton);

    // ----------------------------------------------------------------
    sbCntr++;
  }

  public void setDefaults() {
    sbCntr = 0;  // This have to be AddMenuSpeedButton(); and by CmndNumber to find menu item
    for (int Cntr = 0; Cntr < SpBnsDefaults.length; Cntr++)
      AddMenuSpeedButton();
  }

  public void select (int No) {}

  public Dimension getPreferredSize () {
    int Cols = (getComponentCount() / Rows) + getComponentCount() % Rows;
    Insets I = getInsets();
    return new Dimension (Cols * (ButtonWidth  + Gap) + 2 * TopGap + I.left + I.right,
                          Rows * (ButtonHeight + Gap) + 2 * TopGap + I.top  + I.bottom);
  }
}
