/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.gui.ide;

import java.awt.*;
import java.awt.event.*;

import java.io.*;
import java.util.*;

import org.freebuilder.gui.beans.*;
import org.freebuilder.gui.idemenu.*;
import org.freebuilder.gui.editors.*;
import org.freebuilder.gui.idemenu.*;
import org.freebuilder.system.debug.*;
import org.freebuilder.gui.ideoptions.*;
import org.freebuilder.system.packages.*;
import org.freebuilder.system.ideengine.*;
import org.freebuilder.system.projectman.*;
import org.freebuilder.system.classes.events.*;
import org.freebuilder.system.classes.options.*;
import org.freebuilder.system.classes.events.engine.*;
import org.freebuilder.system.classes.options.manager.*;

import com.sun.java.swing.*;
import com.sun.java.swing.tree.*;
import com.sun.java.swing.plaf.basic.*;
import com.sun.java.swing.event.*;

/**
  *  @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
   @version 0.7, 07-01-98
*/
class MyScrollPane extends JScrollPane {
  public Dimension getMinimumSize () {
    return new Dimension();
  }
}

/**
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
    @version 0.7, 07-01-98
*/
class BrowsedTreeItem implements TreeNode {
  private String Name;
  BrowsedTreeItem Parent;
  Vector Children = null;

  public BrowsedTreeItem (String Name, BrowsedTreeItem Parent) {
    this.Parent = Parent;
    this.Name = Name;
    if (Parent == null) {
      Children = new Vector();
      Children.addElement (new BrowsedTreeItem("Public", this));
      Children.addElement (new BrowsedTreeItem("Private", this));
      Children.addElement (new BrowsedTreeItem("Protected", this));
      Children.addElement (new BrowsedTreeItem("Package", this));
    }
  }

  public String toString () {
    return Name;
  }

  public Enumeration children() {
    if (Children == null)
      return null;
    return Children.elements();
  }

  public boolean getAllowsChildren() {
    if (Children == null)
      return false;
    return true;
  }

  public TreeNode getChildAt (int Index) {
    if (Children == null)
       return null;
    return (BrowsedTreeItem) Children.elementAt(Index);
  }

  public int getChildCount() {
    if (Children == null)
      return 0;
    return Children.size();
  }

  public int getIndex(TreeNode Child) {
    if (Children == null)
      return -1;
    return Children.indexOf (Child);
  }

  public TreeNode getParent() {
    return Parent;
  }

  public boolean isLeaf() {
    if (Children == null)
      return true;
    return false;
  }
}

/**
   @author	Peter Radkov <wreck@nat.bg>
   @version 0.7, 07-01-98
*/
class MyTreeModel extends DefaultTreeModel {
  public MyTreeModel (TreeNode TheRoot) {
    super(TheRoot);
  }

  public void changeRootName () {
    Object[] listeners = listenerList.getListenerList();
    TreeModelEvent e = null;
    for (int i = listeners.length-2; i>=0; i-=2) {
      if (listeners[i] == TreeModelListener.class) {
        if (e == null)
          e = new TreeModelEvent(this, new Object[] {root});
        ((TreeModelListener)listeners[i+1]).treeNodesChanged(e);
      }
    }
  }
}

/**
   @author	Peter Radkov <wreck@nat.bg>
   @version 0.7, 07-01-98
*/
public class ProjectPanel extends BPanel implements TreeSelectionListener,
                                                    OptionsSetable,
                                                    CheckEnDisI {
  private MyScrollPane FileScroll     = new MyScrollPane();
  private MyScrollPane ProjScroll     = new MyScrollPane();
  private MySplitPane TheSplit;
  private JPanel FilePanel              = new JPanel();
  private JPanel ProjPanel              = new JPanel();
  private SJPanel SpeedPanel            = new SJPanel ();
  private ProjectTreeItem TheTreeRoot   = new ProjectTreeItem (null, null, -1, null);
  private BrowsedTreeItem TheBrowseRoot = new BrowsedTreeItem ("Some File", null);
  private JTree FilesTree               = new JTree(new MyTreeModel(TheTreeRoot));
  private JTree ProjectManagerTree      = new JTree(TheBrowseRoot);
  private boolean IsToPost              = true;
  private boolean IsToUpdateSelection   = true;

  private MenuSpeedButton AddButton        = new MenuSpeedButton (IdeMainMenu.msgmiOpenDirectory,
                                             Globals.ResourceMngr.loadImage (Globals.spbIconsDir + "Add.gif"),       0);
  private MenuSpeedButton AddRootButton    = new MenuSpeedButton (IdeMainMenu.msgmiOpenDirTree,
                                             Globals.ResourceMngr.loadImage (Globals.spbIconsDir + "AddRoot.gif"),   1);
  private MenuSpeedButton AddPacketButton  = new MenuSpeedButton (IdeMainMenu.msgmiOpenPackage,
                                             Globals.ResourceMngr.loadImage (Globals.spbIconsDir + "AddPacket.gif"), 2);
  private MenuSpeedButton AddPacketsButton = new MenuSpeedButton (IdeMainMenu.msgmiOpenPackageTree,
                                             Globals.ResourceMngr.loadImage (Globals.spbIconsDir + "AddPackets.gif"),3);
  private MenuSpeedButton RemoveButton     = new MenuSpeedButton (IdeMainMenu.msgmiProjectRemoveFromProject,
                                             Globals.ResourceMngr.loadImage (Globals.spbIconsDir + "Remove.gif"),   4);
  private MenuSpeedButton AddFileButton    = new MenuSpeedButton (IdeMainMenu.msgmiFileOpen,
                                             Globals.ResourceMngr.loadImage (Globals.spbIconsDir + "New.gif"),      5);

  private int SpeedButtonsSize         = 24;
  private String SelectedItem;
  private boolean RefreshInProgress    = false;

  public ProjectPanel () {
    super ();
    setInner (BPanel.NONE);
    setOuter (BPanel.NONE);

    FilePanel.setLayout (new BorderLayout());
    FileScroll.setViewport(new MyViewport());
    FileScroll.getViewport().setView(FilesTree);

    AddButton       .setSize (SpeedButtonsSize, SpeedButtonsSize);
    AddRootButton   .setSize (SpeedButtonsSize, SpeedButtonsSize);
    AddPacketButton .setSize (SpeedButtonsSize, SpeedButtonsSize);
    AddPacketsButton.setSize (SpeedButtonsSize, SpeedButtonsSize);
    RemoveButton    .setSize (SpeedButtonsSize, SpeedButtonsSize);
    AddFileButton   .setSize (SpeedButtonsSize, SpeedButtonsSize);

    AddButton       .canBePressed (false);
    AddRootButton   .canBePressed (false);
    AddPacketButton .canBePressed (false);
    AddPacketsButton.canBePressed (false);
    RemoveButton    .canBePressed (false);
    AddFileButton   .canBePressed (false);

    AddButton       .setHint ("Add Directory");
    AddRootButton   .setHint ("Add Root Directory");
    AddPacketButton .setHint ("Add Package");
    AddPacketsButton.setHint ("Add Root Package");
    RemoveButton    .setHint ("Remove");
    AddFileButton   .setHint ("Add File");

    SpeedPanel.setLayout (new FlowLayout(FlowLayout.LEFT, 1, 1));

    SpeedPanel.add (AddPacketButton);
    SpeedPanel.add (AddPacketsButton);
    SpeedPanel.add (AddButton);
    SpeedPanel.add (AddRootButton);
    SpeedPanel.add (RemoveButton);
    SpeedPanel.add (AddFileButton);

    FilePanel.add (SpeedPanel, BorderLayout.NORTH);
    FilePanel.add (FileScroll, BorderLayout.CENTER);

    ProjPanel.setLayout (new BorderLayout());
    ProjScroll.setViewport(new MyViewport());
    ProjScroll.getViewport().setView(ProjectManagerTree);

    ProjPanel.add (ProjScroll, BorderLayout.CENTER);

    TheSplit = new MySplitPane (MySplitPane.VERTICAL_SPLIT, this);
    TheSplit.setUI              (new MySplitPaneUI (this));
    TheSplit.setDividerSize     (3);
    TheSplit.setTopComponent    (FilePanel);
    TheSplit.setBottomComponent (ProjPanel);

    setLayout (new BorderLayout());
    add (TheSplit, BorderLayout.CENTER);

    Globals.IEngine.AddSystemEventAdapter  (SystemEvent.msgActiveFileSet,        this, "selectActiveFile");
    Globals.IEngine.AddSystemEventAdapter  (SystemEvent.msgProjectNameChanged,   this, "renameRoot");
    Globals.IEngine.AddSystemEventAdapter  (SystemEvent.msgRootPathsBeginUpdate, this, "forbidButtons");

    OptionsEventAdapter OptionsAdapter = null;
    try {
      OptionsAdapter = new OptionsEventAdapter (MainPanelOptions.MainPanelOptionsName, OptionsEvent.msgOptionsRefresh,
                                             IdeEventListenerI.CALL_MASK, this, "getCurrentOptions");
      Globals.EventsEngine.AddEventListener(OptionsAdapter);

      OptionsAdapter = new OptionsEventAdapter (ProjectOptions.cDefaultName, OptionsEvent.msgOptionsRefresh,
                                           IdeEventListenerI.AFTER_CALL_MASK, this, "renameRoot");
      Globals.EventsEngine.AddEventListener(OptionsAdapter);

      Globals.IEngine.AddSystemEventAdapter (SystemEvent.msgPItemsChanged, IdeEventListenerI.AFTER_CALL_MASK, this, "updateTree");
      Globals.IEngine.AddSystemEventAdapter (SystemEvent.msgPItemsRefresh, IdeEventListenerI.AFTER_CALL_MASK, this, "rebuildTree");
      Globals.AddDoBeforeProjectManEAdapter (ProjectManEvent.msgCreateProject, this, "projectNew");
      Globals.AddDoAfterProjectManEAdapter  (ProjectManEvent.msgOpenProject,   this, "projectOpened");
      Globals.AddDoAfterProjectManEAdapter  (ProjectManEvent.msgCreateProject, this, "projectOpened");
      Globals.AddDoAfterProjectManEAdapter  (ProjectManEvent.msgCloseProject,  this, "projectClosed");
      Globals.AddDoBeforeProjectManEAdapter (ProjectManEvent.msgCloseProject,  this, "projectClosing");

    } catch (NoSuchMethodException e) {
      Debug.Assert(e, this, "MainPanel : No such Method.");
    }

    IdeMenuItem AMenuItem;
    AMenuItem = (IdeMenuItem) Globals.MainMenu.FindMenu(IdeMainMenu.msgmiProjectRemoveFromProject);
    AMenuItem.setSpeedButton (RemoveButton);
    AMenuItem.setCheckStatusListener (this);

    AMenuItem = (IdeMenuItem) Globals.MainMenu.FindMenu(IdeMainMenu.msgmiOpenDirectory);
    AMenuItem.setSpeedButton (AddButton);
    AMenuItem.setCheckStatusListener (this);

    AMenuItem = (IdeMenuItem) Globals.MainMenu.FindMenu(IdeMainMenu.msgmiOpenDirTree);
    AMenuItem.setSpeedButton (AddRootButton);
    AMenuItem.setCheckStatusListener (this);

    AMenuItem = (IdeMenuItem) Globals.MainMenu.FindMenu(IdeMainMenu.msgmiOpenPackage);
    AMenuItem.setSpeedButton (AddPacketButton);
    AMenuItem.setCheckStatusListener (this);

    AMenuItem = (IdeMenuItem) Globals.MainMenu.FindMenu(IdeMainMenu.msgmiOpenPackageTree);
    AMenuItem.setSpeedButton (AddPacketsButton);
    AMenuItem.setCheckStatusListener (this);

    AMenuItem = (IdeMenuItem) Globals.MainMenu.FindMenu(IdeMainMenu.msgmiFileOpen);
    AMenuItem.setSpeedButton (AddFileButton);
    AMenuItem.setCheckStatusListener (this);

    AMenuItem = (IdeMenuItem) Globals.MainMenu.FindMenu(IdeMainMenu.msgmiFileNew);
    AMenuItem.setCheckStatusListener (this);

    getCurrentOptions (null);
    onCloseProject    (null);
    FilesTree.setCellRenderer          (new ProjectTreeRenderer());
    FilesTree.addTreeSelectionListener (this);
  }

  public String getSelectedProjectItemName () {
    Object[] TheSelectedPath = FilesTree.getSelectionPath().getPath();
    return ((ProjectTreeItem)TheSelectedPath[TheSelectedPath.length-1]).getFileName();
  }

  public int getSelectedProjectItemKind () {
    Object[] TheSelectedPath = FilesTree.getSelectionPath().getPath();
    return ((ProjectTreeItem)TheSelectedPath[TheSelectedPath.length-1]).getNodeKind();
  }

  public boolean HaveToEnableMenuItem (IdeMenuItem TheItem) {
    if ((!Globals.PManager.isOpenedProject()) || RefreshInProgress)
      return false;

    if (TheItem.getCmndNumber() != IdeMainMenu.msgmiProjectRemoveFromProject)
      return true;

    if (FilesTree.getSelectionPath() == null)
      return false;

    Object[] TheSelectedPath = FilesTree.getSelectionPath().getPath();
    if (TheSelectedPath.length != 2)
      return false;
    else
      return true;
  }

  public void projectNew (IdeSuperEvent AEvent) {
    ProjectManEvent TheEvent = (ProjectManEvent) AEvent;
    File NewPrjFile = new File (TheEvent.FName);
    if (NewPrjFile.exists() &&
        (Misc.messageBox (new String[] {"OK", "Cancel"}, new String []
        {"Project ", TheEvent.FName, " already exists. Overwrite?"}, 1) == 1))
      TheEvent.CanDoThat = false;
  }

  public void projectClosing (IdeSuperEvent AEvent) {
    MainMenuEvent CloseAll = new MainMenuEvent (IdeMainMenu.msgmiFileCloseAll, this);
    Globals.EventsEngine.SendEvent (CloseAll);
    ProjectManEvent TheEvent = (ProjectManEvent) AEvent;
    TheEvent.CanDoThat = (CloseAll.Result == 0);
  }

  private void updateRemoveButtonState () {
    Globals.EventsEngine.PostEvent (new MainMenuEvent (IdeMainMenu.msgmiProjectRemoveFromProject, MainMenuEvent.msubcRefresh, this));
  }
  private void updateAddDirButtonState () {
    Globals.EventsEngine.PostEvent (new MainMenuEvent (IdeMainMenu.msgmiOpenDirectory, MainMenuEvent.msubcRefresh, this));
  }
  private void updateAddDirsButtonState () {
    Globals.EventsEngine.PostEvent (new MainMenuEvent (IdeMainMenu.msgmiOpenDirTree, MainMenuEvent.msubcRefresh, this));
  }
  private void updateAddPackageButtonState () {
    Globals.EventsEngine.PostEvent (new MainMenuEvent (IdeMainMenu.msgmiOpenPackage, MainMenuEvent.msubcRefresh, this));
  }
  private void updateAddPackagesButtonState () {
    Globals.EventsEngine.PostEvent (new MainMenuEvent (IdeMainMenu.msgmiOpenPackageTree, MainMenuEvent.msubcRefresh, this));
  }
  private void updateAddFileButtonState () {
    Globals.EventsEngine.PostEvent (new MainMenuEvent (IdeMainMenu.msgmiFileOpen, MainMenuEvent.msubcRefresh, this));
  }
  private void updateBuildButtonState () {
    Globals.EventsEngine.PostEvent (new MainMenuEvent (IdeMainMenu.msgmiBuildRebuild, MainMenuEvent.msubcRefresh, this));
  }
  private void updateCompileButtonState () {
    Globals.EventsEngine.PostEvent (new MainMenuEvent (IdeMainMenu.msgmiBuildMake, MainMenuEvent.msubcRefresh, this));
  }
  private void updateBuildProjectButtonState () {
    Globals.EventsEngine.PostEvent (new MainMenuEvent (IdeMainMenu.msgmiBuildRebuildProject, MainMenuEvent.msubcRefresh, this));
  }
  private void updateMakeProjectButtonState () {
    Globals.EventsEngine.PostEvent (new MainMenuEvent (IdeMainMenu.msgmiBuildMakeProject, MainMenuEvent.msubcRefresh, this));
  }
  private void updateRunButtonState () {
    Globals.EventsEngine.PostEvent (new MainMenuEvent (IdeMainMenu.msgmiRunRun, MainMenuEvent.msubcRefresh, this));
  }
  private void updateDebugButtonState () {
    Globals.EventsEngine.PostEvent (new MainMenuEvent (IdeMainMenu.msgmiRunDebug, MainMenuEvent.msubcRefresh, this));
  }
  private void updateProjectCloseButtonState () {
    Globals.EventsEngine.PostEvent (new MainMenuEvent (IdeMainMenu.msgmiProjectClose, MainMenuEvent.msubcRefresh, this));
  }
  private void updateProjectSaveButtonState () {
    Globals.EventsEngine.PostEvent (new MainMenuEvent (IdeMainMenu.msgmiProjectSave, MainMenuEvent.msubcRefresh, this));
  }
  private void updateProjectSaveAsButtonState () {
    Globals.EventsEngine.PostEvent (new MainMenuEvent (IdeMainMenu.msgmiProjectSaveAs, MainMenuEvent.msubcRefresh, this));
  }
  private void updateProjectPropsButtonState () {
    Globals.EventsEngine.PostEvent (new MainMenuEvent (IdeMainMenu.msgmiProjectProperties, MainMenuEvent.msubcRefresh, this));
  }
  private void updateProjectRenameButtonState () {
    Globals.EventsEngine.PostEvent (new MainMenuEvent (IdeMainMenu.msgmiProjectRename, MainMenuEvent.msubcRefresh, this));
  }
  private void updateProjectStoreButtonState () {
    Globals.EventsEngine.PostEvent (new MainMenuEvent (IdeMainMenu.msgmiProjectStore, MainMenuEvent.msubcRefresh, this));
  }
  private void updateProjectDocsButtonState () {
    Globals.EventsEngine.PostEvent (new MainMenuEvent (IdeMainMenu.msgmiProjectDocumentation, MainMenuEvent.msubcRefresh, this));
  }



  private void updateRemoveButtonStateNow () {
    Globals.EventsEngine.SendEvent (new MainMenuEvent (IdeMainMenu.msgmiProjectRemoveFromProject, MainMenuEvent.msubcRefresh, this));
  }
  private void updateAddDirButtonStateNow () {
    Globals.EventsEngine.SendEvent (new MainMenuEvent (IdeMainMenu.msgmiOpenDirectory, MainMenuEvent.msubcRefresh, this));
  }
  private void updateAddDirsButtonStateNow () {
    Globals.EventsEngine.SendEvent (new MainMenuEvent (IdeMainMenu.msgmiOpenDirTree, MainMenuEvent.msubcRefresh, this));
  }
  private void updateAddPackageButtonStateNow () {
    Globals.EventsEngine.SendEvent (new MainMenuEvent (IdeMainMenu.msgmiOpenPackage, MainMenuEvent.msubcRefresh, this));
  }
  private void updateAddPackagesButtonStateNow () {
    Globals.EventsEngine.SendEvent (new MainMenuEvent (IdeMainMenu.msgmiOpenPackageTree, MainMenuEvent.msubcRefresh, this));
  }
  private void updateAddFileButtonStateNow () {
    Globals.EventsEngine.SendEvent (new MainMenuEvent (IdeMainMenu.msgmiFileOpen, MainMenuEvent.msubcRefresh, this));
  }
  private void updateBuildButtonStateNow () {
    Globals.EventsEngine.SendEvent (new MainMenuEvent (IdeMainMenu.msgmiBuildRebuild, MainMenuEvent.msubcRefresh, this));
  }
  private void updateCompileButtonStateNow () {
    Globals.EventsEngine.SendEvent (new MainMenuEvent (IdeMainMenu.msgmiBuildMake, MainMenuEvent.msubcRefresh, this));
  }
  private void updateBuildProjectButtonStateNow () {
    Globals.EventsEngine.SendEvent (new MainMenuEvent (IdeMainMenu.msgmiBuildRebuildProject, MainMenuEvent.msubcRefresh, this));
  }
  private void updateMakeProjectButtonStateNow () {
    Globals.EventsEngine.SendEvent (new MainMenuEvent (IdeMainMenu.msgmiBuildMakeProject, MainMenuEvent.msubcRefresh, this));
  }
  private void updateRunButtonStateNow () {
    Globals.EventsEngine.SendEvent (new MainMenuEvent (IdeMainMenu.msgmiRunRun, MainMenuEvent.msubcRefresh, this));
  }
  private void updateDebugButtonStateNow () {
    Globals.EventsEngine.SendEvent (new MainMenuEvent (IdeMainMenu.msgmiRunDebug, MainMenuEvent.msubcRefresh, this));
  }
  private void updateProjectCloseButtonStateNow () {
    Globals.EventsEngine.SendEvent (new MainMenuEvent (IdeMainMenu.msgmiProjectClose, MainMenuEvent.msubcRefresh, this));
  }
  private void updateProjectSaveButtonStateNow () {
    Globals.EventsEngine.SendEvent (new MainMenuEvent (IdeMainMenu.msgmiProjectSave, MainMenuEvent.msubcRefresh, this));
  }
  private void updateProjectSaveAsButtonStateNow () {
    Globals.EventsEngine.SendEvent (new MainMenuEvent (IdeMainMenu.msgmiProjectSaveAs, MainMenuEvent.msubcRefresh, this));
  }
  private void updateProjectPropsButtonStateNow () {
    Globals.EventsEngine.SendEvent (new MainMenuEvent (IdeMainMenu.msgmiProjectProperties, MainMenuEvent.msubcRefresh, this));
  }
  private void updateProjectRenameButtonStateNow () {
    Globals.EventsEngine.SendEvent (new MainMenuEvent (IdeMainMenu.msgmiProjectRename, MainMenuEvent.msubcRefresh, this));
  }
  private void updateProjectStoreButtonStateNow () {
    Globals.EventsEngine.SendEvent (new MainMenuEvent (IdeMainMenu.msgmiProjectStore, MainMenuEvent.msubcRefresh, this));
  }
  private void updateProjectDocsButtonStateNow () {
    Globals.EventsEngine.SendEvent (new MainMenuEvent (IdeMainMenu.msgmiProjectDocumentation, MainMenuEvent.msubcRefresh, this));
  }

  private void updateButtonsState () {
    updateRemoveButtonState ();
    updateAddFileButtonState ();
    updateAddDirButtonState ();
    updateAddDirsButtonState ();
    updateAddPackageButtonState ();
    updateAddPackagesButtonState ();
    updateBuildButtonState ();
    updateCompileButtonState ();
    updateBuildProjectButtonState ();
    updateMakeProjectButtonState ();
    updateRunButtonState ();
    updateDebugButtonState ();
    updateProjectCloseButtonState ();
    updateProjectSaveButtonState ();
    updateProjectSaveAsButtonState ();
    updateProjectPropsButtonState ();
    updateProjectRenameButtonState ();
    updateProjectStoreButtonState ();
    updateProjectDocsButtonState ();
  }

  private void updateButtonsStateNow () {
    updateRemoveButtonStateNow ();
    updateAddFileButtonStateNow ();
    updateAddDirButtonStateNow ();
    updateAddDirsButtonStateNow ();
    updateAddPackageButtonStateNow ();
    updateAddPackagesButtonStateNow ();
    updateBuildButtonStateNow ();
    updateCompileButtonStateNow ();
    updateBuildProjectButtonStateNow ();
    updateMakeProjectButtonStateNow ();
    updateRunButtonStateNow ();
    updateDebugButtonStateNow ();
    updateProjectCloseButtonStateNow ();
    updateProjectSaveButtonStateNow ();
    updateProjectSaveAsButtonStateNow ();
    updateProjectPropsButtonStateNow ();
    updateProjectRenameButtonStateNow ();
    updateProjectStoreButtonStateNow ();
    updateProjectDocsButtonStateNow ();
  }

  public void forbidButtons (IdeSuperEvent AEvent) {
    RefreshInProgress = true;
    updateButtonsStateNow ();
  }


  private void onCloseProject (IdeSuperEvent AEvent) {
    updateButtonsState();
    renameRoot (AEvent);
  }

  public void projectClosed (IdeSuperEvent AEvent) {
    ProjectManEvent TheEvent = (ProjectManEvent) AEvent;
    if (TheEvent.Done)
      onCloseProject(AEvent);
  }

  public void projectOpened (IdeSuperEvent AEvent) {
    updateButtonsState();
    renameRoot (AEvent);
 }

  public void setNewOptions () {
    OptionsMngr AOptions = Globals.IEngine.getOptions();
    MainPanelOptions TheOptions = (MainPanelOptions) (AOptions.getOptions(MainPanelOptions.MainPanelOptionsName));
    TheOptions.setProjSpliterLoc (TheSplit.getDividerLocation());
    AOptions.setOptions(TheOptions);
  }

  public void getCurrentOptions (IdeSuperEvent AEvent) {
    OptionsMngr AOptions = Globals.IEngine.getOptions();
    MainPanelOptions TheOptions = (MainPanelOptions) (AOptions.getOptions(MainPanelOptions.MainPanelOptionsName));
    if (TheOptions != null) {
      TheSplit.setDividerLocation(TheOptions.getProjSpliterLoc ());
      doLayout();
    }
  }

  private void doSend (String FileName) {
    IsToUpdateSelection = false;
    Globals.EventsEngine.SendEvent (new SystemEvent (SystemEvent.msgSetActiveFile, this, FileName));
    IsToUpdateSelection = true;
  }

  public void valueChanged (TreeSelectionEvent e) {
    if (FilesTree.getSelectionPath() == null) {
      updateRemoveButtonState();
      return;
    }

    updateRemoveButtonState();

    Object [] TheSelctedPath = FilesTree.getSelectionPath().getPath();
    ProjectTreeItem TheSelctedItem = (ProjectTreeItem) TheSelctedPath [TheSelctedPath.length-1];
    SelectedItem     = TheSelctedItem.getFileName();
    if (!IsToPost)
      return;

    if ((SelectedItem != null) && (TheSelctedItem.getFile() != null) &&
         ((TheSelctedItem.getFile().getPacketItemKind() == PacketItemI.cpikClass) ||
          (TheSelctedItem.getFile().getPacketItemKind() == PacketItemI.cpikHtml))) {
      doSend (SelectedItem);
      return;
    }

    if ((SelectedItem != null) && (TheSelctedItem.isToBeShown()))
      doSend (SelectedItem);
    else
      doSend ("");
  }

  public void selectActiveFile (IdeSuperEvent AEvent) {
    if (!IsToUpdateSelection)
      return;
    String TheFile = ((SystemEvent) AEvent).StrValue;
    TreePath PathToNode = TheTreeRoot.getPathToNode (TheFile, 1);
    if (PathToNode != null) {
      IsToPost = false;
      FilesTree.setSelectionPath (PathToNode);
      IsToPost = true;
    }
  }


  public void rebuildTree (IdeSuperEvent AEvent) {
    RefreshInProgress = false;
    Vector Children = TheTreeRoot.getChildren();
    int TreeItemsCount = Children.size();
    MyTreeModel  TheModel   = (MyTreeModel) FilesTree.getModel();
    for (int i = 0; i < TreeItemsCount; i++)
      TheModel.removeNodeFromParent ((ProjectTreeItem)Children.elementAt(0));
    updateTree (AEvent);
    updateAddFileButtonState ();
    updateAddDirButtonState ();
    updateAddDirsButtonState ();
    updateAddPackageButtonState ();
    updateAddPackagesButtonState ();
  }

  public void updateTree (IdeSuperEvent AEvent) {
    Vector Children         = TheTreeRoot.getChildren();
    MyTreeModel  TheModel   = (MyTreeModel) FilesTree.getModel();
    int i,j;
    int PrjItemsCount  = Globals.PItems.getCount();
    int TreeItemsCount = Children.size();

    boolean [] ToAdd    = new boolean [PrjItemsCount];

    for (i = 0; i < PrjItemsCount; i++)
      ToAdd [i] = true;
    for (i = 0; i < TreeItemsCount; i++) {
      ProjectTreeItem CurPrjTreeItem = (ProjectTreeItem) Children.elementAt(i);
      String CurrentItemInTree       = CurPrjTreeItem.getFileName();
      for (j = 0; j < PrjItemsCount; j++) {
        String CurrentProjItemName = Globals.PItems.getString(j);
        if ((CurrentProjItemName.equalsIgnoreCase(CurrentItemInTree)) &&
            (Globals.PItems.getPacketItemKind(j) == CurPrjTreeItem.getNodeKind())) {
          ToAdd [j] = false;
          break;
        }
      }

      if (j == PrjItemsCount) {
        TheModel.removeNodeFromParent (CurPrjTreeItem);
        TreeItemsCount--;
        i--;
      }
    }

    for (i = 0; i < PrjItemsCount; i++)
      if (ToAdd[i]) {
        ProjectTreeItem NewEntry = new ProjectTreeItem (TheTreeRoot, Globals.PItems.getPacketItem(i),
                                                        Globals.PItems.getPacketItemKind(i),
                                                        Globals.PItems.getString(i));
        TheModel.insertNodeInto (NewEntry, TheTreeRoot, TheTreeRoot.findEntryPos (NewEntry));
      }
    updateRemoveButtonState();
    FilesTree.expandRow(0);
  }

  public void focusItem (String FullDosPath) {
    TreePath PathToItem = TheTreeRoot.getPathToNode (FullDosPath, 1);
    if (PathToItem != null)
      FilesTree.setSelectionPath (PathToItem);
  }

  public void renameRoot (IdeSuperEvent AEvent) {
    ((MyTreeModel) FilesTree.getModel()).changeRootName ();
    FilesTree.expandRow(0);
  }
}

