/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */
package org.freebuilder.gui.config;

import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import org.freebuilder.gui.beans.*;
import org.freebuilder.system.ideengine.*;
/**
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
    @version 0.7, 07-01-98
*/
class MemorySizesDialog extends JDialog implements ItemListener, ActionListener {
  private String OK_CMD     = "OK";
  private String CANCEL_CMD = "Cancel";

  private JTextField NativeStack          = new JTextField();
  private JTextField JavaStack            = new JTextField();
  private JTextField InitialHeap          = new JTextField();
  private JTextField JavaHeap             = new JTextField();

  private ButtonGroup NativeStackGroup  = new ButtonGroup ();
  private ButtonGroup JavaStackGroup    = new ButtonGroup ();
  private ButtonGroup InitialHeapGroup  = new ButtonGroup ();
  private ButtonGroup JavaHeapGroup     = new ButtonGroup ();

  private JRadioButton DefNativeStack    = new JRadioButton ("Use Default", true);
  private JRadioButton DefJavaStack      = new JRadioButton ("Use Default", true);
  private JRadioButton DefInitialHeap    = new JRadioButton ("Use Default", true);
  private JRadioButton DefJavaHeap       = new JRadioButton ("Use Default", true);

  private JRadioButton UserNativeStack   = new JRadioButton ("User Defined", false);
  private JRadioButton UserJavaStack     = new JRadioButton ("User Defined", false);
  private JRadioButton UserInitialHeap   = new JRadioButton ("User Defined", false);
  private JRadioButton UserJavaHeap      = new JRadioButton ("User Defined", false);

  private JPanel NativeStackSmallPanel = new JPanel();
  private JPanel JavaStackSmallPanel   = new JPanel();
  private JPanel InitialHeapSmallPanel = new JPanel();
  private JPanel JavaHeapSmallPanel    = new JPanel();

  private BPanel NativeStackPanel     = new BPanel("Maximum native stack size for any thread:");
  private BPanel JavaStackPanel       = new BPanel("Maximum Java stack size for any thread:");
  private BPanel InitialHeapPanel     = new BPanel("Initial Java heap size:");
  private BPanel JavaHeapPanel        = new BPanel("Maximum Java heap size:");
  private BPanel SizesPanel           = new BPanel("Memory Sizes:");

  private BPanel ButtonsPanel           = new BPanel();

  private Button OKButton     = new Button (OK_CMD);
  private Button CancelButton = new Button (CANCEL_CMD);

  private boolean Confirmed;

  public MemorySizesDialog () {
    super(Globals.IdeMainFrame);
    setTitle ("Configure Memory Sizes");
    setModal (true);
    getContentPane().setLayout (new BorderLayout());

    NativeStackPanel .setLayout (new BorderLayout());
    JavaStackPanel   .setLayout (new BorderLayout());
    InitialHeapPanel .setLayout (new BorderLayout());
    JavaHeapPanel    .setLayout (new BorderLayout());
    SizesPanel       .setLayout (new GridLayout (2, 2, 5, 5));

    NativeStackSmallPanel.setLayout (new GridLayout(1, 2));
    JavaStackSmallPanel  .setLayout (new GridLayout(1, 2));
    InitialHeapSmallPanel.setLayout (new GridLayout(1, 2));
    JavaHeapSmallPanel   .setLayout (new GridLayout(1, 2));

    NativeStackPanel.add (NativeStack,  BorderLayout.SOUTH);
    JavaStackPanel  .add (JavaStack,    BorderLayout.SOUTH);
    InitialHeapPanel.add (InitialHeap,  BorderLayout.SOUTH);
    JavaHeapPanel   .add (JavaHeap,     BorderLayout.SOUTH);

    NativeStackPanel.add (NativeStackSmallPanel,  BorderLayout.NORTH);
    JavaStackPanel  .add (JavaStackSmallPanel,    BorderLayout.NORTH);
    InitialHeapPanel.add (InitialHeapSmallPanel,  BorderLayout.NORTH);
    JavaHeapPanel   .add (JavaHeapSmallPanel,     BorderLayout.NORTH);

    NativeStackSmallPanel.add (UserNativeStack);
    JavaStackSmallPanel  .add (UserJavaStack);
    InitialHeapSmallPanel.add (UserInitialHeap);
    JavaHeapSmallPanel   .add (UserJavaHeap);

    NativeStackSmallPanel.add (DefNativeStack);
    JavaStackSmallPanel  .add (DefJavaStack);
    InitialHeapSmallPanel.add (DefInitialHeap);
    JavaHeapSmallPanel   .add (DefJavaHeap);

    NativeStackGroup.add (UserNativeStack);
    JavaStackGroup  .add (UserJavaStack);
    InitialHeapGroup.add (UserInitialHeap);
    JavaHeapGroup   .add (UserJavaHeap);

    NativeStackGroup.add (DefNativeStack);
    JavaStackGroup  .add (DefJavaStack);
    InitialHeapGroup.add (DefInitialHeap);
    JavaHeapGroup   .add (DefJavaHeap);

    DefNativeStack  .addItemListener (this);
    DefJavaStack    .addItemListener (this);
    DefInitialHeap  .addItemListener (this);
    DefJavaHeap     .addItemListener (this);

    UserNativeStack  .addItemListener (this);
    UserJavaStack    .addItemListener (this);
    UserInitialHeap  .addItemListener (this);
    UserJavaHeap     .addItemListener (this);

    NativeStack.setEditable (false);
    JavaStack  .setEditable (false);
    InitialHeap.setEditable (false);
    JavaHeap   .setEditable (false);

    NativeStack.setEnabled (false);
    JavaStack  .setEnabled (false);
    InitialHeap.setEnabled (false);
    JavaHeap   .setEnabled (false);

    SizesPanel       .add (NativeStackPanel);
    SizesPanel       .add (JavaStackPanel);
    SizesPanel       .add (InitialHeapPanel);
    SizesPanel       .add (JavaHeapPanel);
    getContentPane().add (SizesPanel, BorderLayout.NORTH);

    ButtonsPanel.setLayout (new GridLayout (1, 2, 5, 5));
    ButtonsPanel.add (OKButton);
    ButtonsPanel.add (CancelButton);

    OKButton    .addActionListener (this);
    CancelButton.addActionListener (this);

    getContentPane().add (ButtonsPanel, BorderLayout.SOUTH);

    pack ();
    Misc.hardCenter(this);
  }

  public void actionPerformed (ActionEvent e) {
    String CMD = e.getActionCommand();
    if (CMD.compareTo (OK_CMD) == 0)
      Confirmed = true;

    if (CMD.compareTo (CANCEL_CMD) == 0)
      Confirmed = false;

    setVisible (false);
  }

  public void itemStateChanged (ItemEvent e) {
    if (e.getSource().equals (DefNativeStack)) {
      NativeStack.setEnabled  (false);
      NativeStack.setEditable (false);
    }
    if (e.getSource().equals (UserNativeStack)) {
      NativeStack.setEnabled  (true);
      NativeStack.setEditable (true);
    }

    if (e.getSource().equals (DefJavaStack)) {
      JavaStack.setEnabled  (false);
      JavaStack.setEditable (false);
    }
    if (e.getSource().equals (UserJavaStack)) {
      JavaStack.setEnabled  (true);
      JavaStack.setEditable (true);
    }

    if (e.getSource().equals (DefInitialHeap)) {
      InitialHeap.setEnabled  (false);
      InitialHeap.setEditable (false);
    }
    if (e.getSource().equals (UserInitialHeap)) {
      InitialHeap.setEnabled  (true);
      InitialHeap.setEditable (true);
    }

    if (e.getSource().equals (DefJavaHeap)) {
      JavaHeap.setEnabled  (false);
      JavaHeap.setEditable (false);
    }
    if (e.getSource().equals (UserJavaHeap)) {
      JavaHeap.setEnabled  (true);
      JavaHeap.setEditable (true);
    }
  }

  public boolean isConfirmed () {
    return Confirmed;
  }

  public void setNativeStack (String NativeStackSize) {
    NativeStack.setText (NativeStackSize);
  }
  public void setJavaStack (String NewJavaStackSize) {
    JavaStack  .setText (NewJavaStackSize);
  }
  public void setInitialHeap (String NewInitialHeapSize) {
    InitialHeap.setText (NewInitialHeapSize);
  }
  public void setJavaHeap (String NewJavaHeapSize) {
    JavaHeap   .setText (NewJavaHeapSize);
  }

  public String getNativeStack () {
    return NativeStack.getText ();
  }

  public String getJavaStack () {
    return JavaStack.getText ();
  }

  public String getInitialHeap () {
    return InitialHeap.getText ();
  }

  public String getJavaHeap () {
    return JavaHeap.getText ();
  }

  public void setDefaultNativeStack (boolean isDefaultNativeStack) {
    if (isDefaultNativeStack)
      DefNativeStack .setSelected (true);
    else {
      UserNativeStack.setSelected (true);
      NativeStack.setEnabled   (true);
      NativeStack.setEditable  (true);
    }
  }

  public void setDefaultJavaStack (boolean isDefaultJavaStack) {
    if (isDefaultJavaStack)
      DefJavaStack  .setSelected (true);
    else {
      UserJavaStack .setSelected (true);
      JavaStack.setEnabled  (true);
      JavaStack.setEditable (true);
    }
  }

  public void setDefaultInitialHeap (boolean isDefaultInitialHeap) {
    if (isDefaultInitialHeap)
      DefInitialHeap .setSelected (true);
    else {
      UserInitialHeap.setSelected (true);
      InitialHeap.setEnabled  (true);
      InitialHeap.setEditable (true);
    }
  }

  public void setDefaultJavaHeap (boolean isDefaultJavaHeap) {
    if (isDefaultJavaHeap)
      DefJavaHeap .setSelected (true);
    else {
      UserJavaHeap.setSelected (true);
      JavaHeap.setEnabled  (true);
      JavaHeap.setEditable (true);
    }
  }

  public boolean isDefaultNativeStack () {
    return DefNativeStack.isSelected();
  }
  public boolean isDefaultJavaStack   () {
    return DefJavaStack.isSelected();
  }
  public boolean isDefaultInitialHeap () {
    return DefInitialHeap.isSelected();
  }
  public boolean isDefaultJavaHeap    () {
    return DefJavaHeap.isSelected();
  }
}

