/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.gui.beans;

import java.awt.*;
import java.awt.event.*;
import org.freebuilder.gui.idemenu.*;
import org.freebuilder.system.classes.events.engine.*;
import org.freebuilder.system.ideengine.Globals;

/** <code>MenuSpeedButton</code>  is for Use only from IdeMenuItems. This class is for
  * creating a speed buttons which are attached to some IdeMenuItem. IF a menu item is
  * disabled, the corresponding MenuSpeedButton is also disabled. If this situation, it
  * can not send a message !
  *
  * @author	George Petkov <a href=mailto:pgeorge@mail.techno-link.com> pgeorge@mail.techno-link.com </a>,  <a href=mailto:gpetkov@usa.net> gpetkov@usa.net</a>
  * @version 1.00, 07-01-98 */

public class MenuSpeedButton extends SpeedButton implements EnDisableI, SpeedListener {
  int FCmndNumber;
  public MenuSpeedButton(int CmndNumber, Image I, int No, int States) {
    super (I, No, States);
    Init(CmndNumber);
  }

  /** Initializes the object. */
  public MenuSpeedButton(int CmndNumber, Image I, int No) {
    super (I, No, 3);
    Init(CmndNumber);
  }

  private void Init(int ACmnd) {
    setCmndNumber(ACmnd);
    addActionListener(this);
  }

  private void setCmndNumber(int ACmnd) {
    FCmndNumber = ACmnd;
  }

  // From EnDisableI interface ----------------------------------------------------
  public void    setEnabled(boolean Enable) {
    super.setEnabled(Enable);
  }

  public boolean isEnabled() {
    return super.isEnabled();
  }

  public boolean RefreshIsEnabled() {
    return isEnabled();
  }

  public void    RemoveFromMenu() {}
  public void    AddToMenu() {}

  public int     getCmndNumber() {
    return FCmndNumber;
  }
  //-------------------------------------------------------------------------------

  // From SpeedListener interface -------------------------------------------------
  public void actionPerformed(ActionEvent e) {
    Globals.EventsEngine.PostEvent(new MainMenuEvent (FCmndNumber, this));
  }
  public void speedEntered (SpeedButton Source) {}
  public void speedExited  (SpeedButton Source) {}
  //-------------------------------------------------------------------------------

}
