/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.system.projectman;

import java.util.EventObject;

import org.freebuilder.system.classes.*;
import org.freebuilder.system.classes.options.*;
import org.freebuilder.system.classes.options.manager.*;
import org.freebuilder.system.ideengine.*;
import org.freebuilder.system.classes.events.engine.*;
import org.freebuilder.system.debug.*;
import org.freebuilder.gui.beans.*;

/** This class will keep all the project options, including items in project manager
  *
  * @author	George Petkov <a href=mailto:pgeorge@mail.techno-link.com> pgeorge@mail.techno-link.com </a>,  <a href=mailto:gpetkov@usa.net> gpetkov@usa.net</a>
  * @version 0.7, 12/12/97
*/

public class ProjectOptions extends BrowseCollection {
  public static final String cDefaultName  = "Project Options";

  private String RunnableClass;
  private String RunnableHTML;
  private boolean UsePizzaCompiler;
  private int     RunApplication;

  public ProjectOptions() {
    super(cDefaultName);
    setDefaults ();
  }

  public void AssignFrom (BrowseCollection Another) { // Override
    super.AssignFrom(Another);
    ProjectOptions AnotherProjOpts = (ProjectOptions) Another;
    setRunnable           (new String (AnotherProjOpts.getRunnable()));
    setRunnableHTML       (new String (AnotherProjOpts.getRunnableHTML()));
    setRunApplication     (AnotherProjOpts.getRunApplication());
  }

  public Object clone() {
    ProjectOptions TheClone    = (ProjectOptions) super.clone();
    TheClone.setRunnable           (new String (getRunnable()));
    TheClone.setRunnableHTML       (new String (getRunnableHTML()));
    TheClone.setRunApplication     (getRunApplication());
    return TheClone;
  }

  public int getRunApplication () {
    return RunApplication;
  }
  public void setRunApplication (int NewValue) {
    RunApplication = NewValue;
  }

  public boolean isUsePizzaCompiler () {
    return UsePizzaCompiler;
  }
  public void setUsePizzaCompiler (boolean NewValue) {
    UsePizzaCompiler = NewValue;
  }

  public String getRunnable () {
    return RunnableClass;
  }

  public void setRunnable (String NewRunnable) {
    RunnableClass = NewRunnable;
  }

  public String getRunnableHTML () {
    return RunnableHTML;
  }

  public void setRunnableHTML (String NewRunnable) {
    RunnableHTML = NewRunnable;
  }
// ================ OptionsSuperI implementation ================

  public OptionsSuperI Clone () throws CloneNotSupportedException {
    return super.Clone();
  }

  public void setDefaults () {
    super.setDefaults();
    setUsePizzaCompiler   (false);
    setRunnable           ("");
    setRunnableHTML       ("");
    setRunApplication     (1);
  }

  public boolean IsDifferent(OptionsSuperI TheOtherOne) {
    if (super.IsDifferent(TheOtherOne))
      return true;
    ProjectOptions Match = (ProjectOptions) TheOtherOne;
    if (Match.isUsePizzaCompiler() != isUsePizzaCompiler())
      return true;
    if (Match.getRunnable().compareTo (getRunnable()) != 0)
      return true;
    if (Match.getRunnableHTML().compareTo (getRunnableHTML()) != 0)
      return true;
    if (Match.getRunApplication() != getRunApplication())
      return true;
    return false;
  }

  public String getName() {
    return super.getName();
  }

  /** for testing */
  void PrintStringArray(String [] SArray) {
    int Cntr;
    for (Cntr = 0; Cntr < SArray.length; Cntr++)
      if (SArray[Cntr] != null) System.out.println(SArray[Cntr]);
  }

  /** for testing */
  public void PrintContent() {
    super.PrintContent();
    System.out.println("Project Manager content begin --------------------------------- ");
    System.out.println("Runnable       : " + RunnableClass);
    System.out.println("RunnableHTML   : " + RunnableHTML);
    System.out.println("UsePizzaCompiler : " + UsePizzaCompiler);
    System.out.println("Project Manager content end   --------------------------------- ");
  }
}
