/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.system.projectman;

import java.util.EventObject;
import org.freebuilder.system.classes.*;
import org.freebuilder.system.classes.options.*;
import org.freebuilder.system.debug.*;

import org.freebuilder.system.classes.events.*;
import org.freebuilder.system.ideengine.*;
import org.freebuilder.system.packages.*;

/** This class represents a collection of BrowsaCollItem objects. It Adds the ability to
  * to save it contents in Options of the current project. So, it's the best superclass
  * for Project manager, but can be used separately if you want to have a reference to
  * some Package or file.
  *
  * @author	George Petkov <a href=mailto:pgeorge@mail.techno-link.com> pgeorge@mail.techno-link.com </a>,  <a href=mailto:gpetkov@usa.net> gpetkov@usa.net</a>
  * @version 0.7, 12/12/97
*/

public class BrowseCollection extends StringList implements OptionsSuperI {
  public static final String cDefaultName  = "Opened Items Options";
  private             String OptionsName = cDefaultName;

  public BrowseCollection(String AOptionsName) {
    setDefaults();
    OptionsName = AOptionsName;
  }

  public OptionsSuperI Clone() throws CloneNotSupportedException {
    int Cntr;
    BrowseCollection TheClonedOne = null;
    Object NewItem;

    TheClonedOne = (BrowseCollection) clone();

    for (Cntr = 0; Cntr < getCount(); Cntr++) {
      NewItem = ((BrowseCollItem) getObject(Cntr)).clone();
      TheClonedOne.setObject (Cntr,NewItem);
    }
    return TheClonedOne;
  }

  public BrowseCollItem getBrowseCollItem (int Index) {
    return (BrowseCollItem) getObject(Index);
  }

  public BrowseCollItem getBrowseCollItem (String Name) {
    return (BrowseCollItem) getObject(IndexOf(Name));
  }

  /** Override this method complietly */
  public synchronized void setString(int Index, final String S) throws ArrayIndexOutOfBoundsException {
    BrowseCollItem CrntItem;

    CheckBounds(Index);
    Changing();
    CrntItem = (BrowseCollItem )getObject(Index);
    CrntItem.ItemDosPath = S;
    Changed();
  }

  /** Override this method complietly */
  public String getString(int Index) throws ArrayIndexOutOfBoundsException {
    BrowseCollItem CrntItem = (BrowseCollItem )getObject(Index);
    if (CrntItem == null) {
      Debug.Assert(false, this, "Debug : CrntItem == null");
      return "";
    }
    return CrntItem.ItemDosPath;
  }

  public int addBrowseItem(BrowseCollItem BCItem) {
    if (BCItem == null) return -1;
    int Index = Add(BCItem.ItemDosPath, BCItem);
    return Index;
  }

  public int addBrowseItem(int AKind, String AName) {
    if (Debug.isDebug) Debug.Assert((AKind >= BrowseCollItem.ikFile) && (AKind <= BrowseCollItem.ikDirectoryRoot), this, "Invalid Kind");
    return addBrowseItem(new BrowseCollItem(AKind, AName));
  }

  public int addFile(String AFileName) {
    return addBrowseItem(BrowseCollItem.ikFile , AFileName);
  }

  public int addPackage(String APackageName) {
    return addBrowseItem(BrowseCollItem.ikPackage, APackageName);
  }

  public int addPackageRoot(String APackageName) {
    return addBrowseItem(BrowseCollItem.ikPackagesRoot, APackageName);
  }

  public int addDirectory(String ADirectoryName) {
    return addBrowseItem(BrowseCollItem.ikDirectory, ADirectoryName);
  }

  public int addDirectoryRoot(String ADirectoryName) {
    return addBrowseItem(BrowseCollItem.ikDirectoryRoot, ADirectoryName);
  }

  public BrowseCollItem getBrowseItem(int AIndex) throws ArrayIndexOutOfBoundsException {
    return (BrowseCollItem)getObject(AIndex);
  }

  public int isItem(BrowseCollItem BCItem) {
    BrowseCollItem BItem1;
    int Cntr,   ToCount;
    if (BCItem == null) return -1;

    ToCount = getCount();
    for (Cntr = 0; Cntr < ToCount; Cntr++) {
      BItem1 = (BrowseCollItem) getObject(Cntr);
      if (! BCItem.IsDifferent(BItem1)) return Cntr;
    }
    return -1;
  }

  public int isItem(int AKind, String AName) {
    BrowseCollItem BItem1 = new BrowseCollItem(AKind, AName);
    return isItem(BItem1); 
  }

  // Begin of functions of interface OptionsSuperI
  // ====================================================================================
  public OptionsEvent PrepareEvent(int EventNumber) {
    return new OptionsEvent(EventNumber, new EventObject(this), this);
  }

  public boolean IsDifferent(OptionsSuperI TheOtherOne) {
    int ItemsCntr, ToCount;
    BrowseCollection BColl;
    BrowseCollItem   CrntItem, NItem;

    BColl   = (BrowseCollection)TheOtherOne; if (BColl == null) return true;
    ToCount = getCount();                    if (BColl.getCount() != ToCount) return true;
    try {
      for (ItemsCntr = 0; ItemsCntr < ToCount; ItemsCntr++) {
        CrntItem = (BrowseCollItem)      getObject(ItemsCntr); if (CrntItem == null) return true;
        NItem    = (BrowseCollItem)BColl.getObject(ItemsCntr);
        if (CrntItem.IsDifferent(NItem)) return true;
      }
    }
    catch(ArrayIndexOutOfBoundsException e) {
      return true;
    }
    return false;
  }

  public String getName () {
    return OptionsName;
  }

  public void setDefaults() {
    Clear();
  }

  public void AssignFrom(BrowseCollection Another) {
    int ItemsCntr, ToCount;
    BrowseCollItem   CrntItem, NItem;

    if (! IsDifferent(Another)) return;

    ToCount = Another.getCount();
    BeginUpdate();
    try {
      Clear();
      for (ItemsCntr = 0; ItemsCntr < ToCount; ItemsCntr++) {
        CrntItem = Another.getBrowseItem(ItemsCntr);
        if (CrntItem != null)
          addBrowseItem((BrowseCollItem)CrntItem.clone());
      }
    }
    finally {
      EndUpdate();
    }
  }

  // ====================================================================================
  // End   of functions of interface OptionsSuperI
  public synchronized Object clone() {
    return super.clone();
  }

  /** for testing */
  public void PrintContent() {
    int            Cntr;
    BrowseCollItem BcItem;

    System.out.println("Browse Collection content begin --------------------------------- ");
    for (Cntr = 0; Cntr < getCount(); Cntr++) {
      BcItem = getBrowseCollItem(Cntr);
      if (BcItem != null)
        BcItem.PrintContent();
    }
    System.out.println("Browse Collection content end   --------------------------------- ");
  }
}
