/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.system.projectman;

import java.util.EventObject;
import org.freebuilder.system.classes.options.*;

/** Class <code>BrowseCollItemEvent</code>. To inform other objects for changes in Browse
  * collection, or Project Manager.
  *
  * @author	George Petkov <a href=mailto:pgeorge@mail.techno-link.com> pgeorge@mail.techno-link.com </a>,  <a href=mailto:gpetkov@usa.net> gpetkov@usa.net</a>
  * @version 0.7, 02-12-97 */

public class BrowseCollItemEvent extends OptionsEvent {
  final static public int msgNotUsed          = 0;
  /** Next 2 messages are SENDED !!!  */
  final static public int msgAddItem          = msgNotUsed          + 1; /** add BrowseItem to the Collection */
  final static public int msgRemoveItem       = msgAddItem          + 1; /** add BrowseItem to the Collection */
  final static public int msgTheLastOne       = msgRemoveItem       + 1;

  BrowseCollection BColl     = null;
  BrowseCollItem   BCItem    = null;
  boolean          CanDoThat = true;   /** Any object can set this to false (on the first dispatch pass) and prevent do this operation */
  boolean          Done      = false;  /** the object that do the operation, if successful set it to true */
  int              Index     = -1;     /** if add item Index = Index of this item in collection */

  public BrowseCollItemEvent(int AEventID, EventObject Event, BrowseCollection Options, BrowseCollItem ABrItem) {
    super(AEventID, Event, Options);
    BCItem = ABrItem;
    BColl  = Options;
  }
}
