/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.system.paths;

import java.io.*;
import java.net.*;
import java.util.*;
import org.freebuilder.system.classes.*;
import org.freebuilder.gui.ideoptions.*;
import org.freebuilder.system.ideengine.*;

/**
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
    @version 0.7, 07-01-98
*/
public class DistinctPathList extends StringList {

  public DistinctPathList () {
    super ();
    construct ();
  }

  public void construct () {
    Clear();
    PathsOptions AllPaths = (PathsOptions) Globals.Options.getOptions (PathsOptions.PathsOptionsName);

    addToPaths (AllPaths.getPizzaSourceOutPath(), DistinctPathItem.FROM_PIZZASOURCEOUT_PATH);
    addToPaths (AllPaths.getSourcePath()        , DistinctPathItem.FROM_SOURCE_PATH);
    addToPaths (AllPaths.getClassOutPath()      , DistinctPathItem.FROM_CLASS_OUT_PATH);
    addToPaths (AllPaths.getClassPath()         , DistinctPathItem.FROM_CLASS_PATH);
    addToPaths (AllPaths.getDocPath()           , DistinctPathItem.FROM_DOC_PATH);
    addToPaths (AllPaths.getJavaDOCOutPath()    , DistinctPathItem.FROM_JAVADOC_OUT_PATH);

    try {
      /*
      URL AnURL = new URL ("file", "", -1, "c:\\Autoexec.bat");
      System.out.println  ("Protocol : [" + AnURL.getProtocol() + "]");
      System.out.println  ("File : [" + AnURL.getFile() + "]");
      System.out.println  ("Host : [" + AnURL.getHost() + "]");
      System.out.println  ("Port : [" + AnURL.getPort() + "]");
      System.out.println  ("Ref : [" + AnURL.getRef() + "]");
      System.out.println  (AnURL.toExternalForm());
      System.out.println (AnURL.getContent().getClass().getName());
      System.out.println (AnURL.openStream());
      */

      URL AnURL = new URL ("file", "", -1, "c:\\");
      System.out.println  ("Protocol : [" + AnURL.getProtocol() + "]");
      System.out.println  ("File : [" + AnURL.getFile() + "]");
      System.out.println  ("Host : [" + AnURL.getHost() + "]");
      System.out.println  ("Port : [" + AnURL.getPort() + "]");
      System.out.println  ("Ref : [" + AnURL.getRef() + "]");
      System.out.println  (AnURL.toExternalForm());
      System.out.println (AnURL.getContent().getClass().getName());
      System.out.println (AnURL.openStream());



    } catch (Exception e) {
          System.out.println (e);
    }
  }

  private void addToPaths (String ThePath, int FromWhere) {
    String RealPath = ThePath.toLowerCase();
    if (IndexOf (RealPath) == -1)
      Add (RealPath, new DistinctPathItem (RealPath, FromWhere));
  }

  private void addToPaths (String[] Paths, int FromWhere) {
    int i;
    for (i = 0; i < Paths.length; i++)
      addToPaths (Paths[i], FromWhere);
  }

  public int getPathsCount () {return getCount();}
  public boolean contains (String APath) {
    return IndexOf (APath) >= 0;
  }

  public int partOfWhat   (String APath) {
    if (!contains (APath))
      return DistinctPathItem.NOT_FROM_SYSTEM_PATHS;
    return ((DistinctPathItem)getObject (APath)).partOfWhat();
  }

  public void print () {
    int i;
    System.out.println ("------------------- System Paths List ----------------------");
    for (i = 0; i < getCount(); i++)
     System.out.println (getString (i) + " from " + ((DistinctPathItem)getObject(i)).getType());
    System.out.println ("---------------- End of System Paths List ------------------");
  }
}
