/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.system.packages;
import java.util.*;

/** <code>RootPathI</code> interface is used to find the Root path for packages.
  * if it is in a directory than the path is the path to that directory.
  * if it is a some .jar or .zip file, the path to it.
  * relative path is relative to the project file path.
  * if can not be made a relative path than getRootRelativePath will return getRootFullPath
  * Example for library file    : c:\FbProject\FreeBuilder.jar
  *    and project file name is : c:\FbProject\FbTests\MenuTest.jpr
  *
  *    getRootFullPath()      will return c:\FbProject\FreeBuilder.jar
  *    getRootRelativePath()  will return ..\..\FreeBuilder.jar
  *
  * @author	George Petkov <a href=mailto:pgeorge@mail.techno-link.com> pgeorge@mail.techno-link.com </a>,  <a href=mailto:gpetkov@usa.net> gpetkov@usa.net</a>
  * @version 0.7, 12/12/97
*/
public interface RootPathI {
  String getRootFullPath();
  String getRootRelativePath();
}
