/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.system.packages;

import java.util.*;
import org.freebuilder.system.classes.*;
import org.freebuilder.system.ideengine.Globals;
import java.util.zip.*;
import java.io.*;

/** <code>PacketItemI</code> is for organizing hirerachically packets and projects
  * every element in this hierarchy (item) have to implement this interface
  *
  * @author	George Petkov <a href=mailto:pgeorge@mail.techno-link.com> pgeorge@mail.techno-link.com </a>,  <a href=mailto:gpetkov@usa.net> gpetkov@usa.net</a>
  * @version 0.7, 12-12-97
*/

public class PZipFileEntry extends PSFileEntry {
  private String   FileNameInZip = "";

  public PZipFileEntry(ZipEntry  AZipEntry, String AFileName, PacketItemI AParentItem, PacketItemI ARootItem) {
    super(AParentItem, ARootItem, ""); if (AZipEntry == null) return;
    FileName      = AFileName;
    FileNameInZip = AZipEntry.getName();
  }

  public  boolean     isChanged() {
    return false; // if (parent != null) return parent.isChanged;     .
  }

  public String getFileNameInZip() {
    return FileNameInZip;
  }

  public  boolean isStable() {
    return true;
  }

  public void Refresh() {}

  // End of the methods from PacketItemI interface ---------------------------------------
}
