/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.system.classes.events;

import java.util.EventObject;
import org.freebuilder.system.classes.events.engine.*;

/** Class <code>SystemEvent</code>. IdeEngine will send and receive events of that class.
  * This kind of events will rule the program.
  *
  * @author	George Petkov <a href=mailto:pgeorge@mail.techno-link.com> pgeorge@mail.techno-link.com </a>,  <a href=mailto:gpetkov@usa.net> gpetkov@usa.net</a>
  * @version 0.7, 02-12-97 */

public class SystemEvent extends NumberEvent {
  public final static int msgOnStartUp = 0;   // Start up the program.
  public final static int msgOpenProject      = msgOnStartUp        + 1; // Try to Open project with. (From Open project Dialog
  public final static int msgProjectIsOpened  = msgOpenProject      + 1; // To reload Options for this Project
  public final static int msgCanCloseID       = msgProjectIsOpened  + 1; // Query for closing the application

  public final static int msgOpenTextFile                = msgCanCloseID          + 1; // Will be accepted by TextEditorsManager
  public final static int msgTextFileWasOpened           = msgOpenTextFile        + 1; // if Event.Result = 1 Successful.
  public final static int msgCloseActiveTextFile         = msgTextFileWasOpened   + 1; // Will be accepted by TextEditorsManager
  public final static int msgTextFileWasClosed           = msgCloseActiveTextFile + 1; // if Event.Result = 1 Successful.

  public final static int msgMenuQuery_CanUndo           = msgTextFileWasClosed           + 1;
  public final static int msgMenuQuery_CanRedo           = msgMenuQuery_CanUndo           + 1;
  public final static int msgMenuQuery_CanCut            = msgMenuQuery_CanRedo           + 1;
  public final static int msgMenuQuery_CanCopy           = msgMenuQuery_CanCut            + 1;
  public final static int msgMenuQuery_CanPaste          = msgMenuQuery_CanCopy           + 1;
  public final static int msgMenuQuery_CanDelete         = msgMenuQuery_CanPaste          + 1;
  public final static int msgMenuQuery_CanSelectAll      = msgMenuQuery_CanDelete         + 1;
  public final static int msgMenuQuery_CanFind           = msgMenuQuery_CanSelectAll      + 1;
  public final static int msgMenuQuery_CanReplace        = msgMenuQuery_CanFind           + 1;
  public final static int msgMenuQuery_CanSearchAgain    = msgMenuQuery_CanReplace        + 1;
  public final static int msgMenuQuery_CanGoToLineNumber = msgMenuQuery_CanSearchAgain    + 1;

  public final static int msgMenuQuery_CanSave           = msgMenuQuery_CanGoToLineNumber + 1;
  public final static int msgMenuQuery_CanSaveAs         = msgMenuQuery_CanSave           + 1;
  public final static int msgMenuQuery_CanSaveAll        = msgMenuQuery_CanSaveAs         + 1;
  public final static int msgMenuQuery_CanSaveProject    = msgMenuQuery_CanSaveAll        + 1;
  public final static int msgMenuQuery_CanClose          = msgMenuQuery_CanSaveProject    + 1;
  public final static int msgMenuQuery_CanCloseAll       = msgMenuQuery_CanClose          + 1;

  public final static int msgSetActiveFile               = msgMenuQuery_CanCloseAll       + 1;
  public final static int msgActiveFileSet               = msgSetActiveFile               + 1;
  public final static int msgAddToProject                = msgActiveFileSet               + 1;
  public final static int msgProjectNameChanged          = msgAddToProject                + 1;
  public final static int msgRootPathsChanged            = msgProjectNameChanged          + 1;
  public final static int msgRootPathsBeginUpdate        = msgRootPathsChanged            + 1;
  public final static int msgPItemsChanged               = msgRootPathsBeginUpdate        + 1;
  public final static int msgPItemsRefresh               = msgPItemsChanged               + 1;

  public final static int msgLastSystemEvent             = msgPItemsRefresh               + 1; //Query for closing the application

  public String  StrValue = "";
  public int     IntValue;
  public double  RealValue;
  public boolean BooleanValue;
  public int     Result = 0;

  public SystemEvent(int AEventID, EventObject Event) { super(AEventID, Event); }
  public SystemEvent(int AEventID, Object Sender) {
    this (AEventID, new EventObject(Sender));
  }

  public SystemEvent(int AEventID, Object Sender, String AStrValue) {
    this (AEventID, new EventObject(Sender));
    StrValue = AStrValue;
  }

  public SystemEvent(int AEventID, Object Sender, int AIntValue) {
    this (AEventID, new EventObject(Sender));
    IntValue = AIntValue;
  }

  public SystemEvent(int AEventID, Object Sender, double ARealValue) {
    this (AEventID, new EventObject(Sender));
    RealValue = ARealValue;
  }

  public SystemEvent(int AEventID, Object Sender, boolean ABooleanValue) {
    this (AEventID, new EventObject(Sender));
    BooleanValue = ABooleanValue;
  }
}

