/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.gui.idemenu;

import com.sun.java.swing.*;
import com.sun.java.swing.event.*;

import java.awt.*;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import org.freebuilder.system.classes.events.*;
import org.freebuilder.system.classes.events.engine.IdeEventsEngine;

/**
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
    @version 0.7, 07-01-98
*/

class DumbSeparator extends JSeparator implements EnDisableI {
  public void    setEnabled(boolean Enable) {}
  public boolean isEnabled()                {return true;}
  public boolean RefreshIsEnabled()         {return true;}
  public void    RemoveFromMenu()           {}
  public void    AddToMenu()                {}
  public int     getCmndNumber()            {return MainMenuEvent.mmsgNotUsed;}
}

/** The <code>IdeMenu</code> class is Ide version of Menu class. The new methods, and
  * overriden methods use IdeMenuItem class instead of MenuItem class.
  * When open this menu it calls for all it's MenuItems & SubMenues RefreshIsEnabled() is
  * called to set their Enable/Disable status.
  *
  * @author	George Petkov <pgeorge@mail.techno-link.com>,<gpetkov@hotmail.com>, <gpetkov@usa.net>
  * @version 0.7, 07-01-98
*/
public class IdeMenu extends JMenu implements EnDisableI, MenuListener {
  private int             FCmndNumber;
  private int             DeleteMe = 0;

  public IdeMenu(int CmndNumber) {
    FCmndNumber  = CmndNumber;
  }

  public void menuCanceled    (com.sun.java.swing.event.MenuEvent e) {
  }

  public void menuSelected     (com.sun.java.swing.event.MenuEvent e) {
    RefreshIsEnabled();
  }

  public void menuDeselected (com.sun.java.swing.event.MenuEvent e) {
  }

  public EnDisableI FindMenu(int CmndNumber) {
    int        Cntr;
    EnDisableI menuItem;
    IdeMenu    SubMenu;

    for (Cntr = 0; Cntr < getMenuComponentCount(); Cntr++) {
      menuItem = getIdeMenuItem(Cntr);
      if (menuItem.getCmndNumber() == CmndNumber)
        return menuItem;

      if (menuItem instanceof IdeMenu) {
        SubMenu = (IdeMenu)menuItem;
        menuItem = SubMenu.FindMenu(CmndNumber);
        if (menuItem != null)
          return menuItem;
      }
    }
    return null;
  }

  // From EnDisableI interface ----------------------------------------------------
  /** Enable all it's children (MenuItems & SubMenues) */
  public void    setEnabled(boolean Enable) {
    int        Cntr;
    EnDisableI menuItem;
    for (Cntr = 0; Cntr < getMenuComponentCount(); Cntr++) {
      menuItem = getIdeMenuItem(Cntr);
      menuItem.setEnabled(Enable);
    }
  }

  /** returns true if all it's children (MenuItems & SubMenues) are enabled */
  public boolean isEnabled() {
    int        Cntr;
    EnDisableI menuItem;

    for (Cntr = 0; Cntr < getMenuComponentCount(); Cntr++) {
      menuItem = getIdeMenuItem(Cntr);
      if (menuItem.isEnabled())
        return true;
    }
    return true; // BUG in Swing JMenu!!! Beacuse when the menu is disabled it does't work properly!
//    return false;
  }

  /** This method is called by IdeMenuBar.UpdateMenu, or when this menu is opened.
    * It calls for each MenuItem.CheckStatus to enable or disable every MenuItem, or SubMenu
    * if All the menuItems or SubMenues in this menu are disabled the Menu is disabled too
    * @return isEnabled() for the menu.
    */
  public boolean RefreshIsEnabled() {
    int        Cntr;
    EnDisableI menuItem = null;

    for (Cntr = 0; Cntr < getMenuComponentCount(); Cntr++) {
      menuItem = getIdeMenuItem (Cntr);
      menuItem.RefreshIsEnabled();
    }
    return isEnabled();
  }

  public void addSeparator () {
    super.add (new DumbSeparator());
  }

  /** For all it's children calls RemoveFromMenu. At last calls removeActionListener(this) */
  public void    RemoveFromMenu() {
    int        Cntr;
    EnDisableI menuItem;

    for (Cntr = 0; Cntr < getMenuComponentCount(); Cntr++) {
      menuItem = getIdeMenuItem(Cntr);
      menuItem.RemoveFromMenu();
    }
  }

  /** For all it's children calls AddToMenu. At last calls addActionListener(this) */
  public void    AddToMenu() {
    int        Cntr;
    EnDisableI menuItem;

    for (Cntr = 0; Cntr < getMenuComponentCount(); Cntr++) {
      menuItem = getIdeMenuItem(Cntr);
      menuItem.AddToMenu();
    }
  }

  public int     getCmndNumber() {
    return FCmndNumber;
  }
  //-------------------------------------------------------------------------------

  /** Adds the specified item to this menu and calls it's AddToMenu(). */
  public void add (IdeMenuItem menuItem) {
    EnDisableI IItem;

    super.add (menuItem);
    IItem = (EnDisableI)menuItem;
    IItem.AddToMenu();
  }

  /** Adds an item with with the specified label to this menu. @param label the text on the item */
  public void add(String label, int CmndNumber) {
    add(new IdeMenuItem(CmndNumber, label));
  }

  public EnDisableI getIdeMenuItem (int index) {
    return (EnDisableI) getMenuComponent(index);
  }

  /** Deletes the specified item from this menu. and calls it's RemoveFromMenu method. */
  public synchronized void remove(int index) {
    EnDisableI menuItem;
    menuItem = getIdeMenuItem(index);
    if (menuItem != null)
      menuItem.RemoveFromMenu();
    super.remove(index);
  }

  /** Deletes the specified item from this menu. and calls it's RemoveFromMenu method. */
  public synchronized void remove(MenuComponent item) {
    ((EnDisableI)item).RemoveFromMenu();
    super.remove(item);
  }
}

