/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.gui.ide;
import com.sun.java.swing.*;
import com.sun.java.swing.plaf.basic.*;
import com.sun.java.swing.event.*;

import org.freebuilder.gui.ideoptions.abstr.*;
import org.freebuilder.gui.ideoptions.*;

import java.awt.event.*;
import java.awt.*;

import java.beans.*;
import org.freebuilder.gui.beans.*;
import org.freebuilder.system.debug.*;
import org.freebuilder.system.classes.events.engine.*;
import org.freebuilder.system.classes.options.*;
import org.freebuilder.system.ideengine.Globals;

/** <code>IdeBeansPalette</code>  is only an extention of Palette, which handle events for
  * chainging Palette Options and redraws the Palette.
  *
  * @author	George Petkov <a href=mailto:pgeorge@mail.techno-link.com> pgeorge@mail.techno-link.com </a>,  <a href=mailto:gpetkov@usa.net> gpetkov@usa.net</a>
  * @version 0.7, 07-01-98 */

public class IdeBeansPalette extends Palette {
  public IdeBeansPalette() {
    super();
    FPaletteMan = new PaletteOptions();
    AddHandleOptions();
    setPalette(FPaletteMan);
  }

  public void AddHandleOptions() {
    String              OptionsName  = PaletteOptions.PaletteManOptionsName;
    IdeEventsEngine     EventsEngine = Globals.EventsEngine;
    OptionsEventAdapter OptionsAdapter   = null;

    if (EventsEngine == null)  return;
    try {
      OptionsAdapter = new OptionsEventAdapter(OptionsName, OptionsEvent.msgOptionsChanged, this, "OnStartUp");
      EventsEngine.AddEventListener(OptionsAdapter);

      OptionsAdapter = new OptionsEventAdapter(OptionsName, OptionsEvent.msgOptionsRefresh, this, "OnStartUp");
      EventsEngine.AddEventListener(OptionsAdapter);
    }
    catch (NoSuchMethodException e) {
      if (Debug.isDebug) {
        Debug.Assert(e, this,"NoSuchMethodException");
      }
    }
    catch (SecurityException     e) {
      if (Debug.isDebug) {
        Debug.Assert(e, this,"SecurityException");
      }
    };
  }

  public void OnStartUp(IdeSuperEvent AEvent) {
    OptionsEvent   Event    = (OptionsEvent)AEvent;
    PaletteOptions     FOptions = (PaletteOptions)Event.getOptions();
    setPalette(FOptions);
  }
}

