/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.gui.config;

import java.io.*;
import java.awt.*;
import java.awt.event.*;

import org.freebuilder.gui.beans.*;
import org.freebuilder.system.classes.*;


/**
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
    @version 0.7, 07-01-98
*/
public class PathEditorDialog extends Dialog implements ActionListener {
  private static final String ADD_PATH_CMD             = "Add Path";
  private static final String ADD_ARCH_CMD             = "Add Archive";
  private static final String REMOVE_CMD               = "Remove";
  private static final String OK_CMD                   = "OK";
  private static final String CANCEL_CMD               = "Cancel";

  private Frame ParentFrame;

  private List Paths                   = new List ();
  private Button AddPathButton         = new Button (ADD_PATH_CMD);
  private Button AddArchiveButton      = new Button (ADD_ARCH_CMD);
  private Button RemoveButton          = new Button (REMOVE_CMD);
  private Button OKButton              = new Button (OK_CMD);
  private Button CancelButton          = new Button (CANCEL_CMD);
  private BPanel ButtonsPanel          = new BPanel();
  private BPanel PathButtonsPanel      = new BPanel();
  private BPanel ListPanel             = new BPanel("Paths:");
  private BPanel NorthPanel            = new BPanel();
  private BPanel MainPanel             = new BPanel();
  private boolean Confirmed;


  public PathEditorDialog (Frame ParentFrame, StringList Dirs) {
    this(ParentFrame);
    initList (Dirs);
  }

  public PathEditorDialog (Frame ParentFrame, String[] Dirs) {
    this(ParentFrame);
    initList (Dirs);
  }

  public PathEditorDialog (Frame ParentFrame) {
    super (ParentFrame);
    setModal (true);
    setTitle ("Edit Paths");
    setLayout (new BorderLayout());
    setSize (400, 300);
    Misc.hardCenter (this);

    this.ParentFrame = ParentFrame;

    MainPanel.setLayout (new BorderLayout());
    MainPanel.setInner  (BPanel.NONE);
    MainPanel.setOuter  (BPanel.NONE);
    MainPanel.setBorderWidth  (5);

    NorthPanel.setLayout(new BorderLayout());

    PathButtonsPanel.setLayout (new GridLayout (1, 3, 5, 5));
    PathButtonsPanel.add (AddPathButton);
    PathButtonsPanel.add (AddArchiveButton);
    PathButtonsPanel.add (RemoveButton);
    NorthPanel.add (PathButtonsPanel, BorderLayout.SOUTH);

    ListPanel.setLayout (new BorderLayout());
    ListPanel.add       (Paths, BorderLayout.CENTER);
    NorthPanel.add       (ListPanel, BorderLayout.CENTER);

    MainPanel.add (NorthPanel, BorderLayout.CENTER);
    add (MainPanel, BorderLayout.CENTER);

    ButtonsPanel.setLayout (new GridLayout (1, 2, 5, 5));
    ButtonsPanel.add (OKButton);
    ButtonsPanel.add (CancelButton);

    MainPanel.add (ButtonsPanel, BorderLayout.SOUTH);

    AddPathButton.   addActionListener (this);
    AddArchiveButton.addActionListener (this);
    RemoveButton.    addActionListener (this);
    OKButton.        addActionListener (this);
    CancelButton.    addActionListener (this);

    updateRemoveButton();
  }

  private void updateRemoveButton () {
    if (Paths.getItemCount() > 0) {
      Paths.select (0);
      RemoveButton.setEnabled (true);
    } else
      RemoveButton.setEnabled (false);
  }

  private void initList (StringList Dirs) {
    Paths.removeAll();
    if (Dirs != null)
      for (int i = 0; i < Dirs.getCount(); i++)
        Paths.addItem (Dirs.getString (i));
    updateRemoveButton();
  }

  private void initList (String[] Dirs) {
    Paths.removeAll();
    if (Dirs != null)
      for (int i = 0; i < Dirs.length; i++)
        Paths.addItem (Dirs[i]);
    updateRemoveButton();
  }

  public static String getPath (String [] Paths) {
    String Ret = "";
    int i;
    if ((Paths == null) || (Paths.length == 0))
      return Ret;
    for (i = 0; i < Paths.length; i++) {
      Ret += Paths[i];
      if (i < Paths.length - 1)
        Ret += ";";
    }
    return Ret;
  }

  public String getPath () {
    return getPath (getPaths());
  }

  public String[] getPaths () {
    return Paths.getItems();
  }

  private void addToPaths (String NewPath) {
    String [] Items = Paths.getItems();
    int i;
    boolean AlreadyHere = false;

    for (i = 0; i < Items.length; i++)
      if (Items[i].compareTo (NewPath) == 0) {
        AlreadyHere = true;
        break;
      }

    if (!AlreadyHere) {
      Paths.add (NewPath);
      Paths.select (Paths.getItemCount() - 1);
      updateRemoveButton();
    }
  }

  public void actionPerformed (ActionEvent e) {
    String CMD = e.getActionCommand();
    if (CMD == REMOVE_CMD) {
      Paths.remove (Paths.getSelectedIndex());
      updateRemoveButton();
      return;
    }

    if (CMD == ADD_PATH_CMD) {
      DirectoryChooser FileD = new DirectoryChooser (ParentFrame);
      FileD.setVisible (true);
      if (FileD.getDirectory() != null) {
        String NewDir = FileD.getDirectory();
        if (NewDir.length() == 0)
          return;
        int i;
        for (i = 0; i < Paths.getItemCount(); i++)
          if (Paths.getItem(i).equals(NewDir))
            return;
        addToPaths ((new File (NewDir)).getAbsolutePath());
        return;
      }
    }

    if (CMD == ADD_ARCH_CMD) {
      FileDialog LD = new FileDialog (ParentFrame);
      LD.setFile ("*.jar;*.zip");
      LD.setVisible (true);
      if (LD.getDirectory() != null) {
        addToPaths   (LD.getDirectory() + LD.getFile());
      }
    }

    if (CMD == OK_CMD)     {
      Confirmed = true;
      setVisible (false);
    }

    if (CMD == CANCEL_CMD) {
      Confirmed = false;
      setVisible (false);
    }
  }

  public boolean isConfirmed () {
    return Confirmed;
  }
}

