/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */
package org.freebuilder.gui.config;

import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import org.freebuilder.gui.beans.*;
import org.freebuilder.gui.ideoptions.*;
import org.freebuilder.system.ideengine.*;
import org.freebuilder.system.classes.options.manager.*;
/**
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
    @version 0.7, 07-01-98
*/
class JavaDOCOptionsPanel extends BPanel implements Configurator {

  private JPanel NorthPanel           = new JPanel();
  private JPanel ShowAndFlagsPanel    = new JPanel();
  private BPanel FlagsPanel      = new BPanel ("Flags:");
  private JCheckBox Version      = new JCheckBox("Include @version paragraphs");
  private JCheckBox NoDeprecated = new JCheckBox("Exclude @deprecated paragraphs");
  private JCheckBox Author       = new JCheckBox("Include @author paragraphs");
  private JCheckBox NoIndex      = new JCheckBox("Do not generate method and field index");
  private JCheckBox NoTree       = new JCheckBox("Do not generate class hierarchy");

  private BPanel ShowPanel         = new BPanel ("Show:");
  private ButtonGroup ShowFlags    = new ButtonGroup();
  private JRadioButton ShowPublic      = new JRadioButton("Only public classes and members",              false);
  private JRadioButton ShowProtected   = new JRadioButton("Protected/public classes and members",         true);
  private JRadioButton ShowPackage     = new JRadioButton("Package/protected/public classes and members", false);
  private JRadioButton ShowPrivate     = new JRadioButton("All classes and members",                      false);

  private BPanel PathsPanel        = new BPanel ("Paths:");

  public JavaDOCOptionsPanel () {
    super ("JavaDOC Options:");

    ShowFlags.add (ShowPublic);
    ShowFlags.add (ShowProtected);
    ShowFlags.add (ShowPackage);
    ShowFlags.add (ShowPrivate);

    setLayout (new BorderLayout());

    NorthPanel.setLayout (new BorderLayout());

    ShowAndFlagsPanel.setLayout (new BorderLayout());

    FlagsPanel.setLayout (new GridLayout (5, 1));
    FlagsPanel.add (Version);
    FlagsPanel.add (NoDeprecated);
    FlagsPanel.add (Author);
    FlagsPanel.add (NoIndex);
    FlagsPanel.add (NoTree);
    ShowAndFlagsPanel.add (FlagsPanel, BorderLayout.WEST);

    ShowPanel.setLayout (new GridLayout (4, 1));
    ShowPanel.add (ShowPublic);
    ShowPanel.add (ShowProtected);
    ShowPanel.add (ShowPackage);
    ShowPanel.add (ShowPrivate);
    ShowAndFlagsPanel.add (ShowPanel, BorderLayout.EAST);
    NorthPanel.add (ShowAndFlagsPanel, BorderLayout.SOUTH);

    add (NorthPanel,BorderLayout.NORTH);

    PathsPanel.setLayout (new GridLayout(1, 2, 3, 3));
    setPaths();
    add (PathsPanel, BorderLayout.SOUTH);
    getOptions();
  }

  public String toString () {
    return "JavaDOC";
  }

  public void getOptions () {
    OptionsMngr AOptions = Globals.IEngine.getOptions();
    JavaDOCOptions   NewOptions     = (JavaDOCOptions) (AOptions.getOptions(JavaDOCOptions.JavaDOCOptionsName));

    Version.setSelected(NewOptions.getVersion());
    Author.setSelected (NewOptions.getAuthor());
    NoDeprecated.setSelected(NewOptions.getNoDeprecated ());
    NoIndex.setSelected(NewOptions.getNoIndex ());

    NoTree.setSelected(NewOptions.getNoTree ());

    switch (NewOptions.getShowFlags()) {
      case JavaDOCOptions.PROTECTED:
        ShowProtected.setSelected (true);
      break;
      case JavaDOCOptions.PACKAGE:
        ShowPackage.setSelected (true);
      break;
      case JavaDOCOptions.PUBLIC:
        ShowPublic.setSelected (true);
      break;
      case JavaDOCOptions.PRIVATE:
        ShowPrivate.setSelected (true);
      break;
    }
  }

  public void setPaths () {
    PathsPanel.removeAll();
    PathsPanel.add (PathsOptionsConfig.getSourcePathPanel());
    PathsPanel.add (PathsOptionsConfig.getJavaDOCOutPathPanel());
  }

  public void initGUI () {
    setPaths();
  }

  public Component getGUI () {
    return this;
  }

  public void setOptions () {
    OptionsMngr AOptions = Globals.IEngine.getOptions();
    JavaDOCOptions   NewOptions     = (JavaDOCOptions) (AOptions.getOptions(JavaDOCOptions.JavaDOCOptionsName));

    NewOptions.setVersion       (Version.isSelected());
    NewOptions.setAuthor        (Author.isSelected());
    NewOptions.setNoDeprecated  (NoDeprecated.isSelected());
    NewOptions.setNoIndex       (NoIndex.isSelected());
    NewOptions.setNoTree        (NoTree.isSelected());

    if (ShowProtected.isSelected())
      NewOptions.setShowFlags     (JavaDOCOptions.PROTECTED);
    if (ShowPackage.isSelected())
      NewOptions.setShowFlags     (JavaDOCOptions.PACKAGE);
    if (ShowPublic.isSelected())
      NewOptions.setShowFlags     (JavaDOCOptions.PUBLIC);
    if (ShowPrivate.isSelected())
      NewOptions.setShowFlags     (JavaDOCOptions.PRIVATE);
    AOptions.setOptions (NewOptions);
  }
}

