/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.gui.config;
import java.awt.*;
import java.awt.event.*;
import org.freebuilder.gui.beans.*;
import org.freebuilder.system.ideengine.*;

/**
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
    @version 0.7, 07-01-98
*/
public class ConfirmCloseDialog extends Dialog implements ActionListener {
  public static final int SAVE_RESULT      = 1;
  public static final int DONTSAVE_RESULT  = 0;
  public static final int DONTCLOSE_RESULT = 2;

  private String SAVE_CMD      = "Save";
  private String DONTSAVE_CMD  = "Don't Save";
  private String DONTCLOSE_CMD = "Don't Close";

  private int Result = SAVE_RESULT;

  private IconCanvas Caution = new IconCanvas (Globals.ResourceMngr.loadImage (Globals.IconsDir + "Caution.gif"), 0, 1);
//  private IconCanvas Disk    = new IconCanvas (Globals.ResourceMngr.loadImage (Globals.IconsDir + "Disk.gif"),    1, 1);

  private Button SaveButton      = new Button (SAVE_CMD);
  private Button DontSaveButton  = new Button (DONTSAVE_CMD);
  private Button DontCloseButton = new Button (DONTCLOSE_CMD);

  private BPanel ButtonsPanel = new BPanel();
  private BPanel MainPanel    = new BPanel();
  private BPanel MessagePanel = new BPanel("Modified File");

  public ConfirmCloseDialog (String FileName) {
    super (Globals.IdeMainFrame);
    setModal (true);
    setTitle ("Alert!");

    Label TheMessage = new Label (FileName);
    TheMessage.setForeground (Color.red);

    MessagePanel.setLayout (new BorderLayout(5, 5));

    MessagePanel.add (TheMessage, BorderLayout.CENTER);
    MessagePanel.add (Caution, BorderLayout.WEST);
//    MessagePanel.add (Disk,    BorderLayout.WEST);

    ButtonsPanel.setLayout (new GridLayout(1, 3 ,5 ,5));
    ButtonsPanel.add (SaveButton);
    ButtonsPanel.add (DontSaveButton);
    ButtonsPanel.add (DontCloseButton);

    SaveButton     .addActionListener (this);
    DontSaveButton .addActionListener (this);
    DontCloseButton.addActionListener (this);

    MainPanel.setLayout (new BorderLayout());
    MainPanel.setInner (BPanel.NONE);
    MainPanel.setOuter (BPanel.NONE);
    MainPanel.setBorderWidth (5);
    MainPanel.add (MessagePanel, BorderLayout.NORTH);
    MainPanel.add (ButtonsPanel, BorderLayout.SOUTH);

    setLayout (new BorderLayout());

    Insets MainPanelInsets    = MainPanel   .getInsets();
    Insets MessagePanelInsets = MessagePanel.getInsets();
    Insets DialogInsets       = this.getInsets();

    add (MainPanel, BorderLayout.CENTER);

    setSize (getToolkit().getScreenSize());
    pack();
    Misc.hardCenter (this);
    setResizable (true);
  }

  public void actionPerformed (ActionEvent e) {
    String CMD = e.getActionCommand();

    if (CMD.compareTo (SAVE_CMD) == 0)
      Result = SAVE_RESULT;

    if (CMD.compareTo (DONTSAVE_CMD) == 0)
      Result = DONTSAVE_RESULT;

    if (CMD.compareTo (DONTCLOSE_CMD) == 0)
      Result = DONTCLOSE_RESULT;

    setVisible(false);
    dispose();
  }

  public int getResult () {
    return Result;
  }
}
