/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.gui.beans;

import java.awt.GridBagConstraints;
import java.awt.Insets;

/** <code>ConstrGridBagConstr</code> inherits from GridBagConstraints and just add a new
  * constructor.
  * @author	George Petkov <a href=mailto:pgeorge@mail.techno-link.com> pgeorge@mail.techno-link.com </a>,  <a href=mailto:gpetkov@usa.net> gpetkov@usa.net</a>
  * @version 0.7, 07-01-98 */


public class ConstrGridBag extends GridBagConstraints {
  public ConstrGridBag (int X, int Y, int Width, int Height, double WeightX, double WeightY,
                             int Anchor, int Fill, Insets AInsets, int ipadX, int ipadY) {
    gridx      = X;
    gridy      = Y;
    gridwidth  = Width;
    gridheight = Height;
    fill       = Fill;
    ipadx      = ipadX;
    ipady      = ipadY;
    insets     = AInsets;
    anchor     = Anchor;
    weightx    = WeightX;
    weighty    = WeightY;
  }
}

