/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.gui.beans;

import java.awt.*;
import com.sun.java.swing.*;

/** This class is a bordered Panel.
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
  * @version 0.7, 07-01-98
*/

public class BPanel extends JPanel {
  public static final int NONE    = 0;
  public static final int RAISED  = 1;
  public static final int LOWERED = 2;

  private Dimension PreferredSize = null;

  private int Inner = LOWERED;
  private int Outer = RAISED;

  private int BorderWidth = 1;
  private int TopInset = 0;

  private int TitleX = 20;
  private int TitleGap = 0;

  private String Title = "";
  private Color TitleColor = Color.black;

  public BPanel () {
    super();
  }

  public BPanel (String Title) {
    super();
    setTitle (Title);
  }

  public void setTitleColor (Color NewColor) {
    TitleColor = NewColor;
    repaint();
  }

  /**
    Draws the inner border.
  */
  private void drawOuter (Graphics g) {
    int i;
    Color UpLeft = Color.black;
    Color BottomRight = Color.black;
    int Height;
    int Width;

    if (Title != "") {
      Height = g.getFontMetrics().getHeight() / 2;
      Width = g.getFontMetrics().stringWidth(Title);
    } else {
      Height = 0;
      Width = 0;
    }

    switch (Outer) {
      case NONE:
        return;
      case RAISED:
        UpLeft = Color.white;
        BottomRight = Color.gray;
        break;
      case LOWERED:
        UpLeft = Color.gray;
        BottomRight = Color.white;
        break;
    }

    Dimension S = getSize();
    g.setColor (UpLeft);
    for (i = 0; i < BorderWidth; i++) {
      g.drawLine (i, i + Height, TitleX - TitleGap, i + Height);
      g.drawLine (TitleX + 2*TitleGap + Width, i + Height, S.width - 1 - i,i + Height);
      g.drawLine (i, i + Height, i, S.height - 1 - i);
    }

    g.setColor (BottomRight);
    for (i = 0; i < BorderWidth; i++) {
      g.drawLine (S.width - 1 - i, S.height - 1 - i, i, S.height - 1 - i);
      g.drawLine (S.width - 1 - i, S.height - 1 - i, S.width - 1 - i, i + Height);
    }
  }

  /**
    Draws the outer border.
  */
  private void drawInner (Graphics g) {
    int i;
    Color UpLeft = Color.black;
    Color BottomRight = Color.black;
    int Height;
    int Width;

    if (Title != "") {
      Height = g.getFontMetrics().getHeight() / 2;
      Width = g.getFontMetrics().stringWidth(Title);
    } else {
      Height = 0;
      Width = 0;
    }

    switch (Inner) {
      case NONE:
        return;
      case RAISED:
        UpLeft = Color.white;
        BottomRight = Color.gray;
        break;
      case LOWERED:
        UpLeft = Color.gray;
        BottomRight = Color.white;
        break;
    }

    Dimension S = getSize();
    g.setColor (UpLeft);

    for (i = 0; i < BorderWidth; i++) {
      g.drawLine (BorderWidth + i, BorderWidth + i + Height,
                  TitleX - TitleGap,
                  BorderWidth + i + Height);
      g.drawLine (TitleX + 2*TitleGap + Width, BorderWidth + i + Height,
                  S.width - 1 - BorderWidth - i,
                  BorderWidth + i + Height);
      g.drawLine (BorderWidth + i, BorderWidth + i + Height,
                  BorderWidth + i,
                  S.height - 1 - BorderWidth - i);
    }

    g.setColor (BottomRight);
    for (i = 0; i < BorderWidth; i++) {
      g.drawLine (S.width - 1 - BorderWidth - i,
                  S.height - 1 - BorderWidth - i,
                  BorderWidth + i,
                  S.height - 1 - BorderWidth - i);

      g.drawLine (S.width - 1 - BorderWidth - i,
                  S.height - 1 - BorderWidth - i,
                  S.width - 1 - BorderWidth - i,
                  BorderWidth + i + Height);

    }
  }

  private void drawTitle (Graphics g) {
    int Height = g.getFontMetrics().getHeight();
    TopInset = Height;
    g.setColor (TitleColor);
    g.drawString (Title, TitleX, Height);
  }

  public void setTitle (String NewTitle) {
    if (NewTitle == null) {
      Title = "";
      TitleGap = 0;
    }
    else {
      Title = NewTitle;
      TitleGap = 5;
    }
    repaint();
  }

  /**
    Paints this panel.
  */
  public void paint (Graphics g) {
    super.paint(g);
    drawInner(g);
    drawOuter(g);
    drawTitle(g);
  }

  /**
    Changes the look of the inner border.
    Valid values are:
    NONE, RAISED, LOWERED.
  */

  public void setInner (int Inner) {
    this.Inner = Inner;
    repaint();
  }

  /**
    Changes the look of the outer border.
    Valid values are:
    NONE, RAISED, LOWERED.
  */
  public void setOuter (int Outer) {
    this.Outer = Outer;
    repaint();
  }

  /**
    Returns the width of the border - both inner and outer.
  */
  public int getBorderWidth () {
    return BorderWidth * 2;
  }

  /**
    Sets the width of the border - both inner and outer.
  */
  public void setBorderWidth (int NewWidth) {
    if ((NewWidth < 1) || (NewWidth > 5))
      return;
    BorderWidth = NewWidth;
    repaint();
  }

  /**
    Returns this panel's Insets.
  */
  public Insets getInsets () {
    int Gap = BorderWidth*2 + 2;
    if ((Title != "") && (TopInset == 0)) {
      TopInset = Misc.calcStringHeight();
    }

    int TopGap;
    if ((TopInset > Gap) && (Title != ""))
      TopGap = TopInset - Gap + 4;
    else
      TopGap = 0;
    return new Insets (Gap + TopGap, Gap, Gap, Gap);
  }

  public void setPreferredSize (Dimension PreferredSize) {
    this.PreferredSize = PreferredSize;
  }

  public Dimension getPreferredSize () {
    Dimension PrefWidth = super.getPreferredSize();
    if (PreferredSize != null) {
      if (PreferredSize.width < 0)
        PreferredSize.width = PrefWidth.width;
      if (PreferredSize.height < 0)
        PreferredSize.height = PrefWidth.height;
      return PreferredSize;
    } else
      return super.getPreferredSize();
  }
}

