(*  Bitmap - Demo     This Demo show the using of bitmaps                  *)

{$N+,E+,Q-}

uses X_Const,  (* Const. like GetMaxX, GetMaxY                             *)
     x_Main,   (* x_set_mode ...                                           *)
     x_Bitmap, (* very importend for this demo ,-)                         *)
     X_Pal,    (* x_set_rgb_pal                                            *)
     X_Text,   (* E_Write                                                  *)
     X_FileIO, (* F_Open_Read, F_Size, F_Close                             *)
     X_Keys,   (* Clear_Buffer                                             *)
     dos;      (* FindFirst, FindNext ...                                  *)

const sort : Array[0..4] of Byte = (0,3,1,2,4);
type big = array[0..33333] of Byte;

var pbm,cbm,ibm,p:^big;
    s:SearchRec;
    Name:String;
    F:File;
    Hour,min,sek,sek100:Word;
    AbsTime : Array[0..5] of Comp;
    Count   : Array[0..5] of LongInt;
    i,j,l,k,maxX,MaxY,AddY,Saved_Size_cbm,Saved_Size_ibm:Word;
    Line:String;
    dummy:Boolean;
    Size:LongInt;
    r:Real;


begin;

                                 (* Search an PBM-File *)
  if (paramcount>0)and(F_Size(paramstr(1))>0) then Name:=paramstr(1)
  else begin;
         findfirst('*.pbm',AnyFile,S);
         if doserror<>0 then begin;writeLn('None *.pbm-file found');halt;end;
         Name:=S.Name;
       end;

  x_set_mode(8,408);
  x_set_activ_start_addr(0,ScrnLogicalHeight-GetMaxY);
  x_set_visible_start_addr(0,ScrnLogicalHeight-GetMaxY);
  x_set_rgb_pal;
  x_text_init;

  x_set_font(0);
  E_Write(20,GetMaxY-x_font_height,Gray5,Gray2,'Press any key to continue.');
  E_Write(1,20,Gray5,Gray3,'PBM:');
  E_Write(1,20+GetMaxY div 3,Gray5,Gray3,'CBM:');
  E_Write(1,20+2*GetMaxY div 3,Gray5,Gray3,'IBM:');

  GetMEM(pbm,F_Size(Name));      (* Load a PBM *)
  x_load_pbm(Name,pbm^);

                                 (* Convert PBM to IBM *)
  Saved_Size_ibm:=x_sizeof_ipbm(pbm^);
  GetMEM(ibm,Saved_Size_ibm);
  x_pbm_to_ibm(pbm^,ibm^);
                                 (* Convert PBM to CBM *)
  Saved_Size_cbm:=x_sizeof_cpbm(ScrnLogicalByteWidth,pbm^);
  GetMEM(cbm,Saved_Size_cbm);
  x_pbm_to_cbm(ScrnLogicalByteWidth,pbm^,cbm^);


  x_get_pbm_sizeXY(i,j,pbm^);
  MaxX:=GetMaxX -i-20;
  MaxY:=GetMaxY div 3-j-10;
  AddY:=GetMaxY div 3;

  for i:=0 to 4 do
  begin;
    GetTime(Hour,min,sek,sek100);
    AbsTime[i]:=360000*Hour+min*6000+sek*100+sek100;
    Count[i]:=0;
    repeat
      case i of
        0:  X_Put_masked_pbm(random(MaxX)+20,random(MaxY)+10       ,pbm^);
        1:  X_Put_cbm       (random(MaxX)+20,random(MaxY)+10+AddY  ,cbm^);
        2:  X_Put_masked_ibm(random(MaxX)+20,random(MaxY)+10+AddY*2,ibm^);
        3:  X_Put_pbm       (random(MaxX)+20,random(MaxY)+10       ,pbm^);
        4:  X_Put_ibm       (random(MaxX)+20,random(MaxY)+10+AddY*2,ibm^);
      end;
      Inc(Count[i]);
    until keyspressed;
    Clear_Buffer;
    GetTime(Hour,min,sek,sek100);
    AbsTime[i]:=Hour*360000+min*6000+sek*100+sek100-AbsTime[i];
  end;

  x_text_mode;
  WriteLn('      Time in sek-100  Count of Bitmaps  Bitmap per sek  memory size');
  WriteLn('');
  x_get_pbm_sizeXY(l,j,pbm^);k:=((l+3)div 4+1)*j;
  for i:=0 to 4 do
  begin;
    case Sort[i] of
         0:Write('PBM masked ');
         3:Write('PBM        ');
         1:Write('CBM masked ');
         2:Write('IBM masked ');
         4:Write('IBM        ');
    end;
    Write(AbsTime[Sort[i]]:6:0,'     ',Count[Sort[i]]:10,'        ',
          Count[Sort[i]]/AbsTime[Sort[i]]*100:7:0,' (',
          (100*Count[Sort[i]]/AbsTime[Sort[i]]/Count[0]*AbsTime[0]):3:0,'%)  ');
    case Sort[i] of
      0,3:Size:=x_sizeof_pbm(pbm^);
      1:Size:=Saved_Size_cbm;
      2,4:Size:=Saved_Size_ibm;
    end;
    WriteLn(Size:6,' (',100*Size div x_sizeof_pbm(pbm^):3,'%)');
  end;
  WriteLn;
  Write('Bitmap size : ',l:2,'x',j:2);
  r:=100 /(l*j+2);

  i:=0;for j:=4 to x_sizeof_pbm(pbm^) do if MEM[seg(pbm^):(ofs(pbm^)+j)]=0 then Inc(i);
  WriteLn('  with ',i,' (',r*i:2:0,'%) transparent pixel.');
  WriteLn;

  FreeMEM(pbm,x_sizeof_pbm(pbm^));
  FreeMEM(cbm,Saved_Size_cbm);
  FreeMEM(ibm,Saved_Size_ibm);

  if F_Open_Read(F,'Bitmap_D.dat') then
  begin;
    WriteLn('Other Results :                 PBM% (Bitmap per sek),   CBM% ,   VBM% ');
    WriteLn;
    while not eof(F) do
    begin;
      WriteLn(Read_Line(F));
    end;
    F_Close(F);
  end;

  Close_MasterFile;

end.


