(* All these Compiler-directives make the EXE smaler , but the error would
   be more invisible . *)
{$D-,Y-,R-,S-,O-}

(* FEX  -  Font Editor for mode X     by  Christian Harms


   1) is a terrible hack !

   2) read/save normal font from XLib_C  with a width to 8 Rows
      read/save new Bigfont from XLib_TP  with a width to 16 Rows
      save fonts as const-array for including

   3) canging with mouse or keyboard

   4) is a dirty example of using XLib_TP to programm in Mode X

   5) I dont want to make a better version (Do you want ? ;-)

   6) it's free for all modifications (send a better copy to my email)

   email : harms@minnie.informatik.uni-stuttgart.de

*)






{$B-}  (* Compiler generated code for short-circuit boolean-expression eval.*)

uses crt,dos,
     X_Const,  (* values like GetMaxX or GetMaxY                            *)
     X_Main,   (* x_set_mode and Line, PutPixel                             *)
     X_Text,   (* the great text-unit                                       *)
     X_Rect,   (* box - very fast                                           *)
     X_Mouse,  (* mouse-unit                                                *)
     X_Button, (* button-manager , simply make some button                  *)
     X_Pal,    (* set, get palette                                          *)
     X_Keys,   (* emulate mouseclicks as pressed keys                       *)
     X_FileIO; (* standart file operations, used by all XLib-functions      *)

const Box_X  = 3;      (* Start of Zoom-character  *)
      Box_Y  = 3;
      Max_C  = 133;    (* last character           *)
      Char_X = 2;      (* start of character - box *)

      Big_Point : Array[0..4,0..1] of Integer = ( (-1,0),(1,0),(0,-1),(0,1),(0,0) );

      Max_Lines = 8;
      Help_Lines:Array[1..Max_Lines] of String =(
        'F2/F3 or /     dec/increment Font_Height',
        'Shift+Tab/Tab or /'#26'  dec/increment character width',
        'PgUp,PgDown  inc/Decrement character number',
        'Cursorkeys      move pixelcursor in Zoombox',
        'Space/Enter     invert actual/bigger point',
        '[L]oad/[S]ave   load/save the font',
        '[D]ir               Show the selected directory',
        '[F]ont'#26'Inc     convert Fontfile in Include-Pascalfile   [ENTER]');

type Big_Char = record
        MaxX : Byte;
        D    : Array[0..15] of Word;
     end;

var Font       : Array[0..Max_C] of Big_Char;
    XC,YC      : Byte;
    Font_Heigth: Byte;
    Zoom       : Word;        (* dynamic zoom of character in diff. resolution *)
    Char_Y     : Word;
    Char_Rows  : Byte;
    Char_Line  : Byte;
    But_X      : Word;
    Ende       : Boolean;
    actuell    : Byte;        (* index of actuell zoomed character *)
    My_Pal     : Palette;
    FileName   : String;
    FontType   : Byte;       (* 0 -> 8xn Font         1 ->  16xn *)
    Mult_X     : Word;



procedure Init_MEM;
var i:Byte;
begin;
  for i:=0 to Max_C do Font[i].MaxX:=12;
  for i:=0 to Max_C do fillchar(Font[i].D,sizeof(Font[i].D),0);
  XC:=0;
  YC:=0;
  Font_Heigth:=15;
  Ende:=False;
  actuell:=65;
  Mult_X:=16;
  FontType:=1;
end;

function byte2hex(a:Byte):String;
const F:Array[0..15] of Char = ('0','1','2','3','4','5','6','7','8','9',
                                'A','B','C','D','E','F');
begin;
  Byte2hex:=F[a div 16]+f[a mod 16];
end;


procedure Show_Big_Char(C:Char);
var i,j,col:Byte;
    W,temp_Y:Word;
begin;

  Shadow_Box(Box_X-3,Box_Y-3,Box_X+Mult_X*Zoom+2,Box_Y+16*Zoom+1,Gray3,Gray2,Gray1);

  if Font[Byte(c)].MaxX>0 then
    if FontType=1 then
      for i:=0 to Font[Byte(c)].MaxX-1 do
      begin;
        Temp_Y:=Box_Y;
        W:=Font[Byte(c)].D[i];
        for j:=0 to Font_Heigth do
        begin;
          if (w and 1)=0 then Col:=Gray0 else Col:=Gray4;
          Box(Box_X+i*Zoom,Temp_Y,Box_X+i*Zoom+Zoom-1,Temp_Y+Zoom-1,Col);
          Inc(Temp_Y,Zoom);
          w:=w shr 1;
        end;
      end
               else
      for i:=0 to Font_Heigth do
      begin;
        w:=Font[Byte(c)].D[i];
        for j:=0 to Font[Byte(c)].MaxX-1 do
        begin;
          if (w and 1)=0 then Col:=Gray0 else Col:=Gray4;
          Box(Box_X+j*Zoom,Box_Y+i*Zoom,Box_X+j*Zoom+Zoom-1,
              Box_Y+i*Zoom+Zoom-1,Col);
          w:=W shr 1;

        end;
      end;

end;

procedure Set_Cursor(x,y,col:Byte);
begin;
  Line(Box_X+x*Zoom-1,Box_Y+y*Zoom+Zoom-1,Box_X+x*Zoom+Zoom-1,Box_Y+y*Zoom+Zoom-1,col);
  Line(Box_x+x*Zoom+Zoom-1,Box_Y+y*Zoom-1,Box_x+x*Zoom+Zoom-1,Box_Y+y*Zoom+Zoom-1,col);
end;

procedure Get_Cursor;
var x,y:Byte;
begin;
  x:=XC;y:=YC;
  XC:=(MouseX-Box_X)div Zoom;
  YC:=(MouseY-Box_Y)div Zoom;
  if (x<>XC)or(y<>YC) then begin;Set_Cursor(x,y,Gray2);Set_Cursor(XC,YC,Gray5);end;
end;

procedure Show_Button;
var i,j:Word;
    dummy:Boolean;
begin;

  i:=Box_Y+14;
  dummy:=Add_Button_Gray(1,But_X,i,All,'Load');   Inc(i,x_font_Height+4);
  dummy:=Add_Button_Gray(2,But_X,i,All,'Save');   Inc(i,x_font_height+4);
  dummy:=Add_Button_Gray(3,But_X,i,All,'Dir');    Inc(i,x_font_height+4);
  dummy:=Add_Button_Gray(4,But_X,i,All,'Font'#26'Inc'); Inc(i,x_font_height+4);

  i:=But_X-6-x_length('  ');
  j:=1;
  dummy:=Add_Button_Gray(14,i,j,All,'F1');              Inc(j,x_font_height+4);
  dummy:=Add_Button_Gray(10,i,j,both+click,'  ');      Inc(j,x_font_height+4);
  dummy:=Add_Button_Gray(11,i,j,both+click,' '#26' ');  Inc(j,x_font_height+4);
  dummy:=Add_Button_Gray(12,i,j,all,'  ');             Inc(j,x_font_height+4);
  dummy:=Add_Button_Gray(13,i,j,All,'  ');             Inc(j,x_font_height+4);

end;

procedure Show_Bios_Char(a:Char);
var s:String;
const German_Char : Array[#0..#6] of Char = ('','','','','','','');
begin;
  x_set_font(1);
  if FontType=1 then Inc(a);
  if a>#127 then a:=German_Char[Chr(Byte(a)-128)];

  s:='['+a+'-'+Byte2Hex(Byte(a))+']';
  box(But_X,0,GetMaxX,14,0);
  x_Write(But_X,0,255,s);
  x_set_font(2);
end;

procedure Show_Char(x,y,Index:Word;Col:Byte);
var i,j:Byte;
    w:Word;
begin;
  Show_Bios_Char(char(Index));

  if Font[Index].MaxX=0 then
  begin;
    Box(      x,y,x+Mult_X,y+Font_Heigth+1,gray2);
    rectangle(x,y,x+Mult_X-1,y+Font_Heigth,Col);
  end
                        else
  begin;
    Box(x,y,x+Mult_X,y+Font_Heigth+1,Gray2);
    if FontType=1 then
    begin;
      for i:=0 to Font[Index].MaxX-1 do
      begin;
        w:=Font[Index].d[i];
        for j:=0 to Font_Heigth do
        begin;
          if (W and 1)<>0 then PutPixel(x,y+j,Col)
                          else PutPixel(x,y+j,0);
          w:=w shr 1;
        end;
        Inc(X);
      end;
    end else
    begin;
      for i:=0 to Font_Heigth do
      begin;
        w:=Font[Index].D[i];
        for j:=0 to Font[Index].MaxX-1 do
        begin;
          if (w and 1)=0 then Col:=Gray0 else Col:=Gray4;
          PutPixel(x+j,y+i,Col);
          w:=W shr 1;
        end;
      end;
    end;
  end;
end;

procedure Show_All_Char;
var i,j,l:Word;
begin;

  Shadow_Box(Char_X-2,Char_Y-2,GetMaxX-1,GetMaxY-1,Gray3,Gray2,Gray1);

  for i:=0 to Char_Rows-1 do
    for j:=0 to Char_Line-1 do
    begin;
      l:=i+j*(Char_Rows);
      if l<=Max_C then
        if Font[l].MaxX=0 then rectangle(Char_X+i*(Mult_X+1),Char_Y+j*17,
                                         Char_X+Mult_X-1+i*(Mult_X+1),Char_Y+Font_Heigth+j*17,Gray4)
                          else Show_Char(Char_X+i*(Mult_X+1),Char_Y+j*17,l,Gray4);
    end;
  Show_Bios_Char(char(actuell));
end;

procedure Select_Char;
var l:Word;
begin;
  l:=(MouseX-Char_X)div (Mult_X+1) +
     ((MouseY-Char_Y) div 17)*(Char_Rows);
  if (l<>actuell)and(l<=Max_C) then
  begin;
    actuell:=l;
    Show_Big_Char(chr(actuell));
    Show_Bios_Char(char(actuell));
    if XC>Font[actuell].MaxX then XC:=Font[actuell].MaxX;
  end;
end;

procedure Set_Point(x,y:Byte);
var W   : Word;
    col : Byte;
begin;
  if Font[actuell].MaxX>0 then
    if FontType=1 then
    begin;
      w:=Font[actuell].D[x];

      if (w and (1 shl y))=0 then begin;Font[actuell].D[x]:=w or (1 shl y);Col:=Gray4;end
                             else begin;Font[actuell].D[x]:=w and not (1 shl y);Col:=Gray0;end;

      Box(Box_X+x*Zoom,Box_Y+y*Zoom,Box_X+x*Zoom+Zoom-1,Box_Y+y*Zoom+Zoom-1,Col);
      PutPixel(Char_X+(actuell mod (Char_Rows))*(Mult_X+1)+x,
               Char_Y+(actuell div (Char_Rows))*17+y,Col);
    end        else
    begin;
      w:=Font[actuell].D[y];

      if (W and (1 shl x))=0 then begin;Font[actuell].D[y]:=w or (1 shl x);Col:=Gray4;end
                             else begin;Font[actuell].D[y]:=w and not (1 shl x);Col:=Gray0;end;

      Box(Box_X+x*Zoom,Box_Y+y*Zoom,Box_X+x*Zoom+Zoom-1,Box_Y+y*Zoom+Zoom-1,Col);
      PutPixel(Char_X+(actuell mod (Char_Rows))*(Mult_X+1)+x,
               Char_Y+(actuell div (Char_Rows))*17+y,Col);

    end;
end;

procedure Init_Screen;
var i:Byte;
begin;
  Char_Rows:=(GetMaxX-4) div (Mult_X+1);
  Char_Line:=Max_C div Char_Rows+1;
  Char_Y:=GetMaxY-4-Char_Line*17;

  i      := ((Char_Y-Box_Y) div 16)-1;
  Zoom   := i;

  while (Box_X+(Mult_X+1)*Zoom+5>GetMaxX-50) do Dec(Zoom);

  But_X  := GetMaxX-x_length('Font'#26'Inc')-6;


  for i:=250 to 255 do fillchar(My_Pal[i],3,(i-250)*12);
  x_put_pal_raw(My_Pal,256,0,false);
  Gray0:=250;Gray1:=251;Gray2:=252;Gray3:=253;Gray4:=254;Gray5:=255;
  X_ClearAll;
  Show_Big_Char(chr(actuell));
  Show_All_Char;
  Show_Button;

end;

procedure Load_Old_Font(Name:String);
var F:File;
    i:Word;
    Buffer:Array[0..16]Of Byte;
begin;
  if F_Open_Read(f,Name) then
  begin;
    for i:=0 to Max_C do BlockRead(f,Font[i].d,32);
    F_Close(F);
  end;
end;

procedure Save_Font(Name:String);
var a:Byte;
    i,j,h:Word;
    F:File;
    Buffer:Array[0..Max_C] of Word;
    FontType:Byte;
    B:Array[0..32] of Byte;
    ww:Byte;
begin;
  a:=0;FontType:=0;Mult_X:=8;
  while (a<=Max_C)and(Font[a].MaxX=0) do Inc(a);

  for j:=a to Max_C do if Font[j].MaxX>8 then begin;FontType:=1;Mult_X:=16;end;

  if a>Max_C then Exit;

  F_Open_Write(F,Name);
  if FontType=1 then
  begin;  (* 16xn Font *)
    BlockWrite(F,a,1);                 (* FirstChar              *)
    BlockWrite(F,FontType,1);             (* FontType                  *)
    BlockWrite(f,Font_Heigth,1);       (* Font_Heigth            *)
    i:=0;BlockWrite(f,i,1);            (* Font_Weidth var.       *)
    i:=(Max_C-a)*2+2;
    for j:=a to Max_C do
    begin;
      h:=(Word(Font[j].MaxX) shl 12);
      h:=h+i;
      if Font[j].MaxX=0 then h:=0;
      Buffer[j]:=h;
      Inc(i,Font[j].MaxX*2);
    end;
    BlockWrite(F,Buffer[a],(Max_C-a)*2+2);
    for j:=a to Max_C do BlockWrite(F,Font[j].D[0],Font[j].MaxX*2);
  end        else
  begin;          (* save normal Font 8xn *)
    ww:=Font[a].MaxX;           (* ww=0, if diff. widht *)
    for j:=a+1 to 127 do if (ww<>0)and(Font[j].MaxX<>ww) then ww:=0;

    Inc(Font_Heigth);  (* fixed from load_font *)
    BlockWrite(F,a,1);                 (* FirstChar              *)
    BlockWrite(F,FontType,1);             (* FontType                  *)
    BlockWrite(f,Font_Heigth,1);       (* Font_Heigth            *)
    BlockWrite(f,ww,1);                (* Font_Widht var.       *)
    j:=a;
    for j:=a to Max_C do
    begin;
      for i:=0 to Font_Heigth+1 do B[i]:=Font[j].D[i];
      BlockWrite(F,B[0],Font_Heigth);
      if ww=0 then BlockWrite(F,Font[j].MaxX,1);
    end;
    Dec(Font_Heigth);
  end;

  F_Close(f);
end;

procedure Load_Font(Name:String);
var a,h,WW:Byte;
    F:File;
    i,j,l:Word;
    dummy:Boolean;
    B:Array[0..32] of Byte;
begin;
  for i:=0 to Max_C do Font[i].MaxX:=0;
  for i:=0 to Max_C do fillchar(Font[i].D[0],32,0);
  dummy:=F_Open_Read(F,Name);
  a:=Read_Byte(F);                   (* FirstChar            *)
  FontType:=Read_Byte(F);               (* FontType , Fontselector *)
  if FontType=1 then Mult_X:=16 else Mult_X:=8;
  Font_Heigth:=Read_Byte(F);
  WW:=Read_Byte(F);
  if FontType=1 then
  begin;          (* Read BigFont 16x16 *)
    for j:=a to Max_C do
    begin;
      i:=Read_Word(F);
      Font[j].MaxX:=i shr 12;
    end;
    for j:=a to Max_C do BlockRead(F,Font[j].D[0],Font[j].MaxX*2);
  end
  else
  begin;          (* Read normal Font 8xn *)
    j:=a;
    while not eof(F) do
    begin;

      if ww=0 then BlockRead(F,B[1],Font_Heigth+1)
              else BlockRead(F,B[1],Font_Heigth);

      if ww=0 then Font[j].MAxX:=B[Font_Heigth+1]
              else Font[j].MAxX:=WW;

      for i:=0 to Font_Heigth do Font[j].D[i]:=B[i+1];

      inc(j);
    end;
    Dec(Font_Heigth);
  end;
  F_Close(F);
end;

procedure Show_Dir(F:String);
var S:SearchRec;
    x,y:Word;
begin;
  y:=Box_Y+x_font_height+2;
  x:=5;
  FindFirst(F, anyfile, S);
  while (DosError = 0)and((y+x_font_Height<Char_Y)or(x+x_Length(S.Name)+16<But_X-x_length('  '))) do
  begin
    if x+x_Length(S.Name)+2>But_X then begin;x:=5;Inc(y,x_font_height);end;

    E_Write(x,y,Gray4,Gray2,S.Name);
    inc(x,x_Length(S.Name)+10);
    FindNext(S);
  end;
end;

procedure Fnt2Inc(S:String);
type BIG = array[1..5000] of Byte;
var i,size:Word;
    f1,f2:File;
    b:Byte;
    Buffer:^Big;
begin;
  New(Buffer);
  size:=F_Size(S);
  if F_Open_Read(F1,S) then
  begin;
    s:=Only_one_Ext(S,'INC');
    F_Open_Write(F2,s);
    Write_Text(F2,'const Font_'+copy(s,1,pos('.INC',s)-1)+' : Array[1..'+str(size)+'] of Byte = ('#10#13'  ');
    Seek(F1,0);
    BlockRead(F1,Buffer^,size-1);
    for i:=1 to size-1 do
    begin;
      b:=Buffer^[i];
      Write_Text(F2,'$'+Byte2hex(b)+',');
      if i mod 18=0 then Write_Text(F2,#10#13'  ');
    end;
    b:=Buffer^[size-1];
    Write_Text(F2,'$'+Byte2hex(b)+');');
    system.Close(f1);
    F_Close(f2);
  end;
  Dispose(Buffer);
end;

procedure help;
var i:Byte;x,y:Word;
begin;
  WriteLn('fex ?                this help');
  WriteLn('fex [nr] [name]      start in mode <nr> and load Fontfile <name>');
  WriteLn;
  WriteLn('modes without sizeproblems ');
  for i:=0 to x_Max_Modi do
  begin;
    x_mode_info(i,x,y);
    if y>200 then WriteLn('[',I:2,']   with  ',x,'x',y,' Pixel.');
  end;
  Halt(0);
end;

(* Created by FEX with  [Font->Inc] !   (see procedure Fnt2Inc)             *)
const Font_TIMPANI : Array[1..1600] of Byte = (
  $01,$00,$0B,$00,$3E,$41,$55,$41,$41,$5D,$49,$41,$3E,$00,$00,
  $07,$3E,$7F,$6B,$7F,$7F,$63,$77,$7F,$3E,$00,$00,$07,$00,$00,
  $00,$0A,$1F,$1F,$0E,$04,$00,$00,$00,$05,$00,$00,$00,$04,$0E,
  $1F,$0E,$04,$00,$00,$00,$05,$00,$04,$0E,$04,$1B,$1B,$04,$04,
  $0E,$00,$00,$05,$00,$04,$0E,$1F,$1F,$0E,$04,$04,$0E,$00,$00,
  $05,$00,$00,$00,$04,$0E,$04,$00,$00,$00,$00,$00,$04,$0F,$0F,
  $0F,$0B,$01,$0B,$0F,$0F,$0F,$0F,$0F,$04,$00,$00,$1C,$22,$22,
  $22,$1C,$00,$00,$00,$00,$06,$3F,$3F,$23,$1D,$1D,$1D,$23,$3F,
  $3F,$3F,$3F,$06,$00,$00,$38,$30,$28,$04,$0C,$12,$12,$0C,$00,
  $06,$00,$00,$0E,$11,$11,$0E,$04,$04,$0E,$04,$00,$05,$00,$1C,
  $14,$1C,$04,$04,$04,$07,$03,$00,$00,$05,$00,$7C,$54,$74,$14,
  $14,$14,$1F,$0B,$00,$00,$07,$00,$04,$04,$0E,$0E,$0E,$04,$04,
  $04,$00,$00,$04,$00,$02,$06,$0E,$1E,$0E,$06,$02,$00,$00,$00,
  $05,$00,$10,$18,$1C,$1E,$1C,$18,$10,$00,$00,$00,$05,$00,$04,
  $0E,$04,$04,$04,$04,$0E,$04,$00,$00,$04,$00,$0A,$0A,$0A,$0A,
  $0A,$0A,$00,$0A,$00,$00,$04,$00,$1E,$15,$15,$16,$14,$14,$14,
  $14,$00,$00,$05,$0E,$01,$06,$0C,$0A,$0A,$06,$0C,$10,$0E,$00,
  $05,$00,$00,$00,$00,$00,$00,$00,$00,$1F,$1F,$00,$05,$00,$04,
  $0E,$04,$04,$04,$04,$04,$0E,$04,$0E,$04,$00,$04,$0E,$1F,$04,
  $04,$04,$04,$04,$00,$00,$05,$00,$04,$04,$04,$04,$04,$1F,$0E,
  $04,$00,$00,$05,$00,$00,$00,$04,$0C,$1F,$0C,$04,$00,$00,$00,
  $05,$00,$00,$00,$04,$06,$1F,$06,$04,$00,$00,$00,$05,$00,$00,
  $00,$00,$02,$0E,$00,$00,$00,$00,$00,$04,$00,$00,$00,$12,$3F,
  $12,$00,$00,$00,$00,$00,$06,$00,$00,$04,$04,$0E,$0E,$1F,$1F,
  $00,$00,$00,$05,$00,$00,$1F,$1F,$0E,$0E,$04,$04,$00,$00,$00,
  $05,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$04,$02,$02,
  $02,$02,$02,$00,$02,$02,$00,$00,$00,$02,$0A,$0A,$0A,$00,$00,
  $00,$00,$00,$00,$00,$00,$04,$12,$12,$3F,$12,$12,$12,$3F,$12,
  $12,$00,$00,$06,$08,$1C,$2A,$0A,$0C,$18,$28,$2A,$1C,$08,$00,
  $06,$06,$49,$26,$10,$08,$04,$32,$49,$30,$00,$00,$07,$04,$0A,
  $0A,$04,$04,$2A,$12,$12,$2C,$00,$00,$06,$04,$04,$04,$00,$00,
  $00,$00,$00,$00,$00,$00,$03,$08,$0C,$04,$02,$02,$02,$02,$04,
  $0C,$08,$00,$04,$02,$06,$04,$08,$08,$08,$08,$04,$06,$02,$00,
  $04,$00,$00,$00,$22,$1C,$3E,$1C,$22,$00,$00,$00,$07,$00,$00,
  $08,$08,$3E,$08,$08,$00,$00,$00,$00,$06,$00,$00,$00,$00,$00,
  $00,$00,$00,$04,$02,$00,$03,$00,$00,$00,$00,$0E,$00,$00,$00,
  $00,$00,$00,$04,$00,$00,$00,$00,$00,$00,$00,$00,$02,$00,$00,
  $02,$08,$08,$04,$04,$04,$04,$04,$02,$02,$00,$00,$04,$1C,$22,
  $22,$22,$22,$22,$22,$22,$1C,$00,$00,$06,$20,$38,$20,$20,$20,
  $20,$20,$20,$20,$00,$00,$06,$1C,$22,$20,$20,$10,$08,$04,$02,
  $3E,$00,$00,$06,$1C,$22,$20,$20,$18,$20,$20,$22,$1C,$00,$00,
  $06,$10,$18,$18,$14,$14,$12,$3E,$10,$10,$00,$00,$06,$3E,$02,
  $02,$1E,$22,$20,$20,$22,$1C,$00,$00,$06,$1C,$22,$02,$02,$1E,
  $22,$22,$22,$1C,$00,$00,$06,$3E,$20,$10,$10,$08,$08,$04,$04,
  $04,$00,$00,$06,$1C,$22,$22,$22,$1C,$22,$22,$22,$1C,$00,$00,
  $06,$1C,$22,$22,$22,$3C,$20,$20,$22,$1C,$00,$00,$06,$00,$02,
  $02,$00,$00,$00,$00,$02,$02,$00,$00,$02,$00,$04,$04,$00,$00,
  $00,$00,$04,$04,$02,$00,$03,$00,$10,$08,$04,$02,$04,$08,$10,
  $00,$00,$00,$05,$00,$00,$00,$3E,$00,$3E,$00,$00,$00,$00,$00,
  $06,$00,$02,$04,$08,$10,$08,$04,$02,$00,$00,$00,$05,$1C,$22,
  $20,$20,$10,$08,$08,$00,$08,$00,$00,$06,$38,$44,$B2,$AA,$AA,
  $AA,$52,$04,$38,$00,$00,$08,$10,$10,$28,$28,$44,$44,$7C,$82,
  $82,$00,$00,$08,$3C,$44,$44,$44,$3C,$44,$44,$44,$3C,$00,$00,
  $07,$3C,$42,$02,$02,$02,$02,$02,$42,$3C,$00,$00,$07,$1E,$22,
  $42,$42,$42,$42,$42,$22,$1E,$00,$00,$07,$3E,$02,$02,$02,$1E,
  $02,$02,$02,$3E,$00,$00,$06,$3E,$02,$02,$02,$1E,$02,$02,$02,
  $02,$00,$00,$06,$3C,$42,$02,$02,$72,$42,$42,$62,$5C,$00,$00,
  $07,$42,$42,$42,$42,$7E,$42,$42,$42,$42,$00,$00,$07,$02,$02,
  $02,$02,$02,$02,$02,$02,$02,$00,$00,$02,$10,$10,$10,$10,$10,
  $10,$12,$12,$0C,$00,$00,$05,$44,$24,$14,$0C,$0C,$14,$24,$44,
  $84,$00,$00,$08,$02,$02,$02,$02,$02,$02,$02,$02,$3E,$00,$00,
  $06,$82,$82,$C6,$C6,$AA,$AA,$92,$92,$82,$00,$00,$08,$42,$46,
  $46,$4A,$4A,$52,$62,$62,$42,$00,$00,$07,$3C,$42,$42,$42,$42,
  $42,$42,$42,$3C,$00,$00,$07,$3E,$42,$42,$42,$3E,$02,$02,$02,
  $02,$00,$00,$07,$3C,$42,$42,$42,$42,$42,$52,$62,$3C,$40,$00,
  $07,$3E,$42,$42,$42,$3E,$42,$42,$42,$42,$00,$00,$07,$1C,$22,
  $02,$02,$1C,$20,$20,$22,$1C,$00,$00,$06,$3E,$08,$08,$08,$08,
  $08,$08,$08,$08,$00,$00,$06,$42,$42,$42,$42,$42,$42,$42,$42,
  $3C,$00,$00,$07,$82,$82,$44,$44,$44,$28,$28,$10,$10,$00,$00,
  $08,$82,$82,$82,$82,$82,$92,$92,$AA,$44,$00,$00,$08,$82,$82,
  $44,$28,$10,$28,$44,$82,$82,$00,$00,$08,$82,$82,$44,$28,$10,
  $10,$10,$10,$10,$00,$00,$08,$FE,$80,$40,$20,$10,$08,$04,$02,
  $FE,$00,$00,$08,$06,$02,$02,$02,$02,$02,$02,$02,$02,$06,$00,
  $03,$02,$02,$04,$04,$04,$04,$08,$08,$00,$00,$00,$04,$06,$04,
  $04,$04,$04,$04,$04,$04,$04,$06,$00,$03,$08,$14,$22,$00,$00,
  $00,$00,$00,$00,$00,$00,$06,$00,$00,$00,$00,$00,$00,$00,$00,
  $3E,$00,$00,$06,$06,$0C,$00,$00,$00,$00,$00,$00,$00,$00,$00,
  $04,$00,$00,$00,$1C,$20,$3C,$22,$22,$3C,$00,$00,$06,$02,$02,
  $02,$1E,$22,$22,$22,$22,$1E,$00,$00,$06,$00,$00,$00,$1C,$22,
  $02,$02,$22,$1C,$00,$00,$06,$20,$20,$20,$3C,$22,$22,$22,$22,
  $3C,$00,$00,$06,$00,$00,$00,$1C,$22,$3E,$02,$22,$1C,$00,$00,
  $06,$04,$02,$02,$06,$02,$02,$02,$02,$02,$00,$00,$03,$00,$00,
  $00,$3C,$22,$22,$22,$22,$3C,$20,$1E,$06,$02,$02,$02,$1A,$26,
  $22,$22,$22,$22,$00,$00,$06,$02,$00,$00,$02,$02,$02,$02,$02,
  $02,$00,$00,$02,$02,$00,$00,$02,$02,$02,$02,$02,$02,$02,$02,
  $02,$02,$02,$02,$12,$0A,$06,$0A,$12,$22,$00,$00,$06,$02,$02,
  $02,$02,$02,$02,$02,$02,$02,$00,$00,$02,$00,$00,$00,$6E,$92,
  $92,$92,$92,$92,$00,$00,$08,$00,$00,$00,$1A,$26,$22,$22,$22,
  $22,$00,$00,$06,$00,$00,$00,$1C,$22,$22,$22,$22,$1C,$00,$00,
  $06,$00,$00,$00,$1E,$22,$22,$22,$22,$1E,$02,$02,$06,$00,$00,
  $00,$3C,$22,$22,$22,$22,$3C,$20,$20,$06,$00,$00,$00,$06,$02,
  $02,$02,$02,$02,$00,$00,$03,$00,$00,$00,$0C,$12,$04,$08,$12,
  $0C,$00,$00,$05,$00,$02,$02,$06,$02,$02,$02,$02,$04,$00,$00,
  $03,$00,$00,$00,$22,$22,$22,$22,$32,$2C,$00,$00,$06,$00,$00,
  $00,$22,$22,$14,$14,$08,$08,$00,$00,$06,$00,$00,$00,$92,$92,
  $AA,$AA,$44,$44,$00,$00,$08,$00,$00,$00,$12,$12,$0C,$0C,$12,
  $12,$00,$00,$05,$00,$00,$00,$12,$12,$12,$12,$0C,$04,$04,$03,
  $05,$00,$00,$00,$1E,$10,$08,$04,$02,$1E,$00,$00,$05,$0C,$04,
  $04,$04,$04,$02,$04,$04,$04,$0C,$00,$04,$02,$02,$02,$02,$02,
  $02,$02,$02,$02,$02,$00,$02,$06,$04,$04,$04,$04,$08,$04,$04,
  $04,$06,$00,$04,$0A,$05,$00,$00,$00,$00,$00,$00,$00,$00,$00,
  $04,$0E,$11,$15,$11,$0E,$00,$00,$00,$00,$00,$00,$05,$00,$14,
  $00,$1C,$20,$3C,$22,$22,$3C,$00,$00,$06,$54,$10,$28,$28,$44,
  $44,$7C,$82,$82,$00,$00,$08,$00,$14,$00,$1C,$22,$22,$22,$22,
  $1C,$00,$00,$06,$24,$00,$3C,$42,$42,$42,$42,$42,$3C,$00,$00,
  $07,$00,$14,$00,$22,$22,$22,$22,$32,$2C,$00,$00,$06,$24,$00,
  $42,$42,$42,$42,$42,$42,$3C,$00,$00,$00);


Var A:Char;
    i,j,c:Integer;
    s:String;
    d:Boolean;
    P:Pointer;F:File;

begin;
  WriteLn('FEX  Font Editor for mode X    by Christian Harms');
  WriteLn;
  j:=3;s:='';
  if paramcount>0 then
  begin;
    for i:=1 to paramcount do if pos('?',paramstr(i))>0 then help;
    i:=1;
    val(paramstr(i),j,c);
    if c=0 then Inc(i) else j:=3;
    if paramcount<=i then set_key_makro('L'+paramstr(i)+Enter);
  end;

  X_Set_Mode(j,400);
  x_text_init;
  X_register_userfont(Font_Timpani);
  x_set_font(2);
  E_Read_Mode:=Only_Filename;   (* E_Input gets only digits for Filename. *)


  MyMouseInit;
  DefineMouseCursor(MyMouseForm,Gray5);

  Init_Mem;
  actuell:=76;
  Init_Screen;
  Set_Cursor(XC,YC,Gray5);

  repeat
    ShowMouse;
    MouseAction := False;

    repeat
            (* This is the idea of X_Button and X_Keys !!!
               So you can use Buttons by press the key or click with mouse .
               Works without a mousedriver, too !                           *)
      if ButtonStatus<>0 then
        case Get_pressed_Button of
            0:;
            1:set_key_Makro('L');
            2:set_key_Makro('S');
            3:set_key_Makro('D');
            4:set_key_Makro('F');
           10:set_key_Makro(#0+Shift_Tab);
           11:set_key_Makro(TAB);
           12:set_key_Makro(#0+F2);
           13:set_key_Makro(#0+F3);
           14:set_key_Makro(#0+F1);
        end;

      if MouseAction then           (* If mouse moved ... *)
      begin;
        if (MouseY>Box_Y) and (MouseX>Box_X) and
           InBox(Box_X,Box_Y,Box_X+Mult_X*Zoom-2,Box_Y+16*Zoom-2) and

           (((MouseX-Box_X)div Zoom)<Font[actuell].MaxX)     and
           (((MouseY-Box_Y)div Zoom)<=Font_Heigth)                then
        begin;
          HideMouse;
          Get_Cursor;
          if FontType=1 then i:=(Font[actuell].D[XC] and (1 shl YC))
                     else i:=(Font[actuell].D[YC] and (1 shl XC));
          case ButtonStatus of
            0:begin;end;
            1:if (i=0 ) then begin;Set_Point(XC,YC);delay(100);end;
            2:if (i<>0) then begin;Set_Point(XC,YC);delay(100);end;
            3:begin;Set_Point(XC,YC);delay(100);end;
          end;
        end;
        if InBox(Char_X,Char_Y,GetMaxX,GetMaxY)and (ButtonStatus<>0) then
        begin;
          HideMouse;
          Select_Char;
        end;

        MouseAction:=False;
        ShowMouse;
      end;

    until keyspressed;

    HideMouse;      (* ! imported ! *)
    a:=UpCase(ReadKeys);
    case a of
       #0: begin;
             a:=ReadKeys;
             Set_Cursor(XC,YC,Gray2);
             case a of
               Left  : if XC>0 then Dec(XC) else XC:=Font[actuell].MaxX;
               Right : if XC<Font[actuell].MaxX then Inc(XC) else XC:=0;
               Up    : if YC>0 then Dec(YC) else YC:=Font_Heigth       ;
               Down  : if YC<Font_Heigth        then Inc(YC);
               Shift_TAB :if Font[actuell].MaxX>0 then
                       begin;
                         Dec(Font[actuell].MaxX);
                         if XC>Font[actuell].MaxX then XC:=Font[actuell].MaxX;
                         Show_Big_Char(chr(actuell));
                         Show_Char(Char_X+(actuell mod (Char_Rows))*(Mult_X+1),
                                   Char_Y+(actuell div (Char_Rows))*17,
                                   actuell,Gray4);
                       end;
               PGDown: if actuell<Max_C then
                       begin;
                         Inc(actuell);
                         Show_Big_Char(chr(actuell));
                         Show_Bios_Char(char(actuell));
                       end;
               PGUp: if actuell>0 then
                       begin;
                         Dec(actuell);
                         Show_Big_Char(chr(actuell));
                         Show_Bios_Char(char(actuell));
                       end;
               F1:begin;
                    Box(0,0,But_X-6-x_length('  '),Char_Y-3,0);
                    i:=10;
                    for j:=1 to Max_Lines do
                    begin;X_write(5,i,255,Help_Lines[j]);Inc(i,x_font_height);end;
                    wait_key(Return);
                    Box(0,0,But_X-6-x_length('  '),Char_Y-3,0);
                    Show_Big_Char(chr(actuell));
                  end;
               F2:if Font_Heigth>1 then
                  begin;
                    Dec(Font_Heigth);
                    Init_Screen;
                  end;
               F3:if Font_Heigth<15 then
                  begin;
                    Inc(Font_Heigth);
                    Init_Screen;
                  end;
             end;
             Set_Cursor(XC,YC,Gray5);
           end;
    Space:Set_Point(XC,YC);
    Enter:for i:=0 to 4 do
            if (Big_Point[i,0]+XC>=0)and(Big_Point[i,0]+XC<=Font[actuell].MaxX)and
               (Big_Point[i,1]+YC>=0)and(Big_Point[i,1]+YC<=Font_Heigth) then
                  Set_Point(Big_Point[i,0]+XC,Big_Point[i,1]+YC);
      TAB:if (FontType=1)and(Font[actuell].MaxX<15)or
             (FontType=0)and(Font[actuell].MaxX<8)  then
          begin;
            Inc(Font[actuell].MaxX);
            Show_Big_Char(chr(actuell));
            Show_Char(Char_X+(actuell mod (Char_Rows))*(Mult_X+1),
                      Char_Y+(actuell div (Char_Rows))*17,actuell,Gray4);
          end;
    'S':begin;
          s:=FileName;
          if FontType=0 then begin;
                             Shadow_Box(8,8,But_X-20,x_font_height+11,Gray5,Gray4,Gray3);
                             E_Input(10,10,But_X-24,Gray0,Gray2,Gray4,Gray0,'Save (8xn): ',s);
                          end
                     else begin;
                             Shadow_Box(8,8,But_X-20,x_font_height*2+11,Gray5,Gray4,Gray3);
                             x_write(10,12+x_font_height,Gray0,'XLib_C dont support this in version 6 !');
                             E_Input(10,10,But_X-24,Gray0,Gray2,Gray4,Gray0,'Save (16xn): ',s);
                          end;

          if s<>'' then begin;FileName:=Only_One_Ext(S,'FNT');Save_Font(Filename);end;
          Box(8,8,But_X-20,x_font_height*2+12,Gray0);
          Show_Big_Char(chr(actuell));
        end;
    'L':begin;
          s:=FileName;
          Shadow_Box(8,8,But_X-20,x_font_height+11,Gray5,Gray4,Gray3);
          E_Input(10,10,But_X-24,Gray0,Gray2,Gray4,Gray0,'Load Font: ',s);
          if F_Size(Only_One_Ext(S,'FNT'))=0 then s:='';
          if s<>'' then begin;FileName:=Only_One_Ext(S,'FNT');Load_Font(Filename);end;
          XC:=0;YC:=0;
          Init_Screen;
        end;
    'D':begin;
          s:='*.fnt';
          Shadow_Box(8,8,But_X-20,x_font_height+11,Gray5,Gray4,Gray3);
          E_Input(10,10,But_X-24,Gray0,Gray2,Gray4,Gray0,'Wildcard : ',s);
          Box(Box_X,Box_Y,But_X-20,Char_Y-10,Gray0);
          if s<>'' then begin;Show_Dir(s);wait_key(#13);end;
          Box(Box_X,Box_Y,But_X-20,Char_Y-10,Gray0);
          Show_Big_Char(chr(actuell));
        end;
    'F':begin;
          s:=FileName;
          Shadow_Box(8,8,But_X-20,x_font_height+11,Gray5,Gray4,Gray3);
          E_Input(10,10,But_X-24,Gray0,Gray2,Gray4,Gray0,'Fontfilename: ',s);
          if F_Size(Only_One_Ext(S,'FNT'))=0 then s:='';
          if s<>'' then begin;FileName:=Only_One_Ext(S,'FNT');Fnt2Inc(Filename);end;
          Box(8,8,But_X-20,x_font_height+12,Gray0);
          Show_Big_Char(chr(actuell));
        end;

      ESC:Ende:=True;
    end;



  until Ende;


  for i:=1 to 3 do D:=Kill_Button(i); (* to make free the heap *)

  MyMouseDestroy;
  X_Text_Mode;

  WriteLn('This is the end of FEX, the Font Editor in mode X  by Christian Harms.');
  WriteLn;
  WriteLn('FEX is a demo/utility of XLib_TP, the mode x-programmer lib for TP.');
end.














