;
; Napalm Software XMODE routines v1.0
; by Antti Virtanen
; MODE13X  - set VGA to 360x480 256 color XMODE
; putpixel - put a pixel in DX,BX with color CL
; Do what ever you want with this piece of code; Enjoy!
;
; 360x480 isn't allways the best resolution. We made easily
; this example to run in 400x480 x-mode. And I think, that
; 400x600 or 600x400 resolution isn't impossible to reach with
; VGA. It's just a matter of VGA acknowledgement and coding skills.

code    segment
	assume cs:code, ds:code

proggis:
	call mode13x
	xor  dx,dx
	mov  cl,0
	mov  bx,0
	loopp:
	  inc  cl
	  inc  dx
	  inc  bx
	  call putpixel         ;From left upper corner
	  push bx
	  mov  ax,480           ;From left down corner
	  sub  ax,bx
	  mov  bx,ax
	  call putpixel
	  pop  bx
	  push dx
	  mov  ax,360           ;From right upper corner
	  sub  ax,dx
	  mov  dx,ax
	  call putpixel
	  push bx
	  mov  ax,480
	  sub  ax,bx
	  mov  bx,ax
	  call putpixel
	  pop  bx
	  pop  dx
	  push bx
	  mov  bx,240
	  call putpixel
	  push dx
	  mov  ax,360
	  sub  ax,dx
	  mov  dx,ax
	  call putpixel
	  pop  dx
	  pop  bx
	  push dx
	  mov  dx,180
	  call putpixel
	  push bx
	  mov  ax,480
	  sub  ax,bx
	  mov  bx,ax
	  call putpixel
	  pop  bx
	  pop  dx
	  cmp  dx,255
	  jge  poies
	  jmp  loopp
	poies:
	mov  ax,0
	int  16h
	mov  ax,0003
	int  10h
	mov  ax,4c00h
	int  21h

;-----------------------------
;- DX = x
;- BX = y
;- CL = color
;-----------------------------
ymax equ 479
xmax equ 359
translatetab db 01,02,04,08
include xgadr.inc               ;Pixel row offset Look-Up-Table

putpixel proc near
  cmp  bx,ymax
  jg   @qexit
  cmp  dx,xmax
  jg   @qexit
  push di
  push ds
  push bp
  push ax
  push dx
  mov  di,bx
  shl  di,1
  add  di,offset gadr
  mov  bp,[cs:di]
  mov  ax,dx
  shr  dx,1             ;286 men should use SHR DX,2 instead
  shr  dx,1
  add  bp,dx
  mov  di,offset translatetab
  and  ax,3
  add  di,ax
  mov  ah,[cs:di]
  mov  al,2
  mov  dx,3c4h
  out  dx,ax
  mov  ax,0a000h
  mov  ds,ax
  mov  [ds:bp],cl
  pop  dx
  pop  ax
  pop  bp
  pop  ds
  pop  di
  @qexit:
  ret
putpixel endp


vptbl   dw      06b00h  ; horz total
	dw      05901h  ; horz displayed
	dw      05a02h  ; start horz blanking
	dw      08e03h  ; end horz blanking
	dw      05e04h  ; start h sync
	dw      08a05h  ; end h sync
	dw      00d06h  ; vertical total
	dw      03e07h  ; overflow
	dw      04009h  ; cell height
	dw      0ea10h  ; v sync start
	dw      0ac11h  ; v sync end and protect cr0-cr7
	dw      0df12h  ; vertical displayed
	dw      02d13h  ; offset
	dw      00014h  ; turn off dword mode
	dw      0e715h  ; v blank start
	dw      00616h  ; v blank end
	dw      0e317h  ; turn on byte mode
vpend   label   word


mode13x proc near
	push    ds
	mov     ax,cs
	mov     ds,ax

	mov     ax,13h          ; start with standard mode 13h
	int     10h             ; let the bios set the mode

	mov     dx,3c4h         ; alter sequencer registers
	mov     ax,0604h        ; disable chain 4
	out     dx,ax

	mov     ax,0f02h        ; set write plane mask to all bit planes
	out     dx,ax
	push    di
	xor     di,di
	mov     ax,0a000h       ; screen starts at segment A000
	mov     es,ax
	mov     cx,21600        ; ((XSIZE*YSIZE)/(4 planes))/(2 bytes per word)
	xor     ax,ax
	cld
	rep     stosw           ; clear the whole of the screen
	pop     di

	mov     ax,0100h        ; synchronous reset
	out     dx,ax           ; asserted
	mov     dx,3c2h         ; misc output
	mov     al,0e7h         ; use 28 mHz dot clock
	out     dx,al           ; select it
	mov     dx,3c4h         ; sequencer again
	mov     ax,0300h        ; restart sequencer
	out     dx,ax           ; running again

	mov     dx,3d4h         ; alter crtc registers

	mov     al,11h          ; cr11
	out     dx,al           ; current value
	inc     dx              ; point to data
	in      al,dx           ; get cr11 value
	and     al,7fh          ; remove cr0 -> cr7
	out     dx,al           ;    write protect
	dec     dx              ; point to index
	cld
	mov     si,offset vptbl
	mov     cx,((offset vpend)-(offset vptbl)) shr 1
outlp:  lodsw
	out     dx,ax
	loop    outlp
	pop     ds
	ret
mode13x endp

code    ends
	end proggis

