Unit XGRAPH;

{$G+}

{
 XGRAPH.TPU is a part of Napalm Software Xmode library for TP and TASM
 It's copyrighted by Napalm Software, and using in commercial products is
 not allowed without a written permission of Napalm Software. While these
 rules and rules in xmode.txt are kept, xlibtp12.arj is freeware, and you can
 use it as you want to. This source is released for those who don't yet know
 much about xmode. If you use this unit... PLEASE INCLUDE US IN CREDITS!!!

 XGRAPH.PAS is written by Antti Virtanen
 CIRCLE routines based on AARDVARK's MCGA.PAS
 POLYGON routine ripped-off from some AARDVARK release (thanx alot guyz, hope ya don't mind?)
 Documentation is written by Tapio ijl

 Some features:

 -Support for eight different resolution xmodes
 -Enchanced drawing commands (lines, circles, polygons...etc.)
 -Max. resolution 360x480 with 256 colors.
 -Requires only VGA adapter and monitor (color)
 -Mouse routines included to library
 -Usage of two ROM fonts (8x8 and 8x16)
 -User defined fonts possible
 -Useful viewport function
}

Interface

Uses crt, DOS, mouse;

Const
  maxcolor = 256;
  
  poly_complex = 100; {Maximum points/corners in polygon}
  
  {Error codes returned by LOADICON in variable XmodeErr}
  NoError = 0;
  NotEnoughMemError = 2;
  FileInvalid = 1;
  FileNotFound = 1;
  
  {Style codes passed to PutImage and PutScaledImage in variable PutImgStyle}
  NormalPut = 0;
  XORPut = 1;
  BackGroundPut = 2;
  
  
Type
  PaletteType = Record
                  Red : Array [0..255] Of Byte;
                  Green : Array [0..255] Of Byte;
                  Blue : Array [0..255] Of Byte;
                End;
  
Var
  col               : Byte;
  pal               : PaletteType;             {GETPALETTE returns palette in this variable}
  Font              : Array [0..255 * 8] Of Byte;
  bigfont           : Array [0..255 * 16] Of Byte;
  regs              : Registers;
  fontp             : Pointer;
  XMODEerr          : Integer;
  PutImgStyle       : Integer;
  xmax, ymax         : Integer;
  yadd              : Word;
  lastofs           : Word;
  xy_ratio          : Real;
  vx1, vx2, vy1, vy2   : Word;
  
Function  setxmode (xmodus : Byte) : Byte;
Procedure TextMode; {Set vga text mode 3}
Procedure SetViewPort (X1, Y1, X2, Y2 : Word);

Procedure GetPixel (X, Y : Word; page : Byte); {Pixel color will be in var COL}
Procedure PutPixel (X, Y : Word; Color, page : Byte);
Procedure Bar (X, Y, X1, Y1 : Word; Color, page : Byte);
Procedure Rectangle (X, Y, X1, Y1 : Word; Color, page : Byte);
Procedure Circle (X, Y, rad : Word; Color, page : Byte);
Procedure Ellipse (MX, MY, A, B: Word; C, P: Byte);

Procedure filledcircle (X, Y, rad : Word; Color, page : Byte);
Procedure FillEllipse (MX, MY, A, B: Word; C, P: Byte);
Procedure FillPoly (Size: Integer; Var Polygon; C, Pa: Byte);

Procedure setRGB (Color, rvalue, gvalue, bvalue : Byte);
Procedure GetPalette;
Procedure SetPalette;
Procedure pal_fadeout (speed : Byte);
Procedure shade_palette (start, stop, sr, sg, sb, er, eg, eb : Byte);
Procedure palette_cycle (start, stop, Direction : Byte);

Procedure show_page (page : Byte);
Procedure copy_page (inpage, outpage : Byte);
Procedure fillscreen (Color, page : Byte);

Procedure OutText (X, Y : Word; Color, page : Byte; Text : String);
Procedure bigouttext (X, Y : Word; Color, page : Byte; Text : String);
Procedure textline (X1, Y1, X2, Y2 : Word; Color, page, Font : Byte; Text : String);

Function  initialize_mouse : Boolean;
Procedure update_mouse;

Function  GetImage (X, Y, X1, Y1 : Word; Var image : Pointer; page : Byte) : Word;
                             {Returns 0 if no errors, 1 if no memory available}
Procedure PutImage (X, Y : Word; Var image : Pointer; page : Byte);
Procedure freeimagemem (image : Pointer);
                           {Note: Result will be a nice crash, if pointer is not
                            a valid image pointer, but is not nil!}
Procedure putScaledImage (X, Y : Word; ScaleX, ScaleY : Real; Var image : Pointer; page : Byte);

Procedure LoadIcon (filename : String; Var icon : Pointer; ino : Integer);
                       {Errorcode is returned in variable XMODEerr,
                        because TP didn't lemme do this as function?!}
                       {Returns 0 if no errors, 1 if icon file not found, or
                       file is not a valid icon file. Returns 2 if not enough
                       memory for icon.}
Procedure IconUp (X, Y, X1, Y1 : Integer; page : Byte);
                      {Makes a rectangular look-like-3D icon to screen}
Procedure IconDown (X, Y, X1, Y1 : Integer; page : Byte);
                      {Makes a rectangular look-like-3D icon to screen}
Procedure saveicon (filename : String; Var icon : Pointer; ino : Integer);
                      {Errorcode is returned in variable XMODEerr.
                      note: Icon must be a 32x32 image, returned by
                            loadicon or getimage. If size is NOT 32x32
                            saving is done, but result will be ?*!}
Procedure Line (X1, Y1, X2, Y2 : Word; Color, page : Byte);
Procedure Hline (X1, X2, Y : Word; page, Color : Byte);
Procedure Vline (Y1, Y2, X : Word; page, Color : Byte);

Procedure setoffset (offs : Word);
                      {Sets starting offset of visible screen:
                       can be used to create scrolling virtual screen}
{The following procedures are few of my "useful VGA procedures"
 They can often be used in other video modes...}
Procedure setborder (Color : Byte);    {Works fine in txt modes also}
Procedure setlinecomp (newcomp : Word); {only bits 0-9 are used}
Procedure syncretrace; {Timing! in animations, and when need for timing}
Procedure hide_cursor; {TXT modes only}

Implementation

{$I xgadr.lib}

Var
  index, iofs, iseg : Word;
  scroffset         : Word;
  bkcolor           : Byte;
  pages             : Byte;
  oldmousex,
  oldmousey         : Word;
  mouseimg          : Pointer;
  
  
Type
  imagefiletype = Record
                    header   : String;
                    icondata : Array [1..32, 0..33, 0..33] Of Byte;
                  End;
  
Var
  cc, D       : Integer;
  inputdata  : imagefiletype;
  Input      : File Of imagefiletype;
  
Var
  Steigung             : Byte;        {determines, which algorithm will be used to draw lines}
  DY_mal2, DY_m_DX_mal2 : Integer;
  
Const
  TranslateTab: Array [0..3] Of Byte = (1, 2, 4, 8); {For mask addressing    }
  
  Procedure segmentt; Assembler;
  Asm
    dw 0a000h, 0a000h, 0a000h, 0a000h
  End;
  
  {!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  This is the very basic/most important function of xmode library.
  This function sets up font arrays, and inits VGA to xmode!
  Value passed to function indicates which xmode to use.
  Valid values/Supported xmodes are :
  0 : 360x480, 1 displ. page
  1 : 360x400, 1 displ. pages
  2 : 360x240, 3 displ. pages
  3 : 360x200, 3 displ. pages
  4 : 320x200, 4 displ. pages
  5 : 320x400, 2 displ. pages
  6 : 320x240, 3 displ. pages
  7 : 320x480, 1 displ. page
  }
  Function setxmode (xmodus : Byte) : Byte;  {Sets VGA undocumented hi-res 256 color mode}
Const
  param_count = 16;
  
  params1 : Array [0..param_count] Of Word = (     {Parameter table for 360x480}
  $6b00, $5901, $5a02, $8e03,
  $5e04, $8a05, $0D06, $3e07,
  $4009, $ea10, $ac11, $df12,
  $2D13, $0014, $e715, $0616,
  $e317);
  
  params2 : Array [0..param_count] Of Word = (    {Param table for 360x400}
  $6b00, $5901, $5a02, $8e03,
  $5e04, $8a05, $bf06, $1f07,
  $4009, $9c10, $8e11, $8f12,
  $2D13, $0014, $9615, $b916,
  $e317);
  
  params3 : Array [0..param_count] Of Word = (    {Video parameters for 360x240}
  $6b00, $5901, $5a02, $8e03,
  $5e04, $8a05, $0D06, $3e07,
  $4109, $ea10, $ac11, $df12,
  $2D13, $0014, $e715, $0616,
  $e317);
  
  params4 : Array [0..param_count] Of Word = (    {Param table for 360x200}
  $6b00, $5901, $5a02, $8e03,
  $5e04, $8a05, $bf06, $1f07,
  $4109, $9c10, $8e11, $8f12,
  $2D13, $0014, $9615, $b916,
  $e317);
  
  params5 : Array [0..param_count] Of Word = (    {Param table for 320x200}
  $5f00, $4f01, $5002, $8203,
  $5404, $8005, $bf06, $1f07,
  $4109, $9c10, $8e11, $8f12,
  $2813, $0014, $9615, $b916,
  $e317);
  
  params6 : Array [0..param_count] Of Word = (    {Param table for 320x400}
  $5f00, $4f01, $5002, $8203,
  $5404, $8005, $bf06, $1f07,
  $4009, $9c10, $8e11, $8f12,
  $2813, $0014, $9615, $b916,
  $e317);
  
  params7 : Array [0..param_count] Of Word = (    {Param table for 320x240}
  $5f00, $4f01, $5002, $8203,
  $5404, $8005, $0D06, $3e07,
  $4109, $ea10, $8c11, $df12,
  $2813, $0014, $e715, $0616,
  $e317);
  
  params8 : Array [0..param_count] Of Word = (    {Param table for 320x480}
  $5f00, $4f01, $5002, $8203,
  $5404, $8005, $0D06, $3e07,
  $4009, $ea10, $8c11, $df12,
  $2813, $0014, $e715, $0616,
  $e317);
  
Var
  t     : Word;
  dot_clock : Byte;
Begin
  If xmodus > 7 Then Begin
    setxmode := 2;
    Exit;
  End;
  If xmodus In [0, 1, 2, 3] Then xmax := 359;
  If xmodus In [4, 5, 6, 7] Then xmax := 319;
  Case xmodus Of
    0 : ymax := 479;
    1 : ymax := 399;
    2 : ymax := 239;
    3 : ymax := 199;
    4 : ymax := 199;
    5 : ymax := 399;
    6 : ymax := 239;
    7 : ymax := 479;
  End;
  pages := 1;
  Case xmodus Of
    2 : pages := 3;
    3 : pages := 3;
    4 : pages := 4;
    5 : pages := 2;
    6 : pages := 3;
  End;
  lastofs := ( (xmax + 1) ShR 2) * ( (ymax + 1) ShR 1);
  If xmodus In [0, 1, 2, 3] Then yadd := 89;
  If xmodus In [4, 5, 6, 7] Then yadd := 79;
  For t := 0 To 479 Do
    memw [Seg (gadr): Ofs (gadr) + t + t] := t * yadd + t;
  Asm
    mov AX, 1a00h  {Function supported only in VGA}
    Int 10h
    cmp AL, 1AH    {If not supported AL contains something else}
    jne @no_VGA
    mov AX, 0      {Clear our errorcode marker (Just to be damn sure:-}
    mov t, AX
    jmp @yes_VGA
    @no_VGA:
    mov AX, 1
    mov t, AX
    @yes_VGA:
  End;
  setxmode := Lo (t);
  If t <> 0 Then Exit;
  regs. AX := $1130;           {Copy ROM fonts 8x8 and 8x16 to buffers}
  regs. BH := 3;
  Intr ($10, regs);
  fontp := Ptr (regs. ES, regs. BP);
  Move (fontp^, Font, SizeOf (Font) );
  regs. AX := $1130;
  regs. BH := 6;
  Intr ($10, regs);
  fontp := Ptr (regs. ES, regs. BP);
  Move (fontp^, bigfont, SizeOf (bigfont) );
  bkcolor := 0;
  Asm
    mov AX, 13h          {Set standard(BIOS) VGA 320x200x256 mode}
    Int 10h
    
    mov DX, 03c4h        {Unchain!}
    mov AX, 0604h
    out DX, AX
    
    mov AX, 0f02h        {Enable writes to all planes}
    out DX, AX
    
    XOr DI, DI
    mov AX, 0a000h
    mov ES, AX
    mov CX, 32000
    mov AX, 0
    cld
    rep stosw           {Clear the whole video memory}
  End;
  dot_clock := $67;
  If xmodus In [0, 2] Then dot_clock := $e7;
  If xmodus In [4, 5] Then dot_clock := $63;
  If xmodus In [6, 7] Then dot_clock := $e3;
  Asm
    mov DX, 3c4h
    mov AX, 0100h        {Synchronous reset}
    out DX, AX
    mov DX, 3c2h         {28Mhz dot clock}
    mov AL, dot_clock
    out DX, AL
    mov DX, 3c4h         {Restart sequencer}
    mov AX, 0300h
    out DX, AX
    mov DX, 03D4h
    mov AL, 11h          {cr11}
    out DX, AL
    Inc DX
    In  AL, DX
    And AL, 7fh
    out DX, AL           {Write protect}
  End;
  For t := 0 To param_count Do
    Case xmodus Of
      0 : portw [$3D4] := params1 [t];
      1 : portw [$3D4] := params2 [t];
      2 : portw [$3D4] := params3 [t];
      3 : portw [$3D4] := params4 [t];
      4 : portw [$3D4] := params5 [t];
      5 : portw [$3D4] := params6 [t];
      6 : portw [$3D4] := params7 [t];
      7 : portw [$3D4] := params8 [t];
    End;
  memw [Seg (segmentt): Ofs (segmentt) ] := $a000;
  For t := 1 To 3 Do
    memw [Seg (segmentt): Ofs (segmentt) + t * 2] := ( (lastofs + lastofs) Div 16) + $a000;
  
  vx1 := 0;
  vy1 := 0;
  vx2 := xmax;
  vy2 := ymax;
  
  If xmax < ymax Then xy_ratio := xmax / ymax * 0.78
  Else xy_ratio := ymax / xmax / 0.78;
End;

{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
Procedure PutPixel (X, Y : Word; Color, page : Byte); Assembler;
{I've tried to comment this procedure as well as I could. So that
 anyone, with just a little asm and vga acknowledgement could
 understand this.}
Asm
  mov  DI, Y
  cmp  DI, vy2                             {Y out of screen}
  jg   @qexit                             {DI(Y coordinate) greater than YMAX, make a quick exit}
  mov  DX, X                               {This isn't executed, if Y is out of screen}
  cmp  DX, vx2                             {X out of screen, compare x with xmax}
  jg   @qexit                             {If x was greater, jump to quick exit}
  cmp  DI, vy1
  jl   @qexit
  cmp  DX, vx1
  jl   @qexit
  XOr  BX, BX
  mov  BL, page
  cmp  BL, pages                           {Graphic page not valid}
  jg   @qexit
  ShL  BX, 1
  mov  ES, cs: [Offset segmentt + BX]
  ShL  DI, 1                               {Y offsets are WORDS}
  mov  DI, cs: [DI + Offset gadr]             {Y offset to DI}
  mov  CL, DL                              {Low part of X coordinate to CL}
  ShR  DX, 2                               {Divide with 4, because of 4 planes}
  add  DI, DX                              {DI = Y*linesize+(X SHR 2), pixel offset}
  And  CL, 3                               {Only lowest 2 bits (=numbers 0-3)}
  mov  AH, 1
  ShL  AH, CL                              {Bit plane to ah}
  mov  AL, 2                               {Write plane select index}
  mov  DX, 03c4h
  out  DX, AX                              {Select plane}
  mov  AL, Color
  stosb                                   {Same as MOV ES:[DI],AL}
  @qexit:                                 {Exit point, for out-of-screen calls}
End; {putpixel}

{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
Procedure TextMode; Assembler;
Asm
  mov AX, 3
  Int 10h
End;

{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
Procedure Vline (Y1, Y2, X : Word; page, Color : Byte); Assembler;
{
 There's something wrong with this procedure.
 I don't know why I couldn't get this working first,
 but now it works fine. I just wonder why does it not
 work when you change the "@next_pixel" - loop sequence
 a bit like this...
 ...
 @next_pixel:
 stosb
 add di,yadd
 cmp di,bx
 jle @next_pixel
 ...
 Could you tell me why?
 }
Asm
  XOr  BX, BX                    {Move 0 to bx}
  mov  BL, page
  cmp  BL, pages                 {Is page valid}
  jg   @q_exitt
  
  ShL  BL, 1
  mov  ES, cs: [Offset segmentt + BX]
  
  mov  DX, X
  cmp  DX, vx2                  {If x out of screen, no need for further processing}
  jg   @q_exitt
  cmp  DX, vx1
  jl   @q_exitt
  
  mov  BX, Y2
  mov  DI, Y1
  cmp  DI, BX                    {Compare y1 with y2}
  jle  @no_swap_y               {If y1=<y2, then jmp over next command}
  xchg DI, BX                    {y1>y2, so swap them!}
  @no_swap_y:
  cmp  DI, vy2
  jle  @no_max_y1
  mov  DI, vy2
  @no_max_y1:
  cmp  BX, vy2
  jle  @no_max_y2
  mov  BX, vy2
  @no_max_y2:
  cmp  DI, vy1
  jge  @no_less_y1
  mov  DI, vy1
  @no_less_y1:
  cmp  BX, vy1
  jge  @no_less_y2
  mov  BX, vy1
  @no_less_y2:
  
  mov  AH, 1
  mov  CX, DX                    {Take x coordinate to cx}
  And  CL, 3                     {Only values(planes) 0-3}
  ShL  AH, CL
  mov  DX, 3c4h                  {CRT Controller}
  mov  AL, 2                     {Plane select}
  out  DX, AX                    {Select plane}
  mov  AL, Color
  
  mov  DX, X
  ShR  DX, 2                     {Divide x coordinate with 4}
  ShL  BX, 1                     {BX=y2*2,}
  ShL  DI, 1                     {DI=y1*2}
  mov  DI, cs: [Offset gadr + DI]
  mov  BX, cs: [Offset gadr + BX]
  add  DI, DX
  add  BX, DX
  cmp  DI, BX
  jne  @normal
  stosb
  jmp  @q_exitt
  @normal:
  cld                                 {Forward direction flag}
  @next_pixel:
  stosb                               {Same as mov es:[di],al}
  add  DI, yadd                        {STOSB increments di with 1}
  cmp  DI, BX
  jne  @next_pixel
  @q_exitt:
End;  {vline}

{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
Procedure palette_cycle (start, stop, Direction : Byte);
Var
  t : Byte;
  sr, sg, sb : Byte;
  sstart, sstop : Byte;
  r, g, b : Byte;
Begin
  sstop := stop;
  sstart := start;
  If start > stop Then Begin
    sstop := start;
    sstart := stop;
  End;
  If Direction = 1 Then port [$3c7] := sstart
  Else port [$3c7] := stop;
  sr := port [$3c9];
  sg := port [$3c9];
  sb := port [$3c9];
  
  If Direction = 0 Then Begin
    For t := stop Downto start + 1 Do Begin
      port [$3c7] := t - 1;
      r := port [$3c9];
      g := port [$3c9];
      b := port [$3c9];
      port [$3c8] := t;
      port [$3c9] := r;
      port [$3c9] := g;
      port [$3c9] := b;
    End;
    port [$3c8] := start;
  End
  Else Begin
    For t := sstart To sstop - 1 Do Begin
      port [$3c7] := t + 1;
      r := port [$3c9];
      g := port [$3c9];
      b := port [$3c9];
      port [$3c8] := t;
      port [$3c9] := r;
      port [$3c9] := g;
      port [$3c9] := b;
    End;
    port [$3c8] := sstop;
  End;
  port [$3c9] := sr;
  port [$3c9] := sg;
  port [$3c9] := sb;
End;

{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
Procedure Hline (X1, X2, Y : Word; page, Color : Byte); Assembler;
Var
  tmp : Word;
  Asm
    mov BL, page
    cmp BL, pages
    jg  @loppu_filling
    
    mov DI, Y
    cmp DI, vy2
    jg  @loppu_filling
    cmp DI, vy1
    jl  @loppu_filling
    ShL DI, 1
    mov DI, cs: [Offset gadr + DI]
    
    
    mov BX, X1
    mov CX, X2
    cmp BX, CX
    jle @no_c
    xchg CX, BX
    @no_C:
    cmp CX, vx2
    jle @no_round1
    mov CX, vx2
    @no_round1:
    cmp BX, vx2
    jle @no_round2
    mov BX, vx2
    @no_round2:
    cmp CX, vx1
    jge @no_round3
    mov CX, vx1
    @no_round3:
    cmp BX, vx1
    jge @no_round4
    mov BX, vx1
    @no_round4:
    mov X2, CX
    mov X1, BX
    
    sub CX, BX              {Calculate length}
    cmp CX, 10              {If greater than 10, then use 4pixel/byte drawing}
    jg  @method_2
    
    XOr BX, BX
    mov BL, page
    ShL BL, 1
    mov ES, cs: [Offset segmentt + BX]
    mov BX, X1
    
    @loopp:
    mov CL, BL
    And CL, 3
    mov AH, 1
    ShL AH, CL
    mov AL, 2
    mov DX, 3c4h
    out DX, AX
    mov DX, BX
    ShR DX, 2
    push DI
    add DI, DX
    mov AL, Color
    mov ES: [DI], AL
    pop DI
    Inc BX
    cmp BX, X2
    jle @loopp
    jmp @loppu_filling
    
    @method_2:                    {If the horz. line is enough long,
    It's wise to minimize the plane
    selections.}
    XOr BX, BX
    mov BL, page
    ShL BL, 1
    mov ES, cs: [Offset segmentt + BX]
    mov DI, Y
    ShL DI, 1
    mov DI, cs: [Offset gadr + DI]
    mov BX, X1
    
    @loopp2:
    mov CL, BL
    And CL, 3
    cmp CL, 0
    je  @alku_ok
    mov AH, 1
    ShL AH, CL
    mov AL, 2
    mov DX, 3c4h
    out DX, AX
    mov DX, BX
    ShR DX, 2
    push DI
    add DI, DX
    mov AL, Color
    mov ES: [DI], AL
    pop DI
    Inc BX
    cmp BX, X2
    jle @loopp2
    @alku_ok:
    
    pusha
    mov BX, X2
    mov CX, BX
    And CX, 3
    sub BX, CX
    mov tmp, BX
    mov DI, Y
    ShL DI, 1
    mov DI, cs: [Offset gadr + DI]
    @loopp3:
    mov CL, BL
    And CL, 3
    mov AH, 1
    ShL AH, CL
    mov AL, 2
    mov DX, 3c4h
    out DX, AX
    mov DX, BX
    ShR DX, 2
    push DI
    add DI, DX
    mov AL, Color
    mov ES: [DI], AL
    pop DI
    Inc BX
    cmp BX, X2
    jle @loopp3
    popa
    
    
    mov X1, BX
    mov CX, X2
    mov BX, CX
    And CX, 3
    sub BX, CX
    mov SI, BX     {x1=start of 4pixel system, si=end}
    
    mov AX, 0f02h  {All planes -> 4pixels at one stosb!}
    mov DX, 3c4h
    out DX, AX
    mov BX, 1
    mov AL, Color
    cld
    mov CX, SI
    sub CX, X1     {How many bytes}
    ShR CX, 2
    mov DI, Y
    ShL DI, 1
    mov DI, cs: [Offset gadr + DI]
    mov DX, X1
    ShR DX, 2
    add DI, DX
    rep stosb
    
    @loppu_filling:
  End; {hline}
  
  {!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
  Procedure Bar (X, Y, X1, Y1 : Word; Color, page : Byte);
Var
  tx, ty, tx1, ty1 : Word;
Begin
  {Would be better to check the y/x -coordinates only once(hint, hint!!),
  but so what. Few milliseconds there or here, whatsoever.}
  If page > pages Then Exit;
  For ty := Y To Y1 Do
    hline (X, X1, ty, page, Color);
End;

{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
Procedure Rectangle (X, Y, X1, Y1 : Word; Color, page : Byte);
Begin
  hline (X, X1, Y, page, Color);
  hline (X, X1, Y1, page, Color);
  vline (Y, Y1, X, page, Color);
  vline (Y, Y1, X1, page, Color);
End;

{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
Procedure SetRGB (Color, rvalue, gvalue, bvalue : Byte);
{RGB values are bytes, but only bits 0-5 are used}
Begin
  port [$3c8] := Color;
  port [$3c9] := rvalue And 63; {AND 63 is here because 64 is same as 0,}
  port [$3c9] := gvalue And 63; {65 is same as 1...Take away if you don't like.}
  port [$3c9] := bvalue And 63;
End;

{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
Procedure shade_palette (start, stop, sr, sg, sb, er, eg, eb : Byte);
Var
  lgn, a    : Byte;
  rc, gc, bc : Real;
Begin
  lgn := stop - start;
  rc := (sr - er) / lgn;
  gc := (sg - eg) / lgn;
  bc := (sb - eb) / lgn;
  For a := start To stop Do Begin
    setrgb (a, Trunc (rc), Trunc (gc), Trunc (bc) );
    rc := rc + (sr - er) / lgn;
    gc := gc + (sg - eg) / lgn;
    bc := bc + (sb - eb) / lgn;
  End;
End;

{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
Procedure GetPalette;
Var
  j : Word;
Begin
  port [$3c7] := 0; {Start from palette index 0}
  For j := 0 To 255 Do Begin {Go thru all the indexes}
    pal. Red [j] := port [$3c9];   {Don't do any AND here}
    pal. Green [j] := port [$3c9];
    pal. Blue [j] := port [$3c9];
  End;
End;

{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
Procedure copy_page (inpage, outpage : Byte); Assembler;
  Asm
    mov  BL, inpage
    cmp  BL, pages
    jg   @exit_shit
    mov  BL, outpage
    cmp  BL, pages
    jg   @exit_shit
    cli
    mov  AX, 0f02h       {All planes}
    mov  DX, 3c4h
    out  DX, AX
    mov  AX, 4105h       {Choose write mode 1 for speed}
    mov  DX, 3ceh
    out  DX, AX
    
    mov  CX, lastofs
    ShL  CX, 1
    XOr  BX, BX
    mov  BL, outpage
    ShL  BX, 1
    mov  ES, cs: [Offset segmentt + BX]
    mov  BL, inpage
    ShL  BX, 1
    mov  DS, cs: [Offset segmentt + BX]
    XOr  DI, DI
    XOr  SI, SI
    cld
    
    rep  movsb
    
    mov  AX, Seg @data
    mov  DS, AX
    mov  AX, 4005h               {Back to normal write mode 0}
    mov  DX, 3ceh
    out  DX, AX
    sti
    @exit_shit:
  End;

{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
Procedure SetPalette;
Var
  j : Word;
Begin
  port [$3c8] := 0; {Note: getpalette sets 3C7h, it reads. This writes :-}
  For j := 0 To 255 Do Begin
    port [$3c9] := pal. Red [j];
    port [$3c9] := pal. Green [j];
    port [$3c9] := pal. Blue [j];
  End;
End;

{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
Procedure pal_fadeout (speed : Byte);
{This could have been done better,
 but the speed... and it was easier to do,
 easier to understand this way :}
Var
  Y, X : Word;
Begin
  For Y := 0 To 64 Do Begin
    GetPalette;
    For X := 0 To 255 Do Begin
      If pal. Red [X] > 0 Then Dec (pal. Red [X] );
      If pal. Green [X] > 0 Then Dec (pal. Green [X] );
      If pal. Blue [X] > 0 Then Dec (pal. Blue [X] );
    End;
    SetPalette;
    Delay (speed);
  End;
End;

{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
Procedure fillscreen (Color, page : Byte);
Begin
  Asm
    mov  BL, page
    cmp  BL, pages
    jg   @exxx
    push ES
    push DI
    mov DX, 3c4h
    mov AX, 0f02h  {Enable writes to all planes. Now each byte writes 4 pixels!}
    out DX, AX
    XOr BX, BX
    mov BL, page
    ShL BX, 1
    mov ES, cs: [Offset segmentt + BX]
    XOr DI, DI     {Clear DI}
    mov AL, Color  {Because of STOSW both AH and AL must contain the color}
    mov bkcolor, AL
    mov AH, AL
    mov CX, lastofs
    rep stosw
    pop DI        {PUSH and POP just to be 100% sure. TP has sometime crashed:}
    pop ES
    @exxx:
  End;
End;

{OUTTEXT for 8x8 font}
{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
Procedure OutText (X, Y : Word; Color, page : Byte; Text : String);
Const
  fontmask : Array [0..7] Of Byte = (128, 64, 32, 16, 8, 4, 2, 1);
Var
  c, co, co2, tc : Integer;
  CH     : Byte;
Begin
  If page > pages Then Exit;
  col := Color;
  For tc := 1 To Length (Text) Do Begin {Get thru the text}
    CH := mem [Seg (Text [tc] ): Ofs (Text [tc] ) ];
    For co2 := 0 To 7 Do
      For co := 0 To 7 Do  {All bytes in one char}
        If (Font [CH * 8 + co2] And fontmask [co] ) <> 0 Then PutPixel (X + (tc - 1) * 8 + co, Y + co2, col, page);
  End;
End;

{OUTTEXT for 8x16 font}
{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
Procedure bigouttext (X, Y : Word; Color, page : Byte; Text : String);
Const
  fontmask : Array [0..7] Of Byte = (128, 64, 32, 16, 8, 4, 2, 1);
Var
  c, co, co2, tc : Integer;
  CH     : Byte;
Begin
  If page > pages Then Exit;
  col := Color;
  For tc := 1 To Length (Text) Do Begin {Get thru the text}
    CH := mem [Seg (Text [tc] ): Ofs (Text [tc] ) ];
    For co2 := 0 To 15 Do
      For co := 0 To 7 Do  {All bytes in one char}
        If (bigfont [CH * 16 + co2] And fontmask [co] ) <> 0 Then PutPixel (X + (tc - 1) * 8 + co, Y + co2, col, page);
  End;
End;

{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
Procedure textline (X1, Y1, X2, Y2 : Word; Color, page, Font : Byte; Text : String);
Var
  xratio, yratio : Real;
  xx1, xx2, yy2, yy1, c : Word;
  tmp_string : String [2];
Begin
  If page > pages Then Exit;
  Asm
    mov AX, X1
    mov BX, X2
    cmp AX, BX
    jle @no_swapx
    xchg AX, BX
    @no_swapx:
    mov xx1, AX
    mov xx2, BX
    mov AX, Y1
    mov BX, Y2
    cmp AX, BX
    jle @no_swapy
    xchg AX, BX
    @no_swapy:
    mov yy1, AX
    mov yy2, BX
  End;
  xratio := (Xx2 - xx1) / Length (Text);
  yratio := (yy2 - yy1) / Length (Text);
  For c := 1 To Length (Text) Do Begin
    tmp_string := Text [c];
    Case Font Of
      0 : OutText (xx1 + Trunc (c * xratio), yy1 + Trunc (c * yratio), Color, page, tmp_string);
      1 : bigouttext (xx1 + Trunc (c * xratio), yy1 + Trunc (c * yratio), Color, page, tmp_string);
    End;
  End;
End;

{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
Procedure GetPixel (X, Y : Word; page : Byte); Assembler;
Asm
  mov BL, page
  cmp BL, pages
  jg  @qexit
  mov DI, Y
  cmp DI, ymax
  jg  @qexit
  mov DX, X
  cmp DX, xmax
  jg  @qexit
  push ES
  ShL DI, 1
  mov DI, cs: [DI + Offset gadr]
  mov AH, DL
  ShR DX, 2
  add DI, DX
  And AH, 3          {Read plane select doesn't need translatetab}
  mov DX, 03ceh      {Read plane select register is not same as write map select}
  mov AL, 4
  cli
  out  DX, AX        {Select read plane}
  XOr  BX, BX
  mov  BL, page
  ShL  BX, 1
  mov  ES, cs: [Offset segmentt + BX]
  mov  AL, ES: [DI]
  sti
  mov col, AL
  pop ES
  @qexit:
End;

{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
Function GetImage (X, Y, X1, Y1 : Word; Var image : Pointer; page : Byte) : Word;
Var
  tx, ty : Word;
Begin
  If MaxAvail < (X1 - X) * (Y1 - Y) + (X1 - X) + 6 Then Begin
    GetImage := 1;
    Exit;
  End
  Else GetImage := 0;
  If page > pages Then Exit;
  GetMem (image, (X1 - X) * (Y1 - Y) + (X1 - X) + 6);
  iofs := Ofs (image^);
  iseg := Seg (image^);
  memw [iseg: iofs] := (X1 - X) * (Y1 - Y) + (X1 - X);
  Inc (iofs, 2);
  memw [iseg: iofs] := (X1 - X);
  Inc (iofs, 2);
  memw [iseg: iofs] := (Y1 - Y);
  Inc (iofs, 2);
  index := iofs;
  For ty := Y To Y1 Do
    For tx := X To X1 Do Begin
      GetPixel (tx, ty, page);
      mem [iseg: index] := col;
      Inc (index);
    End;
End;

{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
Procedure PutImage (X, Y : Word; Var image : Pointer; page : Byte);
Var
  tx, ty : Word;
Begin
  If page > pages Then Exit;
  If image = Nil Then Exit;
  iofs := Ofs (image^) + 6;
  iseg := Seg (image^);
  index := iofs;
  For ty := Y To Y + memw [iseg: iofs - 2] Do
    For tx := X To X + memw [iseg: iofs - 4] Do Begin
      col := mem [iseg: index];
      If PutImgStyle = XORPut Then Begin
        GetPixel (tx, ty, page);
        col := mem [iseg: index] XOr col;
      End;
      Inc (index);
      If (putimgstyle <> backgroundput) Or (col <> bkcolor) Then PutPixel (tx, ty, col, page);
    End;
End;

{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
Procedure freeimagemem (image : Pointer);
Begin
  If image = Nil Then Exit;
  iofs := Ofs (image^) + 6;
  iseg := Seg (image^);
  FreeMem (image, memw [iseg: iofs - 6] + 6);
End;

{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
Procedure ScaledImage (X, Y : Word; ScaleX, ScaleY : Real; Var image : Pointer; page : Byte);
Var
  tx, ty : Word;
  FastX, FastY,
  SclX, SclY : Word;
  iofs, iseg, index : Word;
  xarray : Array [0..320] Of Byte;
  yarray : Array [0..200] Of Byte;
  tmp, tmp2 : Word;
Begin
  If image = Nil Then Exit;
  iofs := Ofs (image^) + 6;
  iseg := Seg (image^);
  index := iofs;
  SclX := Trunc (ScaleX * 256);   {To get more speed, scalex, and scaley could be WORDs allready}
  SclY := Trunc (ScaleY * 256);   {But beginners will understand this more easily:}
  For tx := X To X + memw [iseg: iofs - 4] Do Begin
    fastx := ( ( (tx - X) * sclx) ShR 8) + X;
    If tmp = fastx Then xarray [tx - X] := 0
    Else xarray [tx - X] := 1;
    tmp := fastx;
  End;
  For ty := Y To Y + memw [iseg: iofs - 2] Do Begin
    fasty := ( ( (ty - Y) * scly) ShR 8) + Y;
    If tmp = fasty Then yarray [ty - Y] := 0
    Else yarray [ty - Y] := 1;
    tmp := fasty;
  End;
  
  For tx := X To X + memw [iseg: iofs - 4] Do Begin
    index := iofs + tx - X;
    If xarray [tx - X] = 1 Then
      Asm          {Multiplies are handled with ASM to get max. speed}
        {Ofcourse MY method isn't the best, but it's MY OWN method ;-}
        mov AX, tx
        sub AX, X
        mov BX, sclx
        mul BX
        ShR AX, 8
        add AX, X
        mov fastx, AX
      End
    Else fastx := xmax + 1;
    Asm
      mov CX, fastx
      And CL, 3
      mov AH, 1
      ShL AH, CL
      mov AL, 2
      mov DX, 3c4h
      out DX, AX
    End;
    
    
    For ty := Y To Y + memw [iseg: iofs - 2] Do Begin
      If yarray [ty - Y] = 1 Then
        Asm
          mov AX, ty
          sub AX, Y
          mov BX, scly
          mul BX
          ShR AX, 8
          add AX, Y
          mov fasty, AX
        End
      Else fasty := ymax + 1;
      col := mem [iseg: index];
      Asm
        mov AX, 0a000h
        mov ES, AX
        mov DI, fasty
        cmp DI, ymax
        jg  @qexit
        mov BX, fastx
        cmp BX, xmax
        jg  @qexit
        ShL DI, 1
        mov DI, cs: [DI + Offset gadr]
        ShR BX, 2
        add DI, BX
        mov AL, col
        mov ES: [DI], AL
        @qexit:
      End;
      index := index + memw [iseg: iofs - 4] + 1;
    End;
  End;
End;

{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
Procedure putScaledImage (X, Y : Word; ScaleX, ScaleY : Real; Var image : Pointer; page : Byte);
Var
  tx, ty : Word;
  FastX, FastY, Fastx2, Fasty2,
  SclX, SclY : Word;
Begin
  If page > pages Then Exit;
  If image = Nil Then Exit;
  If (scalex < 1) And (scaley < 1) Then Begin
    scaledimage (X, Y, scalex, scaley, image, 0);
    Exit;
  End;
  iofs := Ofs (image^) + 6;
  iseg := Seg (image^);
  index := iofs;
  SclX := Trunc (ScaleX * 256);   {To get more speed, scalex, and scaley could be WORDs allready}
  SclY := Trunc (ScaleY * 256);   {But beginners will understand this more easily:}
  For ty := Y To Y + memw [iseg: iofs - 2] Do
    For tx := X To X + memw [iseg: iofs - 4] Do Begin
      Asm          {Multiplies are handled with ASM to get max. speed}
        mov AX, tx  {Ofcourse MY method isn't the best, but it's MY OWN method ;-}
        sub AX, X
        mov BX, SclX
        mul BX
        push AX
        ShR AX, 8
        add AX, X
        mov fastx, AX
        pop AX
        add AX, sclx
        ShR AX, 8
        add AX, X
        mov fastx2, AX
        mov AX, ty
        sub AX, Y
        mov BX, scly
        mul BX
        push AX
        ShR AX, 8
        add AX, Y
        mov fasty, AX
        pop AX
        add AX, scly
        ShR AX, 8
        add AX, Y
        mov fasty2, AX
      End;
      col := mem [iseg: index];
      If PutImgStyle = XORPut Then Begin
        GetPixel (FastX, FastY, page);
        col := mem [iseg: index] XOr col;
      End;
      Inc (index);
      {If you are sure that neither X or Y scaling factor won't get bigger
      than 1 use putpixel instead}
      If (putimgstyle <> backgroundput) Or (col <> bkcolor) Then Bar (FastX, FastY, FastX2, FastY2, col, page);
    End;
End;

Procedure update_mouse;
Var
  D : Word;
Begin
  putimgstyle := NormalPut;
  If (oldmousex <> mousex) Or (oldmousey <> mousey) Then Begin
    PutImage (oldmousex, oldmousey, mouseimg, 0);
    freeimagemem (mouseimg);
    mouseimg := Nil;
    oldmousex := mousex;
    oldmousey := mousey;
    GetImage (oldmousex, oldmousey, oldmousex + 5, oldmousey + 5, mouseimg, 0);
    Bar (oldmousex, oldmousey, oldmousex + 5, oldmousey + 5, 15, 0);
  End;
End;

Function initialize_mouse : Boolean;
Begin
  mouseimg := Nil;
  If initmouse = False Then initialize_mouse := False
  Else initialize_mouse := True;
  setmousex (0, xmax - 5);    {Set mouse movement area on screen}
  setmousey (0, ymax - 6);
End;

{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
Procedure LoadIcon (filename : String; Var icon : Pointer; ino : Integer);
{DUMM! routine, but works...}
Begin
  XmodeErr := 0;
  Assign (Input, filename);
  {$I-}
  Reset (Input);
  {$I+}
  If IOResult <> 0 Then Begin
    XMODEerr := 1;
    Exit;
  End;
  Read (Input, inputdata);
  Close (Input);
  If inputdata. header <> 'ICON94' Then Begin
    XmodeErr := 1;
    Exit;
  End;
  If MaxAvail < 33 * 33 + 6 Then Begin
    XmodeErr := 2;
    Exit;
  End;
  GetMem (icon, 33 * 33 + 6);
  memw [Seg (icon^): Ofs (icon^) ] := 33 * 33;
  memw [Seg (icon^): Ofs (icon^) + 2] := 32;
  memw [Seg (icon^): Ofs (icon^) + 4] := 32;
  For D := 0 To 33 Do
    For cc := 0 To 33 Do
      mem [Seg (icon^): Ofs (icon^) + D * 33 + cc + 6] := inputdata. icondata [ino, D, cc];
End;

{Dumm proc to make look-like-3D icons}
{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
Procedure IconUp (X, Y, X1, Y1 : Integer; page : Byte);
Begin
  If page > pages Then Exit;
  Rectangle (X, Y, X1 - 1, Y + 1, White, page);
  Rectangle (X, Y, X + 1, Y1 - 2, White, page);
  Rectangle (X + 1, Y1 - 1, X1, Y1, DarkGray, page);
  Rectangle (X1 - 1, Y + 1, X1, Y1, DarkGray, page);
  col := DarkGray;
  PutPixel (X, Y1, col, page);
  PutPixel (X1, Y, col, page);
  col := White;
  PutPixel (X1 - 1, Y, col, page);
  PutPixel (X, Y1 - 1, col, page);
End;

{Dumm proc to make look-like-3D icons}
{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
Procedure IconDown (X, Y, X1, Y1 : Integer; page : Byte);
Begin
  If page > pages Then Exit;
  Rectangle (X, Y, X1 - 1, Y + 1, DarkGray, page);
  Rectangle (X, Y, X + 1, Y1 - 2, DarkGray, page);
  Rectangle (X + 1, Y1 - 1, X1, Y1, White, page);
  Rectangle (X1 - 1, Y + 1, X1, Y1, White, page);
  col := White;
  PutPixel (X, Y1, col, page);
  PutPixel (X1, Y, col, page);
  col := DarkGray;
  PutPixel (X1 - 1, Y, col, page);
  PutPixel (X, Y1 - 1, col, page);
End;

{Set new starting offset of visible screen. Provides smooth scrolling
 in XMODE!}
{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
Procedure setoffset (offs : Word);
Begin
  Asm
    cli              {Disable interrupts}
    mov DX, 03dah     {Sync register}
    @Wait1:          {Sync with VRI. Don't have to do this}
    In   AL , DX
    Test AL, 8
    jz  @Wait1
    @Wait2:
    In   AL, DX
    Test AL, 8
    jnz  @Wait2
  End;
  port [$3D4] := $c;  {Set new starting offset of visible screen}
  port [$3D5] := Hi (offs);
  port [$3D4] := $D;
  port [$3D5] := Lo (offs);
  Asm sti End;       {Enable interrupts}
End;

{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
Procedure show_page (page : Byte);
Var
  a : Word;
Begin
  If page > pages Then Exit;
  a := (lastofs + lastofs) * page;
  setoffset (a);
End;

{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
Procedure saveicon (filename : String; Var icon : Pointer; ino : Integer);
Begin
  XmodeErr := 0;
  Assign (Input, filename);
  {$I-}
  Reset (Input);
  {$I+}
  If IOResult <> 0 Then Begin
    XMODEerr := 1;
    Exit;
  End;
  Read (Input, inputdata);
  Close (Input);
  If inputdata. header <> 'ICON94' Then Begin
    XmodeErr := 1;
    Exit;
  End;
  For D := 0 To 33 Do
    For cc := 0 To 33 Do
      inputdata. icondata [ino, D, cc] := mem [Seg (icon^): Ofs (icon^) + D * 33 + cc + 6];
  Assign (Input, filename);
  Reset (Input);
  Write (Input, inputdata);
  Close (Input);
End;

{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
Procedure SetViewPort (X1, Y1, X2, Y2 : Word);
Begin
  vx2 := X2;
  vx1 := X1;
  If X2 < X1 Then Begin
    vx2 := X1;
    vx1 := X2;
  End;
  vy1 := Y1;
  vy2 := Y2;
  If Y2 < Y1 Then Begin
    vy2 := Y1;
    vy1 := Y2;
  End;
End;

{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
Procedure Line (X1, Y1, X2, Y2 : Word; Color, page : Byte); Assembler;
Var
  diagonal_x_increment,
  diagonal_y_increment,
  short_distance,
  straight_x_increment,
  straight_y_increment,
  straight_count,
  diagonal_count: Integer;
  Asm
    XOr BH, BH
    mov BL, page
    cmp BL, pages
    jg  @line_finished
    ShL BX, 1
    mov ES, cs: [Offset segmentt + BX]
    mov CX, 1 {Set initial increments for each pixel position }
    mov DX, 1
    mov DI, Y2 {Calculate Vert. distance }
    sub DI, Y1
    jge @keep_y
    neg DX
    neg DI
    @Keep_Y:
    mov diagonal_y_increment, DX
    mov SI, X2 { Calculate horiz. distance }
    sub SI, X1
    jge @keep_x
    neg CX
    neg SI
    @Keep_X:
    mov diagonal_x_increment, CX
    cmp SI, DI { Figure whether straight segments are horizontal or vertical }
    jge @horz_seg
    mov CX, 0
    xchg SI, DI
    jmp @Save_Values
    @Horz_seg:
    mov DX, 0
    @Save_values:
    mov short_distance, DI
    mov straight_x_increment, CX
    mov straight_y_increment, DX
    mov AX, short_distance { Calculate adjustment factor }
    ShL AX, 1
    mov straight_count, AX
    sub AX, SI
    mov BX, AX
    sub AX, SI
    mov diagonal_count, AX
    mov CX, X1 { prepare to draw the line }
    mov DX, Y1
    Inc SI
    mov AL, Color
    @MainLoop: { Now draw the line }
    Dec SI
    jz  @line_finished
    { Plot Pixel, dx=y coordinate, cx=x coordinate }
    pusha
    mov  DI, DX
    ShL  DI, 1
    mov  DI, cs: [Offset gadr + DI]
    mov  AH, 1
    mov  BX, CX
    And  CL, 3
    ShL  AH, CL
    ShR  BX, 2
    add  DI, BX
    mov  DX, 3c4h
    mov  AL, 02h
    out  DX, AX
    mov  AL, Color
    stosb
    popa
    { End Plot }
    cmp BX, 0
    jge @diagonal_line
    add CX, straight_x_increment { Draw Stright Line Segments }
    add DX, straight_y_increment
    add BX, straight_count
    jmp @MainLoop
    @Diagonal_line: { Draw Diagonal Line Segments }
    add CX, diagonal_x_increment
    add DX, diagonal_y_increment
    add BX, diagonal_count
    jmp @MainLoop
    @Line_Finished:
  End;      {line}
  
  {!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
  Procedure FillPoly (Size: Integer; 
Var Polygon; C, Pa: Byte);
Type
  Vektor = Record
             X, Y, XMax, DX, DY, DZ, Z, Spalte: Integer;
           End;
  VekPoly = Array [1..poly_complex, 1..2, 1..2] Of Integer;
Var
  P: Array [1..poly_complex, 1..2] Of Integer Absolute Polygon;
  Sp: VekPoly;
  NF: Boolean;
  V: Array [1..poly_complex] Of Vektor;
  S: Array [1..2 * poly_complex] Of Integer;
  I, J, K, N, SX, YRMin, YRMax, YR, XMin, YMin, YMax, I2: Integer;
Begin
  If pa > pages Then Exit;
  If Size > poly_complex Then
    Exit;
  K := 1;
  For I := 1 To Size Do
  Begin
    Sp [K, 1, 1] := P [I, 1];
    Sp [K, 1, 2] := P [I, 2];
    If I = Size Then
    Begin
      Sp [K, 2, 1] := P [1, 1];
      Sp [K, 2, 2] := P [1, 2];
    End
    Else
    Begin
      Sp [K, 2, 1] := P [I + 1, 1];
      Sp [K, 2, 2] := P [I + 1, 2];
    End;
    If Sp [K, 2, 2] - Sp [K, 1, 2] < 0 Then
    Begin
      J := Sp [K, 2, 1];
      Sp [K, 2, 1] := Sp [K, 1, 1];
      Sp [K, 1, 1] := J;
      J := Sp [K, 2, 2];
      Sp [K, 2, 2] := Sp [K, 1, 2];
      Sp [K, 1, 2] := J;
    End;
    Inc (K);
  End;
  YRMin := ymax;
  YRMax := 0;
  For K := 1 To Size Do
    For I := 1 To 2 Do
    Begin
      If Sp [K, I, 2] > YRMax Then
        YRMax := Sp [K, I, 2];
      If Sp [K, I, 2] < YRMin Then
        YRMin := Sp [K, I, 2];
    End;
  If YRMin < 0 Then
    YRMin := 0;
  If YRMax > ymax Then
    YRMax := ymax;
  For K := 1 To Size Do
    With V [K] Do
    Begin
      XMin := Sp [K, 1, 1];
      YMin := Sp [K, 1, 2];
      XMax := Sp [K, 2, 1];
      YMax := Sp [K, 2, 2];
      DX := Abs (XMin - XMax);
      DY := Abs (YMin - YMax);
      X := XMin;
      Y := YMin;
      If XMin < XMax Then
        Z := 1
      Else Z := - 1;
      If DX > DY Then
        I2 := DX
      Else I2 := DY;
      DZ := I2 Div 2;
      Spalte := XMin;
    End;
  For YR := YRMin To YRMax Do
  Begin
    N := 0;
    For K := 1 To Size Do
      If ( (Sp [K, 1, 2] <= YR) And (YR < SP [K, 2, 2] ) ) Or ( (YR = YRMax) And (YRMax = Sp [K, 2, 2] ) And
         (YRMax <> Sp [K, 1, 2] ) ) 
      Then
      Begin
        With V [K] Do
        Begin
          Inc (N);
          S [N] := X;
          SX := X;
          Repeat
            If DZ < DX Then
            Begin
              DZ := DZ + DY;
              X := X + Z;
            End;
            If DZ >= DX Then
            Begin
              DZ := DZ - DX;
              Inc (Y);
            End;
            If Y = YR Then
              SX := X;
            Inc (Spalte, Z);
          Until (Y > YR) Or (Spalte = XMax);
          Inc (N);
          S [N] := SX;
        End;
      End;
    For I := 2 To N Do
      For K := N Downto I Do
        If S [K - 1] > S [K] Then
        Begin
          J := S [K - 1];
          S [K - 1] := S [K];
          S [K] := J;
        End;
    K := 1;
    While K <= N Do
    Begin
      If S [K] < 0 Then
        S [K] := 0;
      If S [K + 3] > xmax Then
        S [K + 3] := xmax;
      Hline (S [K], S [K + 3], YR, Pa, C);
      K := K + 4;
    End;
  End;
End; {fillpoly}

{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
Procedure Ellipse (MX, MY, A, B: Word; C, P: Byte);
Var
  X, Y, X2, J: Integer;
  tmp, tmp2, tmp3, tmp4 : Word;
Begin
  If p > pages Then Exit;
  If (a < 2) Or (b < 2) Then Exit;
  Dec (B);
  X2 := A;
  For Y := 0 To B Do
  Begin
    X := Trunc (A / B * Sqrt (Sqr (B) - Sqr (Y - 0.5) ) );
    For J := X To X2 Do
    Begin
      If (mx - j) < 0 Then tmp := xmax + 1
      Else tmp := mx - j;
      If (my - Y) < 0 Then tmp2 := ymax + 1
      Else tmp2 := my - Y;
      If (mx + j) > xmax Then tmp3 := xmax + 1
      Else tmp3 := mx + j;
      If (my + Y) > ymax Then tmp4 := ymax + 1
      Else tmp4 := my + Y;
      PutPixel (tmp, tmp4, c, p);
      PutPixel (tmp, tmp2, c, p);
      PutPixel (tmp3, tmp4, C, P);
      PutPixel (tmp3, tmp2, C, P);
    End;
    X2 := X;
  End;
  Inc (B);
  For J := 0 To X Do
  Begin
    If (mx - j) < 0 Then tmp := xmax + 1
    Else tmp := mx - j;
    If (my - b) < 0 Then tmp2 := ymax + 1
    Else tmp2 := my - b;
    If (mx + j) > xmax Then tmp3 := xmax
    Else tmp3 := mx + j;
    If (my + b) > ymax Then tmp4 := ymax
    Else tmp4 := my + b;
    PutPixel (tmp3, tmp4, C, P);
    PutPixel (tmp, tmp4, C, P);
    PutPixel (tmp3, tmp2, C, P);
    PutPixel (tmp, tmp2, C, P);
  End;
End;

{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
Procedure Circle (X, Y, rad : Word; Color, page : Byte);
Begin
  If xmax < ymax Then Ellipse (X, Y, Trunc (rad * xy_ratio), rad, Color, page)
  Else Ellipse (X, Y, rad, Trunc (rad * xy_ratio), Color, page);
End;


{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
Procedure FillEllipse (MX, MY, A, B: Word; C, P: Byte);
Var
  X, Y, X2, J: Integer;
  tmp, tmp2, tmp3, tmp4: Word;
Begin
  If p > pages Then Exit;
  If (a < 2) Or (b < 2) Then Exit;
  Dec (B);
  X2 := A;
  If (mx - X2) < 0 Then tmp := 0 Else tmp := mx - a;
  If (mx + a) > xmax Then tmp2 := xmax
  Else tmp2  := mx + a;
  hLine (tmp, tmp2, my, p, C);
  For Y := 1 To B Do
  Begin
    X := Trunc (A / B * Sqrt ( (Sqr (LongInt (B) ) ) - Sqr (Y - 0.5) ) );
    If (mx - X) < 0 Then tmp := 0
    Else tmp := mx - X;
    If (my - Y) < 0 Then tmp2 := 0
    Else tmp2 := my - Y;
    If (mx + X) > xmax Then tmp3 := xmax
    Else tmp3 := mx + X;
    If (my + Y) > ymax Then tmp4 := ymax
    Else tmp4 := my + Y;
    hLine (tmp, tmp3, tmp4, P, C);
    hLine (tmp, tmp3, tmp2, P, C);
    X2 := X;
  End;
End;

{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
Procedure filledcircle (X, Y, rad : Word; Color, page : Byte);
Begin
  If xmax < ymax Then FillEllipse (X, Y, Trunc (rad * xy_ratio), rad, Color, page)
  Else FillEllipse (X, Y, rad, Trunc (rad * xy_ratio), Color, page);
End;

{Works on txt mode. Combined with timer this makes fun!}
{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
Procedure setborder (Color : Byte);
Begin
  Asm  {We need to reset the flip-flop first}
    cli
    mov DX, $3da
    In  AL, DX
  End;
  port [$3c0] := $31; {Surprise! Not index 11h, but if this doesn't work try with $11}
  port [$3c0] := Color;
  Asm sti End; {Enable interrupts}
End;

{This procedure provides split screen facilities in TXT modes, and graph
 modes. Lower split is allways in the beginning of vid mem. Use
 setoffset, and you have two unique parts on screen}
{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
Procedure setlinecomp (newcomp : Word);
Begin
  Asm
    cli
    mov DX, $3D4
    mov AX, newcomp
    mov BH, AH
    mov BL, AH
    And BX, 201h
    mov CL, 4
    ShL BX, CL
    mov AH, AL
    mov AL, 18h
    out DX, AX
    mov AL, 7
    out DX, AL
    Inc DX
    In AL, DX
    Dec DX
    mov AH, AL
    And AH, 0efh
    Or AH, BL
    mov AL, 7
    out DX, AX
    mov AL, 9
    out DX, AL
    Inc DX
    In AL, DX
    Dec DX
    mov AH, AL
    And AH, 0bfh
    ShL BH, 2
    Or AH, BH
    mov AL, 9
    out DX, AX
    sti
  End;
End;

{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
Procedure syncretrace; Assembler;
Asm
  cli
  mov DX, 03dah
  @Wait1:
  In   AL , DX
  Test AL, 8
  jnz  @Wait1
  @Wait2:
  In   AL, DX
  Test AL, 8
  jz  @Wait2
  sti
End;

{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
Procedure hide_cursor; Assembler;
Asm
  mov DX, 3D4h
  mov AL, 0eh   {Cursor location}
  out DX, AL
  Inc DX
  mov AL, 80h   {Outside the screen}
  out DX, AL
End;

Begin
End.
