.286                          ;Don't we have a 286 (386/486)?

;-.-----------------------------------------------.-
;-.- NAPALM SOFT's TWEAKED MODE ASM LIBRARY v1.0 -.-
;-.- """"""""""""""""""""""""""""""""""""""""""" -.-
;-.- 100% Written by Antti Virtanen              -.-
;-.- Distibuted as freeware, part of napalm soft.-.-
;-.- xmode library (Pascal product).             -.-
;-.- Read distribution rules from xmode.txt.     -.-
;-.- Using in demos, etc. is legal, but          -.-
;-.- remember to tell whose routines you use!    -.-
;-.-                                             -.-
;-.-----------------------------------------------.-

;-*----------------------------------------------*-
;-*- ROUTINES IN THIS ASM SOURCE:               -*-
;-*- """"""""""""""""""""""""""""               -*-
;-*- Init_Tweaked, doesn't need explanations?   -*-
;-*- Putpixel, neither this one                 -*-
;-*- Getpixel, or this                          -*-
;-*- Bar, draws a rectangular bar               -*-
;-*- SetRGB, Sets an individual VGA color       -*-
;-*- GetRGB, Gets an individual VGA color       -*-
;-*- Outtext, Outputs a string with ROM 8x8 font-*-
;-*- ShowPage, Sets new page within range 0-3   -*-
;-*- CopyPage, Copies a display page            -*-
;-*- PaletteCycle, Cycles vga palette           -*-
;-*-                                            -*-
;-*- See the calling/return values from the     -*-
;-*- start of each procedure                    -*-
;-*-                                            -*-
;-*- Line drawing is not included, sorry.       -*-
;-*- I'm working on it!                         -*-
;-*-                                            -*-
;-*- This source is only a little demonstration -*-
;-*- of tweaked mode. Several routines are left -*-
;-*- away, because we would like YOU to do them.-*-
;-*----------------------------------------------*-

;-------------------------------------------
;--  Init 320x200x256x4 VGA tweaked mode  --
;-------------------------------------------
init_tweaked proc near
  pusha
  mov ax,13h                  ;Standard (BIOS) 320x200 256 color mode
  int 10h
  cli                         ;Disable interrupts
  mov dx,03c4h
  mov al,4
  out dx,al
  inc dx
  in  al,dx
  and al,0f7h
  or  al,04
  out dx,al
  dec dx
  mov ax,0f02h
  out dx,ax
  sti
  mov di,0
  mov ax,0a000h
  mov es,ax
  xor ax,ax
  mov cx,32000
  cld
  rep stosw                       ;Clear video memory
  mov dx,03d4h
  mov al,014h
  out dx,al
  inc dx
  in  al,dx
  and al,0bfh
  out dx,al
  dec dx
  mov al,017h
  out dx,al
  inc dx
  in  al,dx
  or  al,040h
  out dx,al
  popa                            ;Pop general registers
  ret
init_tweaked endp

;--------------------------------
;--  Palette Cycle             --
;--  Call registers:           --
;--    CL, Cycle start         --
;--    CH, Cycle end           --
;--------------------------------
palettecycle    proc    near
  push          ax
  push          bx
  push          cx
  push          dx

  mov           dx,3c7h
  mov           al,cl
  out           dx,al

  mov           dx,3c9h
  in            al,dx
  mov           cs:[offset sr],al
  in            al,dx
  mov           cs:[offset sg],al
  in            al,dx
  mov           cs:[offset sb],al
  @cycle:
  mov           dx,3c7h
  mov           al,cl
  inc           al
  out           dx,al
  mov           dx,3c9h
  in            al,dx
  mov           bl,al
  in            al,dx
  mov           bh,al
  in            al,dx
  mov           ah,al
  mov           dx,3c8h
  mov           al,cl
  out           dx,al
  inc           dx
  mov           al,bl
  out           dx,al
  mov           al,bh
  out           dx,al
  mov           al,ah
  out           dx,al
  inc           cl
  cmp           cl,ch
  jne           @cycle
  mov           dx,3c8h
  mov           al,ch
  out           dx,al
  inc           dx
  mov           al,cs:[offset sr]
  out           dx,al
  mov           al,cs:[offset sg]
  out           dx,al
  mov           al,cs:[offset sb]
  out           dx,al
  pop           dx
  pop           cx
  pop           bx
  pop           ax
  ret
palettecycle    endp

;--------------------------------
;--  Tweaked mode putpixel     --
;--  Call registers :          --
;--   AX, y coordinate         --
;--   BX, x coordinate         --
;--   CH, color                --
;--   CL, page                 --
;--                            --
;--------------------------------
putpixel proc near
 cmp bx,319
 jg p_exit
 cmp ax,199
 jg p_exit
 pusha
 push es                                    ;PUSHA Doesn't save segment registers
 mov  di,ax
 shl  di,1
 mov  di,cs:[di+offset gadr]                ;DI contains row offset of pixel
 push bx
 mov  bx,cx
 xor  bh,bh
 mov  ax,cs:[bx+offset segment_adr]
 pop  bx
 mov  es,ax                                ;ES contains segment address of displ page
 mov  cl,bl
 and  cl,3
 mov  ah,1
 shl  ah,cl                      ;AH=Bit plane
 mov  al,2                       ;Map mask register
 mov  bp,bx
 shr  bp,2
 add  di,bp                      ;DI=Pixel offset
 mov  dx,03c4h                   ;CRTC I/O address
 out  dx,ax                      ;Plane should be now set properly
 mov  [es:di],ch                 ;Plot the pixel
 sti                             ;Enable interrupts
 pop es
 popa
p_exit:
 ret
putpixel endp

;--------------------------------------------
;-- Tweaked mode getpixel                  --
;-- Call registers:                        --
;--   DI, y coordinate                     --
;--   BX, x coordinate                     --
;-- Return registers:                      --
;--   AL, pixel color                      --
;--------------------------------------------
getpixel proc near
  push di
  push bx
  push dx
  push es
  push 0a000h
  pop  es
  push ax
  shl  di,1
  mov  di,cs:[offset gadr+di]
  mov  ah,bl
  and  ah,3
  mov  al,4
  mov  dx,3ceh
  out  dx,ax
  shr  bx,2
  add  di,bx
  lodsb
  pop  ax
  pop  es
  pop  dx
  pop  bx
  pop  di
  ret
getpixel endp

;-----------------------------------------
;-- SetRGB, set an individual VGA color --
;-- Call registers:                     --
;--   AL, color to set                  --
;--   CL, Red value (0-63)              --
;--   CH, Blue value (0-63)             --
;--   BL, Green value (0-63)            --
;-----------------------------------------
SetRGB proc near
  push ax
  push dx
  mov  dx,3c8h
  out  dx,al
  inc  dx
  mov  al,cl
  out  dx,al
  mov  al,bl
  out  dx,al
  mov  al,ch
  out  dx,al
  pop  dx
  pop  ax
  ret
SetRGB endp

;-----------------------------------------
;-- GetRGB, get an individual VGA color --
;-- Call registers:                     --
;--   AL, color to get                  --
;-- Return registers:                   --
;--   CL, Red value (0-63)              --
;--   CH, Blue value (0-63)             --
;--   BL, Green value (0-63)            --
;-----------------------------------------
GetRGB proc near
  push ax
  push dx
  mov  dx,3c7h
  out  dx,al
  mov  dx,3c9h
  in   al,dx
  mov  cl,al
  in   al,dx
  mov  Bl,al
  in   al,dx
  pop  dx
  mov  ch,al
  pop  ax
  ret
GetRGB endp

;--------------------------------------------
;-- Tweaked mode bar routine               --
;--  -Draws a rectangular bar              --
;-- Call registers:                        --
;--   AX, upper y coordinate               --
;--   BX, upper x coordinate               --
;--   DI, lower y coordinate               --
;--   DX, lower x coordinate               --
;--   CH, color                            --
;--   CL, display page                     --
;--------------------------------------------
do_bar proc near
  pusha
  push es

  cmp  bx,dx
  jle  @No_SwapX
  xchg dx,bx
  @No_SwapX:
  mov  cs:[offset x1],bx
  mov  cs:[offset x2],dx
  cmp  ax,di
  jle  @No_SwapY
  xchg ax,di
  @No_SwapY:
  mov  cs:[offset y1],ax
  mov  cs:[offset y2],di

  cmp  cs:[offset y1],ymax
  jle  @Not_BiggerY1
  mov  cs:[offset y1],ymax
  @Not_BiggerY1:
  cmp  cs:[offset y2],ymax
  jle  @Not_BiggerY2
  mov  cs:[offset y2],ymax
  @Not_BiggerY2:
  cmp  cs:[offset x1],xmax
  jle  @Not_BiggerX1
  mov  cs:[offset x1],xmax
  @Not_BiggerX1:
  cmp  cs:[offset x2],xmax
  jle  @Not_BiggerX2
  mov  cs:[offset x2],xmax
  @Not_BiggerX2:

  xor  ah,ah
  mov  al,cl
  mov  di,ax
  shl  di,1
  mov  es,cs:[di+offset segment_adr]
  mov  bx,cs:[offset x1]
  dec  bx
  mov  di,cs:[offset y1]
  shl  di,1
  mov  di,cs:[offset gadr+di]
  mov  cs:[offset temp],di
  cld
  @do_single_line:
  inc  bx
  @start:
  mov  di,cs:[offset temp]
  push cx
  mov  cl,bl
  and  cl,3
  mov  ah,1
  shl  ah,cl
  mov  al,2
  mov  dx,03c4h
  out  dx,ax
  mov  cx,bx
  shr  cx,2
  add  di,cx
  pop  cx
  mov  al,ch
  mov  si,cs:[offset y1]
  dec  si
  @plot_pixel:
  inc  si
  stosb
  add  di,79
  cmp  si,cs:[offset y2]
  jne  @plot_pixel
  cmp  bx,cs:[offset x2]
  jne  @do_single_line
  pop  es
  popa
  ret
do_bar endp

;--------------------------------------------
;--  Tweaked mode out character routine    --
;--  -Used by outtext proc                 --
;--  Call registers:                       --
;--    AX, y coordinate                    --
;--    BX, x coordinate                    --
;--    CH, color                           --
;--    CL, page                            --
;--    DH, character to display            --
;--------------------------------------------
outchar proc near
  pusha

  xor  dl,dl
  xchg dl,dh
  mov  di,dx
  xchg dh,dl
  shl  di,3
  add  di,offset romfont
  dec  di
  mov  word ptr cs:[offset temp],0      ;Clear temp variable
  @loop_a:
    inc  di
    inc  word ptr cs:[offset temp]
    xor  bp,bp
    @loop_b:
      mov  dl,cs:[di]
      and  dl,cs:[offset font_mask+bp]
      cmp  dl,0
      jne  @tee_pixeli
      @takas:
      inc  bp
      cmp  bp,8
      jne  @loop_b
    cmp  word ptr cs:[offset temp],8
    jne  @loop_a
  popa
  ret
  @tee_pixeli:
    push ax
    push bx
    add  bx,bp
    add  ax,cs:[offset temp]
    call putpixel
    pop  bx
    pop  ax
    jmp  @takas
outchar endp

;-------------------------------------------------
;--  Tweaked mode outtext                       --
;--  Call registers :                           --
;--   AX, y coordinate                          --
;--   BX, x coordinate                          --
;--   CH, color                                 --
;--   CL, page                                  --
;--   ES:BP, 0 terminated string, max lng 254   --
;--                                             --
;-------------------------------------------------

outtext proc near
  cmp  ax,199                        ;Y out of screen
  jg   o_exit
  pusha
next_char:
  cmp  bx,319                        ;X out of screen
  jg   string_ready
  cmp  byte ptr [es:bp],0
  je   string_ready                   ;Is char 0 -> Is the string complete
  mov  dh,[es:bp]
  call outchar
  inc  bp
  add  bx,8
  jmp  next_char
  string_ready:
  popa
  o_exit:
  ret
outtext endp

;--------------------------------
;-- ShowPage                   --
;-- Call registers:            --
;--   BX, page (0-3)           --
;--------------------------------
ShowPage proc near
  push cx
  push ax
  push dx
  push bx
  mov  cx,bx
  @addition:
  add  bx,16000
  loop @addition
  sub  bx,16000
  mov  dx,03d4h
  mov  al,0ch
  mov  ah,bh
  out  dx,ax
  mov  al,0dh
  mov  ah,bl
  out  dx,ax
  pop  bx
  pop  dx
  pop  ax
  pop  cx
  ret
ShowPage endp

;----------------------------------
;-- CopyPage                     --
;-- Call registers:              --
;--   BX, inpage                 --
;--   DI, outpage                --
;----------------------------------
CopyPage proc near
  PUSHA
  PUSH ES
  PUSH DS
  shl  bx,1
  mov  ds,cs:[offset segment_adr+bx]
  shl  di,1
  mov  es,cs:[offset segment_adr+di]
  mov  ax,0f02h         ;All planes
  mov  dx,3c4h
  out  dx,ax
  mov  dx,3ceh
  mov  ax,4105h         ;Write mode 1
  out  dx,ax
  xor  di,di
  xor  si,si
  cld
  mov  cx,16000

  rep  movsb

  POP  DS
  POP  ES
  POPA
  RET
CopyPage endp

;Here ends the code, and it's time for variables and constants (EQU)
ymax           equ 199
xmax           equ 319

font_mask      db  128,64,32,16,8,4,2,1

segment_adr    dw  0a000h,0a3e8h,0a7d0h,0abb8h

x1             dw  0
x2             dw  0
y1             dw  0
y2             dw  0
                    
sr              db 0
sg              db 0
sb              db 0


temp           dw  0,0

gadr           label word
   DW 0000h,00500,00A0h,000F0h,00140h,00190h,001E0h,00230h
   DW 0280h,02D0h,00320h,00370h,003C0h,00410h,00460h,004B0h
   DW 0500h,0550h,005A0h,005F0h,00640h,00690h,006E0h,00730h
   DW 0780h,07D0h,00820h,00870h,008C0h,00910h,00960h,009B0h
   DW 0A00h,0A50h,00AA0h,00AF0h,00B40h,00B90h,00BE0h,00C30h
   DW 0C80h,0CD0h,00D20h,00D70h,00DC0h,00E10h,00E60h,00EB0h
   DW 0F00h,0F50h,00FA0h,00FF0h,01040h,01090h,010E0h,01130h
   DW 01180h,011D0h,01220h,01270h,012C0h,01310h,01360h,013B0h
   DW 01400h,01450h,014A0h,014F0h,01540h,01590h,015E0h,01630h
   DW 01680h,016D0h,01720h,01770h,017C0h,01810h,01860h,018B0h
   DW 01900h,01950h,019A0h,019F0h,01A40h,01A90h,01AE0h,01B30h
   DW 01B80h,01BD0h,01C20h,01C70h,01CC0h,01D10h,01D60h,01DB0h
   DW 01E00h,01E50h,01EA0h,01EF0h,01F40h,01F90h,01FE0h,02030h
   DW 02080h,020D0h,02120h,02170h,021C0h,02210h,02260h,022B0h
   DW 02300h,02350h,023A0h,023F0h,02440h,02490h,024E0h,02530h
   DW 02580h,025D0h,02620h,02670h,026C0h,02710h,02760h,027B0h
   DW 02800h,02850h,028A0h,028F0h,02940h,02990h,029E0h,02A30h
   DW 02A80h,02AD0h,02B20h,02B70h,02BC0h,02C10h,02C60h,02CB0h
   DW 02D00h,02D50h,02DA0h,02DF0h,02E40h,02E90h,02EE0h,02F30h
   DW 02F80h,02FD0h,03020h,03070h,030C0h,03110h,03160h,031B0h
   DW 03200h,03250h,032A0h,032F0h,03340h,03390h,033E0h,03430h
   DW 03480h,034D0h,03520h,03570h,035C0h,03610h,03660h,036B0h
   DW 03700h,03750h,037A0h,037F0h,03840h,03890h,038E0h,03930h
   DW 03980h,039D0h,03A20h,03A70h,03AC0h,03B10h,03B60h,03BB0h
   DW 03C00h,03C50h,03CA0h,03CF0h,03D40h,03D90h,03DE0h,03E30h

include  8x8font.inc