{$X+}
PROGRAM curve;

	{ Draw a Bezier curve }

USES
	VGraph, Crt;

CONST
	lastPoint = 6;     						{ highest subscript used }

VAR
	pt          	: Array[0..LastPoint] of PointType;
	errorCode, n 	: INTEGER;

PROCEDURE initPoints;
BEGIN
	pt [0].x := 160;   pt [0].y := 110;
	pt [1].x := 160;   pt [1].y := 160;
	pt [2].x :=  55;   pt [2].y := 160;
	pt [3].x :=  55;   pt [3].y :=  20;
	pt [4].x := 205;   pt [4].y :=  40;
	pt [5].x := 190;   pt [5].y := 110;
	pt [6].x := 280;   pt [6].y := 110;
END;

BEGIN
	InitVesa(V640x480x256);

	{ Check to make sure it happened }
	ErrorCode := graphResult;
	IF errorCode <> grOK THEN BEGIN
		WRITELN ('Graphics error ', errorCode);
		WRITELN ('Program cannot run');
		HALT (1);
	END;

	{ Draw the hull outline }
	InitPoints;      							{ First initialize control points }
	SetLineStyle (dottedLn, 0, normWidth);
	SetColor (1);
	MoveTo (pt [0].x, pt [0].y);
	FOR n := 1 TO lastPoint DO
		LineTo (pt [n].x, pt [n].y);

	{ Now draw the curve itself }
	SetLineStyle (solidLn, 0, normWidth);
	SetColor (2);
	DrawBezier(lastPoint,pt[1]);

	{ Clean up after a keypress }
	ReadKey;
	CloseVesa;
END.


