{ ͻ
   Programmer Tony Papadimitriou                             
   Program    ZapDir                                         
   Uses       Dos, TPUtils, TPRecDir                         
   Includes   Nothing                                        
   Links      Nothing                                        
   Created    Sunday, December 19, 1993  2:08 am             
   Updated    Saturday, December 25, 1993  3:50 pm           
   Language   (MSDOS) Turbo Pascal 6.0                       
   Purpose    Show off TPRecDir unit.  Use with CAUTION.     
   Version History Ķ
   1.00       Original                                       
  ͼ }
uses
  Dos,
  TPUtils,
  TPRecDir;

const
  progName = 'ZAPDIR';
  version  = '1.00';

procedure Copyright;
begin
  Writeln(stderr);
  Writeln(stderr,progName+' ver. ' + version + '  Copyright (c) 1993-94 by Tony G. Papadimitriou *FREEWARE*');
  Writeln(stderr);
end; { Copyright }

var
  dirs,
  files: Longint;

{ --- this is the user routine whose address you must supply to ForEachFileIn }
{ --- it must be True on success }
function List(rec: SearchRec): Boolean; far;
var
  f     : file;
  code  : Word;
  errors: Boolean;
begin
  if AttributeMatches(rec.attr,Directory) then
  begin
    {$I-} RmDir(rec.name); {$I+}
    code   := IOResult;
    errors := code <> 0;
    if not errors then
    begin
      Writeln('Removed dir ',FExpand(rec.name));
      Inc(dirs);
    end
    else
      Writeln('Could not remove directory ',FExpand(rec.name),' due to error code ',code);
  end
  else
  begin
    Assign(f,rec.name);
    SetFAttr(f,Archive);
    {$I-} Erase(f); {$I+}
    code   := IOResult;
    errors := code <> 0;
    if not errors then
    begin
      Writeln('Erased file ',FExpand(rec.name));
      Inc(files);
    end
    else
      Writeln('Could not erase file ',FExpand(rec.name),' due to error code ',code);
  end;
  List := not errors;
end; { List }

var
  counter: Longint;
  path   : String;
  mask   : String;
begin
  Copyright;
  if ParamCount = 0 then
  begin
    Writeln(stderr,'Usage: ZapDir [<path>\]<mask>[;<mask>]');
    Writeln(stderr);
    Writeln(stderr,'       Press ESC during search to interrupt prematurely.');
    Halt;
  end; { if }
  dirs  := 0;
  files := 0;
  path := ParamStr(1);
  mask := GetMask(path);
  path := GetPath(path);
  counter := ForEachFileIn(path,mask,AnyFile,True,True,@List);
  if errorsFound then Writeln(stderr,'Errors during processing!');
  Writeln(stderr,'Deleted ',dirs,' dir'+OneManyStr(dirs,'','s')+
                 ' and ',files,' file'+OneManyStr(files,'','s')+
                 ' for a total of ',counter,
                 ' match'+OneManyStr(counter,'','es'));
end.
