{ ͻ
   Programmer Tony Papadimitriou                             
   Program    EXTS                                           
   Uses       Dos, TPUtils, TPRecDir                         
   Includes   Nothing                                        
   Links      Nothing                                        
   Created    Sunday, December 19, 1993  2:08 am             
   Updated    Saturday, December 25, 1993 11:29 pm           
   Language   (MSDOS) Turbo Pascal 6.0                       
   Purpose    Show off TPRecDir unit                         
   Version History Ķ
   1.00       Original                                       
  ͼ }
uses
  Dos,
  TPUtils,
  TPRecDir;

const
  progName = 'EXTS';
  version  = '1.00';

procedure Copyright;
begin
  Writeln(stderr);
  Writeln(stderr,progName+' ver. ' + version + '  Copyright (c) 1993-94 by Tony G. Papadimitriou *FREEWARE*');
  Writeln(stderr);
end; { Copyright }

type
  String3 = String[ 3 ]; { used for storing extensions }

  PLinkedList = ^TLinkedList;
  TLinkedList = record
    data: String3;       { extension }
    size: Word;          { counter for occurrences of data }
    next: PLinkedList;   { pointer to next node }
  end; { TLinkedList }

var
  totalMatches : Longint;
  head         : PLinkedList;

procedure AddNode(data: String3); { add in alphabetical order }
var
  searchPos,
  previous,
  current: PLinkedList;
begin
  data := UpWord(data);
  New(current);
  current^.data := data;
  current^.size := 1;
  current^.next := NIL;
  if head = NIL then
    head := current
  else
  begin
    searchPos := head;
    previous := head;
    while (searchPos <> NIL) and (data > searchPos^.data) do
    begin
      previous := searchPos;
      searchPos := searchPos^.next;
    end; { while }
    if head = searchPos then
    begin
      current^.next := head;
      head := current;
    end
    else
    begin
      current^.next := previous^.next;
      previous^.next := current;
    end; { else }
  end; { else }
end; { AddNode }

procedure AddUniqueNode(data: String3); { add a node that does not exist in list }
var
  p: PLinkedList;
begin
  data := UpWord(data);
  p := head;
  while (p <> NIL) and (data <> p^.data) do
    p := p^.next;
  if p = NIL then
    AddNode(data)
  else
    Inc(p^.size);
end; { AddUniqueNode }

procedure ShowNodes;
var
  p,
  kill: PLinkedList;
  count: Word;
begin
  count := 0;
  Writeln('ͻ');
  Writeln(' Ext  Num  Ext  Num  Ext  Num  Ext  Num  Ext  Num  Ext  Num ');
  Writeln('͹');
  p := head;
  while p <> NIL do
  begin
    Write(' ',Left(p^.data,3,' '),' ',p^.size:5);
    kill := p;
    p := p^.next;
    Dispose(kill);
    Inc(count);
    if (count mod 6) = 0 then Writeln('');
  end; { while }
  while (count mod 6) <> 0 do
  begin
    Write('          ');
    Inc(count);
    if (count mod 6) = 0 then Writeln('');
  end; { while }
  Writeln('ͼ');
end; { ShowNodes }

{ --- this is the user routine whose address you must supply to ForEachFileIn }
function List(rec: SearchRec): Boolean; far;
var
  dir: DirStr;
  nam: NameStr;
  ext: ExtStr;
begin
  List := True;
  ShowProgressHere;
  if not AttributeMatches(rec.attr,Directory) then
  begin
    Inc(totalMatches);
    FSplit(rec.name,dir,nam,ext);
    AddUniqueNode(Copy(ext,2,Length(ext)));
  end;
end; { List }

var
  path : PathStr;
  mask : String;
begin
  Copyright;
  if ParamCount = 0 then
  begin
    Writeln(stderr,'Usage: EXTS [<path>\]<mask>[;<mask>]');
    Writeln(stderr);
    Writeln(stderr,'       Press ESC during search to interrupt prematurely.');
    Halt;
  end; { if }
  head := NIL;
  totalMatches := 0;
  path := ParamStr(1);
  mask := GetMask(path);
  path := GetPath(path);
  Write(stderr,'Working  ');
  ForEachFileIn(path,mask,AnyFile,True,True,@List);
  BlankLine;
  if errorsFound then Writeln(stderr,'Errors during processing!');
  ShowNodes;
  Writeln(stderr,totalMatches,' match'+OneManyStr(totalMatches,'','es')+' found!');
end.
