Orpheus

Native VCL user interface components for Delphi professionals
-------------------------------------------------------------
Orpheus is a collection of native VCL (Visual Component Library)
components that extend the user interface design capabilities of
Borland Delphi. Don't hassle with using and distributing VBX or DLL
based controls when you can have optimized VCL components that are
fully integrated with Delphi, compile directly into your EXE files,
and include complete source code. You get:

  o full validation of string, numeric, and date/time data fields
  o protected, hidden, required, and calculated fields in forms
  o a list box with virtually unlimited capacity
  o array editors for all fundamental data types
  o notebook component with multi-row side and top tabs
  o viewer for text or binary files of any size
  o multi-line text editor with real-time word wrap and 16 MB
    capacity
  o 2D table control that holds editable fields, check boxes, combo
    boxes, and more
  o calendar component with extensive library of date and time
    manipulation routines
  o two-way and four-way spin components
  o meter components for use in installation and monitoring programs,
    and more

Professional Validated Data Entry
---------------------------------
  The entry field components in Orpheus let you perform true
field-by-field validation of user input in Delphi forms. Orpheus
fields have built-in support for all Pascal data types, including
strings, integer types, floating point types, and even date, time,
and currency. The field editors accept easy-to-use picture masks that
provide automatic international support for date, time, and currency.
You can even create user-defined picture mask characters for special
needs. Numeric fields can be edited in decimal, scientific, hex, or
binary formats. Orpheus provides a choice of three field editors,
including a calculator-style editor for right-to-left numeric input.

  Validated forms in Orpheus provide even more flexibility at runtime.
Fields can be calculated, protected, hidden, or required. Event
handlers can be installed to gain control before or after each field
is edited. Field definitions -- data type, length, picture mask,
options -- can be changed on the fly.  Validation can be "hard",
requiring each field to be absolutely correct before the focus leaves
it, or "soft", highlighting invalid fields but not enforcing
correctness until the form is accepted.

Limitless Lists
---------------
  Although list boxes are used frequently in Windows apps, the
internal Windows control is quite limited -- only 8 thousand items
with 32K of text unless you are willing to do a lot of work yourself.
And the Delphi list box is just a wrapper around the Windows control.
Orpheus provides a list box that removes the limits. You can have up
to 2 billion items with single or multiple selection, each item in any
color, protected items, and more. You write an event handler that
provides each item string on demand, so the items don't need to be
stored in any particular data structure. You can load them from an
array, from a lookup tree, or even from disk.

  Orpheus also provides array editors. These look like list boxes but
allow in-place editing of any fundamental Pascal data type.

Notebook Tabs the Way You Want Them
-----------------------------------
  The tabbed multi-page form is the hottest new user interface
scheme -- the latest Microsoft apps use it and Windows95 uses it,
among others. Although Delphi provides tab controls, the Orpheus
components out-tab them by far in flexibility and features. Orpheus
tabs can look just like the multi-row tabs seen in Word for Windows
and Windows95. When you change the font size, number of tabs, or form
width at design time, the Orpheus tabs automatically adjust
themselves. Or you can put tabs along the right side of a form, just
like a spiral notebook.

Edit and View Files of Any Size
-------------------------------
  The built-in Windows edit control is limited in much the same way as
the list box, to only 32K of text. The Orpheus text editor supports up
to 16 MB of text on the Windows global heap and provides real time
word wrap, multi-step undo/redo, bookmarks, search/replace, and more.

  Orpheus also includes a file viewer component that browses text or
binary files of any size by using a page buffering scheme.

The Most Flexible Tables
------------------------
  Imagine a table that contains any mixture of editable string and
numeric data fields, labels, combo boxes, and check boxes. Continue
this dream table with a capacity of 16K columns and 16K row formats
for up to 2 billion rows, handled by a sparse array manager that
minimizes your use of system memory. Combine this with easy Delphi
design and a range of user-installable event hooks and you have the
Orpheus table control.

Dozens of Delectable Doodads
----------------------------
  Orpheus contains too many useful components to describe in detail
here. Some of them might cost you $69 each as VBX controls without
source code! You get two-way and four-way spin components that allow
users to increment fields with the mouse or keyboard. You get a timer
cache, for managing as many timer events as you need based on a single
Windows timer resource. You get meter components for monitoring
progress of long processes. You get a command installation tool for
associating keystrokes with commands in other components such as the
text editor. You get a font selection component for picking any
Windows font, including rotated fonts. You get a calendar component
for selecting dates between the years 1600 and 3999. And more!

32 Bit Support When You Need It
-------------------------------
  Borland has promised to release a 32 bit version of Delphi shortly
after the shipment of Windows95. They've designed VCL so that it will
port with little or no effort from 16 bit Windows to 32 bit. As a
result, your investment in native VCL components such as Orpheus will
pay off with a quick and easy port to 32 bit Windows.

Order Information
-----------------
  Orpheus costs $199 and includes a 60 day money back guarantee. It
will be available for shipment soon after Borland ships Delphi.
Upgrades will be available to owners of TurboPower's Data Entry
Workshop.

  For more information, or to order, call 1-800-333-4160 from 9 a.m.
to 5 p.m. Mountain time, or write to TurboPower Software, P.O. Box
49009, Colorado Springs, CO 80949. International customers call
719-260-9136.  Send faxes to 719-260-7151. Send electronic mail to
CompuServe 76004,2611. Visit our CompuServe area in PCVENB section 6.
We accept MasterCard, Visa, American Express, Discover, a check in
U.S. funds drawn on a U.S. bank, or COD (within U.S. only).

Information in this preliminary data sheet is subject to change.
