{

                                                      ͻ
                                                         PTUI Windows   
                                                           Include      
                                                          Rev. 1.00     
                                                      ͼ

}

Procedure TextWindow.SaveBackground;
Begin
  Size:=TextImageSize(X1,Y1,X2+2,Y2+1);       {Save the backgound text, shadow}
  If Size>MaxAvail Then Error(1);
  GetMem(Save,Size);
  Mouse.Hide;
  GetTextImage(X1,Y1,X2+ShadowXSize,Y2+ShadowYSize,Save);
  Mouse.Show;
End;

Procedure TextWindow.DrawWindow;
Begin
  VideoColor(BoxFrg,BoxBck);         {Redraw the window outline and interior}
  Mouse.Hide;
  DrawShadowWindow(X1,Y1,X2,Y2,ShdFrg,ShdBck,LineStyle,ShadowStyle);
  Mouse.Show;
End;

Procedure TextWindow.Open(NX1,NY1,NX2,NY2:Word;
                          Forg,Back,ShadForg,ShadBack:Byte;
                          LStyle:LineStyles;SStyle:ShadowStyles);
Begin
  Buttons.Init;
  FillChar(VSlide,SizeOf(VSlide),0);
  FillChar(HSlide,SizeOf(HSlide),0);
  HdrButtonNum  :=0;
  Header        :='';
  Card          :=PTUIVCRT.Card;
  Status        :=Visible;

  Case SStyle Of
    NoShade   : Begin
                  ShadowXSize:=0;
                  ShadowYSize:=0;
                End;
    Solid     : Begin
                  ShadowXSize:=1;
                  ShadowYSize:=1;
                End;
    LightHash,
    MediumHash,
    DarkHash  : Begin
                  ShadowXSize:=2;
                  ShadowYSize:=1;
                End;
  End;

  LineStyle  :=LStyle;
  ShadowStyle:=SStyle;
  BoxFrg     :=Forg;
  BoxBck     :=Back;
  ShdFrg     :=ShadForg;
  ShdBck     :=ShadBack;
  X1         :=NX1;
  Y1         :=NY1;
  X2         :=NX2;
  Y2         :=NY2;

  SaveBackground;
  DrawWindow;
End;

Procedure TextWindow.DisplayHeading;
Begin
  Mouse.Hide;
  If Header='' Then
  Begin
    VideoColor(BoxFrg,BoxBck);      {Blank the heading area}
    GotoXY(X1+1,Y1+1);
    Pad(X2-X1-1,#32);
  End
  Else
  Begin
    VideoColor(HdrFrg,HdrBck);
    GotoXY(X1+1,Y1+1);
    WriteStr(Header);
  End;
  Mouse.Show;
End;

Procedure TextWindow.NewHeading(NewHead:String;NewMode:TextFormats;
                                Forg,Back:Byte);
Begin
  HdrFrg:=Forg;
  HdrBck:=Back;              {Setup the new heading line}
  HdrFmt:=NewMode;
  If NewHead='' Then
    Header:=''
  Else
    FormatVar(NewHead,Header,X2-X1-1,NewMode);
  DisplayHeading;
End;

Procedure TextWindow.Hide;

Var
  NewSave :Pointer;

Begin
  Status:=Hidden;
  If Size>MaxAvail Then Error(1);
  GetMem(NewSave,Size);
  Mouse.Hide;
  GetTextImage(X1,Y1,X2,Y2,NewSave);   {Save the window}
  PutTextImage(X1,Y1,Save);            {Put old text back}
  Mouse.Show;
  FreeMem(Save,Size);
  Save:=NewSave;
End;

Procedure TextWindow.Show;

Var
  NewSave :Pointer;

Begin
  Status:=Visible;
  If Size>MaxAvail Then Error(1);
  GetMem(NewSave,Size);             {Save the text}
  Mouse.Hide;
  GetTextImage(X1,Y1,X2+ShadowXSize,Y2+ShadowYSize,NewSave);
  PutTextImage(X1,Y1,Save);       {Display the window}
  FreeMem(Save,Size);
  TextBackground(BoxBck);
  VideoColor(ShdFrg,ShdBck);            {Background Colours may have changed}
  DrawShadow(X1,Y1,X2,Y2,ShadowStyle);  {Redraw the new shadow}
  Mouse.Show;
  Save:=NewSave;
End;

Procedure TextWindow.NewPosition(NewX,NewY:Word);

Var
  OldX,
  OldY  :Word;

Begin
  OldX:=X1;
  OldY:=Y1;

  Hide;                    {Hide the window}
  X2:=NewX+(X2-X1);
  Y2:=NewY+(Y2-Y1);        {Change the position}
  X1:=NewX;
  Y1:=NewY;
  Show;                    {Redisplay the same window}

  Buttons.MoveAll(Integer(X1)-Integer(OldX),Integer(Y1)-Integer(OldY));
  If HSlide.MaxPos>0 Then
  Begin
    HSlide.X1:=HSlide.X1 + Integer(X1) - Integer(OldX);
    HSlide.Y1:=HSlide.Y1 + Integer(Y1) - Integer(OldY);
    HSlide.X2:=HSlide.X2 + Integer(X1) - Integer(OldX);
    HSlide.Y2:=HSlide.Y2 + Integer(Y1) - Integer(OldY);
  End;
  If VSlide.MaxPos>0 Then
  Begin
    VSlide.X1:=VSlide.X1 + Integer(X1) - Integer(OldX);
    VSlide.Y1:=VSlide.Y1 + Integer(Y1) - Integer(OldY);
    VSlide.X2:=VSlide.X2 + Integer(X1) - Integer(OldX);
    VSlide.Y2:=VSlide.Y2 + Integer(Y1) - Integer(OldY);
  End;
End;

Procedure TextWindow.Drag;

Var
  MouseL,
  MouseR,
  MouseM,
  MouseMoved,
  MouseRelease :Boolean;
  OldMouseX,
  OldMouseY,
  MouseX,
  MouseY,
  MouseStartX,
  MouseStartY,
  MouseDistX,
  MouseDistY,
  OldX,
  OldY         :Word;
  C            :Char;
  OldBut       :Pointer;

Begin
  OldBut:=Buttons.Buttons;
  If Mouse.Active Then
  Begin
    C:=#1;
    OldMouseX:=65535;
    OldMouseY:=65535;
    MouseStartX:=X1-1;
    MouseStartY:=Y1-1;
    Mouse.SetXY(MouseStartX * MouseGranularity,MouseStartY * MouseGranularity);
  End;
  MouseRelease:=False;
  OldX:=X1;
  OldY:=Y1;
  Repeat
    Repeat
      MouseMoved:=False;
      KeyBuffer(Clear);
      If Mouse.Active Then
      Begin
        Mouse.GetStatus(MouseX,MouseY,MouseL,MouseR,MouseM);
        MouseX:=(MouseX Div MouseGranularity) + 1;
        MouseY:=(MouseY Div MouseGranularity) + 1;
        If (MouseX<>OldMouseX) Or (MouseY<>OldMouseY) Then MouseMoved:=True;
        If (Not MouseL) And (Not MouseR) Then MouseRelease:=True;
      End;
    Until KeyPressed Or ((MouseMoved Or MouseRelease) And Mouse.Active);
    If MouseMoved Then
    Begin
      If (MouseX+(X2-X1)>VideoCard[Card].XSize-2) Then
        OldMouseX:=VideoCard[Card].XSize-2-(X2-X1)
      Else
        OldMouseX:=MouseX;
      If (MouseY+(Y2-Y1)>VideoCard[Card].YSize-1) Then
        OldMouseY:=VideoCard[Card].YSize-1-(Y2-Y1)
      Else
        OldMouseY:=MouseY;
      If (OldMouseX<>X1) Or (OldMouseY<>Y1) Then
        NewPosition(OldMouseX,OldMouseY);
    End
    Else
    Begin
      If KeyPressed Then C:=ReadKey;
      If C=#0 Then
      Begin
        C:=ReadKey;
        Case C Of
          'K':If X1>4                       Then NewPosition(X1-4,Y1);
          'M':If X2<VideoCard[Card].XSize-6 Then NewPosition(X1+4,Y1);
          'H':If Y1>4                       Then NewPosition(X1,Y1-4);
          'P':If Y2<VideoCard[Card].YSize-5 Then NewPosition(X1,Y1+4);
        End;
      End
      Else
        Case C Of
          '4':If X1>1                       Then NewPosition(X1-1,Y1);
          '6':If X2<VideoCard[Card].XSize-2 Then NewPosition(X1+1,Y1);
          '8':If Y1>1                       Then NewPosition(X1,Y1-1);
          '2':If Y2<VideoCard[Card].YSize-1 Then NewPosition(X1,Y1+1);
        End;
    End;
  Until (C in [#27,#13]) Or (MouseRelease And Mouse.Active);
  If (C=#27) Then
    NewPosition(OldX,OldY);
  Buttons.Buttons:=OldBut;
End;

Procedure TextWindow.DragVertSlideButton;

Var
  Dummy,
  SlideBarX1,
  SlideBarY1,
  SlideBarX2,
  SlideBarY2,
  OldMouseY,
  MouseX,
  MouseY       :Word;
  MouseL,
  MouseR,
  MouseM,
  MouseMoved,
  MouseRelease :Boolean;
  OldSlideBarMx:LongInt;
  C            :Char;
  NewSlide     :SlideBarInfo;

Begin
  OldSlideBarMx:=VSlide.MaxPos;
  C:=#1;
  MouseRelease:=False;
  VertSlideButtonPos(MouseX,MouseY,Dummy,Dummy);
  MouseY:=65535;
  Repeat
    MouseMoved:=False;
    OldMouseY:=MouseY;
    KeyBuffer(Clear);
    Repeat
      If Mouse.Active Then
      Begin
        Mouse.GetStatus(MouseX,MouseY,MouseL,MouseR,MouseM);
        MouseY:=(MouseY Div MouseGranularity) + 1;
        If (MouseY<>OldMouseY) Then MouseMoved:=True;
        If (Not MouseL) And (Not MouseR) Then MouseRelease:=True;
      End;
    Until KeyPressed Or MouseMoved Or MouseRelease;

    VertSlideBarPos(SlideBarX1,SlideBarY1,SlideBarX2,SlideBarY2);
    If KeyPressed Then
    Begin
      C:=ReadKey;
      If C=#0 Then
      Begin
        C:=ReadKey;
        Case C Of
          'H':If MouseY>SlideBarY1   Then Dec(MouseY,1);
          'I':If MouseY>SlideBarY1+9 Then Dec(MouseY,10);
          'P':If MouseY<SlideBarY2   Then Inc(MouseY,1);
          'Q':If MouseY<SlideBarY2-9 Then Inc(MouseY,10);
        End;
      End;
    End
    Else
    Begin
      If (MouseY>SlideBarY2) Then MouseY:=SlideBarY2;
      If (MouseY<SlideBarY1) Then MouseY:=SlideBarY1;
    End;

    NewSlide:=VSlide;
    NewSlide.CurPos:=MouseY-SlideBarY1;
    NewSlide.MaxPos:=SlideBarY2-SlideBarY1;
    VertSlideBar(NewSlide);

  Until (C in [#13,#27]) Or MouseRelease;

  VSlide.MaxPos:=OldSlideBarMx;
  VSlide.CurPos:=AdjustMeter(0,SlideBarY2-SlideBarY1,MouseY-SlideBarY1,
                             0,VSlide.MaxPos);
End;

Procedure TextWindow.DragHorzSlideButton;

Var
  Dummy,
  SlideBarX1,
  SlideBarY1,
  SlideBarX2,
  SlideBarY2,
  OldMouseX,
  MouseX,
  MouseY       :Word;
  MouseL,
  MouseR,
  MouseM,
  MouseMoved,
  MouseRelease :Boolean;
  OldSlideBarMx:LongInt;
  C            :Char;
  NewSlide     :SlideBarInfo;

Begin
  OldSlideBarMx:=HSlide.MaxPos;
  C:=#1;
  MouseRelease:=False;
  HorzSlideButtonPos(MouseX,MouseY,Dummy,Dummy);
  MouseX:=65535;
  Repeat
    MouseMoved:=False;
    OldMouseX:=MouseX;
    KeyBuffer(Clear);
    Repeat
      If Mouse.Active Then
      Begin
        Mouse.GetStatus(MouseX,MouseY,MouseL,MouseR,MouseM);
        MouseX:=(MouseX Div MouseGranularity) + 1;
        If (MouseX<>OldMouseX) Then MouseMoved:=True;
        If (Not MouseL) And (Not MouseR) Then MouseRelease:=True;
      End;
    Until KeyPressed Or MouseMoved Or MouseRelease;

    HorzSlideBarPos(SlideBarX1,SlideBarY1,SlideBarX2,SlideBarY2);
    If KeyPressed Then
    Begin
      C:=ReadKey;
      If C=#0 Then
      Begin
        C:=ReadKey;
        Case C Of
          'K':If MouseX>SlideBarX1   Then Dec(MouseX,1);
          'I':If MouseX>SlideBarX1+9 Then Dec(MouseX,10);
          'M':If MouseX<SlideBarX2   Then Inc(MouseX,1);
          'Q':If MouseX<SlideBarX2-9 Then Inc(MouseX,10);
        End;
      End;
    End
    Else
    Begin
      If (MouseX>SlideBarX2) Then MouseX:=SlideBarX2;
      If (MouseX<SlideBarX1) Then MouseX:=SlideBarX1;
    End;

    NewSlide:=HSlide;
    NewSlide.CurPos:=MouseX-SlideBarX1;
    NewSlide.MaxPos:=SlideBarX2-SlideBarX1;
    HorzSlideBar(NewSlide);
  Until (C in [#13,#27]) Or MouseRelease;

  HSlide.MaxPos:=OldSlideBarMx;
  HSlide.CurPos:=AdjustMeter(0,SlideBarX2-SlideBarX1,MouseX-SlideBarX1,
                             0,HSlide.MaxPos);
End;

Procedure TextWindow.NewSize(NX1,NY1,NX2,NY2:Word);

Var
  NewHead:String;

Begin
  UnPadVar(Header,NewHead);   {Save the heading}
  Close;
  Open(NX1,NY1,NX2,NY2,BoxFrg,BoxBck,ShdFrg,ShdBck,LineStyle,ShadowStyle);
  If NewHead<>'' Then         {ReOpen the window}
  Begin
    FormatVar(NewHead,Header,X2-X1-1,HdrFmt);
    DisplayHeading;
  End;
End;

Procedure TextWindow.NewStyle(Forg,Back,ShadForg,ShadBack:Byte;
                              LStyle:LineStyles;SStyle:ShadowStyles);

Var
  NewHead:String;

Begin
  NewHead:=Header;
  Close;                         {ReOpen the window with new info}
  Open(X1,Y1,X2,Y2,Forg,Back,ShadForg,ShadBack,LStyle,SStyle);
  Header:=NewHead;
  DisplayHeading;
End;

Procedure TextWindow.HeadingIcon(Active:Boolean);

Var
  HeadingX1,
  HeadingY1,
  HeadingX2,
  HeadingY2:Word;

Begin
  HeadingPos(HeadingX1,HeadingY1,HeadingX2,HeadingY2);
  If Active Then
  Begin
    If HdrButtonNum=0 Then
    Begin
      Buttons.Add(HeadingX1, HeadingY1, HeadingX2, HeadingY2,
                  SpecialCode(Key_Ctrl, Key_F5), KeyCode(Key_Ctrl, Key_F5));
      HdrButtonNum:=Buttons.Number;
    End;
  End
  Else
  Begin
    Buttons.GotoNumber(HdrButtonNum);
    Buttons.KillOne;
    HdrButtonNum:=0;
  End;
End;

Procedure TextWindow.VertSlideIcon(Active:Boolean);

Var
  SlideButtonX1,
  SlideButtonY1,
  SlideButtonX2,
  SlideButtonY2,

  SlideButtonUpX1,
  SlideButtonUpY1,
  SlideButtonUpX2,
  SlideButtonUpY2,

  SlideButtonDownX1,
  SlideButtonDownY1,
  SlideButtonDownX2,
  SlideButtonDownY2,

  SlideBarX1,
  SlideBarY1,
  SlideBarX2,
  SlideBarY2    :Word;

Begin
  VertSlideBarPos(SlideBarX1,SlideBarY1,SlideBarX2,SlideBarY2);
  VertSlideButtonPos(SlideButtonX1,SlideButtonY1,SlideButtonX2,SlideButtonY2);
  VertSlideButtonUpPos(SlideButtonUpX1,SlideButtonUpY1,SlideButtonUpX2,SlideButtonUpY2);
  VertSlideButtonDownPos(SlideButtonDownX1,SlideButtonDownY1,SlideButtonDownX2,SlideButtonDownY2);

  If Active And (VSlide.MaxPos>0) Then
  Begin
    If VSlide.ButtonNum=0 Then
    Begin
      Buttons.Add(SlideButtonX1, SlideButtonY1, SlideButtonX2,
                  SlideButtonY2,
                  SpecialCode(Mouse_Only, Mouse_SlideButtonVert), KeyCode(Mouse_Only, Mouse_SlideButtonVert));
      VSlide.ButtonNum:=Buttons.Number;
    End;
    If VSlide.BarButtonNum=0 Then
    Begin
      Buttons.Add(SlideBarX1, SlideBarY1, SlideBarX2,
                  SlideBarY2,
                  SpecialCode(Mouse_Only, Mouse_SlideBarVert), KeyCode(Mouse_Only, Mouse_SlideBarVert));
      VSlide.BarButtonNum:=Buttons.Number;
    End;
    If VSlide.ButtonLeftUpNum=0 Then
    Begin
      Buttons.Add(SlideButtonUpX1, SlideButtonUpY1, SlideButtonUpX2,
                  SlideButtonUpY2,
                  SpecialCode(Key_None, Key_Up), KeyCode(Key_None, Key_Up));
      VSlide.ButtonLeftUpNum:=Buttons.Number;
    End;
    If VSlide.ButtonRightDownNum=0 Then
    Begin
      Buttons.Add(SlideButtonDownX1, SlideButtonDownY1, SlideButtonDownX2,
                  SlideButtonDownY2,
                  SpecialCode(Key_None, Key_Down), KeyCode(Key_None, Key_Down));
      VSlide.ButtonRightDownNum:=Buttons.Number;
    End;
  End
  Else
  Begin
    Buttons.GotoNumber(VSlide.BarButtonNum);
    Buttons.KillOne;
    VSlide.BarButtonNum:=0;
    Buttons.GotoNumber(VSlide.ButtonNum);
    Buttons.KillOne;
    VSlide.ButtonNum:=0;
    Buttons.GotoNumber(VSlide.ButtonRightDownNum);
    Buttons.KillOne;
    VSlide.ButtonRightDownNum:=0;
    Buttons.GotoNumber(VSlide.ButtonLeftUpNum);
    Buttons.KillOne;
    VSlide.ButtonLeftUpNum:=0;
  End;
End;

Procedure TextWindow.HorzSlideIcon(Active:Boolean);

Var
  SlideButtonX1,
  SlideButtonY1,
  SlideButtonX2,
  SlideButtonY2,

  SlideButtonUpX1,
  SlideButtonUpY1,
  SlideButtonUpX2,
  SlideButtonUpY2,

  SlideButtonDownX1,
  SlideButtonDownY1,
  SlideButtonDownX2,
  SlideButtonDownY2,

  SlideBarX1,
  SlideBarY1,
  SlideBarX2,
  SlideBarY2    :Word;

Begin
  HorzSlideBarPos(SlideBarX1,SlideBarY1,SlideBarX2,SlideBarY2);
  HorzSlideButtonPos(SlideButtonX1,SlideButtonY1,SlideButtonX2,SlideButtonY2);
  HorzSlideButtonLeftPos(SlideButtonUpX1,SlideButtonUpY1,SlideButtonUpX2,SlideButtonUpY2);
  HorzSlideButtonRightPos(SlideButtonDownX1,SlideButtonDownY1,SlideButtonDownX2,SlideButtonDownY2);

  If Active And (HSlide.MaxPos>0) Then
  Begin
    If HSlide.ButtonNum=0 Then
    Begin
      Buttons.Add(SlideButtonX1, SlideButtonY1, SlideButtonX2,
                  SlideButtonY2,
                  SpecialCode(Mouse_Only, Mouse_SlideButtonHorz), KeyCode(Mouse_Only, Mouse_SlideButtonHorz));
      HSlide.ButtonNum:=Buttons.Number;
    End;
    If HSlide.BarButtonNum=0 Then
    Begin
      Buttons.Add(SlideBarX1, SlideBarY1, SlideBarX2,
                  SlideBarY2,
                  SpecialCode(Mouse_Only, Mouse_SlideBarHorz), KeyCode(Mouse_Only, Mouse_SlideBarHorz));
      HSlide.BarButtonNum:=Buttons.Number;
    End;
    If HSlide.ButtonLeftUpNum=0 Then
    Begin
      Buttons.Add(SlideButtonUpX1, SlideButtonUpY1, SlideButtonUpX2,
                  SlideButtonUpY2,
                  SpecialCode(Key_None, Key_Left), KeyCode(Key_None, Key_Left));
      HSlide.ButtonLeftUpNum:=Buttons.Number;
    End;
    If HSlide.ButtonRightDownNum=0 Then
    Begin
      Buttons.Add(SlideButtonDownX1, SlideButtonDownY1, SlideButtonDownX2,
                  SlideButtonDownY2,
                  SpecialCode(Key_None, Key_Right), KeyCode(Key_None, Key_Right));
      HSlide.ButtonRightDownNum:=Buttons.Number;
    End;
  End
  Else
  Begin
    Buttons.GotoNumber(HSlide.BarButtonNum);
    Buttons.KillOne;
    HSlide.BarButtonNum:=0;
    Buttons.GotoNumber(HSlide.ButtonNum);
    Buttons.KillOne;
    HSlide.ButtonNum:=0;
    Buttons.GotoNumber(HSlide.ButtonRightDownNum);
    Buttons.KillOne;
    HSlide.ButtonRightDownNum:=0;
    Buttons.GotoNumber(HSlide.ButtonLeftUpNum);
    Buttons.KillOne;
    HSlide.ButtonLeftUpNum:=0;
  End;
End;

Procedure TextWindow.DrawVertSlideBar;
Begin
  If VSlide.MaxPos=0 Then Exit;
  VSlide.ButtonScreenPos:=AdjustMeter(0,VSlide.MaxPos,VSlide.CurPos,VSlide.Y1+1,VSlide.Y2-1);
  Mouse.Hide;
  VideoColor(VSlide.Forg,VSlide.Back);
  FillBlock(VSlide.X1,VSlide.Y1+1,VSlide.X2,VSlide.Y2-1,VSlide.MainChar);
  GotoXY(VSlide.X1,VSlide.ButtonScreenPos);
  WriteChr(VSlide.ButtonChar);
  GotoXY(VSlide.X1,VSlide.Y1);
  WriteChr(VSlide.UpLeftChar);
  GotoXY(VSlide.X1,VSlide.Y2);
  WriteChr(VSlide.DownRightChar);
  Mouse.Show;
End;

Procedure TextWindow.VertSlideBar(Details:SlideBarInfo);

Var
  Dummy,
  NewX,
  NewY,
  OldX,
  OldY    :Word;

Begin
  VertSlideButtonPos(OldX,OldY,Dummy,Dummy);

  VSlide.X1                :=Details.X1;
  VSlide.Y1                :=Details.Y1;
  VSlide.X2                :=Details.X2;
  VSlide.Y2                :=Details.Y2;
  VSlide.Forg              :=Details.Forg;
  VSlide.Back              :=Details.Back;
  VSlide.MainChar          :=Details.MainChar;
  VSlide.ButtonChar        :=Details.ButtonChar;
  VSlide.UpLeftChar        :=Details.UpLeftChar;
  VSlide.DownRightChar     :=Details.DownRightChar;
  VSlide.CurPos            :=Details.CurPos;
  VSlide.MaxPos            :=Details.MaxPos;

  DrawVertSlideBar;
  If VSlide.ButtonNum>0 Then
  Begin
    VertSlideButtonPos(NewX,NewY,Dummy,Dummy);
    Buttons.Move(Integer(NewX)-OldX,Integer(NewY)-OldY,VSlide.ButtonNum);
  End;
End;

Procedure TextWindow.UpdateVertSlideBar(CurPos:LongInt);

Var
  Dummy,
  NewX,
  NewY,
  OldX,
  OldY    :Word;

Begin
  VertSlideButtonPos(OldX,OldY,Dummy,Dummy);
  VSlide.CurPos:=CurPos;
  DrawVertSlideBar;
  If VSlide.ButtonNum>0 Then
  Begin
    VertSlideButtonPos(NewX,NewY,Dummy,Dummy);
    Buttons.Move(Integer(NewX)-OldX,Integer(NewY)-OldY,VSlide.ButtonNum);
  End;
End;

Procedure TextWindow.DrawHorzSlideBar;
Begin
  If HSlide.MaxPos=0 Then Exit;
  HSlide.ButtonScreenPos:=AdjustMeter(0,HSlide.MaxPos,HSlide.CurPos,HSlide.X1+1,HSlide.X2-1);
  Mouse.Hide;
  VideoColor(HSlide.Forg,HSlide.Back);
  FillBlock(HSlide.X1+1,HSlide.Y1,HSlide.X2-1,HSlide.Y2,HSlide.MainChar);
  GotoXY(HSlide.ButtonScreenPos,HSlide.Y1);
  WriteChr(HSlide.ButtonChar);  {Still do Arrows, Use nnnnSlideBarPos}
  GotoXY(HSlide.X1,HSlide.Y1);
  WriteChr(HSlide.UpLeftChar);
  GotoXY(HSlide.X2,HSlide.Y2);
  WriteChr(HSlide.DownRightChar);
  Mouse.Show;
End;

Procedure TextWindow.HorzSlideBar(Details:SlideBarInfo);

Var
  Dummy,
  NewX,
  NewY,
  OldX,
  OldY    :Word;

Begin
  HorzSlideButtonPos(OldX,OldY,Dummy,Dummy);

  HSlide.X1                :=Details.X1;
  HSlide.Y1                :=Details.Y1;
  HSlide.X2                :=Details.X2;
  HSlide.Y2                :=Details.Y2;
  HSlide.Forg              :=Details.Forg;
  HSlide.Back              :=Details.Back;
  HSlide.MainChar          :=Details.MainChar;
  HSlide.ButtonChar        :=Details.ButtonChar;
  HSlide.UpLeftChar        :=Details.UpLeftChar;
  HSlide.DownRightChar     :=Details.DownRightChar;
  HSlide.CurPos            :=Details.CurPos;
  HSlide.MaxPos            :=Details.MaxPos;

  DrawHorzSlideBar;
  If HSlide.ButtonNum>0 Then
  Begin
    HorzSlideButtonPos(NewX,NewY,Dummy,Dummy);
    Buttons.Move(Integer(NewX)-OldX,Integer(NewY)-OldY,HSlide.ButtonNum);
  End;
End;

Procedure TextWindow.UpdateHorzSlideBar(CurPos:LongInt);

Var
  Dummy,
  NewX,
  NewY,
  OldX,
  OldY    :Word;

Begin
  HorzSlideButtonPos(OldX,OldY,Dummy,Dummy);
  HSlide.CurPos:=CurPos;
  DrawHorzSlideBar;
  If HSlide.ButtonNum>0 Then
  Begin
    HorzSlideButtonPos(NewX,NewY,Dummy,Dummy);
    Buttons.Move(Integer(NewX)-OldX,Integer(NewY)-OldY,HSlide.ButtonNum);
  End;
End;

Procedure TextWindow.HeadingPos(Var BX1,BY1,BX2,BY2:Word);
Begin
  BX1:=X1+1;
  BY1:=Y1+1;
  BX2:=X2-1;
  BY2:=Y1+1;
End;

Procedure TextWindow.VertSlideBarPos(Var BX1,BY1,BX2,BY2:Word);
Begin
  BX1:=VSlide.X1;
  BY1:=VSlide.Y1+1;
  BX2:=VSlide.X2;
  BY2:=VSlide.Y2-1;
End;

Procedure TextWindow.VertSlideButtonPos(Var BX1,BY1,BX2,BY2:Word);
Begin
  BX1:=VSlide.X1;
  BY1:=VSlide.ButtonScreenPos;
  BX2:=VSlide.X2;
  BY2:=BY1;
End;

Procedure TextWindow.VertSlideButtonUpPos(Var BX1,BY1,BX2,BY2:Word);
Begin
  BX1:=VSlide.X1;
  BY1:=VSlide.Y1;
  BX2:=BX1;
  BY2:=BY1;
End;

Procedure TextWindow.VertSlideButtonDownPos(Var BX1,BY1,BX2,BY2:Word);
Begin
  BX1:=VSlide.X1;
  BY1:=VSlide.Y2;
  BX2:=BX1;
  BY2:=BY1;
End;

Procedure TextWindow.HorzSlideBarPos(Var BX1,BY1,BX2,BY2:Word);
Begin
  BX1:=HSlide.X1 + 1;
  BY1:=HSlide.Y1;
  BX2:=HSlide.X2 - 1;
  BY2:=HSlide.Y2;
End;

Procedure TextWindow.HorzSlideButtonPos(Var BX1,BY1,BX2,BY2:Word);
Begin
  BX1:=HSlide.ButtonScreenPos;
  BY1:=HSlide.Y1;
  BX2:=BX1;
  BY2:=HSlide.Y2;
End;

Procedure TextWindow.HorzSlideButtonLeftPos(Var BX1,BY1,BX2,BY2:Word);
Begin
  BX1:=HSlide.X1;
  BY1:=HSlide.Y1;
  BX2:=BX1;
  BY2:=BY1;
End;

Procedure TextWindow.HorzSlideButtonRightPos(Var BX1,BY1,BX2,BY2:Word);
Begin
  BX1:=HSlide.X2;
  BY1:=HSlide.Y2;
  BX2:=BX1;
  BY2:=BY1;
End;

Procedure TextWindow.Lock;
Begin
  Window(X1,Y1,X2,Y2);   {Confine screen output to this window}
End;

Procedure TextWindow.UnLock;
Begin
  Window(1,1,VideoCard[Card].XSize,VideoCard[Card].YSize);     {User can write anywhere on screen}
End;

Procedure TextWindow.Close;
Begin
  Mouse.Hide;
  PutTextImage(X1,Y1,Save);    {Restore the screen as it was}
  Mouse.Show;
  FreeMem(Save,Size);
End;

{ Copyright 1993, Michael Gallias }
