{$M 4000,0,0}	(*  This keeps the compiler from allocating heap memory!! *)
{$A+,G+}		(*  286 instructions, and word alignment.. *)
program GusTest ;
uses dos,crt, GP15, memalloc ;
var modfilename,
	sndfilename : string ;
	sndpointer	: pointer ;
	sndhandle	: word ;
	sndsize		: word ;
	nexttime	: longint ;

procedure loadsample ;
var f : file ;
	l : longint ;
 begin
	sndsize := 0 ;
	assign(f, sndfilename) ;
	reset(f,1) ;
	l := filesize(f) ;
	if (l > 65000) then l := 65000 ; (* Sorry, my GP15 routines (and DOS)   *)
									 (* can't handle more than 65k samples. *)
	if (malloc(sndpointer, l) = 0) then begin
		sndsize := l ;
		blockread(f, sndpointer^, l) ;
	end ;
	close(f) ;
 end ;

begin
	writeln('This is a test.') ;
	writeln('To run this you need to know these things:') ;
	writeln('   1. The path to a .MOD file you would like played (module).') ;
	writeln('   2. The path to an 8 bit .SND file you would like played.') ;
	writeln('And.. if your GUS isn''t using the default base address (220h)') ;
	writeln('you should make sure your ULTRASND environment variable is') ;
	writeln('set up properly.  Also make sure you have enuff GUS DRAM for') ;
	writeln('both the .SND file and the module''s samples AT ONCE.') ;
	writeln ;
	writeln('Press ENTER if everything is ok, anything else to try again later.') ;
	if (readkey <> #13) then halt(0) ;
	writeln('OK!  Here we go..') ;
	writeln('Give me the path to a .MOD file (f.ex. "c:\misc\modules\trance.mod")') ;
	write('-> ') ;
	readln(modfilename) ;
	writeln('Give me the path to a .SND file (f.ex. "c:\ultrasnd\intro.snd")') ;
	write('-> ') ;
	readln(sndfilename) ;
	writeln('Ok, now this program SHOULD play back the .MOD file, and also') ;
	writeln('the .SND file, once every 2 seconds (after showing off a little).') ;
	GP_ResetGUS ;

	loadsample ;
	if (sndsize > 0) then
		sndhandle := GP_ProtSampAdd
						(sndpointer^, sndsize, 63, 0,sndsize, false) ;
					(* data, size, volume, repeat begin, repeat end, signed? *)
	dalloc(sndpointer) ;
	(* Free the memory!  GUS DRAM is a wonderful thing.. *)

	Writeln('A 3 voice, looping .SND playback test.. press any key to stop.') ;
	GP.Vars^[NextVoice] := 10 ;
	(* Force the following playback to use voices 10, 11 and 12 *)
    GP_ProtSampPlay(sndhandle, 11025, GP_FarLeft, GP_VocLoopOn) ;
					(* handle, frequency, balance, loopmode *)
	delay(500) ;
    GP_ProtSampPlay(sndhandle, 22050, GP_Middle, GP_VocLoopOn) ;
	delay(500) ;
    GP_ProtSampPlay(sndhandle, 44100, GP_FarRight, GP_VocLoopOn) ;

	if readkey = #0 then if readkey = #0 then ;

	GP_StopVoice(10) ;
	GP_StopVoice(11) ;
	GP_StopVoice(12) ;  (* Kill the output *)

	writeln ;
	Writeln('That was fun!  Now lets do some module stuff..') ;

	GP_LoadModule(modfilename) ;
	GP_StartPlaying ;

	delay(500) ;
	writeln('Volume goes down..') ;
    GP_SlideModVolTo(GP_MinVolume) ;
	delay(1000) ;
	writeln('Volume goes up..') ;
    GP_SlideModVolTo(GP_MaxVolume) ;

	writeln ;
	writeln('Now, lets get some status reports, and play with our .SND') ;
	writeln('file again.  And lets turn down the volume.') ;
	writeln ;
	delay(1000) ;

    GP_SlideModVolTo(GP_MidVolume div 2) ;      (* 1/4 volume = 16 *)
	delay(1000) ;

	nexttime := 0 ;
	repeat
		if (GP.Timer^ > nexttime) then begin
            GP_ProtSampPlay(sndhandle, 11025, GP_Middle, GP_VocNoFlags) ;
			nexttime := GP.Timer^+2000 ;
		end ;
		gotoxy(1,WhereY) ;
		write('Position: ',	GP.Vars^[PlayingPattern]:3,
						'/',GP.Vars^[PatternRow]:2,'  ') ;
		write('Timer: ',GP.Timer^:8) ;
		write('  Next .SND voice: ', GP.Vars^[NextVoice]:2) ;
	until keypressed ;

	if readkey = #0 then if readkey = #0 then ;

	writeln ;
	writeln ;
    writeln('Thats it!  Now go read the dox (if you haven''t already).') ;

	GP_KillModule ;
	GP_ResetGUS ;
end.
