UNIT Sequence;
  {Life and death and sequencing routines for Fumiko}


INTERFACE


  USES
    Dos, CRT, GloblCTV, Arcana, Butler;


  FUNCTION Alive (var group: group_type; var board: board_type; depth: byte): boolean;
    {Returns true if the group in question is unconditionally alive}


  FUNCTION Life (group: group_type; first_player: color_type; var board: board_type;
                  depth: byte; var crucial_move: location_type): byte;
    {The big one, folks!  Reads out sequences to see if the group in question}
    {can live.}


  PROCEDURE Update_Aliveness (var group: group_type; var board: board_type; var depth: byte);
    {Rates the group's life from 1 (hosed) to 7 (2 eyes)}


  FUNCTION Critical_Points_For (var group: group_type; var board: board_type): location_list;
    {Generates a list of moves to consider in attacking/defending the group}


  FUNCTION Strategy (var board: board_type; var player: color_type): string;
    {Returns a string suggesting territory, defense, or offense}


  PROCEDURE Pick_Move (var board: board_type; player: color_type; var move: location_list; depth: byte);
    {Picks a strategy and calls the appropriate tacticians}


  PROCEDURE Play_Move (var board: board_type; player: color_type; depth: byte);
    {Calls pick_move and plays it}


IMPLEMENTATION


  USES
    GroupMgr, BrdHndlr, Tactics;


  PROCEDURE Fill_Liberties (var x, y: byte; var liberty: boolean_board; var board: board_type;
                             var new_move_made: boolean; var depth: byte);
    {An ugly part of alive.  Plays opposing stones in liberties of the group}
    {in question.  LOCAL}
    Var
      a, b: byte;
      attacker: color_type;
    Begin  {Fill Liberties}
      new_move_made := false;
      attacker := opposite (board.groups [board.data [x, y].group]^.owner);
      For a := 1 to board_size do
        For b := 1 to board_size do
          If board.data [x, y].group <> 0
            Then Begin
                   If liberty [a, b]
                     Then If legal_move (a, b, attacker, board)
                               and not suicidal (a, b, attacker, board)
                            Then Begin
                                   liberty [a, b] := false;
                                   new_move_made := true;
                                   Play_At (a, b, attacker, board, 1 + maximum_search_depth)
                                 End
                 End
    End;  {Fill Liberties}


  PROCEDURE Add_Helpful_Groups (var group: byte; var liberty: boolean_board; var board: board_type; var addition: boolean);
    {Another ugly part of alive.  Finds groups that share liberties with the}
    {group in question, and add their liberties to the liberty array.  LOCAL}
    Var
      x, y, a, b: byte;
      direction: direction_type;
      neighbor: location_type;
    Begin  {Add Helpful Groups}
      addition := false;
      For x := 1 to board_size do
        For y := 1 to board_size do
          If liberty [x, y]
            Then Begin  {See if any other groups border on this liberty}
                   For direction := north to west do
                     Begin
                       neighbor := neighbors [x, y, direction];
                       If (on_board (neighbor.x, neighbor.y))
                            and (board.data [neighbor.x, neighbor.y].color = board.groups [group]^.owner)
                            and not (board.data [neighbor.x, neighbor.y].group = group)
                         Then Begin
                                For a := 1 to board_size do
                                  For b := 1 to board_size do
                                    If board.groups [board.data [neighbor.x, neighbor.y].group]^
                                        .interpretation [a, b].adjacent and
                                        (board.data [neighbor.x, neighbor.y].color = empty)
                                      Then If not liberty [a, b]
                                             Then Begin
                                                    liberty [a, b] := true;
                                                    addition := true
                                                  End
                              End
                     End
                 End
    End;  {Add Helpful Groups}


  FUNCTION Alive (var group: group_type; var board: board_type; depth: byte): boolean;
    {Returns true if the group in question is unconditionally alive}
    Var
      x, y: byte;
      member: location_type;
      liberty: boolean_board;
      new_move_made, another_group_added: boolean;
      previous_board_file: string;
    Begin  {Alive}
      Write (depth, ' ');
      Save_Board (board, previous_board_file);
      For x := 1 to board_size do
        For y := 1 to board_size do
          liberty [x, y] := group.interpretation [x, y].adjacent
                             and (board.data [x, y].color = empty);
      Find_Member (group, member);
      Repeat
        Repeat
          Fill_Liberties (member.x, member.y, liberty, board, new_move_made, depth)
        Until (not new_move_made)
                or (board.data [member.x, member.y].group = 0)
                or (board.groups [board.data [member.x, member.y].group]^.liberties = 1);
        If (not new_move_made)
             and (board.data [member.x, member.y].group <> 0)
             and (board.groups [board.data [member.x, member.y].group]^.liberties > 1)
          Then Add_Helpful_Groups (board.data [member.x, member.y].group, liberty, board, another_group_added)
          Else another_group_added := false
      Until not another_group_added;
      alive := (board.data [member.x, member.y].group <> 0)
                 and (board.groups [board.data [member.x, member.y].group]^.liberties > 1);
      Load_Board (board, previous_board_file);
      Delete_Board (previous_board_file)
    End;  {Alive}


  FUNCTION Aji  (var group: group_type; var board: board_type): byte;
    {Performs a static analysis on a group's life.  LOCAL}
    Var
      x, y: byte;
      neighbor_in_atari: boolean;
    Begin  {Aji}
      If group.liberties = 1
        Then Begin
               neighbor_in_atari := false;
               For x := 1 to board_size do
                 For y := 1 to board_size do
                   With group.interpretation [x, y] do
                     If adjacent and (board.data [x, y].color = opposite (group.owner))
                         and (board.groups [board.data [x, y].group]^.liberties = 1)
                       Then neighbor_in_atari := true;
               If neighbor_in_atari
                 Then aji := 4  {Unknown}
                 Else aji := 1  {Hosed}
             End
        Else Case group.room of
               0..1: aji := 2;  {Probably hosed}
               10..255: aji := 6  {Probably alive}
               Else aji := 4  {Unknown}
             End
    End;  {Aji}


  FUNCTION Life (group: group_type; first_player: color_type; var board: board_type;
                  depth: byte; var crucial_move: location_type): byte;
    {The big one, folks!  Reads out sequences to see if the group in question}
    {can live.}
    Var
      points_to_consider, move: location_list;
      where: location_type;
      best: byte;
      defending, found_one: boolean;
      previous_board_file: string;
    Begin  {Life}
      If (depth >= maximum_search_depth) or (group.aliveness in [1, 6, 7])
        Then life := group.aliveness
        Else Begin
               defending := first_player = group.owner;
               found_one := false;
               points_to_consider := critical_points_for (group, board);
               Find_Member (group, where);
               move := points_to_consider;
               Save_Board (board, previous_board_file);
               While move <> nil do
                 If found_one or suicidal (move^.location.x, move^.location.y, first_player, board)
                   Then Begin
                          If defending
                            Then move^.value := 0
                            Else move^.value := 8;
                          move := move^.next
                        End
                   Else Begin
                          Play_At (move^.location.x, move^.location.y, first_player, board, depth + 1);
                          If board.data [where.x, where.y].group = 0
                            Then move^.value := 0
                            Else If plenty_of_time (physical_board.turn)
                                   Then move^.value := life (board.groups [board.data [where.x, where.y].group]^,
                                                              opposite (first_player), board, depth + 1, crucial_move)
                                   Else move^.value := life (board.groups [board.data [where.x, where.y].group]^,
                                                              opposite (first_player), board, depth + 2, crucial_move);
                          If (defending and (move^.value = 7))
                               or ((not defending) and (move^.value = 1))
                            Then found_one := true;
                          move := move^.next;
                          Load_Board (board, previous_board_file)
                        End;
               Delete_Board (previous_board_file);
               If defending
                 Then best := 0
                 Else best := 8;
               move := points_to_consider;
               While move <> nil do
                 Begin
                   If defending
                     Then Begin
                            If move^.value > best
                              Then Begin
                                     best := move^.value;
                                     crucial_move := move^.location
                                   End
                          End
                     Else If move^.value < best
                            Then Begin
                                   best := move^.value;
                                   crucial_move := move^.location
                                 End;
                   move := move^.next
                 End;
               Clean_Out_Location_List (points_to_consider);
               life := best
             End
    End;  {Life}


  PROCEDURE Update_Aliveness (var group: group_type; var board: board_type; var depth: byte);
    {Rates the group's life from 1 (hosed) to 7 (2 eyes)}
    Var
      opponent_first, self_first: byte;
    Begin  {Update Aliveness}
      With group do
        If aliveness < 7  {It's not already unconditionally alive}
          Then Begin
                 aliveness := aji (group, board);
                 If aliveness = 4  {Unsettled}
                   Then If alive (group, board, depth)
                          Then aliveness := 7  {Alive}
                          Else If (depth = 0) and (plenty_of_time (board.turn) or (group.last_update = 0))
                                   {Only read sequences from physical board, and when there's time}
                                 Then Begin
                                        opponent_first := life (group, opposite (group.owner), board, depth, group.to_kill);
                                        If opponent_first > 5
                                          Then aliveness := 5  {Alive if opponent moves first}
                                          Else Begin
                                                 self_first := life (group, group.owner, board, depth, group.to_save);
                                                 If opponent_first < 3
                                                   Then aliveness := aliveness - 1;
                                                 If self_first > 5
                                                   Then aliveness := aliveness + 1
                                               End
                                      End
               End
    End;  {Update Aliveness}


  FUNCTION Attack_Potential_At (var x, y: byte; var group: group_type; var board: board_type): integer;
    {Returns an integer rating of the point as a place to attack the group}
    {LOCAL}
    Var
      direction: direction_type;
      neighbor: location_type;
      importance, tally: integer;
    Begin  {Attack Potential At}
      If legal_move (x, y, opposite (group.owner), board)
        Then Begin
               If (group.interpretation [x, y].adjacent) and (board.data [x, y].color = empty)
                 Then tally := 5000
                 Else tally := 0;
               For direction := north to ne do
                 Begin
                   neighbor := neighbors [x, y, direction];
                   If on_board (neighbor.x, neighbor.y)
                     Then Begin
                            importance := 0;
                            With group.interpretation [neighbor.x, neighbor.y] do
                              If connected or adjacent
                                Then If board.data [neighbor.x, neighbor.y].color = group.owner
                                       Then importance := 10
                                       Else If adjacent and (board.data [neighbor.x, neighbor.y].color = empty)
                                              Then importance := 5
                                              Else importance := 2;
                            If direction in [north..west]
                              Then importance := importance * 141
                              Else importance := importance * 100;
                            tally := tally + importance
                          End
                 End;
               attack_potential_at := tally
             End
        Else attack_potential_at := 0
    End;  {Attack Potential At}


  FUNCTION Critical_Points_For (var group: group_type; var board: board_type): location_list;
    {Generates a list of points to consider in attacking/defending the group}
    Var
      x, y: byte;
      rating: integer_board;
    Begin  {Critical Points For}
      For x := 1 to board_size do
        For y := 1 to board_size do
          rating [x, y] := Attack_Potential_At (x, y, group, board);
      critical_points_for := highest_rated (rating)
    End;  {Critical Points For}


  FUNCTION Strategy (var board: board_type; var player: color_type): string;
    {Returns a string suggesting territory, defense, or offense}
    Var
      b, w: integer;
      count: byte;
      points: integer_board;
      i_have_a_weak_group, he_has_a_weak_group: boolean;
    Begin  {Strategy}
      Estimate_Score (board, b, w, points);
      If b + w < board_size_squared div 2
        Then strategy := 'Grab for some of that empty territory'
        Else Begin
               i_have_a_weak_group := false;
               he_has_a_weak_group := false;
               count := 1;
               Repeat
                 If board.groups [count]^.aliveness in [3..5]
                   Then If board.groups [count]^.owner = player
                          Then i_have_a_weak_group := true
                          Else he_has_a_weak_group := true;
                 Inc (count)
               Until (board.groups [count]^.size = 0) or (i_have_a_weak_group and he_has_a_weak_group);
               If abs (w - b) < board_size
                 Then If i_have_a_weak_group
                        Then strategy := 'Defend your groups'
                        Else If he_has_a_weak_group
                               Then strategy := 'Attack the opponent''s groups'
                               Else strategy := 'It''s close--push'
                 Else If ((w > b) and (player = black_stone)) or ((b > w) and (player = white_stone))
                        Then If he_has_a_weak_group
                               Then strategy := 'You need to kill something'
                               Else strategy := 'You''re in trouble--invade'
                        Else If i_have_a_weak_group
                               Then strategy := 'Keep your lead--defend your groups'
                               Else strategy := 'You''re winning--seal it up'
             End
    End;  {Strategy}


  PROCEDURE Pick_Move (var board: board_type; player: color_type; var move: location_list; depth: byte);
    {Picks a strategy and calls the appropriate tacticians}
    Var
      count: byte;
      b, w: integer;
      points: integer_board;
      i_have_a_weak_group, he_has_a_weak_group: boolean;
    Begin  {Pick Move}
      move := nil;
      Estimate_Score (board, b, w, points);
      If b + w < board_size_squared div 2
        Then Grab_Territory (board, player, move, points, depth)
        Else Begin
               i_have_a_weak_group := false;
               he_has_a_weak_group := false;
               count := 1;
               Repeat
                 If board.groups [count]^.aliveness in [4..5]
                   Then If board.groups [count]^.owner = player
                          Then i_have_a_weak_group := true
                          Else he_has_a_weak_group := true;
                 Inc (count)
               Until (board.groups [count]^.size = 0) or (i_have_a_weak_group and he_has_a_weak_group);
               If abs (w - b) < board_size
                 Then If i_have_a_weak_group
                        Then Defend_Groups (board, player, move, depth)
                        Else If he_has_a_weak_group
                               Then Attack_Opponent (board, player, move, depth)
                               Else Push (board, player, move, points, depth)
                 Else If ((w > b) and (player = black_stone)) or ((b > w) and (player = white_stone))
                        Then If he_has_a_weak_group
                               Then Attack_Opponent (board, player, move, depth)
                               Else Invade (board, player, move, points, depth)
                        Else If i_have_a_weak_group
                               Then Defend_Groups (board, player, move, depth)
             End;
      If move = nil
        Then Seal_Up (board, player, move, points, depth);
      If move = nil
        Then Push (board, player, move, points, depth);
      If (move = nil) and (i_have_a_weak_group)
        Then Defend_Groups (board, player, move, depth);
      If (move = nil) and (he_has_a_weak_group)
        Then Attack_Opponent (board, player, move, depth);
      If move = nil
        Then Invade (board, player, move, points, depth);
      If move = nil
        Then Begin
               New (move);
               move^.location.x := 0;
               move^.location.y := 0;
               move^.next := nil
             End
    End;  {Pick Move}


  PROCEDURE Play_Move (var board: board_type; player: color_type; depth: byte);
    {Calls pick_move and plays it}
    Var
      move, good_moves: location_list;
      start_hour, start_minute, start_second, start_hundredths, hour, minute, second, hundredths: word;
      move_coordinates: string;
    Begin  {Play Move}
      WriteLn ('I have ', time_left div 60, ' minutes left');
      GetTime (start_hour, start_minute, start_second, start_hundredths);
      Pick_Move (board, player, good_moves, depth);
      move := good_moves;
      While move^.next <> nil do
        move := move^.next;
      If on_board (move^.location.x, move^.location.y)
        Then Begin
               Str (move^.location.y, move_coordinates);
               Case move^.location.x of
                 1..8: move_coordinates := chr (move^.location.x + ord ('a') - 1) + move_coordinates;
                 9..19: move_coordinates := chr (move^.location.x + ord ('a')) + move_coordinates
               End;
               WriteLn;
               WriteLn ('*** I move at ', move_coordinates, ' ***');
               Play_At (move^.location.x, move^.location.y, player, physical_board, 0)
             End
        Else If move^.location.y = 0
               Then Begin
                      WriteLn;
                      WriteLn ('*** I Pass ***');
                      Pass (board)
                    End
               Else Get_User_Move (player, board);
      WriteLn ('(Return to continue)');
      ReadLn;
      Clean_Out_Location_List (good_moves);
      GetTime (hour, minute, second, hundredths);
      If hour > start_hour
        Then Dec (time_left, (hour - start_hour) * 3600)
        Else If start_hour > hour
               Then Dec (time_left, (24 + hour - start_hour) * 3600);
      If minute > start_minute
        Then Dec (time_left, (minute - start_minute) * 60)
        Else If start_minute > minute
               Then Inc (time_left, (start_minute - minute) * 60);
      If second > start_second
        Then Dec (time_left, second - start_second)
        Else If start_second > second
               Then Inc (time_left, start_second - second);
      If (time_left > total_time) or (time_left = 0)
        Then time_left := 1
    End;  {Play Move}


END.  {Sequence}

