program Tutorial4;
{
 3d Tutorial step#4
 Made by fh (C) 1/1/1996
 Mail: fh@viktoria.drp.fmph.uniba.sk
}
uses tutunit,crt;

const sin005 : real = 0.049979169;
      cos005 : real = 0.99875026;
var xt,yt,zt:real; {temp points}
    ch:char; {for key you want to press}
    xan,yan,zan:real; {angles for axis X,Y,Z}
    objname: string[20]; {just a junk}
    sx,sy,sx1,sy1,p,zoom,p1: integer; {Screen coords X,Y}
    points,lines:word; {nr. of points and lines of the object}
    obj,objold: array[0..511] of real; {object to rotate (max 512 points}
    lobj: array[0..1023] of integer; {line index of object (max 1024}
    xsin,ysin,zsin,xcos,ycos,zcos: real; {some help variables}
    {eeh, sorry if i don't use all of them, no time for optimization}

procedure intro;
begin
textcolor(15);
writeln;
writeln(' Name of object: ',objname);
textcolor(7);
writeln;
writeln(' Keyz: x     - rotates around X axis,');
writeln('       y     - rotates around Y axis,');
writeln('       z     - rotates around Z axis,');
writeln('       UP    - moves the object up,');
writeln('       DOWN  - moves the object down,');
writeln('       LEFT  - moves the object left,');
writeln('       RIGHT - moves the object right,');
writeln('       +     - moves the object to the front,');
writeln('       -     - moves the object to the back,');
writeln('       [     - increases the size of the object,');
writeln('       ]     - decreases the size of the object,');
writeln('       r     - resets the values.');
writeln;
writeln('Press a key to continue ...');
readkey;
end;

procedure readdata;
var f:text;
begin
 writeln('3d Tutorial step#4 (C) 1996 by fh.');
 if ParamCount <> 1 then begin writeln('Usage: TUT4 datafile'); halt(0); end;
 assign(F,Paramstr(1));
 reset(F);
 readln(F,objname);
 readln(F,points,lines);
 p1:=0;
 for p:=1 to points do begin readln(F,obj[p1],obj[p1+1],obj[p1+2]); p1:=p1+3; end;
 p1:=0;
 for p:=1 to lines do begin readln(F,lobj[p1],lobj[p1+1]); p1:=p1+2; end;
 close(F);
end;

procedure draw(color:byte); {procedure to draw a cube}
begin
 for p:=0 to lines-1 do begin {loops for all lines}
  sx:=round(zoom*obj[lobj[p*2]*3])+160; {x coord for point1}
  sy:=round(zoom*obj[lobj[p*2]*3+1])+100; {y coord for point1}
  sx1:=round(zoom*obj[lobj[p*2+1]*3])+160; {x coord for point2}
  sy1:=round(zoom*obj[lobj[p*2+1]*3+1])+100; {y coord for point2}
  line(SX,SY,sx1,sy1,color); {draw line between points 1&2 in current color}
 end;
end;

procedure calc; {calculates new values after rotate step}
begin
 for p:=0 to points-1 do begin {repeats for all points}
  Yt := obj[p*3+1] * xCOS - obj[p*3+2] * xsin; {read old values from the table of coord,}
  Zt := obj[p*3+1] * xsin + obj[p*3+2] * xcos; {rotating about x axis}
  obj[p*3+1] := Yt; {writes the new values back to the table}
  obj[p*3+2] := Zt;

  Xt := obj[p*3] * ycos - obj[p*3+2] * ySIN; {same as above, for Y axis}
  Zt := obj[p*3] * ySIN + obj[p*3+2] * yCOS;
  obj[p*3] := Xt;
  obj[p*3+2] := Zt;

  Xt := obj[p*3] * zCOS - obj[p*3+1] * zSIN; {about Z axis}
  Yt := obj[p*3] * zSIN + obj[p*3+1] * zCOS;
  obj[p*3] := Xt;
  obj[p*3+1] := Yt;
 end;
end;

procedure move(xp,yp,zp:real);
begin
 for p:=0 to points-1 do begin {repeats for all points}
  obj[p*3]:=obj[p*3]+xp; {add xp to the X coord (even if it is less then 0)}
  obj[p*3+1]:=obj[p*3+1]+yp; {add yp to the Y coord}
  obj[p*3+2]:=obj[p*3+2]+zp; {...i think you've got the idea}
 end;
end;

begin
 readdata;
 intro;
 setmode;      {sets the 13h (320x200x256) mode}
 zoom:=30;     {size of the object}

 cls;
 draw(15);
 repeat        {loops ...}
  ch:=readkey;
  draw(0);
  xsin:=0; {'cause sin(0)=0}
  ysin:=0; {...}
  zsin:=0; {...}
  xcos:=1; {'cause cos(0)=1}
  ycos:=1; {...}
  zcos:=1; {...}
  case ch of
   'X' : begin xsin:=sin005; {rotates around X}
	 xcos:=cos005; end;  
   'Y' : begin ysin:=sin005; {...}
	 ycos:=cos005; end;
   'Z' : begin zsin:=sin005;
	 zcos:=cos005; end;
   'x' : begin xsin:=sin005; {for small caps, too}
	 xcos:=cos005; end;
   'y' : begin ysin:=sin005; {...}
	 ycos:=cos005; end;
   'z' : begin zsin:=sin005;
	 zcos:=cos005; end;
   '[' : zoom:=zoom+5;       {bigger}
   ']' : zoom:=zoom-5;       {smaller}
   #77 : move(0.1,0,0);      {move right}
   #72 : move(0,-0.1,0);     {move up}
   #75 : move(-0.1,0,0);     {move left}
   #80 : move(0,0.1,0);      {move down}
   '+' : begin; move(0,0,-0.1); zoom:=zoom+5; end; {move to front} {or no?}
   '-' : begin; move(0,0,0.1); zoom:=zoom-5; end;  {move to back}
   'r' : readdata;           {resets the values}
   'R' : readdata;           { '  ' }
  end;
  calc;         {calculates the new coords}
  draw(15);     {draws it again}
  waitretrace;  {wait a sec!}
 until ch=#27; {... 'till you press ESC}
 closegraph;      {jump back to text mode}
 writeln('3dTutorial step#4');
 writeln('Made by fh(c)96.');
end.
