{$A+,B-,E-,F-,G+,I-,L-,N-,O-,P-,Q-,R-,S-,T-,V-,X+}
program shaded_cube; {this version doesn't contain the perspective}
uses unit1,crt;

const cube: array[0..23] of real = {good old cube}
       (-1,-1,-1,-1,-1,1,-1,1,-1,
        -1,1,1,1,-1,-1,1,-1,1,
        1,1,-1,1,1,1);
    pindex: array[0..23] of byte = {plane index: 4 points = 1 plane}
     (0,3,1,2,0,5,4,1,0,6,2,4,6,3,2,7,3,5,1,7,4,7,6,5);
    cos002= 9.9980000666E-01; {precalculated values of cos/sin}
    sin002= 1.9998666693E-02; {...it's a bit faster...}
    cos005= 9.9875026039E-01;
    sin005= 4.9979169271E-02;
    cos010= 9.9500416528E-01;
    sin010= 9.9833416647E-02;
var xt,yt,zt:real;
    p,pp,zoom,per,q1,q2,q3,q:integer;
    pom,v1,v2,v3,u1,u2,u3,n1,n2,n3,n: real;
    r,g,b:byte;
    uncube: array[0..23] of real;

procedure draw;
begin
 for p:=0 to 5 do begin
  v1:=cube[pindex[p*4]*3]-cube[pindex[p*4+1]*3];      {vector1_coord1}
  v2:=cube[pindex[p*4]*3+1]-cube[pindex[p*4+1]*3+1];  {vector1_coord2}
  v3:=cube[pindex[p*4]*3+2]-cube[pindex[p*4+1]*3+2];  {...}
  u1:=cube[pindex[p*4+2]*3]-cube[pindex[p*4+3]*3];    {vector2_coord1}
  u2:=cube[pindex[p*4+2]*3+1]-cube[pindex[p*4+3]*3+1]; {...}
  u3:=cube[pindex[p*4+2]*3+2]-cube[pindex[p*4+3]*3+2];
  n1:=v2*u3-u2*v3; {normal_coord1}
  n2:=v3*u1-u3*v1; {...}
  n3:=v1*u2-u1*v2;
  n:=sqrt(n1*n1+n2*n2+n3*n3); {size of the normal}
  pom:=(n3*q3)/(n*q); {(cos of the) angle between the normal and the viewpoint}
  if pom>0 then begin {if the (cos)angle is lower than zero, don't show}
   setonecolor(p+100,abs(round(pom*r)),abs(round(pom*g)),abs(round(pom*b)));
   setcolor(p+100); {sets up the color that belongs to that (cos)angle}
   triangle(round(zoom*cube[pindex[p*4]*3])+160, {draws the plane of the cube}
           round(zoom*cube[pindex[p*4]*3+1])+100, {as 2 triangles}
           round(zoom*cube[pindex[p*4+1]*3])+160, {(it's fast enough, i think)}
	   round(zoom*cube[pindex[p*4+1]*3+1])+100,
           round(zoom*cube[pindex[p*4+2]*3])+160,
           round(zoom*cube[pindex[p*4+2]*3+1])+100);
   triangle(round(zoom*cube[pindex[p*4]*3])+160,
           round(zoom*cube[pindex[p*4]*3+1])+100,
           round(zoom*cube[pindex[p*4+1]*3])+160,
	   round(zoom*cube[pindex[p*4+1]*3+1])+100,
           round(zoom*cube[pindex[p*4+3]*3])+160,
           round(zoom*cube[pindex[p*4+3]*3+1])+100);
   for pp:=0 to 23 do uncube[pp]:=cube[pp]; {saves the old coords to 'uncube'}
   end;
 end;
end;

procedure undraw;
begin
 for p:=0 to 5 do begin {undraws all planes}
   setcolor(0);
   triangle(round(zoom*uncube[pindex[p*4]*3])+160, {again as 2 triangles}
           round(zoom*uncube[pindex[p*4]*3+1])+100,
           round(zoom*uncube[pindex[p*4+1]*3])+160,
	   round(zoom*uncube[pindex[p*4+1]*3+1])+100,
           round(zoom*uncube[pindex[p*4+2]*3])+160,
           round(zoom*uncube[pindex[p*4+2]*3+1])+100);
   triangle(round(zoom*uncube[pindex[p*4]*3])+160,
           round(zoom*uncube[pindex[p*4]*3+1])+100,
           round(zoom*uncube[pindex[p*4+1]*3])+160,
	   round(zoom*uncube[pindex[p*4+1]*3+1])+100,
           round(zoom*uncube[pindex[p*4+3]*3])+160,
           round(zoom*uncube[pindex[p*4+3]*3+1])+100);
   end;
end;

procedure rotate;
begin
 for p:=0 to 7 do begin {the same as in previous steps}
  Yt := cube[p*3+1] * COS002 - cube[p*3+2] * SIN002;
  Zt := cube[p*3+1] * SIN002 + cube[p*3+2] * COS002;
  cube[p*3+1] := Yt;
  cube[p*3+2] := Zt;

  Xt := cube[p*3] * COS005 - cube[p*3+2] * SIN005;
  Zt := cube[p*3] * SIN005 + cube[p*3+2] * COS005;
  cube[p*3] := Xt;
  cube[p*3+2] := Zt;

  Xt := cube[p*3] * COS010 - cube[p*3+1] * SIN010;
  Yt := cube[p*3] * SIN010 + cube[p*3+1] * COS010;
  cube[p*3] := Xt;
  cube[p*3+1] := Yt;
 end;
end;

begin
 setmode;
 r:=60; {color_red}
 g:=60; {..._green}
 b:=0;  {..._blue}
 q1:=0; {viewpoint/lightsource_coord1 - its precalculated - it doesnt change}
 q2:=0; {..._coord2}
 q3:=-4; {...}
 q:=4; {size of the viewpoint}
 per:=6; {perspective}
 zoom:=30; {size}
{ aktual_screen_seg:=$a000; {guess...}
{ aktual_screen_ofs:=0;}

 draw; {draws...}
 repeat {...loops...}
  rotate; {...calculates new values...}
  undraw; {...and undraws...}
  draw; {...and draws again...}
  waitretrace; {...and waits...}
 until keypressed; {...and loops until you press something}
 readkey; {...}
 closegraph; {bye-bye}

 writeln('Shaded Cube v0.1');
 writeln('Made by fh(C)96.');
end.
