Program farAllocExample; { (C) 1992 Jussi Lahdenniemi }
                         { -------------------------- }
                         { An example program for using the farAlloc }

Uses farAlloc;

Var myArray : PfarArray; { Make a variable of type PfarArray }
    loop    : Longint;
    test    : Boolean;

begin
  writeln;
  writeln('farAlloc example program - (C) 1992 Jussi Lahdenniemi');
  writeln;
  writeln('Program starting, memory free ',memAvail,' bytes');
  writeln;
  myArray:=new(PfarArray,init(100000,true));{ Initialize the object, allocate }
                                            { 100 000 bytes of memory, rc on  }
  if myArray^.loc = nil then begin          { Failure!                        }
    writeln('Memory allocation failed. Maybe not enough memory.');
    halt(1);
  end;
  writeln('Array initialized, memory free ',memavail,' bytes.');
  writeln('Writing something into the array..');
  writeln;
  for loop:=0 to 49999 do begin
    myArray^.wW(loop*2,loop mod 65536);   { Write something into the array  }
    if loop mod 1000=0 then write('.');   { For impatient programmers.. ;-) }
  end;
  writeln;
  writeln('These numbers should all be ten : ');
  test:=false;                          { Test if they are correct        }
  loop:=10*2;
  while loop<100000 do begin
    write(myArray^.rB(loop),'  ');
    test:=test or (myArray^.rB(loop)<>10);
    inc(loop,512);                      { Add 512 to jump to the next sequence }
  end;
  writeln;
  writeln('---------');
  if test then writeln('Oh no! There were also other numbers !') else
               writeln('Success! Only tens.');
  writeln;
  dispose(myArray,done);                { dispose the array               }
  writeln('The array is now disposed, memory free ',memAvail,' bytes!');
  writeln;
end.
