PROGRAM ENVIRON1;
{
	Environment mapping!
	Created by Bjarke Viksoe, jan 1996
	E-mail me at: bjarke.viksoe@ntsrv.capacity.dk

	This is a simple form of environment mapping. Not perfect.
	But the principles are right here, though.
	What is really done is mapping 'vertex' normals to a picture
	and then	texture map the whole thing!!! Much better results
	could have been achived if I had only the time to look into
	things. But I decided to wrap this stuff of unfinished and
	get on with my life.

	As you can see the light is wrong. Instead of highligh I have
	some kind of downlight (???). Anyway just fiddle with the light
	calc routine to get it right again.
}

{{$DEFINE DEBUG}
{{$DEFINE MEASURE}
{$S-,R-,N+,G+}

USES
	DEMOINIT, X3DS, PICTURE;

TYPE
	tNewCoord = RECORD {size is 16 bytes}
		x,y,z : integer;
		nx,ny,nz : integer;
		o : longint;
	end;
	tCoordBuffer = array[0..ARRAY_MAXCOORDS] of tCoordRec;
	tFaceArray = array[0..ARRAY_MAXFACES] of tFaceRec;
	tRotatedCoordBuffer = array[0..ARRAY_MAXCOORDS] of tNewCoord;
	tSlopeType = array[0..320*2] of integer;
	pLargeByteArray = ^tLargeByteArray;
	tLargeByteArray = array[0..65534] of byte;
	pLargeWordArray = ^tLargeByteArray;
	tLargeWordArray = array[0..254,0..127] of word;

VAR
	slope, textureslope : tSlopeType;
	face          : tFaceArray;          {holds face-definitions}
	coords        : tCoordBuffer;        {holds original coordinates}
	cbuffer       : tRotatedCoordBuffer; {holds rotated coordinates}
	number_faces  : word;
	number_coords : word;
	Dummy,SqrtTable : array[0..4095] of byte;
	env : pLargeByteArray;

	minx,maxx : integer;

	sinustabel : array[0..639] of integer;
	v1,v2,v3   : word;
	cos1,sin1,cos2,sin2,cos3,sin3 : integer;

CONST
	display1 : word = $0000;
	display2 : word = $4000;
	display3 : word = $8000;


(*------------------------------------------------*)
(*             INITIALIZE RENDERING               *)
(*------------------------------------------------*)

Procedure SetupSinus;
Var
	i : integer;
	v, vadd : real;
Begin
	v:=0.0;
	vadd:=(2.0*pi/512.0);
	for i:=0 to 639 do begin
		sinustabel[i]:=round(sin(v)*32767);
		v:=v+vadd;
	end;
End;


Procedure InitDemo;
Var
	i,j : integer;
	c1,c2,c3 : longint;
	v,xv, amb, dif, spec : real;
Begin
	Screen_Off;
	ClearWholeScreen;
	SetupSinus;

	v1:=0; v2:=0; v3:=128;

	{create simple environment map}
	New( env );
	if Ofs(env^)<>0 then halt;
	for i:=0 to 255 do
		for j:=0 to 255 do
			env^[j*256+i]:= 32+((Sqr(i-128) + Sqr(j-128)) DIV 260);

	{make a nice colours}
	SetRGB(0, 0,0,0);
	v:=pi / 2;
	xv:=pi / 128;
	for i:=1 to 128 do begin
		amb := 1.0; dif := cos(v) * 40.0; spec := cos(v) * 190.0;
		c1 := trunc((amb+dif+spec)/4.0);
		amb := 1.0;	dif := cos(v) * 5.0;	spec := cos(v) * 190.0;
		c2 := trunc((amb+dif+spec)/4.0);
		amb := 1.0;	dif := cos(v) * 2.0;	spec := cos(v) * 190.0;
		c3 := trunc((amb+dif+spec)/4.0);
		SetRGB( i, c1,c2,c3);
		v:=v-xv;
	end;
	for i:=129 to 255 do SetRGB(i, 0,0,0);

	j:=0;
	FillChar(Dummy,SizeOf(Dummy),0);
	for i:=0 to 4095 do begin
		if Sqr(j+1)=i then Inc(j);
		SqrtTable[i]:=j;
	end;

	Screen_On;
End;

Procedure UninitDemo;
Begin
	Dispose( env );
End;

Function IntSqrt(const l : longint) : word; Assembler;
{Looks clumsy, but calculate square root very quickly...}
Asm
	DB LONG; mov ax,WORD PTR [l]
	DB LONG; mov bx,ax
	DB LONG; mov cx, $0000; DW $4000;
	DB LONG; mov dx,cx
	DB LONG; add dx,ax
	DB LONG; shr ax,1
	DB LONG; cmp dx,bx
	ja @over1
	DB LONG; sub bx,dx
	DB LONG; or ax,cx
@over1:
	DB LONG; shr cx,2
	DB LONG; mov dx,cx
	DB LONG; add dx,ax
	DB LONG; shr ax,1
	DB LONG; cmp dx,bx
	ja @over2
	DB LONG; sub bx,dx
	DB LONG; or ax,cx
@over2:
	DB LONG; shr cx,2
	DB LONG; mov dx,cx
	DB LONG; add dx,ax
	DB LONG; shr ax,1
	DB LONG; cmp dx,bx
	ja @over3
	DB LONG; sub bx,dx
	DB LONG; or ax,cx
@over3:
	DB LONG; shr cx,2
	DB LONG; mov dx,cx
	DB LONG; add dx,ax
	DB LONG; shr ax,1
	DB LONG; cmp dx,bx
	ja @over4
	DB LONG; sub bx,dx
	DB LONG; or ax,cx
@over4:
	DB LONG; shr cx,2
	DB LONG; mov dx,cx
	DB LONG; add dx,ax
	DB LONG; shr ax,1
	DB LONG; cmp dx,bx
	ja @over5
	DB LONG; sub bx,dx
	DB LONG; or ax,cx
@over5:
	DB LONG; shr cx,2
	DB LONG; mov dx,cx
	DB LONG; add dx,ax
	DB LONG; shr ax,1
	DB LONG; cmp dx,bx
	ja @over6
	DB LONG; sub bx,dx
	DB LONG; or ax,cx
@over6:
	DB LONG; shr cx,2
	DB LONG; mov dx,cx
	DB LONG; add dx,ax
	DB LONG; shr ax,1
	DB LONG; cmp dx,bx
	ja @over7
	DB LONG; sub bx,dx
	DB LONG; or ax,cx
@over7:
	DB LONG; shr cx,2
	DB LONG; mov dx,cx
	DB LONG; add dx,ax
	DB LONG; shr ax,1
	DB LONG; cmp dx,bx
	ja @over8
	DB LONG; sub bx,dx
	DB LONG; or ax,cx
@over8:
	DB LONG; shr cx,2
	DB LONG; mov dx,cx
	DB LONG; add dx,ax
	DB LONG; shr ax,1
	DB LONG; cmp dx,bx
	ja @over9
	DB LONG; sub bx,dx
	DB LONG; or ax,cx
@over9:
	DB LONG; shr cx,2
	DB LONG; mov dx,cx
	DB LONG; add dx,ax
	DB LONG; shr ax,1
	DB LONG; cmp dx,bx
	ja @over10
	DB LONG; sub bx,dx
	DB LONG; or ax,cx
@over10:
	DB LONG; shr cx,2
	DB LONG; mov dx,cx
	DB LONG; add dx,ax
	DB LONG; shr ax,1
	DB LONG; cmp dx,bx
	ja @over11
	DB LONG; sub bx,dx
	DB LONG; or ax,cx
@over11:
	DB LONG; shr cx,2
	DB LONG; mov dx,cx
	DB LONG; add dx,ax
	DB LONG; shr ax,1
	DB LONG; cmp dx,bx
	ja @over12
	DB LONG; sub bx,dx
	DB LONG; or ax,cx
@over12:
	DB LONG; shr cx,2
	DB LONG; mov dx,cx
	DB LONG; add dx,ax
	DB LONG; shr ax,1
	DB LONG; cmp dx,bx
	ja @over13
	DB LONG; sub bx,dx
	DB LONG; or ax,cx
@over13:
	DB LONG; shr cx,2
	DB LONG; mov dx,cx
	DB LONG; add dx,ax
	DB LONG; shr ax,1
	DB LONG; cmp dx,bx
	ja @over14
	DB LONG; sub bx,dx
	DB LONG; or ax,cx
@over14:
	DB LONG; shr cx,2
	DB LONG; mov dx,cx
	DB LONG; add dx,ax
	DB LONG; shr ax,1
	DB LONG; cmp dx,bx
	ja @over15
	DB LONG; sub bx,dx
	DB LONG; or ax,cx
@over15:
	DB LONG; shr cx,2
	DB LONG; mov dx,cx
	DB LONG; add dx,ax
	DB LONG; shr ax,1
	DB LONG; cmp dx,bx
	ja @over16
	DB LONG; sub bx,dx
	DB LONG; or ax,cx
@over16:
End;


(*------------------------------------------------*)
(*            START RENDERING PROCESS             *)
(*------------------------------------------------*)

Procedure SwapDisplay;
Var
	temp : word;
Begin
	temp:=display3;
	display3:=display2;
	display2:=display1;
	display1:=temp;
	SetAddress( Ptr(SEGA000,display2) );
End;

Procedure ClearScreen; assembler;
Asm
	mov	dx,$3C4
	mov	ax,$0F02
	out	dx,ax

	mov	es,[SEGA000]
	mov	di,[display1]
	mov	cx,(WIDTH*HEIGHT)/2
	xor	ax,ax
	rep stosw
End;

Procedure FindFaceZ; Assembler;
{Finds the medium z-value for each face-record}
Asm
	lea	si,face+tFaceRec.l1
	lea	di,cbuffer+tNewCoord.z {point a first z-coord in coordbuffer... }
										  {makes it easier to index}
	cld
	mov	cx,[number_faces]
@loop:
{ face[i].z := (z1 + z2 + z3) DIV 3; }
	lodsw
	shl	ax,4
	mov	bx,ax
	mov	dx,[di+bx]
	lodsw
	shl	ax,4
	mov	bx,ax
	add	dx,[di+bx]
	sar	dx,1
	lodsw
	shl	ax,4
	mov	bx,ax
	add	dx,[di+bx]
	sar	dx,1
	mov	[si-8],dx {put result in face[i].z}
	add	si,2
	dec	cx
	jnz	@loop
End;

Procedure QuickSort(lo,hi:integer);
 Procedure Sort(l,r:integer);
 Var
	 i,j,x : integer;
 Begin
	i:=l; j:=r;
	x:=face[(l+r) SHR 1].z;
	repeat
	  if i < j then begin
		 while face[i].z < x do inc(i);
		 while x < face[j].z do dec(j);
		 asm
			 lea	si,face	{ swap face records... face[i] <-> face[j] }
			 mov	di,si
			 mov	ax,[i]
			 shl	ax,3
			 add	di,ax
			 mov	ax,[j]
			 shl	ax,3
			 add	si,ax
			 DB LONG; mov ax,[di]
			 DB LONG; xchg [si],ax
			 DB LONG; stosw;
			 DB LONG; mov ax,[di]
			 DB LONG; xchg [si+4],ax
			 DB LONG; stosw;
		 end;
		 inc(i); dec(j);
	  end;
	until i >= j;
	if l < j then Sort(l,j);
	if i < r then Sort(i,r);
 End;
Begin
	asm
		mov	ax,ds {we hope that BP won't change ES for a while...}
		mov	es,ax
		cld
	end;
	Sort(lo,hi);
End;


(*------------------------------------------------*)
(*       CALCULATE FACES POSITION ON SCREEN       *)
(*------------------------------------------------*)

Procedure ClearSlope; assembler;
Asm
	mov	ax,ds
	mov	es,ax
	lea	di,slope
	DB LONG; mov ax,$8000; DW $8000;
	cld
	mov	cx,TYPE(tSlopeType)/4
	rep; DB LONG; stosw
End;

Procedure CalcSlope(l1,l2 : integer); assembler;
{Calc edge buffer for line drawing/texture mapping.
 tex1x/tex1y is texture map position (x1,y1), tex2x/tex2y is texture map position (x2,y2)}
Var
	tex1x, tex1y, tex2x, tex2y : word;
	tex1xadd,tex1yadd : integer;
	xlowadd,xhighadd : word;
	ysize : integer;
Asm
	lea	si,cbuffer
	DB LONG; xor cx,cx
	mov	bx,[l1]						{get first coords}
	shl	bx,4
	mov	ax,[si+bx+tNewCoord.nx]	{get normal x/y coords}
	mov	[tex2x],ax
	mov	ax,[si+bx+tNewCoord.ny]
	mov	[tex2y],ax
	mov	dx,[si+bx+tNewCoord.x]	{get x/y coords}
	mov	cx,[si+bx+tNewCoord.y]

	mov	ax,[l2]						{get second coords}
	shl	ax,4
	add	si,ax
	mov	ax,[si+tNewCoord.nx]		{get normal x/y coords}
	mov	[tex1x],ax
	mov	ax,[si+tNewCoord.ny]
	mov	[tex1y],ax
	mov	ax,[si+tNewCoord.x]		{get x/y coords}
	mov	bx,[si+tNewCoord.y]

	cmp	bx,cx					{make sure we go downwards...}
	jle	@noswap
	mov	si,[tex1x]			{swap texture x}
	xchg	[tex2x],si
	mov	[tex1x],si
	mov	si,[tex1y]			{swap texture y}
	xchg	[tex2y],si
	mov	[tex1y],si
	xchg	ax,dx					{swap x}
	xchg	bx,cx					{sway y}
@noswap:

	or		bx,bx
	js		@zero
	cmp	bx,[minx]			{record miny and maxy}
	jae	@minx
	mov	[minx],bx
@minx:
	cmp	cx,[maxx]
	jbe	@maxx
	mov	[maxx],cx
@maxx:

	sub	cx,bx
	jcxz	@done
	mov	[ysize],cx
	add	bx,bx
	add	bx,bx
	lea	si,slope
	add	si,bx

	push	ax
	sub	dx,ax

	mov	ax,dx
	DB LONG; shl	ax,16
	{cdq} DB $66,$99
	DB LONG; idiv	cx
	DB LONG; mov	dx,ax
	DB LONG; shr	dx,16
	mov	[xlowadd],ax
	mov	[xhighadd],dx

	mov	ah,BYTE PTR [tex2x]
	sub	ah,BYTE PTR [tex1x]
	xor	al,al
	cwd
	idiv	cx
	mov	[tex1xadd],ax

	mov	ah,BYTE PTR [tex2y]
	sub	ah,BYTE PTR [tex1y]
	xor	al,al
	cwd
	idiv	cx
	mov	[tex1yadd],ax
@one:
	pop	cx

	xor	bx,bx
	mov	ah,BYTE PTR [tex1x]
	xor	al,al
	mov	dh,BYTE PTR [tex1y]
	xor	dl,dl
	mov	di,$8000
@loop:
	cmp	[si],di
	jne	@other
	mov	[si],cx
	mov	[si+TYPE(tSlopeType)],ah
	mov	[si+TYPE(tSlopeType)+1],dh
	add	si,4
	add	bx,[xlowadd]
	adc	cx,[xhighadd]
	add	ax,[tex1xadd]
	add	dx,[tex1yadd]
	dec	[ysize]
	jnz	@loop
@done:
	jmp	NEAR PTR @zero
@other:
	mov	[si+2],cx
	mov	[si+TYPE(tSlopeType)+2],ah
	mov	[si+TYPE(tSlopeType)+3],dh
	add	si,4
	add	bx,[xlowadd]
	adc	cx,[xhighadd]
	add	ax,[tex1xadd]
	add	dx,[tex1yadd]
	dec	[ysize]
	jnz	@loop
@zero:
end;



(*------------------------------------------------*)
(*       PREPARE AND DO ROTATION OF POINTS        *)
(*------------------------------------------------*)

Procedure CalcAngle;
Begin
	{get sinus values}
	sin1:=sinustabel[v1]; cos1:=sinustabel[v1+128];
	sin2:=sinustabel[v2]; cos2:=sinustabel[v2+128];
	sin3:=sinustabel[v3]; cos3:=sinustabel[v3+128];
	{rotate object a bit}
	v1:=(v1+5) AND 511;
	v2:=(v2-4) AND 511;
	v3:=(v3+3) AND 511;
End;

Procedure RotateAllCoords; assembler;
{Rotate all coords in "coords" around all 3 axis and make
 perspective calcualtion. Store x,y,z results in "cbuffer"}
Var
	xcoord,ycoord,zcoord, n : integer;
Asm
	mov	ax,ds
	mov	es,ax
	lea	si,[coords]
	lea	di,[cbuffer]
	mov	ax,[number_coords]
	mov	[n],ax
	cld
@loop:
	lodsw
	mov	[xcoord],ax
	lodsw
	mov	[ycoord],ax
	lodsw
	mov	[zcoord],ax

	mov	ax,[xcoord]             {rotate around Z-axis}
	push	ax
	imul	[Cos1]
	add	ax,ax
	adc	dx,dx
	mov	bx,dx
	mov	ax,[ycoord]
	imul	[Sin1]
	add	ax,ax
	adc	dx,dx
	sub	bx,dx
	mov	[xcoord],bx
	pop	ax
	imul	[Sin1]
	add	ax,ax
	adc	dx,dx
	mov	bx,dx
	mov	ax,[ycoord]
	imul	[Cos1]
	add	ax,ax
	adc	dx,dx
	add	bx,dx
	mov	[ycoord],bx

	mov	ax,[ycoord]             {rotate around Y-axis}
	push	ax
	imul	[Cos2]
	add	ax,ax
	adc	dx,dx
	mov	bx,dx
	mov	ax,[zcoord]
	imul	[Sin2]
	add	ax,ax
	adc	dx,dx
	sub	bx,dx
	mov	[ycoord],bx
	pop	ax
	imul	[Sin2]
	add	ax,ax
	adc	dx,dx
	mov	bx,dx
	mov	ax,[zcoord]
	imul	[Cos2]
	add	ax,ax
	adc	dx,dx
	add	bx,dx
	mov	[zcoord],bx

	mov	ax,[xcoord]             {rotate around X-axis}
	push	ax
	imul	[Cos3]
	add	ax,ax
	adc	dx,dx
	mov	bx,dx
	mov	ax,[zcoord]
	imul	[Sin3]
	add	ax,ax
	adc	dx,dx
	sub   bx,dx
	mov	[xcoord],bx
	pop	ax
	imul	[Sin3]
	add	ax,ax
	adc	dx,dx
	mov	bx,dx
	mov	ax,[zcoord]
	imul	[Cos3]
	add	ax,ax
	adc	dx,dx
	add	bx,dx
	mov	[zcoord],bx

	add	bx,800
	or		bx,bx
	jnz	@zero
	mov	bl,1
@zero:

	mov	ax,[xcoord]
	cwd
	mov	dl,ah
	mov	ah,al
	xor	al,al
	idiv	bx
	add	ax,100
	stosw

	mov	ax,[ycoord]
	cwd
	mov	dl,ah
	mov	ah,al
	xor	al,al
	idiv	bx
	add	ax,160
	stosw

	mov	ax,bx
	sub	ax,800
	stosw
	DB LONG; xor ax,ax
	stosw
	DB LONG; stosw
	DB LONG; stosw

	dec	[n]
	jnz	@loop
End;


Function FaceShown(l1,l2,l3 : word) : boolean;
Var
	a,b : longint;
Begin
	asm
		mov	cx,[l1] {*16 because a 'cbuffer' record is 16 bytes long}
		shl	cx,4
		shl	[l2],4
		shl	[l3],4
		lea	si,cbuffer
{ a := x1-x2 * y3-y2; }
		mov	bx,cx
		mov	ax,[si+bx]
		mov	bx,[l3]
		mov	dx,[si+bx+2]
		mov	bx,[l2]
		sub	ax,[si+bx]
		sub	dx,[si+bx+2]
		imul	dx
		mov	WORD PTR [a+2],ax
		mov	WORD PTR [a],dx
{ b := y1-y2 * x3-x2; }
		mov	bx,cx
		mov	ax,[si+bx+2]
		mov	bx,[l3]
		mov	dx,[si+bx]
		mov	bx,[l2]
		sub	ax,[si+bx+2]
		sub	dx,[si+bx]
		imul	dx
		mov	WORD PTR [b+2],ax
		mov	WORD PTR [b],dx
	end;
	FaceShown := (a-b) > 0;
End;


Function CalcLight(l1,l2,l3 : word) : integer;
Var
	 CX1,CY1,CZ1, CX2,CY2,CZ2 : integer;
	 DX,DY,DZ : longint;
	 PX,PY,PZ : integer;
	 Quadrat : integer;
Begin
	with cbuffer[l1] do begin
		PX:=x;
		PY:=y;
		PZ:=z;
	end;
	CX1:=cbuffer[l2].x-PX;
	CY1:=cbuffer[l2].y-PY;
	CZ1:=cbuffer[l2].z-PZ;
	CX2:=cbuffer[l3].x-PX;
	CY2:=cbuffer[l3].y-PY;
	CZ2:=cbuffer[l3].z-PZ;
	DX:=(LongMul(CY1,CZ2)-LongMul(CZ1,CY2));
	DY:=(LongMul(CZ1,CX2)-LongMul(CX1,CZ2));
	DZ:=(LongMul(CX1,CY2)-LongMul(CY1,CX2));
	with cbuffer[l1] do begin
		Inc( nx,DX );
		Inc( ny,DY );
		Inc( nz,DZ );
	end;
	with cbuffer[l2] do begin
		Inc( nx,DX );
		Inc( ny,DY );
		Inc( nz,DZ );
	end;
	with cbuffer[l3] do begin
		Inc( nx,DX );
		Inc( ny,DY );
		Inc( nz,DZ );
	end;
End;

Procedure FillShape(x,xsize : integer); Assembler;
Var
	tex1,tex2 : word;
	xlowadd,xhighadd,ylowadd,yhighadd : word;
	loops : word;
Asm
	mov	ax,[xsize]
	jz		@done
	cmp	ax,320
	jae	@done

	mov	di,[display1]
	mov	ax,[x]
	shr	ax,2
	add	di,ax

	lea	si,slope
	mov	ax,x
	shl	ax,2
	add	si,ax

	mov	es,[SEGA000]
	cld
@xloop:
	mov	cx,[x]
	and	cl,3
	mov	al,1
	shl	al,cl
	mov	ah,al
	mov	dx,$3C4
	mov	al,$02
	out	dx,ax

	mov	cx,[si+TYPE(tSlopeType)] {fetch texture x,y values}
	lodsw									 {fetch first xpos}
	mov	dx,ax
	mov	bx,[si+TYPE(tSlopeType)] {fetch second texture values}
	lodsw									 {fetch second xpos}
	cmp	ax,dx							 {need to go from left to right..}
	jle	@exchange
	xchg	ax,dx
	xchg	cx,bx
@exchange:
	mov	[tex1],cx
	mov	[tex2],bx

	cmp	dx,0
	jl		@filledout_fast
	cmp	ax,200
	jge	@filledout_fast
	cmp	ax,0
	jge	@cut1
	xor	ax,ax
@cut1:
	cmp	dx,199
	jle	@cut2
	mov	dx,199
@cut2:

	push	si
	push	di

	DB LONG; xor cx,cx
	mov	cx,dx
	sub	cx,ax
	or		cx,cx
	jnz	@y_is_great
	jmp	@filledout
@y_is_great:
	add	ax,ax
	mov	bx,ax
	add	di,[OFFSET ytabel+bx]
	mov	[loops],cx

	push	ds

	mov	al,BYTE PTR [tex1]
	sub	al,BYTE PTR [tex2]
	cbw
	DB LONG; shl	ax,16
	{cdq} DB $66,$99
	DB LONG; idiv	cx
	DB LONG; mov	dx,ax
	DB LONG; shr	dx,16
	mov	[xlowadd],ax
	mov	[xhighadd],dx

	mov	al,BYTE PTR [tex1+1]
	sub	al,BYTE PTR [tex2+1]
	cbw
	DB LONG; shl	ax,16
	{cdq} DB $66,$99
	DB LONG; idiv	cx
	DB LONG; mov	dx,ax
	DB LONG; shr	dx,16
	mov	[ylowadd],ax
	mov	[yhighadd],dx

	DB LONG; xor dx,dx
	mov	dx,[yhighadd]

	mov	ax,[xlowadd]
	DB LONG; shl ax,16

	mov	bx,[ylowadd]
	DB LONG; shl bx,16
	mov	bx,[xhighadd]
	DB LONG; mov si,bx

	DB LONG; xor bx,bx
	mov	bl,BYTE PTR [tex2]
	mov	bh,BYTE PTR [tex2+1]
	DB LONG; xor cx,cx
	mov	cx,[loops]
	mov	ds,WORD PTR [env+2]
@loop:
	DB LONG; add cx,ax
	DB LONG; adc bx,si
	adc	bh,dl
	mov	dh,[bx]
	mov	[es:di],dh
	add	di,80
	dec	cx
	jnz	@loop

	pop	ds

@filledout:
	pop	di
	pop	si
@filledout_fast:
	inc   [x]
	test	[x],3
	jnz	@no_address_add
	inc	di
@no_address_add:
	dec	[xsize]
	jnz	@xloop
@done:
End;


(*------------------------------------------------*)
(*                      MAIN                      *)
(*------------------------------------------------*)

Procedure RunOnce;
Var
	i : integer;
	Quotient : longint;
Begin
{$IFDEF DEBUG}
	SwapDisplay;
	VBLANK;
{$ELSE}
	SwapDisplay;
	while retraces = 0 do ;
	retraces := 0;
{$ENDIF}

{$IFDEF MEASURE}
	SetRGB(0,30,0,0);
{$ENDIF}
	ClearScreen;
	CalcAngle;
	RotateAllCoords;
	FindFaceZ;
	QuickSort(0,number_faces-1);

	for i := 0 to number_faces-1 do with face[i] do
		CalcLight(l1,l2,l3);
	for i:=0 to number_coords-1 do with cbuffer[i] do begin
		if nz<750 then nz:=750;
		nx:=LongDiv(LongMul(nx,34),nz+800)+128;
		ny:=LongDiv(LongMul(ny,34),nz+800)+128;
		nx:=mini(nx,255);	ny:=mini(ny,255);
		nx:=maxi(nx,0); ny:=maxi(ny,0);
	end;

	for i := number_faces-1 downto 0 do begin
		with face[i] do if FaceShown(l1,l2,l3) then begin
			ClearSlope;
			minx := 320; maxx := 0;
			CalcSlope(l1,l2);
			CalcSlope(l2,l3);
			CalcSlope(l3,l1);
			FillShape(minx, maxx-minx);
		end;
	end;

{$IFDEF MEASURE}
	SetRGB(0,0,0,0);
	while KeyHit[26] do ; {Hit 'P' to pause}
{$ENDIF}
End;


Begin
	IncludeObject[1]:='*';
	IncludeObject[2]:='';
	if NOT Load3dsObject( 'TORUS.3DS', 0.9, face, coords, number_faces, number_coords ) then halt;

	OpenScreen;
	InitDemo;
{$IFNDEF DEBUG}
	SetAllInterrupts;
	repeat RunOnce until Key='e';
	RestoreAllInterrupts;
{$ELSE}
	repeat RunOnce until KeyPressed;
{$ENDIF}
	CloseScreen;
	UninitDemo;
End.
