UNIT CEL256;
{
  CEL256
  - by Bjarke Viksoe

  Converts a CEL or Autodesk Animator PIC 320x200 pixels picture
  in 256 colours to a raw picture.
  No IO checking. No size checking.
}

INTERFACE

USES
	DEMOINIT, PICTURE;


procedure ConvertCEL(dst : pScreen; src : pBuffer; filesize : longint);
procedure LoadPix(buffer : pScreen; filename : string);


(*--------------------------------------*)

IMPLEMENTATION

{$I-}

TYPE
	pHeader = ^HeaderType;
	HeaderType = RECORD
		magic : word;
		width : word;
		height : word;
		left : word;
		right : word;
		BitsPrPixel : byte;
		compression : byte;
		imagesize : longint;
		pad : array[1..16] of byte;
	end;


Procedure ExtractCMAP(v : pBuffer);
var
	i,j : word;
begin
	i:=SizeOf(HeaderType);
	for j:=1 to 256*3 do begin
		CMAP[j]:=v^[i] SHR 2;
		Inc(i);
	end;
end;


procedure ConvertCEL(dst : pScreen; src : pBuffer; filesize : longint);
var
	h : pHeader;
begin
	h := pHeader(src);
	with h^ do begin
		if (magic<>$9119) then exit;
		if (width>320) OR (height>240) OR (compression<>0) then exit;
	end;
	ExtractCMAP(src);
	Move(src^[sizeof(HeaderType)+786], dst^, (h^.width * h^.height))
end;


procedure LoadPix(buffer : pScreen; filename : string);
var
	pFileMem: pBuffer;
	FileHandle : file;
	size : longint;
begin
	Assign(FileHandle, filename);
	Reset(FileHandle, 1);
	size := FileSize(FileHandle);
	if (size > 65535) then exit;
	if (size > MaxAvail) then exit;
	GetMem(pFileMem, size);
	BlockRead(FileHandle, pFileMem^, size);
	Close(FileHandle);
	if IOResult=0 then begin
		ConvertCEL(buffer, pFileMem, size);
	end;
	FreeMem(pFileMem, size);
end;

{$I+}

end.
