UNIT AVIPLAY;
{
  AVI PLAYER by Bjarke Viksoe
  Begun: Mar 1996
  Last Revised: Mar 1995

  - doesn't really support ALL possible AVI constructs.
	 (somewhat impossible since AVI relies on 3rd party decompressors)
  -- assumes a lot of nasty things.
  --- once again we're suck on BP's shit oh-i-can-only-addresses-in-64Kb
		space limit!

  At present it supports: RGB and RLE decompression.
  Only 320*200 AVIs are supported! Better use less, though.

 * An AVI file is the following RIFF form:
 *	RIFF('AVI'
 *	      LIST('hdrl'
 *		    avih(<MainAVIHeader>)
 *                  LIST ('strl'
 *                      strh(<Stream header>)
 *                      strf(<Stream format>)
 *                      ... additional header data
 *            LIST('movi'
 *      	  [ LIST('rec'
 *      		      SubChunk...
 *      		   )
 *      	      | SubChunk ] ....
 *            )
 *            [ <AVIIndex> ]
 *      )
 *	Some defined chunk types:
 *           Video Streams:
 *                  ##db:	RGB DIB bits
 *                  ##dc:	RLE8 compressed DIB bits
 *                  ##pc:	Palette Change
 *           Audio Streams:
 *                  ##wb:	waveform audio Bytes
}

INTERFACE

USES
	PICTURE;

Function AVIInit(const filename : string) : Boolean;
Function AVIDone : Boolean;
Function AVIReadFrame(i : Word) : Boolean;
Function AVIDisplayFrame( screen : pointer ) : Boolean;

Type
	{Version 1 header}
	AVIHEADER = RECORD
	 dwMicroSecPerFrame    : LongInt;
	 dwMaxBytesPerSec      : LongInt;
	 dwReserved1           : LongInt;
	 dwFlags               : LongInt;
	 dwTotalFrames         : LongInt;
	 dwInitialFrames       : LongInt;
	 dwStreams             : LongInt;
	 dwSuggestedBufferSize : LongInt;
	 dwWidth               : LongInt;
	 dwHeight              : LongInt;
	 dwReserved            : array [1..4] of LongInt;
	end;
	AVISTREAM = RECORD
	 fccType               : array[0..3] of char;
	 fccHandler            : array[0..3] of char;
	 dwFlags               : LongInt;
	 dwPriority            : LongInt;
	 dwInitialFrames       : LongInt;
	 dwScale               : LongInt;
	 dwRate                : LongInt;
	 dwStart               : LongInt;
	 dwLength              : LongInt;
	 dwSuggestedBufferSize : LongInt;
	 dwQuality             : LongInt;
	 dwSampleSize          : LongInt;
	end;
	AVIINDEX = RECORD
	 ckid          : LongInt;
	 dwFlags       : LongInt;
	 dwChunkOffset : LongInt;
	 dwChunkLength : LongInt;
	end;
	AVIINDEXARRAY = array[1..1000] of AVIINDEX; {allocated dynamically}
	AVIPALETTE = RECORD
	 bFirstEntry   : Byte;
	 bNumEntries   : Byte;
	 wFlags        : Word;
	 palette       : array[1..256] of RECORD r,g,b : Byte; end;
	end;

Const
	RECID = $20636572;

VAR
	header        : AVIHEADER;
	cmap_changed  : Boolean;
	width, height : Word;

IMPLEMENTATION

Type
	{Our 64000 Bytes large buffer}
	AVIBuffer = array[0..63999] of char;

VAR
	f                     : FILE;
	pBuffer               : ^AVIBuffer;
	pIndex                : ^AVIIndexArray;
	MovieStart            : LongInt;
	BufferStart           : LongInt;
	bFrameRead            : Boolean; {used for sanity check}
	index                 : Word;
	framecount            : Word;
	stream                : AVISTREAM;
	AVInr                 : Word;
	grouped               : boolean;

{$I-}

(*========================================================*)

Function CheckChunkName(s : string) : Boolean;
Var
	id : string[4];
Begin
	CheckChunkName:=FALSE;
	BlockRead(f, id[1], 4);
	id[0]:=#4;
	if id<>s then exit;
	CheckChunkName:=TRUE;
End;

Procedure AVIReadRLE;
Type
	tBMP = RECORD
		fccType         : array[0..3] of char;
		fccSize         : LongInt;
		biSize          : LongInt;
		biWidth         : LongInt;
		biHeight        : LongInt;
		biPlanes        : Word;
		biBitCount      : Word;
		biCompression   : LongInt;
		biSizeImage     : LongInt;
		biXPelsPerMeter : LongInt;
		biYPelsPerMeter : LongInt;
		biClrUsed       : LongInt;
		biClrImportant  : LongInt;
	end;
Var
	i,j, k, Result : Word;
	len       : LongInt;
	bmp		 : tBMP;
	stuff     : array[1..1024] of Byte;
Begin
	{Read BMP/DIB and extract colors}
	BlockRead(f, len, 4);
	BlockRead(f, len, 4);
	BlockRead(f, bmp, SizeOf(bmp), Result );
	BlockRead(f, stuff, 256*4, Result );
	j:=1;
	k:=1;
	for i:=1 to 256 do begin
		CMAP[j]   := stuff[k+2] SHR 2;
		CMAP[j+1] := stuff[k+1] SHR 2;
		CMAP[j+2] := stuff[k] SHR 2;
		Inc(k,4);
		Inc(j,3);
	end;
End;

Function AVIReadHeader : Boolean;
Type
	AVISTRUCT = RECORD
		list     : array[0..3] of char;
		size     : LongInt;
		id       : array[0..3] of char;
		subid    : array[0..3] of char;
		length   : LongInt;
	end;
Var
	i, Result : Word;
	len,add   : LongInt;
	pos       : LongInt;
	struct    : AVISTRUCT;
	name      : array[0..3] of char;
Begin
	AVIReadHeader := FALSE;
	if NOT CheckChunkName('RIFF') then exit;
	BlockRead(f, len, 4);
	if NOT CheckChunkName('AVI ') then exit;
	if NOT CheckChunkName('LIST') then exit;
	BlockRead(f, len, 4);
	if NOT CheckChunkName('hdrl') then exit;

	if NOT CheckChunkName('avih') then exit;
	BlockRead(f, len, 4);
	add:=SizeOf(AVIHEADER) - len;
	if add<0 then exit;
	BlockRead(f, header, SizeOf(AVIHEADER), Result );
	if IOResult<>0 then exit;

	{seek video data type}
	AVInr:=0;
	while TRUE do begin
		BlockRead(f, struct, SizeOf(AVISTRUCT), Result );
		if IOResult<>0 then exit;
		with struct do begin
			if (list<>'LIST') OR (id<>'strl') OR (subid<>'strh') then exit;
			pos:=FilePos(f);
			BlockRead(f, stream, SizeOf(AVISTREAM), Result );
			if (stream.fccType = 'vids') then break;
			Seek( f, pos + size + 8);
		end;
		Inc(AVInr);
	end;
	if (stream.fccType <> 'vids') then exit;
	if stream.fccHandler = 'RLE ' then AVIReadRLE;

	{seek video data header}
	Seek(f, 12);
	while TRUE do begin
		BlockRead(f, name, 4);
		BlockRead(f, len, 4);
		if IOResult<>0 then exit;
		if name='LIST' then begin
			if CheckChunkName('movi') then break;
		end
		else
			BlockRead(f, name, 4);
		Seek(f, FilePos(f) + len - 4 );
	end;
	MovieStart:=FilePos(f) - 12;

	{seek index array}
	Seek(f, 12);
	while TRUE do begin
		if CheckChunkName('idx1') then break;
		BlockRead(f, len, 4);
		if IOResult<>0 then exit;
		Seek(f, FilePos(f) + len);
	end;
	BlockRead(f, len, 4);                 {read size of index}
	if (len > 65000) then exit;
	if (MaxAvail < len) then exit;
	GetMem( pIndex, len );
	BlockRead( f, pIndex^, len, Result ); {read whole index into memory}
	if IOResult<>0 then exit;

	{all done}
	index:=1;
	framecount:=1;
	cmap_changed := TRUE;
	AVIReadHeader := TRUE;
end;

Function AVIInit(const filename : string) : Boolean;
Var
	Result, c : Word;
Begin
	AVIInit:=FALSE;

	pBuffer:=NIL;
	Result:=IOResult; {Clear IOResult}
	Assign(F, filename);
	Reset(F,1);
	if IOResult<>0 then exit;

	if NOT AVIReadHeader then exit;

	if header.dwSuggestedBufferSize > SizeOf(AVIBuffer) then exit;
	if MaxAvail < SizeOf(AVIBuffer) then exit;
	New( pBuffer );
	if Ofs(pBuffer^)<>0 then exit; {AVIBuffer must be at segment-border!}

	width:=320;
	height:=200;
	bFrameRead:=FALSE;
	AVIInit:=TRUE;
End;

Function AVIDone : Boolean;
Begin
	AVIDone:=FALSE;
	if Assigned(pBuffer) then Dispose( pBuffer );
	if Assigned(pIndex) then Dispose( pIndex );
	pBuffer:=NIL;
	Close(f);
	if IOResult<>0 then exit;
	AVIDone:=TRUE;
End;


(*========================================================*)

Procedure PaletteChange( src : pointer );
Begin
	cmap_changed := TRUE;
End;

Procedure DecompressRGB( src, dst : pointer; size : Word ); assembler;
Asm
	push	ds
	les	di,[dst]
	mov	cx,32000
	xor	ax,ax
	rep stosw
	pop	ds
End;

Procedure DecompressRLE( src, dst : pointer; size : Word ); assembler;
Var
	ScreenWidth : Word;
Asm
	push	ds
	mov	ax,[width]
	mov	[ScreenWidth],ax
	les	di,[dst] {goto bottom of picture, since it's drawn up-side-down}
	mov	ax,[width]
	imul	[height]
	add	di,ax
	lds	si,[src]
	xor	ah,ah
	xor	ch,ch
	xor	dx,dx
	cld
@loop:
	lodsb
	mov	cl,al
	lodsb
	or		cl,cl  {RLE_ESCAPE}
	jnz	@fill
	or		al,al  {RLE_EOL}
	jz		@eol
	cmp	al,1   {RLE_EOF}
	je    @xit
	cmp	al,2   {RLE_JUMP}
	je    @jump
	mov	cl,al
	add	dx,cx
	rep movsb
	mov	ax,si {align}
	and	ax,1
	add	si,ax
	jmp	NEAR PTR @loop
@eol:
	sub	di,[ScreenWidth]
	sub	di,dx
	xor	dx,dx
	jmp	NEAR PTR @loop
@jump:
	xor	ah,ah
	lodsb
	add	di,ax
	add	dx,ax
	lodsb
	push	dx
	mul	[ScreenWidth]
	sub	di,ax
	xor	ax,ax
	pop	dx
	jmp	NEAR PTR @loop
@fill:
	add	dx,cx
	rep stosb
	jmp	NEAR PTR @loop
@xit:
	pop	ds
End;


(*========================================================*)

Function AVIReadFrame(i : Word) : Boolean;
Var
	Result : Word;
Begin
	AVIReadFrame:=FALSE;
	cmap_changed := FALSE;

	if framecount > header.dwTotalFrames then begin
		index:=1;
		framecount:=1;
	end;
	with pIndex^[index] do begin
		if ckid = RECID then begin {'rec '}
			BufferStart := dwChunkOffset - 8;
			Seek(f, MovieStart + dwChunkOffset );
			BlockRead( f, pBuffer^, dwChunkLength, Result );
			if IOResult<>0 then exit;
			grouped:=TRUE;
			Inc(index);
		end
		else
			grouped:=FALSE;
	end;

	bFrameRead:=TRUE;
	AVIReadFrame:=TRUE;
end;

(*========================================================*)


Function AVIDisplayFrame( screen : pointer ) : Boolean;
Var
	src  : pointer;
	ckid : LongInt;
	id, nr, Result : Word;
	i    : integer;
	ok   : boolean;
Begin
	AVIDisplayFrame:=FALSE;
	if NOT bFrameRead then exit;

	ok:=FALSE;
	while NOT ok do begin
		ckid:=pIndex^[index].ckid;
		id:=Swap((ckid AND $FFFF0000) SHR 16);  {id}
		nr:=Swap((ckid AND $0000FFFF) - $3030); {## (wrong)}
		{is this for our video stream?}
		if (nr<>AVInr) then begin
			Inc(Index);
			if pIndex^[index].ckid = RECID then break;
			continue;
		end;
		{Ok, we know this is the video stream...}
		ok:=TRUE;
		{might need to load it...}
		if NOT grouped then with pIndex^[index] do begin
			BufferStart := dwChunkOffset;
			Seek(f, MovieStart + dwChunkOffset + 16);
			BlockRead( f, pBuffer^, dwChunkLength, Result );
			if IOResult<>0 then exit;
			src := pBuffer;
		end
		else
			src := @pBuffer^[ pIndex^[index].dwChunkOffset - BufferStart + 8];

		{Parse local chunks}
		if stream.fccHandler = 'RLE ' then begin
		 case id of
		  $6462: DecompressRLE( src, screen, 0 ); {'##db'}
		  $6463: DecompressRLE( src, screen, 0 ); {'##dc'}
		 end;
		end;
		{Parse global chunks}
		case id of
		 $7063: PaletteChange( src );            {'##pc'}
		end;

		Inc(Index);
		if pIndex^[index].ckid = RECID then break;
	end;

	{if 'rec ' chunks found, spool until next...}
	if grouped then
		while pIndex^[index].ckid <> RECID do
			Inc(Index);

	Inc(framecount);
	bFrameRead:=FALSE;
	AVIDisplayFrame:=TRUE;
End;


End.
