UNIT X3DS;

INTERFACE

{$S-,R-,N+,G+,X+}

USES
	STRPROCS;

CONST
	ARRAY_MAXCOORDS = 800; {how many coordinates can we max handle}
	ARRAY_MAXFACES = 1200; {how many faces can we max handle}

TYPE
	tFaceRec = RECORD  {It's a good idea to keep sizes at 2^n, since}
		z : integer;    {BP may figure out how to optimize indexing}
		l1,l2,l3 : word;
	end;
	tCoordRec = RECORD
		x,y,z : integer;
	end;

VAR
	IncludeObject : array[1..10] of string;

Function Load3DSobject( filename : string;
								divfactor : single;
								VAR face : array of tFaceRec; VAR coords : array of tCoordRec;
								VAR FaceNr, CoordNr : word) : boolean;


IMPLEMENTATION

{$I-}

(*------------------------------------------------*)
(*             LOAD 3D STUDIO OBJECT              *)
(*------------------------------------------------*)

Function Load3DSobject( filename : string;
								divfactor : single;
								VAR face : array of tFaceRec; VAR coords : array of tCoordRec;
								VAR FaceNr, CoordNr : word) : boolean;
Type
	tChunk = RECORD
		ID : word;
		next : longint;
	end;
Var
	f : FILE;
	lastCoordNr : word;  {used when adding multiple objects...}

	Function ParseAsciiString : string;
	{All this trouble, just to parse over an ascii string}
	Var
		tmp : string;
		c : char;
		oldpos : longint;
	Begin
		tmp:='';
		repeat
			BlockRead(f, c, 1);
			if c=#0 then break;
			tmp:=tmp+c;
		until FALSE;
		ParseAsciiString:=tmp;
	End;

	Procedure ParseVertexList;
	Const
		MAXSIZE = 400;
	Type
		tVertex = RECORD
			x,y,z : single;
		end;
	Var
		numCoords : word;
		i : integer;
		vertex : tVertex;
	Begin
		BlockRead(f, numCoords, SizeOf( word ) );
		if IOResult<>0 then halt;
		for i:=1 to numCoords do begin
			if (CoordNr > ARRAY_MAXCOORDS) then begin
				Writeln('Too many coordinates. Increase ARRAY_MAXCOORDS constant.');
				halt;
			end;
			BlockRead( f, vertex, SizeOf(tVertex) );
			if IOResult<>0 then halt;
			{Insert coords into our own coordinate array}
			coords[CoordNr].x := Trunc(vertex.x / DIVFACTOR);
			coords[CoordNr].y := Trunc(vertex.y / DIVFACTOR);
			coords[CoordNr].z := Trunc(vertex.z / DIVFACTOR);
			if (Abs(coords[CoordNr].x) > MAXSIZE) OR (Abs(coords[CoordNr].y) > MAXSIZE) OR (Abs(coords[CoordNr].z) > MAXSIZE) then begin
				Writeln('Coordinates too large for world. Increase DIVFACTOR constant.');
				halt;
			end;
			Inc(CoordNr);
		end;
	End;

	Procedure ParsePointList;
	Type
		tPoint = RECORD
			p1, p2, p3 : word;
			flag : word;
		end;
	Var
		n : word;
		i,numPoints : word;
		point : tPoint;
	Begin
		BlockRead(f, numPoints, SizeOf( word ) );
		if IOResult<>0 then halt;
		for i:=1 to numPoints do begin
			if (FaceNr > ARRAY_MAXFACES) then begin
				Writeln('Too many faces. Increase ARRAY_MAXFACES constant.');
				halt;
			end;
			BlockRead( f, point, SizeOf(tPoint) );
			if IOResult<>0 then halt;
			{Insert points into our own face-definitions-array}
			Face[FaceNr].l1:=point.p1 + lastCoordNr;
			Face[FaceNr].l2:=point.p2 + lastCoordNr;
			Face[FaceNr].l3:=point.p3 + lastCoordNr;
				{flag: bit 0-2 AB BC AC}
			Inc(FaceNr);
		end;
	End;

	Procedure ParseMaterial;
	Var
		matname : string;
	Begin
		{find out name of object}
		matname:=Upper(ParseAsciiString);
	End;

	Procedure ParseLight;
	Type
		tLight = RECORD
			x, y, z : single;
		end;
	Var
		light : tLight;
	Begin
		BlockRead(f, light, SizeOf( tLight ) );
		if IOResult<>0 then halt;
	End;

	Procedure ParseCamera;
	Type
		tCamera = RECORD
			x, y, z : single;
			target_x, target_y, target_z : single;
			bank, lens : single;
		end;
	Var
		camera : tCamera;
	Begin
		BlockRead(f, camera, SizeOf( tCamera ) );
		if IOResult<>0 then halt;
	End;

	Procedure ParseTriPolygonObjectChunk;
	Var
		Chunk : tChunk;
		oldpos : longint;
	Begin
		lastCoordNr:=CoordNr;
		repeat
			{read next chunk}
			oldpos:=FilePos(f);
			BlockRead( f, chunk, SizeOf( tChunk ) );
			if IOResult<>0 then break;
			if (chunk.id <= $4100) OR (chunk.id >= $4200) then break;
			case (chunk.id) of
			 $4110 : ParseVertexList;
			 $4120 : ParsePointList;
			 $4130 : ParseMaterial;
			end;
			{seek to next chunk...}
			Seek( f, oldpos + chunk.next );
		until FALSE;
	end;

	Procedure ParseObjectMeshChunk;
	Var
		objectname : string; {current object in progress}
		Chunk : tChunk;
		oldpos : longint;
		i : word;
	Begin
		{dig out name of object}
		objectname:=Upper(ParseAsciiString);
		{figure out if we really want to include this object...}
		for i:=1 to High(IncludeObject) do begin
			if IncludeObject[i]='' then exit;
			if IncludeObject[i]='*' then break; {ok, takes all}
			if IncludeObject[i]=objectname then break; {ok}
		end;
		{now parse object chunk! These are meshes, cameras, lights ect ect...}
		repeat
			{read next chunk}
			oldpos:=FilePos(f);
			BlockRead( f, chunk, SizeOf( tChunk ) );
			if IOResult<>0 then break;
			if (chunk.id <= $4000) OR (chunk.id >= $5000) then break;
			{is it anything we can possible use?}
			case (chunk.id) of
			 $4100 : ParseTriPolygonObjectChunk;
			 $4600 : ParseLight;
			 $4700 : ParseCamera;
			end;
			{seek to next chunk...}
			Seek( f, oldpos + chunk.next );
		until FALSE;
	end;

	Procedure ParsePrimaryChunk;
	Var
		Chunk : tChunk;
		oldpos : longint;
	Begin
		repeat
			{read next chunk}
			oldpos:=FilePos(f);
			BlockRead( f, chunk, SizeOf( tChunk ) );
			if IOResult<>0 then break;
			{find objects...}
			case (chunk.id) of
			 $4000 : ParseObjectMeshChunk;
			 $AFFF : ParseMaterial;
			 $B000 : break;
			end;
			{seek to next chunk...}
			Seek( f, oldpos + chunk.next );
		until FALSE;
	end;

Var
	Chunk : tChunk;
	oldpos : longint;
	i : word;
Begin
	Load3DSobject:=FALSE;
	{figure out filename}
	if Pos('.', filename)=0 then filename:=filename+'.3DS';
	Assign( f, filename );
	Reset( f, 1 );
	if (IOResult<>0) then exit;

	{initialize}
	CoordNr:=0;
	FaceNr:=0;
	for i:=1 to High(IncludeObject) do IncludeObject[i]:=Upper(IncludeObject[i]);

	{parse file...}
	BlockRead( f, chunk, SizeOf( tChunk ) );
	if (chunk.id = $4D4D) OR (IOResult=0) then begin
		repeat
			oldpos:=FilePos(f);
			BlockRead( f, chunk, SizeOf( tChunk ) );
			if IOResult<>0 then break;
			case (chunk.id) of
			 $3D3D : ParsePrimaryChunk;
			end;
			Seek( f, oldpos + chunk.next );
		until FALSE;
	end;
	Close(f);

	{set other variables...}
	if (CoordNr=0) OR (FaceNr=0) then exit;

	Load3DSobject:=TRUE;
End;

Begin
	IncludeObject[1]:='';
End.

{$I+}
