UNIT FILEOS1;
{
  Big Virtual File Operating System (better than OS/2)
  - by Bjarke Viksoe, Aug 1994
  Compiles multiple datafiles into one big file of crap.
  Ups, files cannot be larger than 65535 bytes! Will fix that l8r.

  How to create one:
	 Make a textfile (with ext .lst) with all filename entries.
	 Create this Pascal program:
		program make; uses fileos1; begin CreateBigFile(ParamStr(1)); end.
	 Compile it.
	 Run it with the name of your textfile (without .lst ext) as parameter!
	 The new compiled file has same name, but a .dat ext.
  How to use it:
	 Include the unit FILEOS1 in your program.
	 Run InitFileSystem with name of the compiled file.
	 Get files with "GetFile" procedure (include file ext, but no path).
	 Remember to close it all with CloseFileSystem before ending program.
}

INTERFACE

USES
	DOS;

TYPE
	string12 = string[12];


function CreateBigFile(name : string) : boolean;

function InitFileSystem(name : string) : boolean;
function GetFile(name : string12; buffer : pointer) : boolean;
function GetFileSize(name : string12) : longint;
procedure CloseFileSystem;


(*=--------------------------------------------=*)


IMPLEMENTATION

CONST
	MAXFILES = 100;

TYPE
	filerec = RECORD
		name : string12;
		pos,size : longint;
	end;

	pDirectoryBuffer = ^DirectoryBuffer;
	DirectoryBuffer = RECORD
		entries : integer;
		entry : array[1..MAXFILES] of filerec
	end;


VAR
	{this is the datafile handle}
	F : File;
	{here is our directory structure.
	 And nope, we don't reserve MAXFILES records, but allocate dynamically!}
	Directory : pDirectoryBuffer;


(*=--------------------------------------------=*)

function CreateBigFile(name : string) : boolean;
var
	dir : pDirectoryBuffer;
	ScriptFile : text;
	TempFile : file;
	pos,size : longint;
	mem : pointer;
	P: PathStr;
	D: DirStr;
	N: NameStr;
	E: ExtStr;
const
	copyright : string[17] = '(c) Bjarke Viksoe';
begin
{$I-}
	CreateBigFile:=FALSE;

	Assign(ScriptFile, name+'.lst');
	Reset(ScriptFile);
	if (IOresult<>0) then begin
		Writeln('ERROR CREATING BIG-FILE: ',name,'.lst not found.');
		exit;
	end;
	Assign(F, name+'.dat');
	Rewrite(F,1);
	if (IOresult<>0) then begin
		Writeln('ERROR CREATING BIG-FILE: Cannot create ',name,'.dat ?');
		Close(ScriptFile);
		exit;
	end;

	{Write 'blank' number entries and directory pos}
	BlockWrite(F,pos,2);
	BlockWrite(F,pos,4);
	BlockWrite(F,copyright[1],length(copyright));

	New(dir);
	GetMem(mem,65535);

	dir^.entries:=1;
	while not EOF(ScriptFile) do begin
		{find next filename entry}
		ReadLn(ScriptFile,P);
		if (P='') OR (P[1]=';') then continue;

		{open file to append...}
		Assign(tempFile,P);
		Reset(tempFile,1);
		if (IOresult<>0) then begin
			Writeln('ERROR CREATING BIG-FILE: File not found: ',P);
			Dispose(dir);
			FreeMem(mem,65535); Close(ScriptFile); Close(F);
			exit;
		end;

		FSplit(P,D,N,E);
		{update directory list}
		dir^.entry[dir^.entries].name:=N+E;
		dir^.entry[dir^.entries].pos:=FilePos(F);
		size:=FileSize(tempFile);
		dir^.entry[dir^.entries].size:=size;

		{append file to big file}
		BlockRead(tempFile,mem^,size);
		BlockWrite(F,mem^,size);
		{file copied, close file}
		Close(tempFile);

		if (IOresult<>0) then begin
			Writeln('ERROR CREATING BIG-FILE: Copy error with ',P,'.');
			Dispose(dir);
			FreeMem(mem,65535); Close(ScriptFile); Close(F);
			exit;
		end;

		inc(dir^.entries);
		if (dir^.entries > MAXFILES) then begin
			Writeln('ERROR CREATING BIG-FILE: Too many files.');
			Dispose(dir);
			FreeMem(mem,65535); Close(ScriptFile); Close(F);
			exit;
		end;
	end;
	FreeMem(mem,65535);
	{close .lst file}
	Close(ScriptFile);

	{get current fileposition = end of datafiles}
	pos:=FilePos(F);
	{write number of entries and position of directorybuffer}
	Seek(F,0);
	BlockWrite(F, dir^.entries, 2);
	BlockWrite(F, pos, 4);

	{write directory buffer}
	Seek(F, pos);
	BlockWrite(F, dir^.entry[1], dir^.entries*SizeOf(FileRec));
	Dispose(dir);

	{close our datafile}
	Close(F);
	if (IOresult<>0) then begin
		Writeln('ERROR CREATING BIG-FILE: Couldn''t write directory block.');
		exit;
	end;

	CreateBigFile:=TRUE;
{$I+}
end;


(*=--------------------------------------------=*)

function GetFile(name : string12; buffer : pointer) : boolean;
var
	i : word;
begin
	GetFile:=FALSE;
{$I-}
	i:=IOresult; {clear IOresult}
	for i:=1 to Directory^.entries do
		if (Directory^.entry[i].name=name) then with Directory^.entry[i] do begin
			Seek(F,pos);
			BlockRead(F, buffer^, size);
			if IOresult<>0 then exit;
			GetFile:=TRUE;
			exit;
		end;
{$I+}
end;

function GetFileSize(name : string12) : longint;
var
	i : word;
begin
	GetFileSize:=0;
	for i:=1 to Directory^.entries do
		if (Directory^.entry[i].name=name) then with Directory^.entry[i] do begin
			GetFileSize:=size;
			exit;
		end;
end;


function InitFileSystem(name : string) : boolean;
var
	num : word;
	pos : longint;
	ok : boolean;
begin
	InitFileSystem:=FALSE;
{$I-}
	num:=IOresult; {clear IOresult}
	{open big compiled file}
	Assign(F, name);
	Reset(F,1);
	if (IOresult<>0) then exit; {not found}

	{read number of file entries and position of directorybuffer}
	BlockRead(F, num, 2);
	BlockRead(F, pos, 4);

	{read directory}
	GetMem(Directory, 2+(num*SizeOf(FileRec)) );
	Seek(F, pos);
	Directory^.entries:=num;
	BlockRead(F, Directory^.entry[1], num*SizeOf(FileRec) );
	if (IOresult<>0) then exit;
{$I+}
	InitFileSystem:=TRUE;
end;


procedure CloseFileSystem;
begin
	FreeMem(Directory, 2 + (Directory^.entries * SizeOf(FileRec)) );
{$I-}
	Close(F);
{$I+}
end;

end.
